"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/forms/TimeframePicker.tsx
var TimeframePicker_exports = {};
__export(TimeframePicker_exports, {
  TimeframePicker: () => TimeframePicker,
  default: () => TimeframePicker_default
});
module.exports = __toCommonJS(TimeframePicker_exports);
var import_react = require("react");
var import_react_hook_form = require("react-hook-form");
var import_DatePicker = require("@mui/x-date-pickers/DatePicker");
var import_dayjs = __toESM(require("dayjs"), 1);
var import_jsx_runtime = require("react/jsx-runtime");
var ensureStartOfDay = (date) => {
  const momentDate = typeof date === "string" ? (0, import_dayjs.default)(date.replace("Z", "")) : (0, import_dayjs.default)(date);
  return `${momentDate.format().split("T")[0]}T00:00:00.000`;
};
var ensureEndOfDay = (date) => {
  const momentDate = typeof date === "string" ? (0, import_dayjs.default)(date.replace("Z", "")) : (0, import_dayjs.default)(date);
  return `${momentDate.format().split("T")[0]}T23:59:59.999`;
};
var TimeframePicker = ({
  tonight: propsTonight,
  format = "YYYY-MM-DD",
  fromLabel = "From",
  toLabel = "To",
  slotProps = {},
  fallbackValue = (0, import_dayjs.default)()
}) => {
  const [tonight] = (0, import_react.useState)((0, import_dayjs.default)(propsTonight));
  const [maxStartDate, setMaxStartDate] = (0, import_react.useState)(tonight);
  const [minEndDate, setMinEndDate] = (0, import_react.useState)(tonight);
  const { control, setValue, watch, getValues } = (0, import_react_hook_form.useFormContext)();
  const startDate = watch("startDate");
  const endDate = watch("endDate");
  (0, import_react.useEffect)(() => {
    const currentEndDate = getValues("endDate");
    const now = (/* @__PURE__ */ new Date()).toISOString().replace("Z", "");
    if (startDate > currentEndDate) {
      setValue("endDate", ensureEndOfDay(startDate));
    } else if (currentEndDate > now) {
      setValue("endDate", now);
    }
    setMinEndDate((0, import_dayjs.default)(startDate));
  }, [startDate, getValues, setValue]);
  (0, import_react.useEffect)(() => {
    const currentStartDate = getValues("startDate");
    if (endDate < currentStartDate) {
      setValue("startDate", ensureStartOfDay(endDate));
    }
    setMaxStartDate((0, import_dayjs.default)(endDate));
  }, [endDate, getValues, setValue]);
  const handleChangeStartDate = (date) => ensureStartOfDay(date);
  const handleChangeEndDate = (date) => ensureEndOfDay(date);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: "flexbox", style: { flexWrap: "wrap", gap: 15 }, children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_react_hook_form.Controller,
      {
        name: "startDate",
        control,
        render: ({ field: { onChange, value } }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
          import_DatePicker.DatePicker,
          {
            disableFuture: true,
            format,
            slotProps: {
              ...slotProps,
              textField: (props) => ({
                ...slotProps.textField,
                inputProps: {
                  ...props.inputProps,
                  ...slotProps.textField?.inputProps,
                  "aria-label": "From"
                }
              })
            },
            yearsOrder: "desc",
            label: fromLabel,
            maxDate: maxStartDate,
            onChange: (e) => onChange(handleChangeStartDate(e)),
            value: value ? (0, import_dayjs.default)(value) : fallbackValue
          }
        )
      }
    ),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_react_hook_form.Controller,
      {
        name: "endDate",
        control,
        render: ({ field: { onChange, value } }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
          import_DatePicker.DatePicker,
          {
            disableFuture: true,
            format,
            slotProps: {
              ...slotProps,
              textField: (props) => ({
                ...slotProps.textField,
                inputProps: {
                  ...props.inputProps,
                  ...slotProps.textField?.inputProps,
                  "aria-label": "To"
                }
              })
            },
            yearsOrder: "desc",
            label: toLabel,
            minDate: minEndDate,
            onChange: (e) => onChange(handleChangeEndDate(e)),
            value: value ? (0, import_dayjs.default)(value) : fallbackValue
          }
        )
      }
    )
  ] });
};
var TimeframePicker_default = TimeframePicker;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  TimeframePicker
});
//# sourceMappingURL=TimeframePicker.cjs.map