import {
  DetailInformation,
  DeviceDetails_default
} from "./chunk-LHTCZWYC.js";
import {
  TerminalPlayer_default
} from "./chunk-2GQZ436W.js";

// src/auditlogs/eventdetails/TerminalSession.tsx
import { useEffect, useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import { useTheme } from "@mui/material/styles";
import Loader from "@northern.tech/common-ui/Loader";
import Time from "@northern.tech/common-ui/Time";
import { getAuditlogDevice, getCurrentSession, getIdAttribute, getUserCapabilities } from "@northern.tech/store/selectors";
import { getDeviceById, getSessionDetails } from "@northern.tech/store/thunks";
import dayjs from "dayjs";
import durationDayJs from "dayjs/plugin/duration.js";
import { jsx, jsxs } from "react/jsx-runtime";
dayjs.extend(durationDayJs);
var TerminalSession = ({ item, onClose }) => {
  const theme = useTheme();
  const [sessionDetails, setSessionDetails] = useState();
  const dispatch = useDispatch();
  const { action, actor, meta, object = {}, time } = item;
  const { canReadDevices } = useSelector(getUserCapabilities);
  const device = useSelector(getAuditlogDevice);
  const idAttribute = useSelector(getIdAttribute);
  const { token } = useSelector(getCurrentSession);
  useEffect(() => {
    if (canReadDevices) {
      dispatch(getDeviceById(object.id));
    }
    dispatch(
      getSessionDetails({
        sessionId: meta.session_id[0],
        deviceId: object.id,
        userId: actor.id,
        startDate: action.startsWith("open") ? time : void 0,
        endDate: action.startsWith("close") ? time : void 0
      })
    ).unwrap().then(setSessionDetails);
  }, [action, actor.id, canReadDevices, dispatch, meta.session_id, object.id, time]);
  if (!sessionDetails || canReadDevices && !device) {
    return /* @__PURE__ */ jsx(Loader, { show: true });
  }
  const sessionMeta = {
    "Session ID": item.meta.session_id[0],
    "Start time": /* @__PURE__ */ jsx(Time, { value: sessionDetails.start }),
    "End time": /* @__PURE__ */ jsx(Time, { value: sessionDetails.end }),
    "Duration": dayjs.duration(dayjs(sessionDetails.end).diff(sessionDetails.start)).format("HH:mm:ss:SSS"),
    User: item.actor.email
  };
  return /* @__PURE__ */ jsxs("div", { className: "flexbox", style: { flexWrap: "wrap" }, children: [
    /* @__PURE__ */ jsx(TerminalPlayer_default, { className: "flexbox column margin-top", item, sessionInitialized: !!sessionDetails, token }),
    /* @__PURE__ */ jsxs("div", { className: "flexbox column", style: { margin: theme.spacing(3), minWidth: "min-content" }, children: [
      canReadDevices && /* @__PURE__ */ jsx(DeviceDetails_default, { device, idAttribute, onClose }),
      /* @__PURE__ */ jsx(DetailInformation, { title: "session", details: sessionMeta })
    ] })
  ] });
};
var TerminalSession_default = TerminalSession;

export {
  TerminalSession,
  TerminalSession_default
};
//# sourceMappingURL=chunk-U2F7NBPO.js.map