"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/actions.ts
var actions_exports = {};
__export(actions_exports, {
  default: () => actions_default
});
module.exports = __toCommonJS(actions_exports);

// src/appSlice/index.ts
var import_toolkit = require("@reduxjs/toolkit");

// src/constants.ts
var import_constants2 = require("@northern.tech/utils/constants");

// src/deploymentsSlice/constants.ts
var alreadyInstalled = "already-installed";
var deploymentSubstates = {
  aborted: "aborted",
  alreadyInstalled,
  decommissioned: "decommissioned",
  downloading: "downloading",
  failure: "failure",
  installing: "installing",
  noartifact: "noartifact",
  pause_before_committing: "pause_before_committing",
  pause_before_installing: "pause_before_installing",
  pause_before_rebooting: "pause_before_rebooting",
  pending: "pending",
  rebooting: "rebooting",
  success: "success"
};
var deploymentStatesToSubstates = {
  failures: [deploymentSubstates.failure, deploymentSubstates.aborted, deploymentSubstates.decommissioned],
  inprogress: [deploymentSubstates.downloading, deploymentSubstates.installing, deploymentSubstates.rebooting],
  paused: [deploymentSubstates.pause_before_installing, deploymentSubstates.pause_before_rebooting, deploymentSubstates.pause_before_committing],
  pending: [deploymentSubstates.pending],
  successes: [deploymentSubstates.success, deploymentSubstates.alreadyInstalled, deploymentSubstates.noartifact]
};
var deploymentStatesToSubstatesWithSkipped = {
  ...deploymentStatesToSubstates,
  failures: [deploymentSubstates.failure],
  skipped: [deploymentSubstates.aborted, deploymentSubstates.noartifact, deploymentSubstates.alreadyInstalled, deploymentSubstates.decommissioned],
  successes: [deploymentSubstates.success]
};
var installationSubstatesMap = {
  download: {
    title: "download",
    done: "downloaded",
    successIndicators: [deploymentSubstates.installing, deploymentSubstates.rebooting, ...deploymentStatesToSubstates.paused, deploymentSubstates.success],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactInstall_Enter"
  },
  install: {
    title: "install",
    done: "installed",
    successIndicators: [
      deploymentSubstates.rebooting,
      deploymentSubstates.pause_before_rebooting,
      deploymentSubstates.pause_before_committing,
      deploymentSubstates.success
    ],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactReboot_Enter"
  },
  reboot: {
    title: "reboot",
    done: "rebooted",
    successIndicators: [deploymentSubstates.pause_before_committing, deploymentSubstates.success],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactCommit_Enter"
  },
  commit: {
    title: "commit",
    done: "committed",
    successIndicators: deploymentStatesToSubstates.successes,
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: void 0
  }
};
var DEPLOYMENT_STATES = {
  finished: "finished",
  inprogress: "inprogress",
  pending: "pending",
  scheduled: "scheduled"
};
var listDefaultsByState = {
  [DEPLOYMENT_STATES.inprogress]: { page: 1, perPage: 10 },
  [DEPLOYMENT_STATES.pending]: { page: 1, perPage: 10 },
  [DEPLOYMENT_STATES.scheduled]: { ...import_constants2.DEVICE_LIST_DEFAULTS },
  [DEPLOYMENT_STATES.finished]: { ...import_constants2.DEVICE_LIST_DEFAULTS },
  sort: { direction: import_constants2.SORTING_OPTIONS.desc }
};
var DEFAULT_PENDING_INPROGRESS_COUNT = 10;
var DEPLOYMENT_ROUTES = {
  active: {
    key: "active",
    route: "/deployments/active",
    states: [DEPLOYMENT_STATES.pending, DEPLOYMENT_STATES.inprogress],
    title: "Active"
  },
  finished: {
    key: "finished",
    route: "/deployments/finished",
    states: [DEPLOYMENT_STATES.finished],
    title: "Finished"
  },
  scheduled: {
    key: "scheduled",
    route: "/deployments/scheduled",
    states: [DEPLOYMENT_STATES.scheduled],
    title: "Scheduled"
  }
};
var defaultStats = {
  [deploymentSubstates.aborted]: 0,
  [deploymentSubstates.alreadyInstalled]: 0,
  [deploymentSubstates.decommissioned]: 0,
  [deploymentSubstates.downloading]: 0,
  [deploymentSubstates.failure]: 0,
  [deploymentSubstates.installing]: 0,
  [deploymentSubstates.noartifact]: 0,
  [deploymentSubstates.pause_before_committing]: 0,
  [deploymentSubstates.pause_before_installing]: 0,
  [deploymentSubstates.pause_before_rebooting]: 0,
  [deploymentSubstates.pending]: 0,
  [deploymentSubstates.rebooting]: 0,
  [deploymentSubstates.success]: 0
};
var deploymentPrototype = {
  devices: {},
  name: void 0,
  statistics: { status: {} }
};
var pauseMap = {
  [deploymentSubstates.pause_before_installing]: {
    title: installationSubstatesMap.download.done,
    followUp: installationSubstatesMap.download.pauseConfigurationIndicator
  },
  [deploymentSubstates.pause_before_rebooting]: {
    title: installationSubstatesMap.install.done,
    followUp: installationSubstatesMap.install.pauseConfigurationIndicator
  },
  [deploymentSubstates.pause_before_committing]: {
    title: installationSubstatesMap.reboot.done,
    followUp: installationSubstatesMap.reboot.pauseConfigurationIndicator
  }
};

// src/organizationSlice/constants.ts
var auditlogTypes = {
  artifact: { title: "Artifact", queryParameter: "object_type", value: "artifact" },
  deployment: { title: "Deployment", queryParameter: "object_deployment_name", value: "deployment" },
  device: { title: "Device", queryParameter: "object_id", value: "device" },
  user_access_token: { title: "Personal Access Token", queryParameter: "user_access_token", value: "user_access_token" },
  user: { title: "User", queryParameter: "object_id", value: "user" },
  tenant: { title: "Tenant", queryParameter: "object_id", value: "tenant" }
};
var AUDIT_LOGS_TYPES = [auditlogTypes.artifact, auditlogTypes.deployment, auditlogTypes.device, auditlogTypes.user_access_token, auditlogTypes.user];
var SP_AUDIT_LOGS_TYPES = [auditlogTypes.user, auditlogTypes.tenant];
var TENANT_LIST_DEFAULT = {
  page: 1,
  perPage: 20
};

// src/usersSlice/constants.ts
var READ_STATES = {
  read: "read",
  seen: "seen",
  unread: "unread"
};

// src/appSlice/index.ts
var sliceName = "app";
var getYesterday = () => {
  const today = /* @__PURE__ */ new Date();
  today.setDate(today.getDate() - 1);
  return today.toISOString();
};
var initialState = {
  cancelSource: void 0,
  commit: "",
  demoArtifactLink: "https://dgsbl4vditpls.cloudfront.net/mender-demo-artifact.mender",
  hostAddress: null,
  snackbar: {
    action: void 0,
    autoHideDuration: void 0,
    message: "",
    open: false,
    preventClickToCopy: false
  },
  // return boolean rather than organization details
  features: {
    hasAuditlogs: false,
    hasDeltaProgress: false,
    hasMultitenancy: false,
    hasDeviceConfig: false,
    hasDeviceConnect: false,
    hasFeedbackEnabled: false,
    hasMonitor: false,
    hasReporting: false,
    isHosted: true,
    isEnterprise: false
  },
  feedbackProbability: 0.3,
  firstLoginAfterSignup: false,
  hostedAnnouncement: "",
  docsVersion: "",
  recaptchaSiteKey: "",
  searchState: {
    deviceIds: [],
    searchTerm: "",
    searchTotal: 0,
    isSearching: false,
    sort: {
      direction: import_constants2.SORTING_OPTIONS.desc
      // key: null,
      // scope: null
    }
  },
  sentry: {
    location: "",
    replaysSessionSampleRate: 0.1,
    tracesSampleRate: 1
  },
  stripeAPIKey: "",
  trackerCode: "",
  uploadsById: {
    // id: { progress: 0, cancelSource: undefined }
  },
  newThreshold: getYesterday(),
  offlineThreshold: getYesterday(),
  versionInformation: {
    Integration: "",
    "Mender-Client": "",
    "Mender-Artifact": "",
    "Meta-Mender": ""
  },
  yesterday: void 0
};
var appSlice = (0, import_toolkit.createSlice)({
  name: sliceName,
  initialState,
  reducers: {
    setFeatures: (state, action) => {
      state.features = {
        ...state.features,
        ...action.payload
      };
    },
    setSnackbar: (state, { payload }) => {
      if (typeof payload === "string" || payload instanceof String) {
        state.snackbar = {
          ...initialState.snackbar,
          message: payload,
          open: !!payload
        };
        return;
      }
      const { message, autoHideDuration, action, preventClickToCopy = false } = payload;
      state.snackbar = {
        message,
        autoHideDuration,
        action,
        preventClickToCopy,
        open: !!message
      };
    },
    setFirstLoginAfterSignup: (state, action) => {
      state.firstLoginAfterSignup = action.payload;
    },
    setAnnouncement: (state, action) => {
      state.hostedAnnouncement = action.payload;
    },
    setSearchState: (state, action) => {
      state.searchState = {
        ...state.searchState,
        ...action.payload
      };
    },
    setOfflineThreshold: (state, action) => {
      state.offlineThreshold = action.payload;
    },
    initUpload: (state, action) => {
      const { id, upload } = action.payload;
      state.uploadsById[id] = upload;
    },
    uploadProgress: (state, action) => {
      const { id, progress } = action.payload;
      state.uploadsById[id] = {
        ...state.uploadsById[id],
        progress
      };
    },
    cleanUpUpload: (state, action) => {
      const { [action.payload]: current, ...remainder } = state.uploadsById;
      state.uploadsById = remainder;
    },
    setVersionInformation: (state, action) => {
      state.versionInformation = {
        ...state.versionInformation,
        ...action.payload
      };
    },
    setEnvironmentData: (state, action) => ({ ...state, ...action.payload })
  }
});
var actions = appSlice.actions;
var appSlice_default = appSlice.reducer;

// src/deploymentsSlice/index.ts
var import_toolkit2 = require("@reduxjs/toolkit");
var sliceName2 = "deployments";
var initialState2 = {
  byId: {
    // [id]: { statistics: { status: {}, total_size }, devices: { [deploymentId]: { id, log } }, totalDeviceCount }
  },
  byStatus: {
    finished: { deploymentIds: [], total: 0 },
    inprogress: { deploymentIds: [], total: 0 },
    pending: { deploymentIds: [], total: 0 },
    scheduled: { deploymentIds: [], total: 0 }
  },
  config: {
    binaryDelta: {
      timeout: -1,
      duplicatesWindow: -1,
      compressionLevel: -1,
      disableChecksum: false,
      disableDecompression: false,
      inputWindow: -1,
      instructionBuffer: -1,
      sourceWindow: -1
    },
    binaryDeltaLimits: {
      timeout: { ...import_constants2.limitDefault, default: 60, max: 3600, min: 60 },
      sourceWindow: import_constants2.limitDefault,
      inputWindow: import_constants2.limitDefault,
      duplicatesWindow: import_constants2.limitDefault,
      instructionBuffer: import_constants2.limitDefault
    }
  },
  deploymentDeviceLimit: 5e3,
  selectedDeviceIds: [],
  selectionState: {
    finished: { ...import_constants2.DEVICE_LIST_DEFAULTS, endDate: void 0, search: "", selection: [], startDate: void 0, total: 0, type: "" },
    inprogress: { ...import_constants2.DEVICE_LIST_DEFAULTS, perPage: DEFAULT_PENDING_INPROGRESS_COUNT, selection: [] },
    pending: { ...import_constants2.DEVICE_LIST_DEFAULTS, perPage: DEFAULT_PENDING_INPROGRESS_COUNT, selection: [] },
    scheduled: { ...import_constants2.DEVICE_LIST_DEFAULTS, selection: [] },
    general: {
      state: DEPLOYMENT_ROUTES.active.key,
      showCreationDialog: false,
      showReportDialog: false,
      reportType: null
      // DeploymentConstants.DEPLOYMENT_TYPES.configuration|DeploymentConstants.DEPLOYMENT_TYPES.software
    },
    selectedId: void 0
  }
};
var deploymentsSlice = (0, import_toolkit2.createSlice)({
  name: sliceName2,
  initialState: initialState2,
  reducers: {
    createdDeployment: (state, action) => {
      state.byId[action.payload.id] = {
        ...deploymentPrototype,
        ...action.payload
      };
      state.byStatus[DEPLOYMENT_STATES.pending].total = state.byStatus[DEPLOYMENT_STATES.pending].total + 1;
      state.byStatus[DEPLOYMENT_STATES.pending].deploymentIds = [...state.byStatus.pending.deploymentIds, action.payload.id];
      state.selectionState[DEPLOYMENT_STATES.pending].selection = [action.payload.id, ...state.selectionState[DEPLOYMENT_STATES.pending].selection];
      state.selectionState[DEPLOYMENT_STATES.pending].total = (state.selectionState[DEPLOYMENT_STATES.pending].total || 0) + 1;
    },
    removedDeployment: (state, action) => {
      const { [action.payload]: removedDeployment, ...remainder } = state.byId;
      state.byId = remainder;
    },
    receivedDeployment: (state, action) => {
      state.byId[action.payload.id] = {
        ...state.byId[action.payload.id] || {},
        ...action.payload
      };
    },
    receivedDeploymentDeviceLog: (state, action) => {
      const { id, deviceId, log } = action.payload;
      const deployment = {
        ...deploymentPrototype,
        ...state.byId[id]
      };
      state.byId[id] = {
        ...deployment,
        devices: {
          ...deployment.devices,
          [deviceId]: {
            ...deployment.devices[deviceId],
            log
          }
        }
      };
    },
    receivedDeploymentDevices: (state, action) => {
      const { id, devices, selectedDeviceIds, totalDeviceCount } = action.payload;
      state.byId[id] = {
        ...state.byId[id],
        devices,
        totalDeviceCount
      };
      state.selectedDeviceIds = selectedDeviceIds;
    },
    receivedDeployments: (state, action) => {
      state.byId = {
        ...state.byId,
        ...action.payload
      };
    },
    receivedDeploymentsForStatus: (state, action) => {
      const { status, deploymentIds, total } = action.payload;
      state.byStatus[status].deploymentIds = deploymentIds;
      state.byStatus[status].total = total;
    },
    selectDeploymentsForStatus: (state, action) => {
      const { status, deploymentIds, total } = action.payload;
      state.selectionState[status].selection = deploymentIds;
      state.selectionState[status].total = total;
    },
    setDeploymentsState: (state, action) => {
      state.selectionState = action.payload;
    },
    setDeploymentsConfig: (state, action) => {
      state.config = action.payload;
    }
  }
});
var actions2 = deploymentsSlice.actions;
var deploymentsSlice_default = deploymentsSlice.reducer;

// src/devicesSlice/index.ts
var import_helpers = require("@northern.tech/utils/helpers");
var import_toolkit3 = require("@reduxjs/toolkit");
var sliceName3 = "devices";
var initialState3 = {
  byId: {
    // [deviceId]: {
    //   ...,
    //   twinsByIntegration: { [external.provider.id]: twinData }
    // }
  },
  byStatus: {
    [import_constants2.DEVICE_STATES.accepted]: { deviceIds: [], total: 0 },
    active: { deviceIds: [], total: 0 },
    inactive: { deviceIds: [], total: 0 },
    [import_constants2.DEVICE_STATES.pending]: { deviceIds: [], total: 0 },
    [import_constants2.DEVICE_STATES.preauth]: { deviceIds: [], total: 0 },
    [import_constants2.DEVICE_STATES.rejected]: { deviceIds: [], total: 0 }
  },
  deviceList: {
    deviceIds: [],
    ...import_constants2.DEVICE_LIST_DEFAULTS,
    selectedAttributes: [],
    selectedIssues: [],
    selection: [],
    sort: {
      direction: import_constants2.SORTING_OPTIONS.desc
      // key: null,
      // scope: null
    },
    state: import_constants2.DEVICE_STATES.accepted,
    total: 0,
    refreshTrigger: false,
    isLoading: false,
    detailsTab: "",
    open: false
  },
  filters: [
    // { key: 'device_type', value: 'raspberry', operator: '$eq', scope: 'inventory' }
  ],
  filteringAttributes: { identityAttributes: [], inventoryAttributes: [], systemAttributes: [], tagAttributes: [] },
  filteringAttributesLimit: 10,
  filteringAttributesConfig: {
    attributes: {
      // inventory: ['some_attribute']
    },
    count: 0,
    limit: 100
  },
  reports: [
    // { items: [{ key: "someKey", count: 42  }], otherCount: 123, total: <otherCount + itemsCount> }
  ],
  total: 0,
  limit: 0,
  groups: {
    byId: {
      // groupName: { deviceIds: [], total: 0, filters: [] },
      // dynamo: { deviceIds: [], total: 3, filters: [{ a: 1 }] }
    },
    selectedGroup: void 0
  }
};
var devicesSlice = (0, import_toolkit3.createSlice)({
  name: sliceName3,
  initialState: initialState3,
  reducers: {
    receivedGroups: (state, action) => {
      state.groups.byId = action.payload;
    },
    addToGroup: (state, action) => {
      const { group, deviceIds } = action.payload;
      const maybeExistingGroup = {
        filters: [],
        deviceIds: [],
        ...state.groups.byId[group]
      };
      state.groups.byId[group] = {
        ...maybeExistingGroup,
        deviceIds: [...maybeExistingGroup.deviceIds, ...deviceIds].filter(import_helpers.duplicateFilter),
        total: (maybeExistingGroup.total || 0) + 1
      };
    },
    removeFromGroup: (state, action) => {
      const { group, deviceIds: removedIds } = action.payload;
      const { deviceIds = [], total = 0, ...maybeExistingGroup } = state.groups.byId[group] || {};
      const changedGroup = {
        ...maybeExistingGroup,
        deviceIds: deviceIds.filter((id) => !removedIds.includes(id)),
        total: Math.max(total - removedIds.length, 0)
      };
      if (changedGroup.total || changedGroup.deviceIds.length) {
        state.groups.byId[group] = changedGroup;
        return;
      } else if (state.groups.selectedGroup === group) {
        state.groups.selectedGroup = void 0;
      }
      const { [group]: removal, ...remainingById } = state.groups.byId;
      state.groups.byId = remainingById;
    },
    addGroup: (state, action) => {
      const { groupName, group } = action.payload;
      state.groups.byId[groupName] = {
        ...state.groups.byId[groupName],
        ...group
      };
    },
    selectGroup: (state, { payload: group }) => {
      state.deviceList.deviceIds = group && state.groups.byId[group] && state.groups.byId[group].deviceIds && state.groups.byId[group].deviceIds.length > 0 ? state.groups.byId[group].deviceIds : [];
      state.groups.selectedGroup = group;
    },
    removeGroup: (state, action) => {
      const { [action.payload]: removal, ...remainingById } = state.groups.byId;
      state.groups.byId = remainingById;
      state.groups.selectedGroup = state.groups.selectedGroup === action.payload ? void 0 : state.groups.selectedGroup;
    },
    setDeviceListState: (state, action) => {
      state.deviceList = {
        ...state.deviceList,
        ...action.payload,
        sort: {
          ...state.deviceList.sort,
          ...action.payload.sort
        }
      };
    },
    setFilterAttributes: (state, action) => {
      state.filteringAttributes = action.payload;
    },
    setFilterablesConfig: (state, action) => {
      state.filteringAttributesConfig = action.payload;
    },
    receivedDevices: (state, action) => {
      state.byId = {
        ...state.byId,
        ...action.payload
      };
    },
    setDeviceFilters: (state, action) => {
      if ((0, import_helpers.deepCompare)(action.payload, state.filters)) {
        return;
      }
      state.filters = action.payload.filter((filter) => filter.key && filter.operator && filter.scope && typeof filter.value !== "undefined");
    },
    setInactiveDevices: (state, action) => {
      const { activeDeviceTotal, inactiveDeviceTotal } = action.payload;
      state.byStatus.active.total = activeDeviceTotal;
      state.byStatus.inactive.total = inactiveDeviceTotal;
    },
    setDeviceReports: (state, action) => {
      state.reports = action.payload;
    },
    setDevicesByStatus: (state, action) => {
      const { forceUpdate, status, total, deviceIds } = action.payload;
      state.byStatus[status] = total || forceUpdate ? { deviceIds, total } : state.byStatus[status];
    },
    setDevicesCountByStatus: (state, action) => {
      const { count, status } = action.payload;
      state.byStatus[status].total = count;
    },
    setDeviceLimit: (state, action) => {
      state.limit = action.payload;
    },
    receivedDevice: (state, action) => {
      state.byId[action.payload.id] = {
        ...state.byId[action.payload.id],
        ...action.payload
      };
    },
    maybeUpdateDevicesByStatus: (state, action) => {
      const { deviceId, authId } = action.payload;
      const device = state.byId[deviceId];
      const hasMultipleAuthSets = authId && device.auth_sets ? device.auth_sets.filter((authset) => authset.id !== authId).length > 0 : false;
      if (!hasMultipleAuthSets && Object.values(import_constants2.DEVICE_STATES).includes(device.status)) {
        const deviceIds = state.byStatus[device.status].deviceIds.filter((id) => id !== deviceId);
        state.byStatus[device.status] = { deviceIds, total: Math.max(0, state.byStatus[device.status].total - 1) };
      }
    }
  }
});
var actions3 = devicesSlice.actions;
var devicesSlice_default = devicesSlice.reducer;

// src/monitorSlice/index.ts
var import_toolkit4 = require("@reduxjs/toolkit");
var sliceName4 = "monitor";
var initialState4 = {
  alerts: {
    alertList: { ...import_constants2.DEVICE_LIST_DEFAULTS, total: 0 },
    byDeviceId: {}
  },
  issueCounts: {
    byType: Object.keys(import_constants2.DEVICE_ISSUE_OPTIONS).reduce((accu, key) => ({ ...accu, [key]: { filtered: 0, total: 0 } }), {})
  },
  settings: {
    global: {
      channels: {
        ...Object.keys(import_constants2.alertChannels).reduce((accu, item) => ({ ...accu, [item]: { enabled: true } }), {})
      }
    }
  }
};
var monitorSlice = (0, import_toolkit4.createSlice)({
  name: sliceName4,
  initialState: initialState4,
  reducers: {
    changeAlertChannel: (state, action) => {
      const { channel, enabled } = action.payload;
      state.settings.global.channels[channel] = { enabled };
    },
    receiveDeviceAlerts: (state, action) => {
      const { deviceId, alerts } = action.payload;
      state.alerts.byDeviceId[deviceId] = { alerts };
    },
    receiveLatestDeviceAlerts: (state, action) => {
      const { deviceId, alerts } = action.payload;
      state.alerts.byDeviceId[deviceId] = { ...state.alerts.byDeviceId[deviceId], latest: alerts };
    },
    receiveDeviceIssueCounts: (state, action) => {
      const { issueType, counts } = action.payload;
      state.issueCounts.byType[issueType] = counts;
    },
    setAlertListState: (state, action) => {
      state.alerts.alertList = { ...state.alerts.alertList, ...action.payload };
    }
  }
});
var actions4 = monitorSlice.actions;
var monitorSlice_default = monitorSlice.reducer;

// src/onboardingSlice/index.ts
var import_toolkit5 = require("@reduxjs/toolkit");
var sliceName5 = "onboarding";
var initialState5 = {
  approach: null,
  complete: false,
  deviceType: null,
  demoArtifactPort: 85,
  progress: null,
  showTips: null,
  showTipsDialog: false
};
var onboardingSlice = (0, import_toolkit5.createSlice)({
  name: sliceName5,
  initialState: initialState5,
  reducers: {
    setOnboardingState: (state, action) => ({ ...state, ...action.payload }),
    setDemoArtifactPort: (state, action) => {
      state.demoArtifactPort = action.payload;
    },
    setShowOnboardingHelp: (state, action) => {
      state.showTips = action.payload;
    },
    setShowDismissOnboardingTipsDialog: (state, action) => {
      state.showTipsDialog = action.payload;
    },
    setOnboardingComplete: (state, action) => {
      state.complete = action.payload;
    },
    setOnboardingProgress: (state, action) => {
      state.progress = action.payload;
    },
    setOnboardingDeviceType: (state, action) => {
      state.deviceType = action.payload;
    },
    setOnboardingApproach: (state, action) => {
      state.approach = action.payload;
    }
  }
});
var actions5 = onboardingSlice.actions;
var onboardingSlice_default = onboardingSlice.reducer;

// src/organizationSlice/index.ts
var import_toolkit6 = require("@reduxjs/toolkit");
var sliceName6 = "organization";
var initialState6 = {
  card: {
    last4: "",
    expiration: { month: 1, year: 2020 },
    brand: ""
  },
  intentId: null,
  tenantList: {
    ...TENANT_LIST_DEFAULT,
    total: 0,
    tenants: [],
    selectedTenant: null,
    sort: {
      direction: import_constants2.SORTING_OPTIONS.desc,
      key: "name"
    }
  },
  organization: {
    // id, name, status, tenant_token, plan
  },
  auditlog: {
    events: [],
    selectionState: {
      ...import_constants2.DEVICE_LIST_DEFAULTS,
      detail: void 0,
      endDate: void 0,
      selectedIssue: void 0,
      sort: { direction: import_constants2.SORTING_OPTIONS.desc },
      startDate: void 0,
      total: 0,
      type: void 0,
      user: void 0,
      isLoading: false
    }
  },
  externalDeviceIntegrations: [
    // { <connection_string|x509|...>, id, provider }
  ],
  ssoConfigs: [],
  webhooks: {
    // [id]: { events: [] }
    // for now:
    events: [],
    eventsTotal: 0
  }
};
var organizationSlice = (0, import_toolkit6.createSlice)({
  name: sliceName6,
  initialState: initialState6,
  reducers: {
    receiveAuditLogs: (state, action) => {
      const { events, total } = action.payload;
      state.auditlog.events = events;
      state.auditlog.selectionState.total = total;
    },
    setAuditLogState: (state, action) => {
      state.auditlog.selectionState = {
        ...state.auditlog.selectionState,
        ...action.payload
      };
    },
    receiveCurrentCard: (state, action) => {
      state.card = action.payload;
    },
    receiveSetupIntent: (state, action) => {
      state.intentId = action.payload;
    },
    setOrganization: (state, action) => {
      state.organization = { ...state.organization, ...action.payload };
    },
    setSubscription: (state, action) => {
      state.organization.subscription = { ...state.organization.subscription, ...action.payload };
    },
    setBillingProfile: (state, action) => {
      state.organization.billing_profile = action.payload;
    },
    setTenantListState: (state, action) => {
      state.tenantList = action.payload;
    },
    receiveExternalDeviceIntegrations: (state, action) => {
      state.externalDeviceIntegrations = action.payload;
    },
    receiveSsoConfigs: (state, action) => {
      state.ssoConfigs = action.payload;
    },
    receiveWebhookEvents: (state, action) => {
      const { value, total } = action.payload;
      state.webhooks.events = value;
      state.webhooks.eventsTotal = total;
    }
  }
});
var actions6 = organizationSlice.actions;
var organizationSlice_default = organizationSlice.reducer;

// src/releasesSlice/index.ts
var import_toolkit7 = require("@reduxjs/toolkit");
var sliceName7 = "releases";
var initialState7 = {
  /*
   * Return list of saved artifacts objects
   */
  /*
   * return list of artifacts where duplicate names are collated with device compatibility lists combined
   */
  // artifacts: AppStore.getCollatedArtifacts(AppStore.getArtifactsRepo()),
  artifacts: [],
  /*
   * Return list of saved release objects
   */
  byId: {
    /*
    [releaseName]: {
      artifacts: [
        {
          id: '',
          name: '',
          description: '',
          device_types_compatible: [],
          ...
          updates: [{
            files: [
              { size: 123, name: '' }
            ],
            type_info: { type: '' }
          }],
          url: '' // optional
        }
      ],
      modified: ''
      device_types_compatible,
      name: '',
      tags: ['something'],
      notes: ''
    }
    */
  },
  releasesList: {
    ...import_constants2.DEVICE_LIST_DEFAULTS,
    searchedIds: [],
    releaseIds: [],
    selection: [],
    sort: {
      direction: import_constants2.SORTING_OPTIONS.desc,
      key: "modified"
    },
    isLoading: void 0,
    searchTerm: "",
    searchTotal: 0,
    selectedTags: [],
    total: 0,
    type: ""
  },
  tags: [],
  updateTypes: [],
  /*
   * Return single release with corresponding Artifacts
   */
  selectedRelease: null
};
var releaseSlice = (0, import_toolkit7.createSlice)({
  name: sliceName7,
  initialState: initialState7,
  reducers: {
    receiveRelease: (state, action) => {
      const { name } = action.payload;
      state.byId[name] = action.payload;
    },
    receiveReleases: (state, action) => {
      state.byId = action.payload;
    },
    receiveReleaseTags: (state, action) => {
      state.tags = action.payload;
    },
    receiveReleaseTypes: (state, action) => {
      state.updateTypes = action.payload;
    },
    removeRelease: (state, action) => {
      const { [action.payload]: toBeRemoved, ...byId } = state.byId;
      state.byId = byId;
      state.selectedRelease = action.payload === state.selectedRelease ? null : state.selectedRelease;
    },
    selectedRelease: (state, action) => {
      state.selectedRelease = action.payload;
    },
    setReleaseListState: (state, action) => {
      state.releasesList = action.payload;
    }
  }
});
var actions7 = releaseSlice.actions;
var releasesSlice_default = releaseSlice.reducer;

// src/usersSlice/index.ts
var import_toolkit8 = require("@reduxjs/toolkit");
var sliceName8 = "users";
var initialState8 = {
  activationCode: void 0,
  byId: {},
  currentUser: null,
  currentSession: {
    // { token: window.localStorage.getItem('JWT'), expiresAt: '2023-01-01T00:15:00.000Z' | undefined }, // expiresAt depending on the stay logged in setting
  },
  customColumns: [],
  qrCode: null,
  globalSettings: {
    id_attribute: void 0,
    previousFilters: [],
    previousPhases: [],
    retries: 0
  },
  permissionSetsById: {
    ...import_constants2.defaultPermissionSets
  },
  rolesById: {
    ...import_constants2.rolesById
  },
  rolesInitialized: false,
  settingsInitialized: false,
  showConnectDeviceDialog: false,
  showFeedbackDialog: false,
  showStartupNotification: false,
  tooltips: {
    byId: {
      // <id>: { readState: <read|unread> } // this object is getting enhanced by the tooltip texts in the app constants
    }
  },
  userSettings: {
    columnSelection: [],
    onboarding: {}
  },
  userSettingsInitialized: false
};
var usersSlice = (0, import_toolkit8.createSlice)({
  name: sliceName8,
  initialState: initialState8,
  reducers: {
    receivedQrCode: (state, action) => {
      state.qrCode = action.payload;
    },
    successfullyLoggedIn: (state, action) => {
      state.currentSession = action.payload;
    },
    receivedUserList: (state, action) => {
      state.byId = action.payload;
    },
    receivedActivationCode: (state, action) => {
      state.activationCode = action.payload;
    },
    receivedUser: (state, action) => {
      state.byId[action.payload.id] = action.payload;
      state.currentUser = action.payload.id;
    },
    removedUser: (state, action) => {
      const { [action.payload]: removedUser, ...byId } = state.byId;
      state.byId = byId;
      state.currentUser = state.currentUser === action.payload ? null : state.currentUser;
    },
    updatedUser: (state, action) => {
      state.byId[action.payload.id] = {
        ...state.byId[action.payload.id],
        ...action.payload
      };
    },
    receivedPermissionSets: (state, action) => {
      state.permissionSetsById = action.payload;
    },
    receivedRoles: (state, action) => {
      state.rolesById = action.payload;
      state.rolesInitialized = true;
    },
    finishedRoleInitialization: (state, action) => {
      state.rolesInitialized = action.payload;
    },
    createdRole: (state, action) => {
      state.rolesById[action.payload.name] = {
        ...state.rolesById[action.payload.name],
        ...action.payload
      };
    },
    removedRole: (state, action) => {
      const { [action.payload]: toBeRemoved, ...rolesById2 } = state.rolesById;
      state.rolesById = rolesById2;
    },
    setCustomColumns: (state, action) => {
      state.customColumns = action.payload;
    },
    setGlobalSettings: (state, action) => {
      state.settingsInitialized = true;
      state.globalSettings = {
        ...state.globalSettings,
        ...action.payload
      };
    },
    setUserSettings: (state, action) => {
      state.userSettingsInitialized = true;
      state.userSettings = {
        ...state.userSettings,
        ...action.payload
      };
    },
    setTooltipState: (state, action) => {
      const { id, readState = READ_STATES.read } = action.payload;
      state.tooltips.byId[id] = { ...state.tooltips.byId[id], readState };
    },
    setTooltipsState: (state, action) => {
      state.tooltips.byId = {
        ...state.tooltips.byId,
        ...action.payload
      };
    },
    setShowFeedbackDialog: (state, action) => {
      state.showFeedbackDialog = action.payload;
    },
    setShowConnectingDialog: (state, action) => {
      state.showConnectDeviceDialog = action.payload;
    },
    setShowStartupNotification: (state, action) => {
      state.showStartupNotification = action.payload;
    }
  }
});
var actions8 = usersSlice.actions;
var usersSlice_default = usersSlice.reducer;

// src/actions.ts
var actions_default = {
  ...actions,
  ...actions2,
  ...actions3,
  ...actions4,
  ...actions5,
  ...actions6,
  ...actions7,
  ...actions8
};
//# sourceMappingURL=actions.cjs.map