import * as reselect from 'reselect';
import * as _northern_tech_utils_constants from '@northern.tech/utils/constants';
import { ReadState } from '../usersSlice/constants.js';
import { User, UserSession, CustomColumn, GlobalSettings, UserSettings } from '../usersSlice/index.js';
import { ReleaseSliceType } from '../releasesSlice/index.js';
import { OrganizationState } from '../organizationSlice/types.js';
import { OnboardingApproach } from '../onboardingSlice/index.js';
import * as _northern_tech_types_Alert from '@northern.tech/types/Alert';
import { Deployment, DeploymentByStatus, DeploymentConfig, SelectionState } from '../deploymentsSlice/index.js';
import { DeviceSliceType } from '../devicesSlice/index.js';
import { SearchState, Upload, SnackbarContent, SentryConfig } from './index.js';
import { RootState } from '../store.js';
import 'redux';
import '@reduxjs/toolkit';
import 'immer';
import '@northern.tech/types/MenderTypes';
import '../commonConstants.js';
import 'react/jsx-runtime';
import './constants.js';
import '@mui/material/OverridableComponent';
import '@mui/material';
import '../organizationSlice/constants.js';
import '../devicesSlice/constants.js';
import 'redux-thunk';

declare const getDocsVersion: (state: RootState) => string;
declare const getFeatures: (state: RootState) => Record<string, boolean>;
declare const getFullVersionInformation: (state: RootState) => {
    [key: string]: string | {
        releaseDate: string;
        repos: Record<string, string>;
    } | undefined;
    backend?: string;
    GUI?: string;
    latestRelease?: {
        releaseDate: string;
        repos: Record<string, string>;
    };
};
declare const getSearchState: (state: RootState) => SearchState;
declare const getUploads: (state: RootState) => Record<string, Upload>;
declare const getSnackbar: (state: RootState) => SnackbarContent;
declare const getHostAddress: (state: RootState) => string | null;
declare const getHostedAnnouncement: (state: RootState) => string;
declare const getRecaptchaKey: (state: RootState) => string;
declare const getStripeKey: (state: RootState) => string;
declare const getTrackerCode: (state: RootState) => string;
declare const getSentryConfig: (state: RootState) => SentryConfig;
declare const getCommit: (state: RootState) => string;
declare const getIsFirstLogin: (state: RootState) => boolean;
declare const getFeedbackProbability: (state: RootState) => number;
declare const getIsUploading: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => boolean) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: Record<string, Upload>) => boolean;
    memoizedResultFunc: ((resultFuncArgs_0: Record<string, Upload>) => boolean) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => boolean;
    dependencies: [(state: RootState) => Record<string, Upload>];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getSearchedDevices: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => string[]) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: SearchState) => string[];
    memoizedResultFunc: ((resultFuncArgs_0: SearchState) => string[]) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => string[];
    dependencies: [(state: RootState) => SearchState];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getVersionInformation: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => {
    [key: string]: string | {
        releaseDate: string;
        repos: Record<string, string>;
    } | undefined;
    backend?: string;
    GUI?: string;
    latestRelease?: {
        releaseDate: string;
        repos: Record<string, string>;
    };
}) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: {
        [key: string]: string | {
            releaseDate: string;
            repos: Record<string, string>;
        } | undefined;
        backend?: string;
        GUI?: string;
        latestRelease?: {
            releaseDate: string;
            repos: Record<string, string>;
        };
    }, resultFuncArgs_1: Record<string, boolean>) => {
        [key: string]: string | {
            releaseDate: string;
            repos: Record<string, string>;
        } | undefined;
        backend?: string;
        GUI?: string;
        latestRelease?: {
            releaseDate: string;
            repos: Record<string, string>;
        };
    };
    memoizedResultFunc: ((resultFuncArgs_0: {
        [key: string]: string | {
            releaseDate: string;
            repos: Record<string, string>;
        } | undefined;
        backend?: string;
        GUI?: string;
        latestRelease?: {
            releaseDate: string;
            repos: Record<string, string>;
        };
    }, resultFuncArgs_1: Record<string, boolean>) => {
        [key: string]: string | {
            releaseDate: string;
            repos: Record<string, string>;
        } | undefined;
        backend?: string;
        GUI?: string;
        latestRelease?: {
            releaseDate: string;
            repos: Record<string, string>;
        };
    }) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => {
        [key: string]: string | {
            releaseDate: string;
            repos: Record<string, string>;
        } | undefined;
        backend?: string;
        GUI?: string;
        latestRelease?: {
            releaseDate: string;
            repos: Record<string, string>;
        };
    };
    dependencies: [(state: RootState) => {
        [key: string]: string | {
            releaseDate: string;
            repos: Record<string, string>;
        } | undefined;
        backend?: string;
        GUI?: string;
        latestRelease?: {
            releaseDate: string;
            repos: Record<string, string>;
        };
    }, (state: RootState) => Record<string, boolean>];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getIsPreview: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => boolean) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: {
        [key: string]: string | {
            releaseDate: string;
            repos: Record<string, string>;
        } | undefined;
        backend?: string;
        GUI?: string;
        latestRelease?: {
            releaseDate: string;
            repos: Record<string, string>;
        };
    }) => boolean;
    memoizedResultFunc: ((resultFuncArgs_0: {
        [key: string]: string | {
            releaseDate: string;
            repos: Record<string, string>;
        } | undefined;
        backend?: string;
        GUI?: string;
        latestRelease?: {
            releaseDate: string;
            repos: Record<string, string>;
        };
    }) => boolean) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => boolean;
    dependencies: [(state: RootState) => {
        [key: string]: string | {
            releaseDate: string;
            repos: Record<string, string>;
        } | undefined;
        backend?: string;
        GUI?: string;
        latestRelease?: {
            releaseDate: string;
            repos: Record<string, string>;
        };
    }];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};

export { getCommit, getDocsVersion, getFeatures, getFeedbackProbability, getFullVersionInformation, getHostAddress, getHostedAnnouncement, getIsFirstLogin, getIsPreview, getIsUploading, getRecaptchaKey, getSearchState, getSearchedDevices, getSentryConfig, getSnackbar, getStripeKey, getTrackerCode, getUploads, getVersionInformation };
