import * as redux from 'redux';
import * as _reduxjs_toolkit from '@reduxjs/toolkit';
import { PayloadAction } from '@reduxjs/toolkit';
import * as immer from 'immer';
import { Alert } from '@northern.tech/types/MenderTypes';
import { DeviceIssueOptionKey } from '@northern.tech/utils/constants';
import { AlertChannelKey } from './constants.cjs';

declare const sliceName = "monitor";
type IssueCounts = Record<DeviceIssueOptionKey, {
    filtered: number;
    total: number;
}>;
type ChannelSettings = Record<AlertChannelKey, {
    enabled: boolean;
}>;
type SanitizedAlert = Alert & {
    fullName?: string;
};
type MonitorSliceType = {
    alerts: {
        alertList: {
            page: number;
            perPage: number;
            total: number;
        };
        byDeviceId: {
            alerts?: Record<string, SanitizedAlert>;
            latest?: Record<string, SanitizedAlert>;
        };
    };
    issueCounts: {
        byType: IssueCounts;
    };
    settings: {
        global: {
            channels: ChannelSettings;
        };
    };
};
declare const initialState: MonitorSliceType;
declare const monitorSlice: _reduxjs_toolkit.Slice<MonitorSliceType, {
    changeAlertChannel: (state: immer.WritableDraft<MonitorSliceType>, action: PayloadAction<{
        channel: AlertChannelKey;
        enabled: boolean;
    }>) => void;
    receiveDeviceAlerts: (state: immer.WritableDraft<MonitorSliceType>, action: PayloadAction<{
        alerts: SanitizedAlert[];
        deviceId: string;
    }>) => void;
    receiveLatestDeviceAlerts: (state: immer.WritableDraft<MonitorSliceType>, action: PayloadAction<{
        alerts: SanitizedAlert[];
        deviceId: string;
    }>) => void;
    receiveDeviceIssueCounts: (state: immer.WritableDraft<MonitorSliceType>, action: PayloadAction<{
        counts: {
            filtered: number;
            total: number;
        };
        issueType: DeviceIssueOptionKey;
    }>) => void;
    setAlertListState: (state: immer.WritableDraft<MonitorSliceType>, action: {
        payload: any;
        type: string;
    }) => void;
}, "monitor", "monitor", _reduxjs_toolkit.SliceSelectors<MonitorSliceType>>;
declare const actions: _reduxjs_toolkit.CaseReducerActions<{
    changeAlertChannel: (state: immer.WritableDraft<MonitorSliceType>, action: PayloadAction<{
        channel: AlertChannelKey;
        enabled: boolean;
    }>) => void;
    receiveDeviceAlerts: (state: immer.WritableDraft<MonitorSliceType>, action: PayloadAction<{
        alerts: SanitizedAlert[];
        deviceId: string;
    }>) => void;
    receiveLatestDeviceAlerts: (state: immer.WritableDraft<MonitorSliceType>, action: PayloadAction<{
        alerts: SanitizedAlert[];
        deviceId: string;
    }>) => void;
    receiveDeviceIssueCounts: (state: immer.WritableDraft<MonitorSliceType>, action: PayloadAction<{
        counts: {
            filtered: number;
            total: number;
        };
        issueType: DeviceIssueOptionKey;
    }>) => void;
    setAlertListState: (state: immer.WritableDraft<MonitorSliceType>, action: {
        payload: any;
        type: string;
    }) => void;
}, "monitor">;
declare const _default: redux.Reducer<MonitorSliceType>;

export { actions, _default as default, initialState, monitorSlice, sliceName };
