import { SnackbarContent } from '../appSlice/index.cjs';
import { DeviceFilter, Device } from '../devicesSlice/index.cjs';
import * as _reduxjs_toolkit from '@reduxjs/toolkit';
import { AppDispatch, RootState } from '../store.cjs';
import { Alert } from '@northern.tech/types/MenderTypes';
import { DeviceIssueOptionKey } from '@northern.tech/utils/constants';
import { AlertChannelKey } from './constants.cjs';
import 'redux';
import 'immer';
import '@mui/material';
import '../commonConstants.cjs';
import 'react/jsx-runtime';
import '../devicesSlice/constants.cjs';
import '../deploymentsSlice/index.cjs';
import 'redux-thunk';
import '../usersSlice/constants.cjs';
import '../usersSlice/index.cjs';
import '../releasesSlice/index.cjs';
import '../organizationSlice/types.cjs';
import '../appSlice/constants.cjs';
import '@mui/material/OverridableComponent';
import '../organizationSlice/constants.cjs';
import '../onboardingSlice/index.cjs';
import '@northern.tech/types/Alert';

interface GetDeviceAlertsPayload {
    config?: {
        issuedAfter?: string;
        issuedBefore?: string;
        page?: number;
        perPage?: number;
        sortAscending?: boolean;
    };
    id: string;
}
declare const getDeviceAlerts: _reduxjs_toolkit.AsyncThunk<[{
    payload: {
        alerts: (Alert & {
            fullName?: string;
        })[];
        deviceId: string;
    };
    type: "monitor/receiveDeviceAlerts";
}, {
    payload: any;
    type: "monitor/setAlertListState";
}], GetDeviceAlertsPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
interface GetLatestDeviceAlertsPayload {
    config?: {
        page?: number;
        perPage?: number;
    };
    id: string;
}
declare const getLatestDeviceAlerts: _reduxjs_toolkit.AsyncThunk<{
    payload: {
        alerts: (Alert & {
            fullName?: string;
        })[];
        deviceId: string;
    };
    type: "monitor/receiveLatestDeviceAlerts";
}, GetLatestDeviceAlertsPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
interface GetIssueCountsByTypePayload {
    options?: Partial<{
        filters: DeviceFilter[];
        group: string;
        status: string;
        type: string;
    }>;
    type: DeviceIssueOptionKey;
}
declare const getIssueCountsByType: _reduxjs_toolkit.AsyncThunk<any, GetIssueCountsByTypePayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getDeviceMonitorConfig: _reduxjs_toolkit.AsyncThunk<[{
    payload: {
        id: string;
    } & Partial<Device>;
    type: "devices/receivedDevice";
}], string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
interface ChangeNotificationSettingPayload {
    channel?: AlertChannelKey;
    enabled: boolean;
}
declare const changeNotificationSetting: _reduxjs_toolkit.AsyncThunk<[{
    payload: {
        channel: AlertChannelKey;
        enabled: boolean;
    };
    type: "monitor/changeAlertChannel";
}, {
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}], ChangeNotificationSettingPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;

export { changeNotificationSetting, getDeviceAlerts, getDeviceMonitorConfig, getIssueCountsByType, getLatestDeviceAlerts };
