import * as redux from 'redux';
import * as _reduxjs_toolkit from '@reduxjs/toolkit';
import { PayloadAction } from '@reduxjs/toolkit';
import * as immer from 'immer';

declare const sliceName = "onboarding";
type OnboardingApproach = 'virtual' | 'physical';
type OnboardingSliceType = {
    address?: string;
    approach: OnboardingApproach | null;
    complete: boolean;
    demoArtifactPort: number;
    deviceConnection?: string;
    deviceType: string[] | string | null;
    progress: string | null;
    showTips: boolean | null;
    showTipsDialog: boolean;
};
declare const initialState: OnboardingSliceType;
declare const onboardingSlice: _reduxjs_toolkit.Slice<OnboardingSliceType, {
    setOnboardingState: (state: immer.WritableDraft<OnboardingSliceType>, action: PayloadAction<Partial<OnboardingSliceType>>) => {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    setDemoArtifactPort: (state: immer.WritableDraft<OnboardingSliceType>, action: PayloadAction<number>) => void;
    setShowOnboardingHelp: (state: immer.WritableDraft<OnboardingSliceType>, action: PayloadAction<boolean>) => void;
    setShowDismissOnboardingTipsDialog: (state: immer.WritableDraft<OnboardingSliceType>, action: PayloadAction<boolean>) => void;
    setOnboardingComplete: (state: immer.WritableDraft<OnboardingSliceType>, action: PayloadAction<boolean>) => void;
    setOnboardingProgress: (state: immer.WritableDraft<OnboardingSliceType>, action: PayloadAction<string>) => void;
    setOnboardingDeviceType: (state: immer.WritableDraft<OnboardingSliceType>, action: PayloadAction<string[] | string>) => void;
    setOnboardingApproach: (state: immer.WritableDraft<OnboardingSliceType>, action: PayloadAction<OnboardingApproach>) => void;
}, "onboarding", "onboarding", _reduxjs_toolkit.SliceSelectors<OnboardingSliceType>>;
declare const actions: _reduxjs_toolkit.CaseReducerActions<{
    setOnboardingState: (state: immer.WritableDraft<OnboardingSliceType>, action: PayloadAction<Partial<OnboardingSliceType>>) => {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    setDemoArtifactPort: (state: immer.WritableDraft<OnboardingSliceType>, action: PayloadAction<number>) => void;
    setShowOnboardingHelp: (state: immer.WritableDraft<OnboardingSliceType>, action: PayloadAction<boolean>) => void;
    setShowDismissOnboardingTipsDialog: (state: immer.WritableDraft<OnboardingSliceType>, action: PayloadAction<boolean>) => void;
    setOnboardingComplete: (state: immer.WritableDraft<OnboardingSliceType>, action: PayloadAction<boolean>) => void;
    setOnboardingProgress: (state: immer.WritableDraft<OnboardingSliceType>, action: PayloadAction<string>) => void;
    setOnboardingDeviceType: (state: immer.WritableDraft<OnboardingSliceType>, action: PayloadAction<string[] | string>) => void;
    setOnboardingApproach: (state: immer.WritableDraft<OnboardingSliceType>, action: PayloadAction<OnboardingApproach>) => void;
}, "onboarding">;
declare const _default: redux.Reducer<OnboardingSliceType>;

export { type OnboardingApproach, actions, _default as default, initialState, onboardingSlice, sliceName };
