import { Tenant as Tenant$1, TenantTenantadm, BillingProfile, Product, SAMLMetadata, AuditLog as AuditLog$1, Integration, Event } from '@northern.tech/types/MenderTypes';
import { SortOptions } from '@northern.tech/utils/constants';
import { AvailableAddon } from '../appSlice/constants.cjs';
import { SSO_TYPES } from './constants.cjs';
import '@mui/material/OverridableComponent';
import '@mui/material';

interface Card {
    brand?: string;
    expiration: {
        month?: number;
        year?: number;
    };
    last4?: string;
}
interface AuditLogSelectionState {
    detail?: string;
    endDate?: string;
    isLoading?: boolean;
    page: number;
    perPage: number;
    selectedId?: string;
    selectedIssue?: string;
    sort: SortOptions;
    startDate?: string;
    total: number;
    type?: {
        queryParameter: string;
        title: string;
        value: string;
    };
    user?: {
        id: string;
    };
}
interface AuditLog {
    events: Array<AuditLog$1>;
    selectionState: AuditLogSelectionState;
}
interface Webhook {
    events: Event[];
    eventsTotal: number;
}
type Tenant = Tenant$1 & TenantTenantadm & {
    addons: Addon[];
};
interface TenantList {
    page: number;
    perPage: number;
    selectedTenant: TenantTenantadm | null;
    sort: SortOptions;
    tenants: TenantTenantadm[];
    total: number;
}
type SSOConfig = SAMLMetadata & {
    config: string;
    type: [keyof typeof SSO_TYPES];
};
interface OrganizationState {
    auditlog: AuditLog;
    card: Card;
    externalDeviceIntegrations: Integration[];
    intentId: string | null;
    organization: Partial<Organization>;
    ssoConfigs: SSOConfig[];
    tenantList: TenantList;
    webhooks: Webhook;
}
interface Addon {
    enabled: boolean;
    name: AvailableAddon;
}
interface SubscriptionLine {
    amount: number;
    currency: string;
    description: string;
    price_id: string;
    quantity: number;
}
interface Subscription {
    currency: string;
    id: string;
    lines: SubscriptionLine[];
    period_end: string;
    period_start: string;
    plan: string;
    products: Product[];
    status: string;
    total: number;
}
interface Organization extends Tenant {
    addons: Addon[];
    billing_profile: BillingProfile;
    subscription: Subscription;
}

export type { Addon, AuditLogSelectionState, Card, Organization, OrganizationState, SSOConfig, Subscription, Tenant, TenantList, Webhook };
