import { ReadState } from './constants.cjs';
import * as _northern_tech_utils_constants from '@northern.tech/utils/constants';
import { UserSession, CustomColumn } from './index.cjs';
import * as _northern_tech_types_RolePermission from '@northern.tech/types/RolePermission';
import 'redux';
import '@reduxjs/toolkit';
import 'immer';
import '@northern.tech/types/MenderTypes';
import '../commonConstants.cjs';
import 'react/jsx-runtime';

declare const mockState: {
    byId: {
        a1: {
            email: string;
            id: string;
            created_ts: string;
            roles: "RBAC_ROLE_PERMIT_ALL"[];
            verified: boolean;
        };
        "a30a780b-b843-5344-80e3-0fd95a4f6fc3": {
            email: string;
            id: string;
            created_ts: string;
            roles: "RBAC_ROLE_PERMIT_ALL"[];
            tfa_status: "enabled";
        };
    };
    currentUser: string;
    globalSettings: {
        '2fa': string;
        id_attribute: undefined;
        previousFilters: never[];
    };
    rolesById: {
        test: {
            name: string;
            description: string;
            editable: boolean;
            uiPermissions: {
                groups: {
                    testGroup: "read"[];
                };
                releases: {
                    bar: "read"[];
                };
                auditlog: string[];
                deployments?: string[];
                tenantManagement: string[];
                userManagement: string[];
            };
            isCustom?: boolean;
            permissions?: _northern_tech_types_RolePermission.RolePermission[];
        };
    };
    settingsInitialized: boolean;
    userSettings: {
        '2fa': string;
        previousFilters: never[];
        columnSelection: never[];
        onboarding: {
            something: string;
        };
        tooltips: {};
    };
    activationCode?: string;
    currentSession?: UserSession | object;
    customColumns: CustomColumn[];
    permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
    qrCode: string | null;
    rolesInitialized: boolean;
    showConnectDeviceDialog: boolean;
    showFeedbackDialog: boolean;
    showStartupNotification: boolean;
    tooltips: {
        byId: Record<string, {
            readState: ReadState;
        }>;
    };
    userSettingsInitialized: boolean;
};

export { mockState };
