/**
 * The actor may be a user or device.
 * Depending on the type of the actor different information will be available.
 */
type Actor = {
    /**
     * A unique identifier of the actor.
     */
    id: string;
    /**
     * The type of the actor.
     */
    type: Actor.type;
    /**
     * The email address of the user.
     */
    email?: string;
    /**
     * The identity data of the device.
     */
    identity_data?: string;
};
declare namespace Actor {
    /**
     * The type of the actor.
     */
    enum type {
        USER = "user",
        DEVICE = "device"
    }
}

export { Actor };
