import { IdentityData } from './IdentityData.js';

/**
 * Authentication data set
 */
type AuthSetDeviceauth = {
    /**
     * Authentication data set ID.
     */
    id?: string;
    /**
     * The device's public key (PEM encoding). generated by the device or pre-provisioned by the vendor. Currently supported public algorithms are: RSA, Ed25519 and ECDSA P-256.
     */
    pubkey?: string;
    identity_data?: IdentityData;
    status?: AuthSetDeviceauth.status;
    /**
     * Created timestamp
     */
    ts?: string;
    /**
     * Device ID connected to authentication data set
     */
    device_id?: string;
};
declare namespace AuthSetDeviceauth {
    enum status {
        PENDING = "pending",
        ACCEPTED = "accepted",
        REJECTED = "rejected",
        PREAUTHORIZED = "preauthorized",
        NOAUTH = "noauth"
    }
}

export { AuthSetDeviceauth };
