import { DeviceAuthEvent } from './DeviceAuthEvent.js';
import { DeviceInventoryEvent } from './DeviceInventoryEvent.js';
import './AuthSet.js';

type Event = {
    /**
     * A unique event identifier generated by the Mender server
     */
    id?: string;
    /**
     * Type of the event
     */
    type?: Event.type;
    delivery_statuses?: Array<{
        /**
         * The ID of the integration the status belongs.
         */
        integration_id: string;
        /**
         * Whether the event hook was executed successfully.
         */
        success: boolean;
        /**
         * The (HTTP) status code of the hook.
         */
        status_code?: number;
        /**
         * An error message if the hook failed.
         */
        error?: string;
    }>;
    /**
     * Creation timestamp
     */
    time?: string;
    data?: DeviceAuthEvent | DeviceInventoryEvent;
};
declare namespace Event {
    /**
     * Type of the event
     */
    enum type {
        DEVICE_PROVISIONED = "device-provisioned",
        DEVICE_DECOMMISSIONED = "device-decommissioned",
        DEVICE_STATUS_CHANGED = "device-status-changed",
        DEVICE_INVENTORY_CHANGED = "device-inventory-changed"
    }
}

export { Event };
