import { SubscriptionRequest } from './SubscriptionRequest.js';
import './Plan.js';
import './Features.js';
import './Product.js';
import './Addon.js';

type Subscription = SubscriptionRequest & {
    /**
     * The unique subscription ID.
     */
    id?: string;
    /**
     * The subscription status.
     */
    status?: Subscription.status;
};
declare namespace Subscription {
    /**
     * The subscription status.
     */
    enum status {
        ACTIVE = "active",
        CANCELED = "canceled",
        INCOMPLETE = "incomplete",
        PAST_DUE = "past_due",
        UNPAID = "unpaid"
    }
}

export { Subscription };
