/**
 * Highcharts JS v12.4.0 (2025-09-04)
 * @module highcharts/modules/marker-clusters
 * @requires highcharts
 *
 * Marker clusters module for Highcharts
 *
 * (c) 2010-2025 Wojciech Chmiel
 *
 * License: www.highcharts.com/license
 */let t;import*as e from"../highcharts.js";var i,s,a={};a.n=t=>{var e=t&&t.__esModule?()=>t.default:()=>t;return a.d(e,{a:e}),e},a.d=(t,e)=>{for(var i in e)a.o(e,i)&&!a.o(t,i)&&Object.defineProperty(t,i,{enumerable:!0,get:e[i]})},a.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e);let r=e.default;var o=a.n(r);let n={cluster:{enabled:!1,allowOverlap:!0,animation:{duration:500},drillToCluster:!0,minimumClusterSize:2,layoutAlgorithm:{gridSize:50,distance:40,kmeansThreshold:100},marker:{symbol:"cluster",radius:15,lineWidth:0,lineColor:"#ffffff"},dataLabels:{enabled:!0,format:"{point.clusterPointsAmount}",verticalAlign:"middle",align:"center",style:{color:"contrast"},inside:!0}},tooltip:{clusterFormat:"<span>Clustered points: {point.clusterPointsAmount}</span><br/>"}};(i=s||(s={})).setLength=function(t,e,i){return Array.isArray(t)?(t.length=e,t):t[i?"subarray":"slice"](0,e)},i.splice=function(t,e,i,s,a=[]){if(Array.isArray(t))return Array.isArray(a)||(a=Array.from(a)),{removed:t.splice(e,i,...a),array:t};let r=Object.getPrototypeOf(t).constructor,o=t[s?"subarray":"slice"](e,e+i),n=new r(t.length-i+a.length);return n.set(t.subarray(0,e),0),n.set(a,e),n.set(t.subarray(e+i),e+a.length),{removed:o,array:n}};let{setLength:l,splice:p}=s,{fireEvent:u,objectEach:h,uniqueKey:d}=o(),c=class{constructor(t={}){this.autoId=!t.id,this.columns={},this.id=t.id||d(),this.modified=this,this.rowCount=0,this.versionTag=d();let e=0;h(t.columns||{},(t,i)=>{this.columns[i]=t.slice(),e=Math.max(e,t.length)}),this.applyRowCount(e)}applyRowCount(t){this.rowCount=t,h(this.columns,(e,i)=>{e.length!==t&&(this.columns[i]=l(e,t))})}deleteRows(t,e=1){if(e>0&&t<this.rowCount){let i=0;h(this.columns,(s,a)=>{this.columns[a]=p(s,t,e).array,i=s.length}),this.rowCount=i}u(this,"afterDeleteRows",{rowIndex:t,rowCount:e}),this.versionTag=d()}getColumn(t,e){return this.columns[t]}getColumns(t,e){return(t||Object.keys(this.columns)).reduce((t,e)=>(t[e]=this.columns[e],t),{})}getRow(t,e){return(e||Object.keys(this.columns)).map(e=>this.columns[e]?.[t])}setColumn(t,e=[],i=0,s){this.setColumns({[t]:e},i,s)}setColumns(t,e,i){let s=this.rowCount;h(t,(t,e)=>{this.columns[e]=t.slice(),s=t.length}),this.applyRowCount(s),i?.silent||(u(this,"afterSetColumns"),this.versionTag=d())}setRow(t,e=this.rowCount,i,s){let{columns:a}=this,r=i?this.rowCount+1:e+1;h(t,(t,o)=>{let n=a[o]||s?.addColumns!==!1&&Array(r);n&&(i?n=p(n,e,0,!0,[t]).array:n[e]=t,a[o]=n)}),r>this.rowCount&&this.applyRowCount(r),s?.silent||(u(this,"afterSetRows"),this.versionTag=d())}},{animObject:m}=o(),{cluster:f}=n,{addEvent:g,defined:x,error:y,isArray:C,isFunction:k,isObject:I,isNumber:M,merge:b,objectEach:S,relativeLength:A,syncTimeout:w}=o(),P={grid:function(t,e,i,s){let a,r,o,n,l,p={},u=this.getGridOffset(),h=this.getScaledGridSize(s);for(l=0;l<t.length;l++){let s=Q(this,{x:t[l],y:e[l]});a=s.x-u.plotLeft,r=s.y-u.plotTop,o=Math.floor(a/h),p[n=Math.floor(r/h)+":"+o]??(p[n]=[]),p[n].push({dataIndex:i[l],x:t[l],y:e[l]})}return p},kmeans:function(t,e,i,s){let a=[],r=[],o={},n=s.processedDistance||f.layoutAlgorithm.distance,l=s.iterations,p=0,u=!0,h=0,d=0,c,m=[];s.processedGridSize=s.processedDistance;let g=this.markerClusterAlgorithms?this.markerClusterAlgorithms.grid.call(this,t,e,i,s):{};for(let t in g)g[t].length>1&&(c=T(g[t]),a.push({posX:c.x,posY:c.y,oldX:0,oldY:0,startPointsLen:g[t].length,points:[]}));for(;u;){for(let t of a)t.points.length=0;r.length=0;for(let s=0;s<t.length;s++)h=t[s],d=e[s],(m=this.getClusterDistancesFromPoint(a,h,d)).length&&m[0].distance<n?a[m[0].clusterIndex].points.push({x:h,y:d,dataIndex:i[s]}):r.push({x:h,y:d,dataIndex:i[s]});for(let t=0;t<a.length;t++)1===a[t].points.length&&(m=this.getClusterDistancesFromPoint(a,a[t].points[0].x,a[t].points[0].y))[1].distance<n&&(a[m[1].clusterIndex].points.push(a[t].points[0]),a[m[0].clusterIndex].points.length=0);u=!1;for(let t=0;t<a.length;t++)c=T(a[t].points),a[t].oldX=a[t].posX,a[t].oldY=a[t].posY,a[t].posX=c.x,a[t].posY=c.y,(a[t].posX>a[t].oldX+1||a[t].posX<a[t].oldX-1||a[t].posY>a[t].oldY+1||a[t].posY<a[t].oldY-1)&&(u=!0);l&&(u=p<l-1),p++}for(let t=0,e=a.length;t<e;++t)o["cluster"+t]=a[t].points;for(let t=0,e=r.length;t<e;++t)o["noise"+t]=[r[t]];return o},optimizedKmeans:function(t,e,i,s){let a=s.processedDistance||f.layoutAlgorithm.gridSize,r=this.getRealExtremes(),o=(this.options.cluster||{}).marker,n,l={},p,u;if(!this.markerClusterInfo||this.initMaxX&&this.initMaxX<r.maxX||this.initMinX&&this.initMinX>r.minX||this.initMaxY&&this.initMaxY<r.maxY||this.initMinY&&this.initMinY>r.minY)this.initMaxX=r.maxX,this.initMinX=r.minX,this.initMaxY=r.maxY,this.initMinY=r.minY,l=this.markerClusterAlgorithms?this.markerClusterAlgorithms.kmeans.call(this,t,e,i,s):{},this.baseClusters=null;else{for(let t of(this.baseClusters??(this.baseClusters={clusters:this.markerClusterInfo.clusters,noise:this.markerClusterInfo.noise}),this.baseClusters.clusters)){for(let e of(t.pointsOutside=[],t.pointsInside=[],t.data)){let i=Q(this,e),s=Q(this,t);n=Math.sqrt(Math.pow(i.x-s.x,2)+Math.pow(i.y-s.y,2)),p=a-(u=t.clusterZone?.marker?.radius?t.clusterZone.marker.radius:o?.radius?o.radius:f.marker.radius)>=0?a-u:u,n>u+p&&x(t.pointsOutside)?t.pointsOutside.push(e):x(t.pointsInside)&&t.pointsInside.push(e)}t.pointsInside.length&&(l[t.id]=t.pointsInside);let e=0;for(let i of t.pointsOutside)l[t.id+"_noise"+e++]=[i]}for(let t of this.baseClusters.noise)l[t.id]=t.data}return l}},X,Y=[],L=0;function z(t,e,i){t.attr({opacity:e}).animate({opacity:1},i)}function D(t,e,i,s){for(let a of(O(t,s,i,!0,!0),e))a.point?.destroy?.()}function O(t,e,i,s,a){t.point&&(s&&t.point.graphic&&(t.point.graphic.show(),z(t.point.graphic,e,i)),a&&t.point.dataLabel&&(t.point.dataLabel.show(),z(t.point.dataLabel,e,i)))}function T(t){let e=t.length,i=0,s=0;for(let a=0;a<e;a++)i+=t[a].x,s+=t[a].y;return{x:i/e,y:s/e}}function v(t,e){let i=[];return i.length=e,t.clusters.forEach(function(t){t.data.forEach(function(t){i[t.dataIndex]=t})}),t.noise.forEach(function(t){i[t.data[0].dataIndex]=t.data[0]}),i}function R(){return Math.random().toString(36).substring(2,7)+"-"+L++}function V(t,e,i){t.point&&(e&&t.point.graphic&&t.point.graphic.hide(),i&&t.point.dataLabel&&t.point.dataLabel.hide())}function E(t){(t.point||t.target).firePointEvent("drillToCluster",t,function(t){let e=t.point||t.target,i=e.series,{xAxis:s,yAxis:a,chart:r}=i,{inverted:o,mapView:n,pointer:l}=r;if(i.options.cluster?.drillToCluster&&e.clusteredData){let t=e.clusteredData.map(t=>t.x).sort((t,e)=>t-e),i=e.clusteredData.map(t=>t.y).sort((t,e)=>t-e),p=t[0],u=t[t.length-1],h=i[0],d=i[i.length-1],c=Math.abs((u-p)*.1),m=Math.abs((d-h)*.1),f=Math.min(p,u)-c,g=Math.max(p,u)+c,x=Math.min(h,d)-m,y=Math.max(h,d)+m;if(n)n.fitToBounds({x1:f,x2:g,y1:x,y2:y});else if(s&&a){let t=s.toPixels(f),e=s.toPixels(g),i=a.toPixels(x),n=a.toPixels(y);o&&([t,e,i,n]=[i,n,t,e]),t>e&&([t,e]=[e,t]),i>n&&([i,n]=[n,i]),l&&(l.zoomX=!0,l.zoomY=!0),r.transform({from:{x:t,y:i,width:e-t,height:n-i}})}}})}function j(t,e){let{chart:i,xAxis:s,yAxis:a}=t;return i.mapView?i.mapView.pixelsToProjectedUnits(e):{x:s?s.toValue(e.x):0,y:a?a.toValue(e.y):0}}function G(t){let e=this.chart,i=e.mapView,s=m(this.options.cluster?.animation),a=s.duration||500,r=this.markerClusterInfo?.pointsState,o=r?.newState,n=r?.oldState,l=[],p,u,h,d=0,c=0,f=0,g=!1,x=!1;if(n&&o){let r=Q(this,u=o[t.stateId]);c=r.x-(i?0:e.plotLeft),f=r.y-(i?0:e.plotTop),1===u.parentsId.length?(p=n[o?.[t.stateId].parentsId[0]],u.point?.graphic&&p.point?.plotX&&p.point.plotY&&(p.point.plotX!==u.point.plotX||p.point.plotY!==u.point.plotY)&&(h=u.point.graphic.getBBox(),d=u.point.graphic?.isImg?0:h.width/2,u.point.graphic.attr({x:p.point.plotX-d,y:p.point.plotY-d}),u.point.graphic.animate({x:c-(u.point.graphic.radius||0),y:f-(u.point.graphic.radius||0)},s,function(){x=!0,p.point?.destroy?.()}),u.point.dataLabel?.alignAttr&&p.point.dataLabel?.alignAttr&&(u.point.dataLabel.attr({x:p.point.dataLabel.alignAttr.x,y:p.point.dataLabel.alignAttr.y}),u.point.dataLabel.animate({x:u.point.dataLabel.alignAttr.x,y:u.point.dataLabel.alignAttr.y},s)))):0===u.parentsId.length?(V(u,!0,!0),w(function(){O(u,.1,s,!0,!0)},a/2)):(V(u,!0,!0),u.parentsId.forEach(function(t){n?.[t]&&(p=n[t],l.push(p),p.point?.graphic&&(g=!0,p.point.graphic.show(),p.point.graphic.animate({x:c-(p.point.graphic.radius||0),y:f-(p.point.graphic.radius||0),opacity:.4},s,function(){x=!0,D(u,l,s,.7)}),p.point.dataLabel&&-9999!==p.point.dataLabel.y&&u.point?.dataLabel?.alignAttr&&(p.point.dataLabel.show(),p.point.dataLabel.animate({x:u.point.dataLabel.alignAttr.x,y:u.point.dataLabel.alignAttr.y,opacity:.4},s))))}),w(function(){x||D(u,l,s,.85)},a),g||w(function(){D(u,l,s,.1)},a/2))}}function F(){this.markerClusterSeriesData?.forEach(t=>{t?.destroy?.()}),this.markerClusterSeriesData=null}function W(){let t,e,i,s,a,r,o,n,l,p,u,h,d,m,y,C,I=this,{chart:b}=I,S=b.mapView,w=I.getColumn("x"),P=I.getColumn("y"),Y=I.options.cluster,L=I.getRealExtremes(),z=[],D=[],O=[];if(S&&I.is("mappoint")&&w&&P&&I.options.data?.forEach((t,e)=>{let i=I.projectPoint(t);i&&(w[e]=i.x,P[e]=i.y)}),Y?.enabled&&w?.length&&P?.length&&!b.polar){u=Y.layoutAlgorithm.type,(y=Y.layoutAlgorithm).processedGridSize=A(y.gridSize||f.layoutAlgorithm.gridSize,b.plotWidth),y.processedDistance=A(y.distance||f.layoutAlgorithm.distance,b.plotWidth),s=y.kmeansThreshold||f.layoutAlgorithm.kmeansThreshold;let h=y.processedGridSize/2,S=j(I,{x:0,y:0}),v=j(I,{x:h,y:h});a=Math.abs(S.x-v.x),r=Math.abs(S.y-v.y);for(let t=0;t<w.length;t++)!I.dataMaxX&&(x(n)&&x(o)&&x(p)&&x(l)?M(P[t])&&M(p)&&M(l)&&(n=Math.max(w[t],n),o=Math.min(w[t],o),p=Math.max(P[t]||p,p),l=Math.min(P[t]||l,l)):(n=o=w[t],p=l=P[t])),w[t]>=L.minX-a&&w[t]<=L.maxX+a&&(P[t]||L.minY)>=L.minY-r&&(P[t]||L.maxY)<=L.maxY+r&&(z.push(w[t]),D.push(P[t]),O.push(t));if(x(n)&&x(o)&&M(p)&&M(l)&&(I.dataMaxX=n,I.dataMinX=o,I.dataMaxY=p,I.dataMinY=l),d=(m=(k(u)?u:I.markerClusterAlgorithms?u&&I.markerClusterAlgorithms[u]?I.markerClusterAlgorithms[u]:z.length<s?I.markerClusterAlgorithms.kmeans:I.markerClusterAlgorithms.grid:()=>!1).call(this,z,D,O,y))?I.getClusteredData(m,Y):m,Y.animation&&I.markerClusterInfo?.pointsState?.oldState){var T=I.markerClusterInfo.pointsState.oldState;for(let t of Object.keys(T))T[t].point?.destroy?.();t=I.markerClusterInfo.pointsState.newState}else t={};e=w.length,i=I.markerClusterInfo,d&&(I.dataTable.modified=new c({columns:{x:d.groupedXData,y:d.groupedYData}}),I.hasGroupedData=!0,I.markerClusterInfo=d,I.groupMap=d.groupMap),X.apply(this),d&&I.markerClusterInfo&&(I.markerClusterInfo.clusters?.forEach(t=>{(C=I.points[t.index]).isCluster=!0,C.clusteredData=t.data,C.clusterPointsAmount=t.data.length,t.point=C,g(C,"click",E)}),I.markerClusterInfo.noise?.forEach(t=>{t.point=I.points[t.index]}),Y.animation&&I.markerClusterInfo&&(I.markerClusterInfo.pointsState={oldState:t,newState:I.getPointsState(d,i,e)}),Y.animation?this.hideClusteredData():this.destroyClusteredData(),this.markerClusterSeriesData=this.hasGroupedData?this.points:null)}else X.apply(this)}function Z(t,e,i){let s=[];for(let a=0;a<t.length;a++){let r=Q(this,{x:e,y:i}),o=Q(this,{x:t[a].posX,y:t[a].posY}),n=Math.sqrt(Math.pow(r.x-o.x,2)+Math.pow(r.y-o.y,2));s.push({clusterIndex:a,distance:n})}return s.sort((t,e)=>t.distance-e.distance)}function _(t,e){let i=this.options.data,s=[],a=[],r=[],o=[],n=[],l=Math.max(2,e.minimumClusterSize||2),p=0,u,h,d,c,m,g,x,M,S,A,w,P;if(k(e.layoutAlgorithm.type)&&!this.isValidGroupedDataObject(t))return y("Highcharts marker-clusters module: The custom algorithm result is not valid!",!1,this.chart),!1;for(let y in t)if(t[y].length>=l){if(d=t[y],u=R(),m=d.length,e.zones)for(let t=0;t<e.zones.length;t++)m>=e.zones[t].from&&m<=e.zones[t].to&&((w=e.zones[t]).zoneIndex=t,A=e.zones[t].marker,P=e.zones[t].className);S=T(d),"grid"!==e.layoutAlgorithm.type||e.allowOverlap?x={x:S.x,y:S.y}:(g=this.options.marker||{},x=this.preventClusterCollisions({x:S.x,y:S.y,key:y,groupedData:t,gridSize:this.getScaledGridSize(e.layoutAlgorithm),defaultRadius:g.radius||3+(g.lineWidth||0),clusterRadius:A&&A.radius?A.radius:(e.marker||{}).radius||f.marker.radius}));for(let t=0;t<m;t++)d[t].parentStateId=u;if(r.push({x:x.x,y:x.y,id:y,stateId:u,index:p,data:d,clusterZone:w,clusterZoneClassName:P}),s.push(x.x),a.push(x.y),n.push({options:{formatPrefix:"cluster",dataLabels:e.dataLabels,marker:b(e.marker,{states:e.states},A||{})}}),i?.length)for(let t=0;t<m;t++)I(i[d[t].dataIndex])&&(d[t].options=i[d[t].dataIndex]);p++,A=null}else for(let e=0;e<t[y].length;e++)h=t[y][e],u=R(),M=null,c=i?.[h.dataIndex],s.push(h.x),a.push(h.y),h.parentStateId=u,o.push({x:h.x,y:h.y,id:y,stateId:u,index:p,data:t[y]}),M=c&&"object"==typeof c&&!C(c)?b(c,{x:h.x,y:h.y}):{userOptions:c,x:h.x,y:h.y},n.push({options:M}),p++;return{clusters:r,noise:o,groupedXData:s,groupedYData:a,groupMap:n}}function B(){let{chart:t,xAxis:e,yAxis:i}=this,s=0,a=0;return{plotLeft:s=e&&this.dataMinX&&this.dataMaxX?e.reversed?e.toPixels(this.dataMaxX):e.toPixels(this.dataMinX):t.plotLeft,plotTop:i&&this.dataMinY&&this.dataMaxY?i.reversed?i.toPixels(this.dataMinY):i.toPixels(this.dataMaxY):t.plotTop}}function H(t,e,i){let s,a,r=e?v(e,i):[],o=v(t,i),n={};Y=[],t.clusters.forEach(t=>{n[t.stateId]={x:t.x,y:t.y,id:t.stateId,point:t.point,parentsId:[]}}),t.noise.forEach(t=>{n[t.stateId]={x:t.x,y:t.y,id:t.stateId,point:t.point,parentsId:[]}});for(let t=0;t<o.length;t++)s=o[t],a=r[t],s?.parentStateId&&a?.parentStateId&&n[s.parentStateId]?.parentsId.indexOf(a.parentStateId)===-1&&(n[s.parentStateId].parentsId.push(a.parentStateId),-1===Y.indexOf(a.parentStateId)&&Y.push(a.parentStateId));return n}function q(){let t=this.chart,e=t.mapView?0:t.plotLeft,i=j(this,{x:e,y:t.mapView?0:t.plotTop}),s=j(this,{x:e+t.plotWidth,y:e+t.plotHeight}),a=i.x,r=s.x,o=i.y,n=s.y;return{minX:Math.min(a,r),maxX:Math.max(a,r),minY:Math.min(o,n),maxY:Math.max(o,n)}}function N(t){let e=this.xAxis,i=this.chart.mapView,s=t.processedGridSize||f.layoutAlgorithm.gridSize,a=!0,r=1,o=1;this.gridValueSize||(i?this.gridValueSize=s/i.getScale():this.gridValueSize=Math.abs(e.toValue(s)-e.toValue(0)));let n=+(s/(i?this.gridValueSize*i.getScale():e.toPixels(this.gridValueSize)-e.toPixels(0))).toFixed(14);for(;a&&1!==n;){let t=Math.pow(2,r);n>.75&&n<1.25?a=!1:n>=1/t&&n<1/t*2?(a=!1,o=t):n<=t&&n>t/2&&(a=!1,o=1/t),r++}return s/o/n}function U(){let t=this.markerClusterSeriesData,e=this.markerClusterInfo?.pointsState?.oldState,i=Y.map(t=>e?.[t].point?.id||"");t?.forEach(t=>{t&&-1!==i.indexOf(t.id)?(t.graphic&&t.graphic.hide(),t.dataLabel&&t.dataLabel.hide()):t?.destroy?.()})}function K(t){let e=!1;return!!I(t)&&(S(t,t=>{if(e=!0,!C(t)||!t.length){e=!1;return}for(let i=0;i<t.length;i++)if(!I(t[i])||!t[i].x||!t[i].y){e=!1;return}}),e)}function J(t){let[e,i]=t.key.split(":").map(parseFloat),s=t.gridSize,a=t.groupedData,r=t.defaultRadius,o=t.clusterRadius,n=i*s,l=e*s,p=Q(this,t),u=[],h=this.options.cluster?.marker,d=this.options.cluster?.zones,c=this.getGridOffset(),m=p.x,g=p.y,y=0,C=0,k,I,M,b,S,A,w,P,X,Y,L,z;m-=c.plotLeft,g-=c.plotTop;for(let a=1;a<5;a++)for(w=0,M=a%2?-1:1,b=a<3?-1:1,S=Math.floor((m+M*o)/s),z=[(A=Math.floor((g+b*o)/s))+":"+S,A+":"+i,e+":"+S];w<z.length;w++)-1===u.indexOf(z[w])&&z[w]!==t.key&&u.push(z[w]);for(let t of u)if(a[t]){a[t].posX||(Y=T(a[t]),a[t].posX=Y.x,a[t].posY=Y.y);let p=Q(this,{x:a[t].posX||0,y:a[t].posY||0});if(k=p.x-c.plotLeft,I=p.y-c.plotTop,[X,P]=t.split(":").map(parseFloat),d){y=a[t].length;for(let t=0;t<d.length;t++)y>=d[t].from&&y<=d[t].to&&(C=x(d[t].marker?.radius)?d[t].marker.radius||0:h?.radius?h.radius:f.marker.radius)}a[t].length>1&&0===C&&h?.radius?C=h.radius:1===a[t].length&&(C=r),L=o+C,C=0,P!==i&&Math.abs(m-k)<L&&(m=P-i<0?n+o:n+s-o),X!==e&&Math.abs(g-I)<L&&(g=X-e<0?l+o:l+s-o)}let D=j(this,{x:m+c.plotLeft,y:g+c.plotTop});return a[t.key].posX=D.x,a[t.key].posY=D.y,D}function Q(t,e){let{chart:i,xAxis:s,yAxis:a}=t;return i.mapView?i.mapView.projectedUnitsToPixels(e):{x:s?s.toPixels(e.x):0,y:a?a.toPixels(e.y):0}}let $={compose:function(t,e){let i=e.prototype;!i.markerClusterAlgorithms&&(X=i.generatePoints,i.markerClusterAlgorithms=P,i.animateClusterPoint=G,i.destroyClusteredData=F,i.generatePoints=W,i.getClusterDistancesFromPoint=Z,i.getClusteredData=_,i.getGridOffset=B,i.getPointsState=H,i.getRealExtremes=q,i.getScaledGridSize=N,i.hideClusteredData=U,i.isValidGroupedDataObject=K,i.preventClusterCollisions=J,g(e,"destroy",i.destroyClusteredData),t.plotOptions&&(t.plotOptions.series=b(t.plotOptions.series,n)))}},{animObject:tt}=o(),{defaultOptions:te}=o(),{composed:ti}=o(),{addEvent:ts,defined:ta,error:tr,isFunction:to,merge:tn,pushUnique:tl,syncTimeout:tp}=o();function tu(){let t=this.chart,e=0;for(let i of t.series)i.markerClusterInfo&&(e=tt((i.options.cluster||{}).animation).duration||0);tp(()=>{t.tooltip&&t.tooltip.destroy()},e)}function th(){for(let t of this.series||[])if(t.markerClusterInfo){let e=t.options.cluster,i=((t.markerClusterInfo||{}).pointsState||{}).oldState;if((e||{}).animation&&t.markerClusterInfo&&0===(t.chart.pointer?.pinchDown||[]).length&&"pan"!==((t.xAxis||{}).eventArgs||{}).trigger&&i&&Object.keys(i).length){for(let e of t.markerClusterInfo.clusters)t.animateClusterPoint(e);for(let e of t.markerClusterInfo.noise)t.animateClusterPoint(e)}}}function td(t){let e=(((t.point||t.target).series.options.cluster||{}).events||{}).drillToCluster;to(e)&&e.call(this,t)}function tc(){if(this.dataGroup)return tr("Highcharts marker-clusters module: Running `Point.update` when point belongs to clustered series is not supported.",!1,this.series.chart),!1}function tm(){let t=(this.options.cluster||{}).drillToCluster;if(this.markerClusterInfo&&this.markerClusterInfo.clusters)for(let e of this.markerClusterInfo.clusters)e.point&&e.point.graphic&&(e.point.graphic.addClass("highcharts-cluster-point"),t&&e.point&&(e.point.graphic.css({cursor:"pointer"}),e.point.dataLabel&&e.point.dataLabel.css({cursor:"pointer"})),ta(e.clusterZone)&&e.point.graphic.addClass(e.clusterZoneClassName||"highcharts-cluster-zone-"+e.clusterZone.zoneIndex))}function tf(e,i,s,a){let r=s/2,o=a/2,n=t.arc(e+r,i+o,r-4,o-4,{start:.5*Math.PI,end:2.5*Math.PI,open:!1}),l=t.arc(e+r,i+o,r-3,o-3,{start:.5*Math.PI,end:2.5*Math.PI,innerR:r-2,open:!1});return t.arc(e+r,i+o,r-1,o-1,{start:.5*Math.PI,end:2.5*Math.PI,innerR:r,open:!1}).concat(l,n)}(te.plotOptions||{}).series=tn((te.plotOptions||{}).series,n);let tg=o();({compose:function(t,e,i,s){if(tl(ti,"MarkerClusters")){let a=s.prototype.pointClass,{scatter:r}=s.types;ts(t,"setExtremes",tu),ts(e,"render",th),ts(a,"drillToCluster",td),ts(a,"update",tc),ts(s,"afterRender",tm),r&&$.compose(i,r)}}}).compose(tg.Axis,tg.Chart,tg.defaultOptions,tg.Series),({compose:function(e){(t=e.prototype.symbols).cluster=tf}}).compose(tg.SVGRenderer);let tx=o();export{tx as default};