/**
 * Highstock JS v12.4.0 (2025-09-04)
 * @module highcharts/modules/pointandfigure
 * @requires highcharts
 * @requires highcharts/modules/stock
 *
 * Point and figure series type for Highcharts Stock
 *
 * (c) 2010-2025 Kamil Musialowski
 *
 * License: www.highcharts.com/license
 */import*as t from"../highcharts.js";import"./stock.js";var e,r={};r.n=t=>{var e=t&&t.__esModule?()=>t.default:()=>t;return r.d(e,{a:e}),e},r.d=(t,e)=>{for(var s in e)r.o(e,s)&&!r.o(t,s)&&Object.defineProperty(t,s,{enumerable:!0,get:e[s]})},r.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e);let s=t.default;var o=r.n(s);r.d({},{});let i=t.default.SeriesRegistry;var a=r.n(i);let{seriesTypes:{scatter:{prototype:{pointClass:l}}}}=a(),n=class extends l{resolveMarker(){let t=this.series.options;this.marker=this.options.marker=this.upTrend?t.markerUp:t.marker,this.color=this.options.marker.lineColor}resolveColor(){super.resolveColor(),this.resolveMarker()}getClassName(){return super.getClassName.call(this)+(this.upTrend?" highcharts-point-up":" highcharts-point-down")}},p=t.default.RendererRegistry;var h=r.n(p);let u=[];function d(t,e,r,s){return[["M",t,e],["L",t+r,e+s],["M",t+r,e],["L",t,e+s],["Z"]]}(e||(e={})).compose=function(t){-1===u.indexOf(t)&&(u.push(t),t.prototype.symbols.cross=d);let e=h().getRendererType();u.indexOf(e)&&u.push(e)};let c=e,{composed:f}=o(),{scatter:m,column:{prototype:g}}=a().seriesTypes,{extend:y,merge:b,pushUnique:x,isNumber:k,relativeLength:C}=o();class M extends m{constructor(){super(...arguments),this.allowDG=!1}static compose(t){x(f,"pointandfigure")&&c.compose(t)}init(){super.init.apply(this,arguments),this.pnfDataGroups=[]}getProcessedData(){let t;if(!this.pnfDataGroups)return{modified:this.dataTable.modified,cropped:!1,cropStart:0,closestPointRange:1};let e=this.dataTable.modified,r=this.options,s=this.getColumn("x",!0),o=this.getColumn("y",!0),i=r.boxSize,a=k(i)?i:C(i,o[0]),l=this.pnfDataGroups,n=a*r.reversalAmount;function p(t,e,r){let s=l[l.length-1],o=e?1:-1,i=Math.floor(o*(t-r)/a);for(let t=1;t<=i;t++){let e=r+a*t*o;s.y.push(e)}}if(this.calculatedBoxSize=a,this.isDirtyData||0===l.length){this.pnfDataGroups.length=0;for(let e=0;e<o.length;e++){let r=s[e],i=o[e],n=o[0];if(i-n>=a){t=!0,l.push({x:r,y:[i],upTrend:t});break}if(n-i>=a){t=!1,l.push({x:r,y:[i],upTrend:t});break}}o.forEach((e,r)=>{let o=s[r],i=function(t){let e=t[t.length-1].y;return e[e.length-1]}(l);t&&(e-i>=a&&p(e,t,i),i-e>=n&&(t=!1,l.push({x:o,y:[],upTrend:t}),p(e,t,i))),!t&&(i-e>=a&&p(e,t,i),e-i>=n&&(t=!0,l.push({x:o,y:[],upTrend:t}),p(e,t,i)))})}let h=[],u=[],d=[];return l.forEach(t=>{let e=t.x,r=t.upTrend;t.y.forEach(t=>{u.push(e),d.push(t),h.push({x:e,y:t,upTrend:r})})}),e.setColumn("x",u),e.setColumn("y",d),this.pnfDataGroups=l,this.processedData=h,{modified:e,cropped:!1,cropStart:0,closestPointRange:1}}markerAttribs(t){let e=this.options,r={},s=t.pos();return r.width=this.markerWidth,r.height=this.markerHeight,s&&r.width&&r.height&&(r.x=s[0]-Math.round(r.width)/2,r.y=s[1]-Math.round(r.height)/2),e.crisp&&r.x&&(r.x=Math.floor(r.x)),r}translate(){let t=this.getColumnMetrics(),e=this.calculatedBoxSize;this.markerWidth=t.width+t.paddedWidth+t.offset,this.markerHeight=this.yAxis.toPixels(0)-this.yAxis.toPixels(e),super.translate()}}M.defaultOptions=b(m.defaultOptions,{boxSize:"1%",reversalAmount:3,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Close: {point.y:.2f}<br/>',headerFormat:""},turboThreshold:0,groupPadding:.2,pointPadding:.1,pointRange:null,dataGrouping:{enabled:!1},markerUp:{symbol:"cross",lineColor:"#00FF00",lineWidth:2},marker:{symbol:"circle",fillColor:"transparent",lineColor:"#FF0000",lineWidth:2},legendSymbol:"lineMarker"}),y(M.prototype,{takeOrdinalPosition:!0,pnfDataGroups:[],getColumnMetrics:g.getColumnMetrics,pointClass:n,sorted:!0}),a().registerSeriesType("pointandfigure",M);let v=o();M.compose(v.Renderer);let D=o();export{D as default};