/**
 * CFEngine modification for the twitter bootstrap
 *
 *  Create styled dropdow, which can show selected value, as example you could see github select branch dropdown
 *
 *  Primarely used for select rows limit on the report pages.
 *
 *
 *  To use it add attribute with data-toggle=cfe-collapse-dropdown to the <select>
 *
 *  PARAMS:
 *
 *  data-btn-css-class - set button class, you could use bootstrap class or your own, by default btn-cfe-paginator is used
 *
 *  data-cfe-caret-text - used to set text after carret symbol
 *
 *  data-cfe-submit-on-change - true/false - submit form on dropdown change,  DEFAULT true
 *
 **/
//'select[data-toggle=cfe-collapse-dropdown]'
    $(document).ready(function() {
        cfepaginatordropdown('select[data-toggle=cfe-collapse-dropdown]');
    });

function cfepaginatordropdown(selector){
        $(selector).each(function(i, e){
                if (!($(e).data('convert') == 'no')) {
                        $(e).hide().wrap('<div class="btn-group pull-right" id="cfe-select-group-' + i + '" />');
                        //create new DOM element with unique ID
                        var select = $('#cfe-select-group-' + i);

                        //class for buttons, we can use bootstrap class or self made
                        var btn_css_class = ($(e).attr('data-btn-css-class')  != null) ? $(e).attr('data-btn-css-class')  : 'btn-cfe-paginator';

                        // text which we add to caret
                        var caret_text    = ($(e).attr('data-cfe-caret-text') != null) ? $(e).attr('data-cfe-caret-text') : '';

                        var current = ($(e).val()) ? $(e).val(): '&nbsp;';
                        //select.html('<input type="hidden" value="' + $(e).val() + '" name="' + $(e).attr('name') + '" id="' + $(e).attr('id') + '" class="' + $(e).attr('class') + '" /><a class="dropdown-toggle" role="button"  data-toggle="dropdown" href="javascript:;">'+ caret_text +'<b class="caret"></b></a><ul class="dropdown-menu"></ul>');

                        //<input type="hidden" value="' + $(e).val() + '" name="' + $(e).attr('name') + '" id="' + $(e).attr('id') + '" class="' + $(e).attr('class') + '" />

                        select.html('<button data-toggle="dropdown" value="' + $(e).val() + '" name="' + $(e).attr('name') + '" id="' + $(e).attr('id') + '" class="' + $(e).attr('class') + ' btn dropdown-toggle">'+ caret_text +'<span class="caret"></span></button><ul class="dropdown-menu"></ul><input type="hidden" value="' + $(e).val() + '" name="' + $(e).attr('name') + '" id="' + $(e).attr('id') + '" class="' + $(e).attr('class') + '" />');
                        $(e).find('option').each(function(o,q) {

                                select.find('.dropdown-menu').append('<li><a href="javascript:void(0);" data-value="' + $(q).attr('value') + '">' + $(q).text() + '</a></li>');
                                if ($(q).attr('selected')) select.find('.dropdown-menu li:eq(' + o + ')').click();
                        });
                        select.find('.dropdown-menu a').click(function() {
                                // check if value was changed
                                if(select.find('input[type=hidden]').val() == $(this).data('value') ) {

                                    return;
                                }



                                select.find('input[type=hidden]').val($(this).data('value')).change();

                                select.find('button.dropdown-toggle').text($(this).text());

                                var doSubmit = ($(e).attr('data-cfe-submit-on-change') != null) ? $(e).attr('data-cfe-submit-on-change') : true;

                                //cast type
                                doSubmit = (doSubmit.toLowerCase() === 'true');

                                if (doSubmit === true) {
                                    select.closest("form").submit();
                                    common.globalSpinner.show();
                                }
                        });

                        select.find('.cfe-option-value').click(function(event){
                           event.stopPropagation();
                           select.addClass('open');
                        });
                }
        });
};