"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/AsyncAutocomplete.tsx
var AsyncAutocomplete_exports = {};
__export(AsyncAutocomplete_exports, {
  AsyncAutocomplete: () => AsyncAutocomplete,
  default: () => AsyncAutocomplete_default
});
module.exports = __toCommonJS(AsyncAutocomplete_exports);
var import_react = require("react");
var import_material = require("@mui/material");
var import_constants = require("@northern.tech/store/constants");
var import_debouncehook = require("@northern.tech/utils/debouncehook");

// src/Loader.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var Loader = (props) => {
  const { fade, show, small, style, table, waiting } = props;
  const hideClass = fade ? "hidden" : "loaderContainer shrunk";
  const showClass = table ? "miniLoaderContainer" : "loaderContainer";
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { style, className: show ? showClass : hideClass, children: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: `${small ? "small" : ""} ${waiting ? "waiting-loader" : ""} loader`, children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { className: "dot dot_1" }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { className: "dot dot_2" }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { className: "dot dot_3" }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { className: "dot dot_4" })
  ] }) });
};
var Loader_default = Loader;

// src/AsyncAutocomplete.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var AsyncAutocomplete = ({
  id,
  initialValue,
  isLoading,
  label,
  placeholder,
  styles,
  selectionAttribute,
  labelAttribute,
  onChange,
  onChangeSelection,
  options
}) => {
  const theme = (0, import_material.useTheme)();
  const [open, setOpen] = (0, import_react.useState)(false);
  const [inputValue, setInputValue] = (0, import_react.useState)(initialValue);
  const loading = open && isLoading;
  const debouncedValue = (0, import_debouncehook.useDebounce)(inputValue, import_constants.TIMEOUTS.debounceShort);
  (0, import_react.useEffect)(() => {
    if (debouncedValue === void 0) {
      return;
    }
    const selection = options.find((option) => option[selectionAttribute] === debouncedValue);
    if (selection) {
      onChangeSelection(selection);
    } else {
      onChange(debouncedValue);
    }
  }, [debouncedValue, JSON.stringify(options), onChange, onChangeSelection, selectionAttribute]);
  const onInputChange = (e, value, reason) => {
    if (reason === "clear") {
      setInputValue("");
      return onChangeSelection();
    } else if (reason === "reset" && !e || reason === "blur") {
      return;
    }
    setInputValue(value);
  };
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
    import_material.Autocomplete,
    {
      autoHighlight: true,
      freeSolo: true,
      getOptionLabel: (option) => option[labelAttribute],
      isOptionEqualToValue: (option, value) => option[selectionAttribute] === value[selectionAttribute],
      id,
      inputValue: inputValue || "",
      loading,
      onClose: () => setOpen(false),
      onInputChange,
      onOpen: () => setOpen(true),
      open,
      openOnFocus: true,
      options,
      renderInput: (params) => /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
        import_material.TextField,
        {
          ...params,
          label,
          placeholder,
          style: styles.textField,
          slotProps: {
            input: {
              ...params.InputProps,
              endAdornment: /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(import_jsx_runtime2.Fragment, { children: [
                loading && /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(Loader_default, { show: true, small: true, table: true, style: { marginTop: theme.spacing(-4) } }),
                params.InputProps.endAdornment
              ] })
            }
          }
        }
      )
    }
  );
};
var AsyncAutocomplete_default = AsyncAutocomplete;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AsyncAutocomplete
});
//# sourceMappingURL=AsyncAutocomplete.cjs.map