/**
 * DeviceInventoryEvent describes an event that relates to changes to a device's inventory data.
 */
type DeviceInventoryEvent = {
    /**
     * Device unique ID.
     */
    device_id: string;
    /**
     * Tenant ID.
     */
    tenant_id: string;
    /**
     * Arbitrary key-value pairs of inventory attributes as device has sent them
     */
    inventory: Record<string, any>;
};

export type { DeviceInventoryEvent };
