/**
 * Highstock JS v12.4.0 (2025-09-04)
 * @module highcharts/indicators/ichimoku-kinko-hyo
 * @requires highcharts
 * @requires highcharts/modules/stock
 *
 * Indicator series type for Highcharts Stock
 *
 * (c) 2010-2025 Sebastian Bochan
 *
 * License: www.highcharts.com/license
 */import*as o from"../highcharts.js";import"../modules/stock.js";import*as t from"../modules/datagrouping.js";var e={};e.n=o=>{var t=o&&o.__esModule?()=>o.default:()=>o;return e.d(t,{a:t}),t},e.d=(o,t)=>{for(var n in t)e.o(t,n)&&!e.o(o,n)&&Object.defineProperty(o,n,{enumerable:!0,get:t[n]})},e.o=(o,t)=>Object.prototype.hasOwnProperty.call(o,t);let n=o.default;var i=e.n(n);e.d({},{});let p=t.default.dataGrouping.approximations;var l=e.n(p);let s=o.default.Color;var a=e.n(s);let r=o.default.SeriesRegistry;var h=e.n(r);let{parse:u}=a(),{sma:c}=h().seriesTypes,{defined:g,extend:k,isArray:f,isNumber:d,getClosestDistance:S,merge:y,objectEach:m}=i();function v(o){return{high:o.reduce(function(o,t){return Math.max(o,t[1])},-1/0),low:o.reduce(function(o,t){return Math.min(o,t[2])},1/0)}}function A(o){let t=o.indicator;t.points=o.points,t.nextPoints=o.nextPoints,t.color=o.color,t.options=y(o.options.senkouSpan.styles,o.gap),t.graph=o.graph,t.fillGraph=!0,h().seriesTypes.sma.prototype.drawGraph.call(t)}class C extends c{constructor(){super(...arguments),this.data=[],this.options={},this.points=[],this.graphCollection=[]}init(){super.init.apply(this,arguments),this.options=y({tenkanLine:{styles:{lineColor:this.color}},kijunLine:{styles:{lineColor:this.color}},chikouLine:{styles:{lineColor:this.color}},senkouSpanA:{styles:{lineColor:this.color,fill:u(this.color).setOpacity(.5).get()}},senkouSpanB:{styles:{lineColor:this.color,fill:u(this.color).setOpacity(.5).get()}},senkouSpan:{styles:{fill:u(this.color).setOpacity(.2).get()}}},this.options)}toYData(o){return[o.tenkanSen,o.kijunSen,o.chikouSpan,o.senkouSpanA,o.senkouSpanB]}translate(){for(let o of(h().seriesTypes.sma.prototype.translate.apply(this),this.points))for(let t of this.pointArrayMap){let e=o[t];d(e)&&(o["plot"+t]=this.yAxis.toPixels(e,!0),o.plotY=o["plot"+t],o.tooltipPos=[o.plotX,o["plot"+t]],o.isNull=!1)}}drawGraph(){let o=this,t=o.points,e=o.options,n=o.graph,i=o.color,p={options:{gapSize:e.gapSize}},l=o.pointArrayMap.length,s=[[],[],[],[],[],[]],a={tenkanLine:s[0],kijunLine:s[1],chikouLine:s[2],senkouSpanA:s[3],senkouSpanB:s[4],senkouSpan:s[5]},r=[],u=o.options.senkouSpan,c=u.color||u.styles.fill,k=u.negativeColor,f=[[],[]],d=[[],[]],S=t.length,v=0,C,Y,x,P,B,N,b,G,X,T,j,O,L;for(o.ikhMap=a;S--;){for(x=0,Y=t[S];x<l;x++)g(Y[C=o.pointArrayMap[x]])&&s[x].push({plotX:Y.plotX,plotY:Y["plot"+C],isNull:!1});if(k&&S!==t.length-1){let o=a.senkouSpanB.length-1,t=function(o,t,e,n){if(o&&t&&e&&n){let i=t.plotX-o.plotX,p=t.plotY-o.plotY,l=n.plotX-e.plotX,s=n.plotY-e.plotY,a=o.plotX-e.plotX,r=o.plotY-e.plotY,h=(-p*a+i*r)/(-l*p+i*s),u=(l*r-s*a)/(-l*p+i*s);if(h>=0&&h<=1&&u>=0&&u<=1)return{plotX:o.plotX+u*i,plotY:o.plotY+u*p}}}(a.senkouSpanA[o-1],a.senkouSpanA[o],a.senkouSpanB[o-1],a.senkouSpanB[o]);if(t){let e={plotX:t.plotX,plotY:t.plotY,isNull:!1,intersectPoint:!0};a.senkouSpanA.splice(o,0,e),a.senkouSpanB.splice(o,0,e),r.push(o)}}}if(m(a,(t,n)=>{e[n]&&"senkouSpan"!==n&&(o.points=s[v],o.options=y(e[n].styles,p),o.graph=o["graph"+n],o.fillGraph=!1,o.color=i,h().seriesTypes.sma.prototype.drawGraph.call(o),o["graph"+n]=o.graph),v++}),o.graphCollection)for(let t of o.graphCollection)o[t].destroy(),delete o[t];if(o.graphCollection=[],k&&a.senkouSpanA[0]&&a.senkouSpanB[0]){for(r.unshift(0),r.push(a.senkouSpanA.length-1),O=0;O<r.length-1;O++)if(P=r[O],B=r[O+1],N=a.senkouSpanB.slice(P,B+1),b=a.senkouSpanA.slice(P,B+1),Math.floor(N.length/2)>=1){let o=Math.floor(N.length/2);if(N[o].plotY===b[o].plotY){for(L=0,G=0,X=0;L<N.length;L++)G+=N[L].plotY,X+=b[L].plotY;f[j=G>X?0:1]=f[j].concat(N),d[j]=d[j].concat(b)}else f[j=N[o].plotY>b[o].plotY?0:1]=f[j].concat(N),d[j]=d[j].concat(b)}else f[j=N[0].plotY>b[0].plotY?0:1]=f[j].concat(N),d[j]=d[j].concat(b);["graphsenkouSpanColor","graphsenkouSpanNegativeColor"].forEach(function(t,n){f[n].length&&d[n].length&&(T=0===n?c:k,A({indicator:o,points:f[n],nextPoints:d[n],color:T,options:e,gap:p,graph:o[t]}),o[t]=o.graph,o.graphCollection.push(t))})}else A({indicator:o,points:a.senkouSpanB,nextPoints:a.senkouSpanA,color:c,options:e,gap:p,graph:o.graphsenkouSpan}),o.graphsenkouSpan=o.graph;delete o.nextPoints,delete o.fillGraph,o.points=t,o.options=e,o.graph=n,o.color=i}getGraphPath(o){let t=[],e,n=[];if(o=o||this.points,this.fillGraph&&this.nextPoints){if((e=h().seriesTypes.sma.prototype.getGraphPath.call(this,this.nextPoints))&&e.length){e[0][0]="L",t=h().seriesTypes.sma.prototype.getGraphPath.call(this,o),n=e.slice(0,t.length);for(let o=n.length-1;o>=0;o--)t.push(n[o])}}else t=h().seriesTypes.sma.prototype.getGraphPath.apply(this,arguments);return t}getValues(o,t){let e,n,i,p,l,s,a,r,h,u,c=t.period,g=t.periodTenkan,k=t.periodSenkouSpanB,d=o.xData,y=o.yData,m=o.xAxis,A=y&&y.length||0,C=S(m.series.map(o=>o.getColumn("x"))),Y=[],x=[];if(d.length<=c||!f(y[0])||4!==y[0].length)return;let P=d[0]-c*C;for(l=0;l<c;l++)x.push(P+l*C);for(l=0;l<A;l++)l>=g&&(s=((n=v(y.slice(l-g,l))).high+n.low)/2),l>=c&&(h=(s+(a=((i=v(y.slice(l-c,l))).high+i.low)/2))/2),l>=k&&(u=((p=v(y.slice(l-k,l))).high+p.low)/2),r=y[l][3],e=d[l],void 0===Y[l]&&(Y[l]=[]),void 0===Y[l+c-1]&&(Y[l+c-1]=[]),Y[l+c-1][0]=s,Y[l+c-1][1]=a,Y[l+c-1][2]=void 0,void 0===Y[l+1]&&(Y[l+1]=[]),Y[l+1][2]=r,l<=c&&(Y[l+c-1][3]=void 0,Y[l+c-1][4]=void 0),void 0===Y[l+2*c-2]&&(Y[l+2*c-2]=[]),Y[l+2*c-2][3]=h,Y[l+2*c-2][4]=u,x.push(e);for(l=1;l<=c;l++)x.push(e+l*C);return{values:Y,xData:x,yData:Y}}}C.defaultOptions=y(c.defaultOptions,{params:{index:void 0,period:26,periodTenkan:9,periodSenkouSpanB:52},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>TENKAN SEN: {point.tenkanSen:.3f}<br/>KIJUN SEN: {point.kijunSen:.3f}<br/>CHIKOU SPAN: {point.chikouSpan:.3f}<br/>SENKOU SPAN A: {point.senkouSpanA:.3f}<br/>SENKOU SPAN B: {point.senkouSpanB:.3f}<br/>'},tenkanLine:{styles:{lineWidth:1,lineColor:void 0}},kijunLine:{styles:{lineWidth:1,lineColor:void 0}},chikouLine:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanA:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanB:{styles:{lineWidth:1,lineColor:void 0}},senkouSpan:{styles:{fill:"rgba(255, 0, 0, 0.5)"}},dataGrouping:{approximation:"ichimoku-averages"}}),k(C.prototype,{pointArrayMap:["tenkanSen","kijunSen","chikouSpan","senkouSpanA","senkouSpanB"],pointValKey:"tenkanSen",nameComponents:["periodSenkouSpanB","period","periodTenkan"]}),l()["ichimoku-averages"]=function(){let o,t=[];return[].forEach.call(arguments,function(e,n){t.push(l().average(e)),o=!o&&void 0===t[n]}),o?void 0:t},h().registerSeriesType("ikh",C);let Y=i();export{Y as default};