<?php

/**
 * Class HealthDiagnosticSqlBuilderFactory
 */
class HealthDiagnosticSqlBuilderFactory
{
    /**
     * @param string $category
     * @param string $userName
     *
     * @return HealthDiagnosticSqlBuilderInterface
     * @throws Exception
     */
    public static function createSqlBuilder(string $category, string $userName): HealthDiagnosticSqlBuilderInterface
    {
        $sqlBuilderClass = ucfirst($category) . 'SqlBuilder';
        $sqlBuilderFile  = __DIR__ . '/implementations/' . $sqlBuilderClass . '.php';
        if (file_exists($sqlBuilderFile) && include_once $sqlBuilderFile) {
            return new $sqlBuilderClass($userName);
        } else {
            throw new Exception('Class ' . $sqlBuilderClass . ' not found.');
        }
    }
}
