"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/ChipSelect.tsx
var ChipSelect_exports = {};
__export(ChipSelect_exports, {
  ChipSelect: () => ChipSelect,
  default: () => ChipSelect_default
});
module.exports = __toCommonJS(ChipSelect_exports);
var import_react = require("react");
var import_react_hook_form = require("react-hook-form");
var import_icons_material = require("@mui/icons-material");
var import_material = require("@mui/material");
var import_helpers = require("@northern.tech/utils/helpers");
var import_jsx_runtime = require("react/jsx-runtime");
var import_react2 = require("react");
var ChipSelect = ({ className = "", name, disabled = false, helperText, inputRef, label = "", options = [], placeholder = "" }) => {
  const [value, setValue] = (0, import_react.useState)("");
  const { control, getValues } = (0, import_react_hook_form.useFormContext)();
  const onTextInputChange = (inputValue, reason, setCurrentSelection) => {
    const value2 = inputValue || "";
    if (reason === "clear") {
      setValue("");
      return setCurrentSelection([]);
    } else if (reason === "reset") {
      return setValue("");
    }
    const lastIndex = value2.lastIndexOf(",");
    const possibleSelection = value2.substring(0, lastIndex).split(",").filter(import_helpers.duplicateFilter);
    const currentValue = value2.substring(lastIndex + 1);
    const selection = getValues(name);
    const nextSelection = (0, import_helpers.unionizeStrings)(selection, possibleSelection);
    setValue(currentValue);
    setCurrentSelection(nextSelection);
  };
  const onTextInputLeave = (value2, setCurrentSelection) => {
    const selection = getValues(name);
    const nextSelection = (0, import_helpers.unionizeStrings)(selection, [value2]);
    setCurrentSelection(nextSelection);
    setValue("");
  };
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_react_hook_form.Controller,
    {
      control,
      name,
      render: ({ field: { onChange: formOnChange, value: currentSelection, ref, ...props } }) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        import_material.Autocomplete,
        {
          id: `${name}-chip-select`,
          value: currentSelection,
          className,
          filterSelectedOptions: true,
          freeSolo: true,
          includeInputInList: true,
          multiple: true,
          onChange: (e, value2) => e.key !== "Backspace" ? formOnChange(value2) : null,
          onInputChange: (e, v, reason) => onTextInputChange(null, reason, formOnChange),
          options,
          readOnly: disabled,
          ref,
          renderTags: (values, getTagProps) => values.map((option, index) => {
            const { key, onDelete, ...tagProps } = getTagProps({ index });
            return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.Chip, { label: option, onDelete, deleteIcon: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Cancel, { onClick: onDelete, "aria-label": `${name}-delete` }), ...tagProps }, key);
          }),
          renderInput: (params) => /* @__PURE__ */ (0, import_react2.createElement)(
            import_material.TextField,
            {
              ...params,
              fullWidth: true,
              slotProps: {
                htmlInput: { ...params.inputProps, value },
                input: params.InputProps
              },
              key: `${name}-input`,
              label,
              variant: disabled ? "standard" : "outlined",
              onBlur: (e) => onTextInputLeave(e.target.value, formOnChange),
              onChange: (e) => onTextInputChange(e.target.value, "input", formOnChange),
              placeholder: currentSelection.length ? "" : placeholder,
              helperText,
              inputRef
            }
          ),
          ...props
        }
      )
    }
  );
};
var ChipSelect_default = ChipSelect;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ChipSelect
});
//# sourceMappingURL=ChipSelect.cjs.map