// src/Confirm.tsx
import { useState } from "react";
import { Cancel as CancelIcon, CheckCircle as CheckCircleIcon, Check as CheckIcon, Close as CloseIcon, Edit as EditIcon } from "@mui/icons-material";
import { Button, IconButton } from "@mui/material";
import { jsx, jsxs } from "react/jsx-runtime";
var defaultRemoving = "Removing...";
var confirmationType = {
  retry: {
    loading: "Creating new deployment...",
    message: "Confirm retry?"
  },
  abort: {
    loading: "Aborting...",
    message: "Confirm abort?"
  },
  chartRemoval: {
    loading: defaultRemoving,
    message: "Remove this chart?"
  },
  decommissioning: {
    loading: "Decommissioning...",
    message: "Decommission this device and remove all of its data from the server. This cannot be undone. Are you sure?"
  },
  deploymentContinuation: {
    loading: "Continuing...",
    message: "All devices with no errors will continue to the next step of the updates. Confirm continue?"
  },
  deploymentAbort: {
    loading: "Aborting...",
    message: "This will abort the deployment and attempt to roll back all devices. Confirm abort?"
  },
  integrationRemoval: {
    loading: defaultRemoving,
    message: "Remove the ingration. Are you sure?"
  },
  webhooksRemoval: {
    loading: defaultRemoving,
    message: "Delete all webhooks?"
  }
};
var Confirm = ({ action, cancel, classes = "", message = "", style = {}, type }) => {
  const [className, setClassName] = useState("fadeIn");
  const [loading, setLoading] = useState(false);
  const handleCancel = () => {
    setClassName("fadeOut");
    cancel();
  };
  const handleConfirm = () => {
    setLoading(true);
    action();
  };
  let notification = message;
  if (confirmationType[type]) {
    notification = loading ? confirmationType[type].loading : confirmationType[type].message;
  }
  return /* @__PURE__ */ jsxs("div", { className: `flexbox center-aligned ${className} ${classes}`, style: { marginRight: "12px", justifyContent: "flex-end", ...style }, children: [
    /* @__PURE__ */ jsx("span", { className: "bold", children: notification }),
    /* @__PURE__ */ jsx(IconButton, { id: "confirmAbort", onClick: handleConfirm, size: "large", children: /* @__PURE__ */ jsx(CheckCircleIcon, { className: "green" }) }),
    /* @__PURE__ */ jsx(IconButton, { onClick: handleCancel, size: "large", children: /* @__PURE__ */ jsx(CancelIcon, { className: "red" }) })
  ] });
};
var EditButton = ({ onClick, disabled = false }) => /* @__PURE__ */ jsx(Button, { onClick, size: "small", disabled, startIcon: /* @__PURE__ */ jsx(EditIcon, {}), style: { padding: 5 }, children: "Edit" });
var ConfirmationButtons = ({ onConfirm, onCancel }) => /* @__PURE__ */ jsxs("div", { className: "flexbox", children: [
  /* @__PURE__ */ jsx(IconButton, { onClick: onConfirm, size: "small", "aria-label": "confirm", children: /* @__PURE__ */ jsx(CheckIcon, { color: "disabled" }) }),
  /* @__PURE__ */ jsx(IconButton, { onClick: onCancel, size: "small", "aria-label": "cancel", children: /* @__PURE__ */ jsx(CloseIcon, { color: "disabled" }) })
] });
var Confirm_default = Confirm;

export {
  confirmationType,
  Confirm,
  EditButton,
  ConfirmationButtons,
  Confirm_default
};
//# sourceMappingURL=chunk-3VW6XNOP.js.map