// src/forms/Form.tsx
import { useEffect } from "react";
import { FormProvider, useForm } from "react-hook-form";
import { Button } from "@mui/material";
import { makeStyles } from "tss-react/mui";
import validator from "validator";
import { jsx, jsxs } from "react/jsx-runtime";
var validationMethods = {
  isAlpha: "This field must contain only letters",
  isAlphanumeric: "This field must contain only letters or numbers",
  isEmail: "Please enter a valid email address",
  isHexadecimal: "The secret has to be entered as a hexadecimal string",
  isNumeric: "Please enter a valid code",
  isURL: "Please enter a valid URL",
  isUUID: "Please enter a valid ID"
};
var getErrorMsg = (validateMethod, args) => {
  if (validationMethods[validateMethod]) {
    return validationMethods[validateMethod];
  }
  switch (validateMethod) {
    case "isLength":
      if (Number(args[0]) === 1) {
        return "This field is required";
      } else if (args[0] > 1) {
        return `Must be at least ${args[0]} characters long`;
      }
      break;
    case "isAlphanumericLocator":
      if (args[0] && validator.matches(args[0], /^[a-zA-Z0-9_-]+$/)) {
        return "";
      } else {
        return "This please only enter valid characters. Valid characters are a-z, A-Z, 0-9, _ and -";
      }
    case "isNot":
      if (args[0] === args[1]) {
        return `This field should have a value other than ${args[0]}`;
      }
      break;
    default:
      return "There is an error with this field";
  }
};
var tryApplyValidationEntry = (value, validations = [], validationResults = []) => {
  const validation = validations.shift();
  if (!validation) {
    return validationResults.pop();
  }
  let args = validation.split(":");
  const validateMethod = args.shift();
  const tmpArgs = args;
  args = [value].concat(args);
  try {
    if (!validator[validateMethod](...args)) {
      return tryApplyValidationEntry(value, validations, [...validationResults, { errortext: getErrorMsg(validateMethod, tmpArgs), isValid: false }]);
    }
  } catch {
    const errortext = getErrorMsg(validateMethod, args) || "";
    return tryApplyValidationEntry(value, validations, [...validationResults, { errortext, isValid: !errortext }]);
  }
  return { errortext: "", isValid: true };
};
var tryApplyValidations = (value, validations, initialValidationResult) => validations.split(",").reduce((accu, validation) => {
  if (!accu.isValid || !validation) {
    return accu;
  }
  const alternatives = validation.split("||");
  return tryApplyValidationEntry(value, alternatives, [accu]);
}, initialValidationResult);
var runPasswordValidations = ({ required, value, validations, isValid, errortext }) => {
  if (required && !value) {
    return { isValid: false, errortext: "Password is required" };
  } else if (required || value) {
    const { isValid: validatedIsValid, errortext: validatedErrortext } = tryApplyValidations(value, validations, { isValid, errortext });
    return { isValid: validatedIsValid, errortext: !validatedIsValid ? validatedErrortext ? validatedErrortext : "Password too weak" : errortext };
  }
  return { isValid, errortext };
};
var runValidations = ({ required, value, id, validations, wasMaybeTouched }) => {
  const isValid = true;
  const errortext = "";
  if (id && id.includes("password")) {
    return runPasswordValidations({ required, value, validations, isValid, errortext });
  } else {
    if (value || required || wasMaybeTouched && validations.includes("isLength:1")) {
      return tryApplyValidations(validations.includes("trim") ? value.trim() : value, validations, { isValid, errortext });
    }
  }
  return { isValid, errortext };
};
var useStyles = makeStyles()((theme) => ({
  buttonWrapper: { display: "flex", justifyContent: "flex-end", height: "min-content", marginTop: theme.spacing(4) },
  cancelButton: { marginRight: theme.spacing() }
}));
var Form = ({
  autocomplete,
  buttonColor,
  children,
  className = "",
  classes = { buttonWrapper: "", cancelButton: "" },
  defaultValues = {},
  handleCancel,
  id,
  initialValues = {},
  onSubmit,
  showButtons,
  submitLabel,
  submitRef
}) => {
  const { classes: internalClasses } = useStyles();
  const methods = useForm({ mode: "onChange", defaultValues });
  const {
    handleSubmit,
    formState: { isValid },
    setValue
  } = methods;
  useEffect(() => {
    if (submitRef) {
      submitRef.current = handleSubmit(onSubmit);
    }
  }, [handleSubmit, onSubmit, submitRef]);
  useEffect(() => {
    Object.entries(initialValues).forEach(([key, value]) => setValue(key, value));
  }, [JSON.stringify(initialValues), setValue]);
  return /* @__PURE__ */ jsx(FormProvider, { ...methods, children: /* @__PURE__ */ jsxs("form", { autoComplete: autocomplete, className, id, noValidate: true, onSubmit: handleSubmit(onSubmit), children: [
    children,
    !!showButtons && /* @__PURE__ */ jsxs("div", { className: `button-wrapper ${internalClasses.buttonWrapper} ${classes.buttonWrapper}`, children: [
      !!handleCancel && /* @__PURE__ */ jsx(Button, { className: `${internalClasses.cancelButton} ${classes.cancelButton}`, onClick: handleCancel, children: "Cancel" }, "cancel"),
      /* @__PURE__ */ jsx(Button, { variant: "contained", type: "submit", disabled: !isValid, color: buttonColor, children: submitLabel })
    ] })
  ] }) });
};
var Form_default = Form;

export {
  runValidations,
  Form,
  Form_default
};
//# sourceMappingURL=chunk-4LPSFMP6.js.map