"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/dialogs/Feedback.tsx
var Feedback_exports = {};
__export(Feedback_exports, {
  FeedbackDialog: () => FeedbackDialog,
  default: () => Feedback_default
});
module.exports = __toCommonJS(Feedback_exports);
var import_react = require("react");
var import_react_redux = require("react-redux");
var import_icons_material = require("@mui/icons-material");
var import_material = require("@mui/material");
var import_mui = require("tss-react/mui");
var import_actions = __toESM(require("@northern.tech/store/actions"), 1);
var import_constants = require("@northern.tech/store/constants");
var import_thunks = require("@northern.tech/store/thunks");
var import_utils = require("@northern.tech/store/utils");
var import_jsx_runtime = require("react/jsx-runtime");
var { setShowFeedbackDialog } = import_actions.default;
var useStyles = (0, import_mui.makeStyles)()((theme) => ({
  root: {
    pointerEvents: "none",
    [`.${import_material.dialogClasses.paper}`]: { width: 350, bottom: 0, right: 0, position: "absolute" },
    [`.${import_material.dialogTitleClasses.root}`]: {
      alignSelf: "flex-end",
      padding: 0,
      [`.${import_material.iconButtonClasses.root}`]: { marginBottom: theme.spacing(-1) }
    },
    ".title": {
      color: (0, import_utils.isDarkMode)(theme.palette.mode) ? (0, import_material.lighten)(theme.palette.primary.main, 0.85) : "inherit"
    }
  },
  columns: { gap: theme.spacing(2) },
  rating: {
    [`.${import_material.iconButtonClasses.root}`]: {
      borderRadius: theme.shape.borderRadius,
      height: theme.spacing(6),
      width: theme.spacing(6),
      backgroundColor: (0, import_utils.isDarkMode)(theme.palette.mode) ? (0, import_material.darken)(theme.palette.primary.main, 0.45) : (0, import_material.lighten)(theme.palette.primary.main, 0.85),
      color: theme.palette.primary.main,
      "&:hover": {
        backgroundColor: theme.palette.primary.main,
        color: (0, import_material.lighten)(theme.palette.primary.main, 0.85)
      }
    }
  },
  text: { [`.${import_material.textFieldClasses.root}`]: { marginTop: 0 }, ".submitButton": { alignSelf: "start" } }
}));
var satisfactionLevels = [
  { Icon: import_icons_material.SentimentVeryDissatisfiedOutlined, title: "Very Dissatisfied" },
  { Icon: import_icons_material.SentimentVeryDissatisfied, title: "Dissatisfied" },
  { Icon: import_icons_material.SentimentNeutral, title: "Neutral" },
  { Icon: import_icons_material.SentimentSatisfiedAlt, title: "Satisfied" },
  { Icon: import_icons_material.SentimentVerySatisfiedOutlined, title: "Very Satisfied" }
];
var explanations = ["Very unsatisfied", "Very satisfied"];
var SatisfactionGauge = ({ classes, setSatisfaction }) => /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: `flexbox column ${classes.columns}`, children: [
  /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "title", children: "How satisfied are you with Mender?" }),
  /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: `flexbox space-between ${classes.rating}`, children: satisfactionLevels.map(({ Icon, title }, index) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.IconButton, { onClick: () => setSatisfaction(index), title, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(Icon, { fontSize: "large" }) }, `satisfaction-${index}`)) }),
  /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "flexbox space-between muted", children: explanations.map((explanation, index) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "slightly-smaller", children: explanation }, `explanation-${index}`)) })
] });
var TextEntry = ({ classes, feedback, onChangeFeedback, onSubmit }) => /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: `flexbox column ${classes.columns} ${classes.text}`, children: [
  /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "title", children: "What do you think is the most important thing to improve in Mender? (optional)" }),
  /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_material.TextField,
    {
      placeholder: "Your feedback",
      multiline: true,
      minRows: 4,
      onChange: ({ target: { value } }) => onChangeFeedback(value),
      value: feedback,
      variant: "outlined"
    }
  ),
  /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.Button, { className: "submitButton", variant: "contained", onClick: onSubmit, children: "Submit Feedback" })
] });
var AppreciationNote = () => /* @__PURE__ */ (0, import_jsx_runtime.jsx)("p", { className: "margin-top-none align-center title", children: "Thank you for taking the time to share your thoughts!" });
var progressionLevels = [SatisfactionGauge, TextEntry, AppreciationNote];
var FeedbackDialog = () => {
  const [progress, setProgress] = (0, import_react.useState)(0);
  const [satisfaction, setSatisfaction] = (0, import_react.useState)(-1);
  const [feedback, setFeedback] = (0, import_react.useState)("");
  const dispatch = (0, import_react_redux.useDispatch)();
  const isInitialized = (0, import_react.useRef)(false);
  const { classes } = useStyles();
  (0, import_react.useEffect)(() => {
    if (!isInitialized.current) {
      return;
    }
    setProgress((current) => current + 1);
  }, [satisfaction]);
  (0, import_react.useEffect)(() => {
    setTimeout(() => isInitialized.current = true, import_constants.TIMEOUTS.oneSecond);
  }, []);
  const onCloseClick = () => dispatch(setShowFeedbackDialog(false));
  const onSubmit = () => {
    setProgress(progress + 1);
    dispatch((0, import_thunks.submitFeedback)({ satisfaction: satisfactionLevels[satisfaction].title, feedback }));
  };
  const Component = progressionLevels[progress];
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_material.Dialog, { className: classes.root, open: true, hideBackdrop: true, disableEnforceFocus: true, PaperProps: { style: { pointerEvents: "auto" } }, children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.DialogTitle, { children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.IconButton, { onClick: onCloseClick, "aria-label": "close", size: "small", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_icons_material.Close, {}) }) }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.DialogContent, { children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(Component, { classes, feedback, setSatisfaction, onChangeFeedback: setFeedback, onSubmit }) })
  ] });
};
var Feedback_default = FeedbackDialog;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  FeedbackDialog
});
//# sourceMappingURL=Feedback.cjs.map