import {
  READ_STATES,
  defaultPermissionSets,
  rolesById
} from "./chunk-7C4SQBEE.js";

// src/usersSlice/index.ts
import { createSlice } from "@reduxjs/toolkit";
var sliceName = "users";
var initialState = {
  activationCode: void 0,
  byId: {},
  currentUser: null,
  currentSession: {
    // { token: window.localStorage.getItem('JWT'), expiresAt: '2023-01-01T00:15:00.000Z' | undefined }, // expiresAt depending on the stay logged in setting
  },
  customColumns: [],
  qrCode: null,
  globalSettings: {
    id_attribute: void 0,
    previousFilters: [],
    previousPhases: [],
    retries: 0
  },
  permissionSetsById: {
    ...defaultPermissionSets
  },
  rolesById: {
    ...rolesById
  },
  rolesInitialized: false,
  settingsInitialized: false,
  showConnectDeviceDialog: false,
  showFeedbackDialog: false,
  showStartupNotification: false,
  tooltips: {
    byId: {
      // <id>: { readState: <read|unread> } // this object is getting enhanced by the tooltip texts in the app constants
    }
  },
  userSettings: {
    columnSelection: [],
    onboarding: {}
  },
  userSettingsInitialized: false
};
var usersSlice = createSlice({
  name: sliceName,
  initialState,
  reducers: {
    receivedQrCode: (state, action) => {
      state.qrCode = action.payload;
    },
    successfullyLoggedIn: (state, action) => {
      state.currentSession = action.payload;
    },
    receivedUserList: (state, action) => {
      state.byId = action.payload;
    },
    receivedActivationCode: (state, action) => {
      state.activationCode = action.payload;
    },
    receivedUser: (state, action) => {
      state.byId[action.payload.id] = action.payload;
      state.currentUser = action.payload.id;
    },
    removedUser: (state, action) => {
      const { [action.payload]: removedUser, ...byId } = state.byId;
      state.byId = byId;
      state.currentUser = state.currentUser === action.payload ? null : state.currentUser;
    },
    updatedUser: (state, action) => {
      state.byId[action.payload.id] = {
        ...state.byId[action.payload.id],
        ...action.payload
      };
    },
    receivedPermissionSets: (state, action) => {
      state.permissionSetsById = action.payload;
    },
    receivedRoles: (state, action) => {
      state.rolesById = action.payload;
      state.rolesInitialized = true;
    },
    finishedRoleInitialization: (state, action) => {
      state.rolesInitialized = action.payload;
    },
    createdRole: (state, action) => {
      state.rolesById[action.payload.name] = {
        ...state.rolesById[action.payload.name],
        ...action.payload
      };
    },
    removedRole: (state, action) => {
      const { [action.payload]: toBeRemoved, ...rolesById2 } = state.rolesById;
      state.rolesById = rolesById2;
    },
    setCustomColumns: (state, action) => {
      state.customColumns = action.payload;
    },
    setGlobalSettings: (state, action) => {
      state.settingsInitialized = true;
      state.globalSettings = {
        ...state.globalSettings,
        ...action.payload
      };
    },
    setUserSettings: (state, action) => {
      state.userSettingsInitialized = true;
      state.userSettings = {
        ...state.userSettings,
        ...action.payload
      };
    },
    setTooltipState: (state, action) => {
      const { id, readState = READ_STATES.read } = action.payload;
      state.tooltips.byId[id] = { ...state.tooltips.byId[id], readState };
    },
    setTooltipsState: (state, action) => {
      state.tooltips.byId = {
        ...state.tooltips.byId,
        ...action.payload
      };
    },
    setShowFeedbackDialog: (state, action) => {
      state.showFeedbackDialog = action.payload;
    },
    setShowConnectingDialog: (state, action) => {
      state.showConnectDeviceDialog = action.payload;
    },
    setShowStartupNotification: (state, action) => {
      state.showStartupNotification = action.payload;
    }
  }
});
var actions = usersSlice.actions;
var usersSlice_default = usersSlice.reducer;

export {
  sliceName,
  initialState,
  usersSlice,
  actions,
  usersSlice_default
};
//# sourceMappingURL=chunk-UGSLGUS6.js.map