import { Address } from './Address.cjs';
import './AddressUpdate.cjs';

/**
 * Billing profile contains information about the customer.
 */
type BillingProfile = {
    /**
     * The customer's email address.
     */
    email: string;
    /**
     * The customer's full name or business name.
     */
    name: string;
    /**
     * The customer's phone number.
     */
    phone?: string;
    address: Address;
    /**
     * Mailing and shipping address for the customer. Appears on invoices.
     */
    shipping: {
        /**
         * Name of the recipient.
         */
        name?: string;
        /**
         * Phone number of the recipient (including extension).
         */
        phone?: string;
        address?: Address;
    };
};

export type { BillingProfile };
