import { Addon } from './Addon.cjs';
import { Plan } from './Plan.cjs';
import { TenantAdditionalInfo } from './TenantAdditionalInfo.cjs';
import { TenantApiLimits } from './TenantApiLimits.cjs';
import './Features.cjs';
import './ApiLimits.cjs';
import './ApiBurst.cjs';
import './ApiQuota.cjs';

/**
 * Tenant descriptor.
 */
type TenantV1 = {
    /**
     * Tenant ID.
     */
    id: string;
    /**
     * Name of the tenant's organization.
     */
    name: string;
    /**
     * Currently used tenant token.
     */
    tenant_token: string;
    /**
     * Status of the tenant account.
     */
    status?: TenantV1.status;
    plan?: Plan;
    /**
     * Whether this account is free trial.
     */
    trial?: boolean;
    /**
     * When trial evaluation expires.
     */
    trial_expiration?: string;
    /**
     * Addons configuration.
     */
    addons?: Array<Addon>;
    /**
     * Whether this account is a service provider.
     */
    service_provider?: boolean;
    additional_info?: TenantAdditionalInfo;
    api_limits?: TenantApiLimits;
    /**
     * Creation date and time, in ISO8601 format.
     */
    created_at?: string;
};
declare namespace TenantV1 {
    /**
     * Status of the tenant account.
     */
    enum status {
        ACTIVE = "active",
        SUSPENDED = "suspended"
    }
}

export { TenantV1 };
