import {
  extractErrorMessage,
  preformatWithRequestID
} from "./chunk-YKX7CGDK.js";

// src/retrytimer.ts
var oneSecond = 1e3;
var timers = {};
function setRetryTimer(err, service, errorContext, timeLeft, setSnackbar) {
  if (timers[service]) {
    return;
  }
  let remaining = timeLeft - oneSecond;
  timers[service] = setInterval(() => {
    remaining -= oneSecond;
    const errMsg = extractErrorMessage(err, "Please check your connection.");
    return remaining > 0 ? setSnackbar(preformatWithRequestID(err.response, `${errorContext} ${errMsg} Retrying in ${remaining / 1e3} seconds`)) : clearRetryTimer(service, setSnackbar);
  }, oneSecond);
}
function clearRetryTimer(service, setSnackbar) {
  if (timers[service]) {
    clearInterval(timers[service]);
    delete timers[service];
    setSnackbar("");
  }
}
function clearAllRetryTimers(setSnackbar) {
  Object.keys(timers).map((service) => clearRetryTimer(service, setSnackbar));
  setSnackbar("");
}

export {
  setRetryTimer,
  clearRetryTimer,
  clearAllRetryTimers
};
//# sourceMappingURL=chunk-ZKL63TNQ.js.map