"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/Pagination.tsx
var Pagination_exports = {};
__export(Pagination_exports, {
  TablePaginationActions: () => TablePaginationActions,
  default: () => Pagination_default
});
module.exports = __toCommonJS(Pagination_exports);
var import_react2 = require("react");
var import_icons_material = require("@mui/icons-material");
var import_material2 = require("@mui/material");
var import_constants = require("@northern.tech/store/constants");
var import_debouncehook = require("@northern.tech/utils/debouncehook");

// src/helptips/MenderTooltip.tsx
var import_react = require("react");
var import_material = require("@mui/material");
var import_mui = require("tss-react/mui");
var import_helpers = require("@northern.tech/utils/helpers");
var import_jsx_runtime = require("react/jsx-runtime");
var MenderTooltip = (0, import_mui.withStyles)(import_material.Tooltip, ({ palette, shadows, spacing }) => ({
  arrow: {
    color: palette.background.paper
  },
  tooltip: {
    backgroundColor: palette.background.paper,
    boxShadow: shadows[1],
    color: palette.text.primary,
    padding: spacing(2),
    fontSize: "small",
    maxWidth: 600,
    info: {
      maxWidth: 300,
      color: palette.text.hint,
      backgroundColor: palette.grey[500]
    }
  }
}));
var MenderTooltip_default = MenderTooltip;

// src/Pagination.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var defaultRowsPerPageOptions = [10, 20, import_constants.DEVICE_LIST_MAXIMUM_LENGTH];
var { perPage: defaultPerPage } = import_constants.DEVICE_LIST_DEFAULTS;
var paginationIndex = 1;
var paginationLimit = 1e4;
var MaybeWrapper = ({ children, disabled }) => disabled ? /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(MenderTooltip_default, { arrow: true, placement: "top", title: "Please refine your filter criteria first in order to proceed.", children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", { children }) }) : /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", { children });
var TablePaginationActions = ({ count, page = 0, onPageChange, rowsPerPage = defaultPerPage, showCountInfo = true }) => {
  const [pageNo, setPageNo] = (0, import_react2.useState)(page + paginationIndex);
  (0, import_react2.useEffect)(() => {
    setPageNo(page + paginationIndex);
  }, [page, rowsPerPage, count]);
  const debouncedPage = (0, import_debouncehook.useDebounce)(pageNo, import_constants.TIMEOUTS.debounceShort);
  (0, import_react2.useEffect)(() => {
    const newPage = Math.min(Math.max(paginationIndex, debouncedPage), Math.max(paginationIndex, Math.ceil(count / rowsPerPage)));
    if (newPage !== page + paginationIndex) {
      onPageChange(newPage);
    }
  }, [count, debouncedPage, onPageChange, page, rowsPerPage]);
  const pages = Math.ceil(count / rowsPerPage);
  const isAtPaginationLimit = pageNo >= paginationLimit / rowsPerPage;
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { className: "flexbox center-aligned", children: [
    showCountInfo && /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", { children: `${(pageNo - paginationIndex) * rowsPerPage + 1}-${Math.min(pageNo * rowsPerPage, count)} of ${count}` }),
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.IconButton, { onClick: () => setPageNo(pageNo - 1), disabled: pageNo === paginationIndex, size: "large", "aria-label": "prev", children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_icons_material.KeyboardArrowLeft, {}) }),
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(MaybeWrapper, { disabled: isAtPaginationLimit, children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_material2.IconButton, { onClick: () => setPageNo(pageNo + 1), disabled: pageNo >= pages || isAtPaginationLimit, size: "large", "aria-label": "next", children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_icons_material.KeyboardArrowRight, {}) }) })
  ] });
};
var Pagination = (props) => {
  const { className, onChangeRowsPerPage, onChangePage, page = 0, rowsPerPageOptions = defaultRowsPerPageOptions, showCountInfo, ...remainingProps } = props;
  const propsPage = Math.max(page - paginationIndex, 0);
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
    import_material2.TablePagination,
    {
      className: `flexbox margin-top ${className || ""}`,
      classes: { spacer: "flexbox no-basis" },
      component: "div",
      labelDisplayedRows: () => "",
      labelRowsPerPage: "Rows",
      slotProps: { select: { name: "pagination" } },
      rowsPerPageOptions,
      onRowsPerPageChange: (e) => onChangeRowsPerPage(e.target.value),
      page: propsPage,
      onPageChange: onChangePage,
      ActionsComponent: (actionProps) => /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(TablePaginationActions, { ...actionProps, showCountInfo }),
      ...remainingProps
    }
  );
};
var areEqual = (prevProps, nextProps) => Math.floor(prevProps.count / prevProps.rowsPerPage) === Math.floor(nextProps.count / nextProps.rowsPerPage) && prevProps.page === nextProps.page && prevProps.rowsPerPage === nextProps.rowsPerPage && prevProps.disabled === nextProps.disabled;
var Pagination_default = (0, import_react2.memo)(Pagination, areEqual);
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  TablePaginationActions
});
//# sourceMappingURL=Pagination.cjs.map