import {
  DeviceNameInput_default
} from "./chunk-MW3FXC7K.js";

// src/DeviceIdentity.tsx
import { useMemo } from "react";
import { useSelector } from "react-redux";
import { makeStyles } from "tss-react/mui";
import { getDeviceById as getDeviceByIdSelector, getIdAttribute } from "@northern.tech/store/selectors";
import { stringToBoolean } from "@northern.tech/utils/helpers";

// ../../assets/img/gateway-connection.svg
var gateway_connection_default = "./gateway-connection-TS7NBQVB.svg";

// ../../assets/img/gateway.svg
var gateway_default = "./gateway-XAJR5DH4.svg";

// src/DeviceIdentity.tsx
import { jsx, jsxs } from "react/jsx-runtime";
var useStyles = makeStyles()((theme) => ({
  container: {
    gridTemplateColumns: "1fr max-content",
    columnGap: theme.spacing()
  },
  gatewayIcon: {
    color: theme.palette.grey[400],
    width: "max-content",
    marginRight: theme.spacing()
  }
}));
var propertyNameMap = {
  inventory: "attributes",
  identity: "identity_data",
  system: "system",
  monitor: "monitor",
  tags: "tags"
};
var defaultTextRender = ({ column, device }) => {
  const propertyName = propertyNameMap[column.attribute.scope] ?? column.attribute.scope;
  const accessorTarget = device[propertyName] ?? device;
  const attributeValue = accessorTarget[column.attribute.name] || device[column.attribute.name];
  return (typeof attributeValue === "object" ? JSON.stringify(attributeValue) : attributeValue) ?? "-";
};
var getDeviceIdentityText = ({ device = {}, idAttribute }) => {
  const { id = "", identity_data = {}, tags = {} } = device;
  const { status, ...remainingIds } = identity_data;
  const nonIdKey = Object.keys(remainingIds)[0];
  if (!idAttribute || idAttribute === "id" || idAttribute === "Device ID") {
    return id;
  } else if (typeof idAttribute === "string" || !Object.keys(idAttribute).length) {
    return identity_data[idAttribute] ?? identity_data[nonIdKey] ?? id;
  }
  const { attribute, scope } = idAttribute;
  if (attribute === "name" && scope === "tags") {
    return tags[attribute] ?? `${id.substring(0, 6)}...`;
  }
  return defaultTextRender({ column: { attribute: { name: attribute, scope } }, device });
};
var DeviceIdComponent = ({ style = {}, value }) => /* @__PURE__ */ jsx("div", { style, children: value });
var attributeComponentMap = {
  default: DeviceIdComponent,
  name: DeviceNameInput_default
};
var adornments = [
  {
    component: gateway_connection_default,
    isApplicable: ({ attributes = {} }) => !stringToBoolean(attributes.mender_is_gateway) && !!attributes.mender_gateway_system_id
  },
  { component: gateway_default, isApplicable: ({ attributes = {} }) => stringToBoolean(attributes.mender_is_gateway) }
];
var DeviceIdentityDisplay = (props) => {
  const { device = {}, isEditable = true, hasAdornment = true } = props;
  const idAttribute = useSelector(getIdAttribute);
  const { attribute, scope } = idAttribute;
  const stateDevice = useSelector((state) => getDeviceByIdSelector(state, device.id));
  const idValue = getDeviceIdentityText({ device: { ...device, ...stateDevice }, idAttribute });
  const { classes } = useStyles();
  let Component = attributeComponentMap.default;
  if (attribute === "name" && scope === "tags") {
    Component = isEditable ? attributeComponentMap.name : Component;
  }
  const { attributes = {} } = device;
  const EndAdornment = useMemo(
    () => adornments.find((item) => item.isApplicable(device))?.component,
    // eslint-disable-next-line react-hooks/exhaustive-deps
    [attributes.mender_is_gateway, attributes.mender_gateway_system_id]
  );
  return (
    // due to the specificity of the deviceListRow child class, applying the display styling through the container class doesn't work, thus the inline style in addition here
    /* @__PURE__ */ jsxs("div", { className: classes.container, style: { display: "grid" }, children: [
      /* @__PURE__ */ jsx(Component, { ...props, value: idValue }),
      hasAdornment && EndAdornment && /* @__PURE__ */ jsx(EndAdornment, { className: classes.gatewayIcon })
    ] })
  );
};
var DeviceIdentity_default = DeviceIdentityDisplay;

export {
  defaultTextRender,
  getDeviceIdentityText,
  DeviceIdentityDisplay,
  DeviceIdentity_default
};
//# sourceMappingURL=chunk-ZAXQQM7L.js.map