"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/helptips/index.ts
var helptips_exports = {};
__export(helptips_exports, {
  MenderTooltip: () => MenderTooltip,
  MenderTooltipClickable: () => MenderTooltipClickable
});
module.exports = __toCommonJS(helptips_exports);

// src/helptips/MenderTooltip.tsx
var import_react = require("react");
var import_material = require("@mui/material");
var import_mui = require("tss-react/mui");
var import_helpers = require("@northern.tech/utils/helpers");
var import_jsx_runtime = require("react/jsx-runtime");
var MenderTooltip = (0, import_mui.withStyles)(import_material.Tooltip, ({ palette, shadows, spacing }) => ({
  arrow: {
    color: palette.background.paper
  },
  tooltip: {
    backgroundColor: palette.background.paper,
    boxShadow: shadows[1],
    color: palette.text.primary,
    padding: spacing(2),
    fontSize: "small",
    maxWidth: 600,
    info: {
      maxWidth: 300,
      color: palette.text.hint,
      backgroundColor: palette.grey[500]
    }
  }
}));
var MenderTooltipClickable = ({
  children,
  onboarding,
  startOpen = false,
  visibility = startOpen,
  onOpenChange,
  tooltipComponent = MenderTooltip,
  ...remainingProps
}) => {
  const [open, setOpen] = (0, import_react.useState)(startOpen || false);
  (0, import_react.useEffect)(() => {
    setOpen(visibility);
  }, [visibility]);
  (0, import_react.useEffect)(() => {
    if (!onOpenChange) {
      return;
    }
    onOpenChange(open);
  }, [open, onOpenChange]);
  const toggleVisibility = () => setOpen(import_helpers.toggle);
  const hide = () => setOpen(false);
  const Component = tooltipComponent;
  const extraProps = onboarding ? {
    PopperProps: {
      disablePortal: true,
      popperOptions: {
        strategy: "fixed",
        modifiers: [
          { name: "flip", enabled: false },
          { name: "preventOverflow", enabled: true, options: { boundary: window, altBoundary: false } }
        ]
      }
    }
  } : {};
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_material.ClickAwayListener, { onClickAway: hide, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    Component,
    {
      arrow: !onboarding,
      open,
      disableFocusListener: true,
      disableHoverListener: true,
      disableTouchListener: true,
      onOpen: () => setOpen(true),
      ...extraProps,
      ...remainingProps,
      children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { onClick: toggleVisibility, children })
    }
  ) });
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  MenderTooltip,
  MenderTooltipClickable
});
//# sourceMappingURL=index.cjs.map