import * as axios from 'axios';

declare const commonRequestConfig: {
    timeout: number;
    headers: {
        'Content-Type': string;
    };
};
declare const authenticatedRequest: axios.AxiosInstance;
declare const Api: {
    get: <T = any, R = axios.AxiosResponse<T, any>, D = any>(url: string, config?: axios.AxiosRequestConfig<D>) => Promise<R>;
    delete: (url: any, data?: any) => Promise<axios.AxiosResponse<any, any>>;
    patch: <T = any, R = axios.AxiosResponse<T, any>, D = any>(url: string, data?: D, config?: axios.AxiosRequestConfig<D>) => Promise<R>;
    post: <T = any, R = axios.AxiosResponse<T, any>, D = any>(url: string, data?: D, config?: axios.AxiosRequestConfig<D>) => Promise<R>;
    postUnauthorized: (url: any, data: any, config?: {}) => Promise<axios.AxiosResponse<any, any>>;
    put: <T = any, R = axios.AxiosResponse<T, any>, D = any>(url: string, data?: D, config?: axios.AxiosRequestConfig<D>) => Promise<R>;
    upload: (url: any, formData: any, progress: any, cancelSignal: any) => Promise<axios.AxiosResponse<any, any>>;
    uploadPut: (url: any, formData: any, progress: any, cancelSignal: any) => Promise<axios.AxiosResponse<any, any>>;
};

export { authenticatedRequest, commonRequestConfig, Api as default };
