// src/commonConstants.tsx
import { mdiAws as AWS, mdiMicrosoftAzure as Azure } from "@mdi/js";
import { Credentials, Integration } from "@northern.tech/types/MenderTypes";

// src/constants.ts
import {
  ALL_DEVICES,
  ALL_DEVICE_STATES,
  ALL_RELEASES,
  APPLICATION_JSON_CONTENT_TYPE,
  APPLICATION_JWT_CONTENT_TYPE,
  ATTRIBUTE_SCOPES,
  DEVICE_FILTERING_OPTIONS,
  DEVICE_ISSUE_OPTIONS,
  DEVICE_LIST_DEFAULTS,
  DEVICE_STATES,
  PermissionTypes,
  SORTING_OPTIONS,
  alertChannels,
  apiRoot,
  apiUrl,
  auditLogsApiUrl,
  defaultPermissionSets,
  deploymentsApiUrl,
  deploymentsApiUrlV2,
  deviceAuthV2,
  deviceConfig,
  deviceConnect,
  emptyRole,
  emptyUiPermissions,
  headerNames,
  inventoryApiUrl,
  inventoryApiUrlV2,
  iotManagerBaseURL,
  limitDefault,
  maxSessionAge,
  monitorApiUrlv1,
  reportingApiUrl,
  rolesById,
  rolesByName,
  scopedPermissionAreas,
  serviceProviderRolesById,
  ssoIdpApiUrlv1,
  tenantadmApiUrlv1,
  tenantadmApiUrlv2,
  twoFAStates,
  uiPermissionsByArea,
  uiPermissionsById,
  useradmApiUrl,
  useradmApiUrlv1,
  useradmApiUrlv2
} from "@northern.tech/utils/constants";

// src/deploymentsSlice/constants.ts
var alreadyInstalled = "already-installed";
var deploymentSubstates = {
  aborted: "aborted",
  alreadyInstalled,
  decommissioned: "decommissioned",
  downloading: "downloading",
  failure: "failure",
  installing: "installing",
  noartifact: "noartifact",
  pause_before_committing: "pause_before_committing",
  pause_before_installing: "pause_before_installing",
  pause_before_rebooting: "pause_before_rebooting",
  pending: "pending",
  rebooting: "rebooting",
  success: "success"
};
var deploymentStatesToSubstates = {
  failures: [deploymentSubstates.failure, deploymentSubstates.aborted, deploymentSubstates.decommissioned],
  inprogress: [deploymentSubstates.downloading, deploymentSubstates.installing, deploymentSubstates.rebooting],
  paused: [deploymentSubstates.pause_before_installing, deploymentSubstates.pause_before_rebooting, deploymentSubstates.pause_before_committing],
  pending: [deploymentSubstates.pending],
  successes: [deploymentSubstates.success, deploymentSubstates.alreadyInstalled, deploymentSubstates.noartifact]
};
var deploymentStatesToSubstatesWithSkipped = {
  ...deploymentStatesToSubstates,
  failures: [deploymentSubstates.failure],
  skipped: [deploymentSubstates.aborted, deploymentSubstates.noartifact, deploymentSubstates.alreadyInstalled, deploymentSubstates.decommissioned],
  successes: [deploymentSubstates.success]
};
var installationSubstatesMap = {
  download: {
    title: "download",
    done: "downloaded",
    successIndicators: [deploymentSubstates.installing, deploymentSubstates.rebooting, ...deploymentStatesToSubstates.paused, deploymentSubstates.success],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactInstall_Enter"
  },
  install: {
    title: "install",
    done: "installed",
    successIndicators: [
      deploymentSubstates.rebooting,
      deploymentSubstates.pause_before_rebooting,
      deploymentSubstates.pause_before_committing,
      deploymentSubstates.success
    ],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactReboot_Enter"
  },
  reboot: {
    title: "reboot",
    done: "rebooted",
    successIndicators: [deploymentSubstates.pause_before_committing, deploymentSubstates.success],
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: "ArtifactCommit_Enter"
  },
  commit: {
    title: "commit",
    done: "committed",
    successIndicators: deploymentStatesToSubstates.successes,
    failureIndicators: deploymentStatesToSubstates.failures,
    pauseConfigurationIndicator: void 0
  }
};
var DEPLOYMENT_STATES = {
  finished: "finished",
  inprogress: "inprogress",
  pending: "pending",
  scheduled: "scheduled"
};
var listDefaultsByState = {
  [DEPLOYMENT_STATES.inprogress]: { page: 1, perPage: 10 },
  [DEPLOYMENT_STATES.pending]: { page: 1, perPage: 10 },
  [DEPLOYMENT_STATES.scheduled]: { ...DEVICE_LIST_DEFAULTS },
  [DEPLOYMENT_STATES.finished]: { ...DEVICE_LIST_DEFAULTS },
  sort: { direction: SORTING_OPTIONS.desc }
};
var DEFAULT_PENDING_INPROGRESS_COUNT = 10;
var DEPLOYMENT_ROUTES = {
  active: {
    key: "active",
    route: "/deployments/active",
    states: [DEPLOYMENT_STATES.pending, DEPLOYMENT_STATES.inprogress],
    title: "Active"
  },
  finished: {
    key: "finished",
    route: "/deployments/finished",
    states: [DEPLOYMENT_STATES.finished],
    title: "Finished"
  },
  scheduled: {
    key: "scheduled",
    route: "/deployments/scheduled",
    states: [DEPLOYMENT_STATES.scheduled],
    title: "Scheduled"
  }
};
var DEPLOYMENT_TYPES = {
  software: "software",
  configuration: "configuration"
};
var defaultStats = {
  [deploymentSubstates.aborted]: 0,
  [deploymentSubstates.alreadyInstalled]: 0,
  [deploymentSubstates.decommissioned]: 0,
  [deploymentSubstates.downloading]: 0,
  [deploymentSubstates.failure]: 0,
  [deploymentSubstates.installing]: 0,
  [deploymentSubstates.noartifact]: 0,
  [deploymentSubstates.pause_before_committing]: 0,
  [deploymentSubstates.pause_before_installing]: 0,
  [deploymentSubstates.pause_before_rebooting]: 0,
  [deploymentSubstates.pending]: 0,
  [deploymentSubstates.rebooting]: 0,
  [deploymentSubstates.success]: 0
};
var deploymentDisplayStates = {
  finished: "Finished",
  scheduled: "Scheduled",
  skipped: "Skipped",
  paused: "Paused",
  pending: "Pending",
  inprogress: "In Progress",
  success: "Success",
  successes: "Success",
  failure: "Fail",
  failures: "Fail"
};
var deploymentPrototype = {
  devices: {},
  name: void 0,
  statistics: { status: {} }
};
var pauseMap = {
  [deploymentSubstates.pause_before_installing]: {
    title: installationSubstatesMap.download.done,
    followUp: installationSubstatesMap.download.pauseConfigurationIndicator
  },
  [deploymentSubstates.pause_before_rebooting]: {
    title: installationSubstatesMap.install.done,
    followUp: installationSubstatesMap.install.pauseConfigurationIndicator
  },
  [deploymentSubstates.pause_before_committing]: {
    title: installationSubstatesMap.reboot.done,
    followUp: installationSubstatesMap.reboot.pauseConfigurationIndicator
  }
};

// src/devicesSlice/constants.ts
var emptyFilter = { key: null, value: "", operator: DEVICE_FILTERING_OPTIONS.$eq.key, scope: "inventory" };
var DEVICE_MESSAGE_PROTOCOLS = {
  Shell: 1
};
var DEVICE_MESSAGE_TYPES = {
  Delay: "delay",
  New: "new",
  Ping: "ping",
  Pong: "pong",
  Resize: "resize",
  Shell: "shell",
  Stop: "stop"
};
var DEVICE_DISMISSAL_STATE = "dismiss";
var DEVICE_CONNECT_STATES = {
  connected: "connected",
  disconnected: "disconnected",
  unknown: "unknown"
};
var geoAttributes = ["geo-lat", "geo-lon"].map((attribute) => ({ attribute, scope: "inventory" }));
var REPORT_CHART_SIZE_LIMIT = 6;

// src/organizationSlice/constants.ts
var XML_METADATA_FORMAT = "xml";
var JSON_METADATA_FORMAT = "json";
var getSamlStartUrl = (id) => `${window.location.origin}${useradmApiUrl}/auth/sso/${id}/login`;
var getOidcStartUrl = (id) => `${window.location.origin}${useradmApiUrl}/oidc/${id}/start`;
var SSO_TYPES = {
  saml: {
    id: "saml",
    type: "saml",
    title: "SAML",
    metadataFormat: XML_METADATA_FORMAT,
    editorLanguage: XML_METADATA_FORMAT,
    contentType: "application/samlmetadata+xml",
    getStartUrl: getSamlStartUrl,
    configDetails: [
      { key: "entityID", label: "Entity ID", getValue: (id) => `${window.location.origin}${useradmApiUrl}/sso/sp/metadata/${id}` },
      { key: "acs", label: "ACS URL", getValue: (id) => `${window.location.origin}${useradmApiUrl}/auth/sso/${id}/acs` },
      { key: "startURL", label: "Start URL", getValue: getSamlStartUrl }
    ]
  },
  oidc: {
    id: "oidc",
    type: "oidc",
    title: "OpenID Connect",
    metadataFormat: JSON_METADATA_FORMAT,
    editorLanguage: JSON_METADATA_FORMAT,
    contentType: "application/json",
    getStartUrl: getOidcStartUrl,
    configDetails: [{ key: "startURL", label: "Start Url", getValue: getOidcStartUrl }]
  }
};
var auditlogTypes = {
  artifact: { title: "Artifact", queryParameter: "object_type", value: "artifact" },
  deployment: { title: "Deployment", queryParameter: "object_deployment_name", value: "deployment" },
  device: { title: "Device", queryParameter: "object_id", value: "device" },
  user_access_token: { title: "Personal Access Token", queryParameter: "user_access_token", value: "user_access_token" },
  user: { title: "User", queryParameter: "object_id", value: "user" },
  tenant: { title: "Tenant", queryParameter: "object_id", value: "tenant" }
};
var AUDIT_LOGS_TYPES = [auditlogTypes.artifact, auditlogTypes.deployment, auditlogTypes.device, auditlogTypes.user_access_token, auditlogTypes.user];
var SP_AUDIT_LOGS_TYPES = [auditlogTypes.user, auditlogTypes.tenant];
var TENANT_LIST_DEFAULT = {
  page: 1,
  perPage: 20
};

// src/usersSlice/constants.ts
var itemUiPermissionsReducer = (accu, { item, uiPermissions }) => item ? { ...accu, [item]: uiPermissions } : accu;
var checkSinglePermission = (permission, requiredPermission) => requiredPermission === permission || uiPermissionsById[permission].permissionLevel > uiPermissionsById[requiredPermission].permissionLevel;
var checkPermissionsObject = (permissions, requiredPermission, scopedAccess, superAccess) => permissions[superAccess]?.some((permission) => checkSinglePermission(permission, requiredPermission)) || permissions[scopedAccess]?.some((permission) => checkSinglePermission(permission, requiredPermission));
var USER_LOGOUT = "USER_LOGOUT";
var OWN_USER_ID = "me";
var settingsKeys = { initialized: "settings-initialized" };
var READ_STATES = {
  read: "read",
  seen: "seen",
  unread: "unread"
};

// src/commonConstants.tsx
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var timeUnits = {
  days: "days",
  minutes: "minutes",
  hours: "hours"
};
var UNGROUPED_GROUP = { id: "*|=ungrouped=|*", name: "Unassigned" };
var DEVICE_LIST_MAXIMUM_LENGTH = 50;
var oneSecond = 1e3;
var TIMEOUTS = {
  debounceDefault: 700,
  debounceShort: 300,
  halfASecond: 0.5 * oneSecond,
  oneSecond,
  twoSeconds: 2 * oneSecond,
  threeSeconds: 3 * oneSecond,
  fiveSeconds: 5 * oneSecond,
  refreshDefault: 10 * oneSecond,
  refreshLong: 60 * oneSecond
};
var DEVICE_ONLINE_CUTOFF = { interval: 1, intervalName: timeUnits.days };
var defaultIdAttribute = Object.freeze({ attribute: "id", scope: ATTRIBUTE_SCOPES.identity });
var credentialTypes = {
  aws: Credentials.type.AWS,
  http: Credentials.type.HTTP,
  sas: Credentials.type.SAS,
  x509: "x509"
};
var EXTERNAL_PROVIDER = {
  "iot-core": {
    credentialsType: credentialTypes.aws,
    icon: AWS,
    title: "AWS IoT Core",
    twinTitle: "Device Shadow",
    provider: "iot-core",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ jsx(Fragment, { children: "For help finding your AWS IoT Core connection string, check the AWS IoT documentation." })
  },
  "iot-hub": {
    credentialsType: credentialTypes.sas,
    icon: Azure,
    title: "Azure IoT Hub",
    twinTitle: "Device Twin",
    provider: "iot-hub",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ jsxs("span", { children: [
      "For help finding your Azure IoT Hub connection string, look under 'Shared access policies' in the Microsoft Azure UI as described",
      " ",
      /* @__PURE__ */ jsx(
        "a",
        {
          href: "https://devblogs.microsoft.com/iotdev/understand-different-connection-strings-in-azure-iot-hub/#iothubconn",
          target: "_blank",
          rel: "noopener noreferrer",
          children: "here"
        }
      ),
      "."
    ] })
  },
  webhook: {
    credentialsType: credentialTypes.http,
    deviceTwin: false,
    twinTitle: "",
    // disable the webhook provider here, since it is treated different than other integrations, with a custom configuration & management view, etc.
    enabled: false,
    provider: "webhook"
  }
};
var emptyWebhook = {
  description: "",
  provider: Integration.provider.WEBHOOK,
  credentials: {
    type: EXTERNAL_PROVIDER.webhook.credentialsType,
    [EXTERNAL_PROVIDER.webhook.credentialsType]: {
      secret: "",
      url: ""
    }
  }
};
var MAX_PAGE_SIZE = 500;
var regionNames = new Intl.DisplayNames(["en"], { type: "region" });
var countries = [
  "AD",
  "AE",
  "AF",
  "AG",
  "AI",
  "AL",
  "AM",
  "AO",
  "AQ",
  "AR",
  "AS",
  "AT",
  "AU",
  "AW",
  "AX",
  "AZ",
  "BA",
  "BB",
  "BD",
  "BE",
  "BF",
  "BG",
  "BH",
  "BI",
  "BJ",
  "BL",
  "BM",
  "BN",
  "BO",
  "BR",
  "BS",
  "BT",
  "BV",
  "BW",
  "BY",
  "BZ",
  "CA",
  "CC",
  "CD",
  "CF",
  "CG",
  "CH",
  "CI",
  "CK",
  "CL",
  "CM",
  "CN",
  "CO",
  "CR",
  "CU",
  "CV",
  "CW",
  "CX",
  "CY",
  "CZ",
  "DE",
  "DJ",
  "DK",
  "DM",
  "DO",
  "DZ",
  "EC",
  "EE",
  "EG",
  "EH",
  "ER",
  "ES",
  "ET",
  "FI",
  "FJ",
  "FK",
  "FM",
  "FO",
  "FR",
  "GA",
  "GB",
  "GD",
  "GE",
  "GF",
  "GG",
  "GH",
  "GI",
  "GL",
  "GM",
  "GN",
  "GP",
  "GQ",
  "GR",
  "GS",
  "GT",
  "GU",
  "GW",
  "GY",
  "HK",
  "HM",
  "HN",
  "HR",
  "HT",
  "HU",
  "ID",
  "IE",
  "IL",
  "IM",
  "IN",
  "IO",
  "IQ",
  "IR",
  "IS",
  "IT",
  "JE",
  "JM",
  "JO",
  "JP",
  "KE",
  "KG",
  "KH",
  "KI",
  "KM",
  "KN",
  "KP",
  "KR",
  "KW",
  "KY",
  "KZ",
  "LA",
  "LB",
  "LC",
  "LI",
  "LK",
  "LR",
  "LS",
  "LT",
  "LU",
  "LV",
  "LY",
  "MA",
  "MC",
  "MD",
  "ME",
  "MF",
  "MG",
  "MH",
  "MK",
  "ML",
  "MM",
  "MN",
  "MO",
  "MP",
  "MQ",
  "MR",
  "MS",
  "MT",
  "MU",
  "MV",
  "MW",
  "MX",
  "MY",
  "MZ",
  "NA",
  "NC",
  "NE",
  "NF",
  "NG",
  "NI",
  "NL",
  "NO",
  "NP",
  "NR",
  "NU",
  "NZ",
  "OM",
  "PA",
  "PE",
  "PF",
  "PG",
  "PH",
  "PK",
  "PL",
  "PM",
  "PN",
  "PR",
  "PS",
  "PT",
  "PW",
  "PY",
  "QA",
  "RE",
  "RO",
  "RS",
  "RU",
  "RW",
  "SA",
  "SB",
  "SC",
  "SD",
  "SE",
  "SG",
  "SH",
  "SI",
  "SJ",
  "SK",
  "SL",
  "SM",
  "SN",
  "SO",
  "SR",
  "SS",
  "ST",
  "SV",
  "SX",
  "SY",
  "SZ",
  "TC",
  "TD",
  "TF",
  "TG",
  "TH",
  "TJ",
  "TK",
  "TL",
  "TM",
  "TN",
  "TO",
  "TR",
  "TT",
  "TV",
  "TW",
  "TZ",
  "UA",
  "UG",
  "US",
  "UY",
  "UZ",
  "VA",
  "VC",
  "VE",
  "VG",
  "VI",
  "VN",
  "VU",
  "WF",
  "WS",
  "XK",
  "YE",
  "YT",
  "ZA",
  "ZM",
  "ZW"
].map((code) => ({ code, label: regionNames.of(code) })).sort((a, b) => a.label.localeCompare(b.label));

export {
  timeUnits,
  UNGROUPED_GROUP,
  DEVICE_LIST_MAXIMUM_LENGTH,
  TIMEOUTS,
  DEVICE_ONLINE_CUTOFF,
  defaultIdAttribute,
  credentialTypes,
  EXTERNAL_PROVIDER,
  emptyWebhook,
  MAX_PAGE_SIZE,
  countries,
  deploymentSubstates,
  deploymentStatesToSubstates,
  deploymentStatesToSubstatesWithSkipped,
  installationSubstatesMap,
  DEPLOYMENT_STATES,
  listDefaultsByState,
  DEFAULT_PENDING_INPROGRESS_COUNT,
  DEPLOYMENT_ROUTES,
  DEPLOYMENT_TYPES,
  defaultStats,
  deploymentDisplayStates,
  deploymentPrototype,
  pauseMap,
  emptyFilter,
  DEVICE_MESSAGE_PROTOCOLS,
  DEVICE_MESSAGE_TYPES,
  DEVICE_DISMISSAL_STATE,
  DEVICE_CONNECT_STATES,
  geoAttributes,
  REPORT_CHART_SIZE_LIMIT,
  XML_METADATA_FORMAT,
  JSON_METADATA_FORMAT,
  getSamlStartUrl,
  getOidcStartUrl,
  SSO_TYPES,
  auditlogTypes,
  AUDIT_LOGS_TYPES,
  SP_AUDIT_LOGS_TYPES,
  TENANT_LIST_DEFAULT,
  itemUiPermissionsReducer,
  checkPermissionsObject,
  USER_LOGOUT,
  OWN_USER_ID,
  settingsKeys,
  READ_STATES,
  ALL_DEVICES,
  ALL_DEVICE_STATES,
  ALL_RELEASES,
  APPLICATION_JSON_CONTENT_TYPE,
  APPLICATION_JWT_CONTENT_TYPE,
  ATTRIBUTE_SCOPES,
  DEVICE_FILTERING_OPTIONS,
  DEVICE_ISSUE_OPTIONS,
  DEVICE_LIST_DEFAULTS,
  DEVICE_STATES,
  PermissionTypes,
  SORTING_OPTIONS,
  alertChannels,
  apiRoot,
  apiUrl,
  auditLogsApiUrl,
  defaultPermissionSets,
  deploymentsApiUrl,
  deploymentsApiUrlV2,
  deviceAuthV2,
  deviceConfig,
  deviceConnect,
  emptyRole,
  emptyUiPermissions,
  headerNames,
  inventoryApiUrl,
  inventoryApiUrlV2,
  iotManagerBaseURL,
  limitDefault,
  maxSessionAge,
  monitorApiUrlv1,
  reportingApiUrl,
  rolesById,
  rolesByName,
  scopedPermissionAreas,
  serviceProviderRolesById,
  ssoIdpApiUrlv1,
  tenantadmApiUrlv1,
  tenantadmApiUrlv2,
  twoFAStates,
  uiPermissionsByArea,
  uiPermissionsById,
  useradmApiUrl,
  useradmApiUrlv1,
  useradmApiUrlv2
};
//# sourceMappingURL=chunk-7C4SQBEE.js.map