import { Credentials } from './Credentials.js';
import './AWSCredentials.js';
import './AzureSharedAccessSecret.js';
import './HTTP.js';

type Integration = {
    /**
     * A unique integration identifier generated by the mender server
     */
    id?: string;
    provider: Integration.provider;
    credentials: Credentials;
    /**
     * A short human readable description (max 1024 characters).
     */
    description?: string;
    /**
     * An array of scopes for the integration. Currently we support deviceauth
     * and inventory scopes. The former will match the events related to a device
     * state (accepted, decomissioned), while the latter the inventory changed event.
     */
    scopes?: Array<"deviceauth" | "inventory">;
};
declare namespace Integration {
    enum provider {
        IOT_HUB = "iot-hub",
        IOT_CORE = "iot-core",
        WEBHOOK = "webhook"
    }
}

export { Integration };
