/**
 * Highcharts JS v12.4.0 (2025-09-04)
 * @module highcharts/modules/boost-canvas
 * @requires highcharts
 *
 * Boost module
 *
 * (c) 2010-2025 Highsoft AS
 * Author: Torstein Honsi
 *
 * License: www.highcharts.com/license
 */let t,e;import*as i from"../highcharts.js";var s,o,r,n={};n.n=t=>{var e=t&&t.__esModule?()=>t.default:()=>t;return n.d(e,{a:e}),e},n.d=(t,e)=>{for(var i in e)n.o(e,i)&&!n.o(t,i)&&Object.defineProperty(t,i,{enumerable:!0,get:e[i]})},n.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e);let a=i.default;var l=n.n(a);let h=["area","areaspline","arearange","column","columnrange","bar","line","scatter","heatmap","bubble","treemap"],d={};h.forEach(t=>{d[t]=!0});let{composed:u}=l(),{addEvent:c,pick:g,pushUnique:m}=l();function f(t){let e=t.series,i=t.boost=t.boost||{},s=t.options.boost||{},o=g(s.seriesThreshold,50);if(e.length>=o)return!0;if(1===e.length)return!1;let r=s.allowForce;if(void 0===r){for(let e of(r=!0,t.xAxis))if(g(e.min,-1/0)>g(e.dataMin,-1/0)||g(e.max,1/0)<g(e.dataMax,1/0)){r=!1;break}}if(void 0!==i.forceChartBoost){if(r)return i.forceChartBoost;i.forceChartBoost=void 0}let n=0,a=0,l;for(let t of e)0!==(l=t.options).boostThreshold&&!1!==t.visible&&"heatmap"!==t.type&&(d[t.type]&&++n,function(...t){let e=-Number.MAX_VALUE;return t.forEach(t=>{if(null!=t&&void 0!==t.length&&t.length>0)return e=t.length,!0}),e}(t.getColumn("x",!0),l.data,t.points)>=(l.boostThreshold||Number.MAX_VALUE)&&++a);return i.forceChartBoost=r&&(n===e.length&&a===n||a>5),i.forceChartBoost}function p(t){function e(){t.boost&&t.boost.wgl&&f(t)&&t.boost.wgl.render(t)}c(t,"predraw",function(){t.boost=t.boost||{},t.boost.forceChartBoost=void 0,t.boosted=!1,t.axes.some(t=>t.isPanning)||t.boost.clear?.(),t.boost.canvas&&t.boost.wgl&&f(t)&&t.boost.wgl.allocateBuffer(t),t.boost.markerGroup&&t.xAxis&&t.xAxis.length>0&&t.yAxis&&t.yAxis.length>0&&t.boost.markerGroup.translate(t.xAxis[0].pos,t.yAxis[0].pos)}),c(t,"load",e,{order:-1}),c(t,"redraw",e);let i=-1,s=-1;c(t.pointer,"afterGetHoverData",e=>{let o=e.hoverPoint?.series;if(t.boost=t.boost||{},t.boost.markerGroup&&o){let e=t.inverted?o.yAxis:o.xAxis,r=t.inverted?o.xAxis:o.yAxis;(e&&e.pos!==i||r&&r.pos!==s)&&(t.series.forEach(t=>{t.halo?.hide()}),t.boost.markerGroup.translate(e.pos,r.pos),i=e.pos,s=r.pos)}})}let b={compose:function(t,e){return e&&m(u,"Boost.Chart")&&t.prototype.callbacks.push(p),t},getBoostClipRect:function(t,e){let i=t.navigator,s={x:t.plotLeft,y:t.plotTop,width:t.plotWidth,height:t.plotHeight};if(i&&t.inverted?(s.width+=i.top+i.height,i.opposite||(s.x=i.left)):i&&!t.inverted&&(s.height=i.top+i.height-t.plotTop),e.is){let{xAxis:i,yAxis:o}=e;if(s=t.getClipBox(e),t.inverted){let t=s.width;s.width=s.height,s.height=t,s.x=o.pos,s.y=i.pos}else s.x=i.pos,s.y=o.pos}if(e===t){let e=t.inverted?t.xAxis:t.yAxis;e.length<=1&&(s.y=Math.min(e[0].pos,s.y),s.height=e[0].pos-t.plotTop+e[0].len)}return s},isChartSeriesBoosting:f},x=i.default.Color;var A=n.n(x);let y={area:"LINES",arearange:"LINES",areaspline:"LINES",column:"LINES",columnrange:"LINES",bar:"LINES",line:"LINE_STRIP",scatter:"POINTS",heatmap:"TRIANGLES",treemap:"TRIANGLES",bubble:"POINTS"},{clamp:v,error:P,pick:T}=l(),C=class{constructor(t){if(this.errors=[],this.uLocations={},this.gl=t,t&&!this.createShader())return}bind(){this.gl&&this.shaderProgram&&this.gl.useProgram(this.shaderProgram)}createShader(){let t=this.stringToProgram("#version 100\n#define LN10 2.302585092994046\nprecision highp float;\nattribute vec4 aVertexPosition;\nattribute vec4 aColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform mat4 uPMatrix;\nuniform float pSize;\nuniform float translatedThreshold;\nuniform bool hasThreshold;\nuniform bool skipTranslation;\nuniform float xAxisTrans;\nuniform float xAxisMin;\nuniform float xAxisMax;\nuniform float xAxisMinPad;\nuniform float xAxisPointRange;\nuniform float xAxisLen;\nuniform bool  xAxisPostTranslate;\nuniform float xAxisOrdinalSlope;\nuniform float xAxisOrdinalOffset;\nuniform float xAxisPos;\nuniform bool  xAxisCVSCoord;\nuniform bool  xAxisIsLog;\nuniform bool  xAxisReversed;\nuniform float yAxisTrans;\nuniform float yAxisMin;\nuniform float yAxisMax;\nuniform float yAxisMinPad;\nuniform float yAxisPointRange;\nuniform float yAxisLen;\nuniform bool  yAxisPostTranslate;\nuniform float yAxisOrdinalSlope;\nuniform float yAxisOrdinalOffset;\nuniform float yAxisPos;\nuniform bool  yAxisCVSCoord;\nuniform bool  yAxisIsLog;\nuniform bool  yAxisReversed;\nuniform bool  isCircle;\nuniform bool  isBubble;\nuniform bool  bubbleSizeByArea;\nuniform float bubbleZMin;\nuniform float bubbleZMax;\nuniform float bubbleZThreshold;\nuniform float bubbleMinSize;\nuniform float bubbleMaxSize;\nuniform bool  bubbleSizeAbs;\nuniform bool  isInverted;\nfloat bubbleRadius(){\nfloat value = aVertexPosition.w;\nfloat zMax = bubbleZMax;\nfloat zMin = bubbleZMin;\nfloat radius = 0.0;\nfloat pos = 0.0;\nfloat zRange = zMax - zMin;\nif (bubbleSizeAbs){\nvalue = value - bubbleZThreshold;\nzMax = max(zMax - bubbleZThreshold, zMin - bubbleZThreshold);\nzMin = 0.0;\n}\nif (value < zMin){\nradius = bubbleZMin / 2.0 - 1.0;\n} else {\npos = zRange > 0.0 ? (value - zMin) / zRange : 0.5;\nif (bubbleSizeByArea && pos > 0.0){\npos = sqrt(pos);\n}\nradius = ceil(bubbleMinSize + pos * (bubbleMaxSize - bubbleMinSize)) / 2.0;\n}\nreturn radius * 2.0;\n}\nfloat translate(float val,\nfloat pointPlacement,\nfloat localA,\nfloat localMin,\nfloat minPixelPadding,\nfloat pointRange,\nfloat len,\nbool  cvsCoord,\nbool  isLog,\nbool  reversed\n){\nfloat sign = 1.0;\nfloat cvsOffset = 0.0;\nif (cvsCoord) {\nsign *= -1.0;\ncvsOffset = len;\n}\nif (isLog) {\nval = log(val) / LN10;\n}\nif (reversed) {\nsign *= -1.0;\ncvsOffset -= sign * len;\n}\nreturn sign * (val - localMin) * localA + cvsOffset + \n(sign * minPixelPadding);\n}\nfloat xToPixels(float value) {\nif (skipTranslation){\nreturn value;// + xAxisPos;\n}\nreturn translate(value, 0.0, xAxisTrans, xAxisMin, xAxisMinPad, xAxisPointRange, xAxisLen, xAxisCVSCoord, xAxisIsLog, xAxisReversed);// + xAxisPos;\n}\nfloat yToPixels(float value, float checkTreshold) {\nfloat v;\nif (skipTranslation){\nv = value;// + yAxisPos;\n} else {\nv = translate(value, 0.0, yAxisTrans, yAxisMin, yAxisMinPad, yAxisPointRange, yAxisLen, yAxisCVSCoord, yAxisIsLog, yAxisReversed);// + yAxisPos;\nif (v > yAxisLen) {\nv = yAxisLen;\n}\n}\nif (checkTreshold > 0.0 && hasThreshold) {\nv = min(v, translatedThreshold);\n}\nreturn v;\n}\nvoid main(void) {\nif (isBubble){\ngl_PointSize = bubbleRadius();\n} else {\ngl_PointSize = pSize;\n}\nvColor = aColor;\nif (!skipTranslation && isCircle && (\naVertexPosition.x < xAxisMin ||\naVertexPosition.x > xAxisMax ||\naVertexPosition.y < yAxisMin ||\naVertexPosition.y > yAxisMax\n)) {\ngl_Position = uPMatrix * vec4(2.0, 2.0, 2.0, 1.0);\n} else if (skipTranslation && isInverted) {\ngl_Position = uPMatrix * vec4(aVertexPosition.y + yAxisPos, aVertexPosition.x + xAxisPos, 0.0, 1.0);\n} else if (isInverted) {\ngl_Position = uPMatrix * vec4(yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, xToPixels(aVertexPosition.x) + xAxisPos, 0.0, 1.0);\n} else {\ngl_Position = uPMatrix * vec4(xToPixels(aVertexPosition.x) + xAxisPos, yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, 0.0, 1.0);\n}\n}","vertex"),e=this.stringToProgram("precision highp float;\nuniform vec4 fillColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform sampler2D uSampler;\nuniform bool isCircle;\nuniform bool hasColor;\nvoid main(void) {\nvec4 col = fillColor;\nvec4 tcol = texture2D(uSampler, gl_PointCoord.st);\nif (hasColor) {\ncol = vColor;\n}\nif (isCircle) {\ncol *= tcol;\nif (tcol.r < 0.0) {\ndiscard;\n} else {\ngl_FragColor = col;\n}\n} else {\ngl_FragColor = col;\n}\n}","fragment"),i=t=>this.gl.getUniformLocation(this.shaderProgram,t);return t&&e?(this.shaderProgram=this.gl.createProgram(),this.gl.attachShader(this.shaderProgram,t),this.gl.attachShader(this.shaderProgram,e),this.gl.linkProgram(this.shaderProgram),this.gl.getProgramParameter(this.shaderProgram,this.gl.LINK_STATUS))?(this.gl.useProgram(this.shaderProgram),this.gl.bindAttribLocation(this.shaderProgram,0,"aVertexPosition"),this.pUniform=i("uPMatrix"),this.psUniform=i("pSize"),this.fcUniform=i("fillColor"),this.isBubbleUniform=i("isBubble"),this.bubbleSizeAbsUniform=i("bubbleSizeAbs"),this.bubbleSizeAreaUniform=i("bubbleSizeByArea"),this.uSamplerUniform=i("uSampler"),this.skipTranslationUniform=i("skipTranslation"),this.isCircleUniform=i("isCircle"),this.isInverted=i("isInverted"),!0):(this.errors.push(this.gl.getProgramInfoLog(this.shaderProgram)),this.handleErrors(),this.shaderProgram=!1,!1):(this.shaderProgram=!1,this.handleErrors(),!1)}handleErrors(){this.errors.length&&P("[highcharts boost] shader error - "+this.errors.join("\n"))}stringToProgram(t,e){let i=this.gl.createShader("vertex"===e?this.gl.VERTEX_SHADER:this.gl.FRAGMENT_SHADER);return(this.gl.shaderSource(i,t),this.gl.compileShader(i),this.gl.getShaderParameter(i,this.gl.COMPILE_STATUS))?i:(this.errors.push("when compiling "+e+" shader:\n"+this.gl.getShaderInfoLog(i)),!1)}destroy(){this.gl&&this.shaderProgram&&(this.gl.deleteProgram(this.shaderProgram),this.shaderProgram=!1)}fillColorUniform(){return this.fcUniform}getProgram(){return this.shaderProgram}pointSizeUniform(){return this.psUniform}perspectiveUniform(){return this.pUniform}reset(){this.gl&&this.shaderProgram&&(this.gl.uniform1i(this.isBubbleUniform,0),this.gl.uniform1i(this.isCircleUniform,0))}setBubbleUniforms(t,e,i,s=1){let o=t.options,r=Number.MAX_VALUE,n=-Number.MAX_VALUE;if(this.gl&&this.shaderProgram&&t.is("bubble")){let a=t.getPxExtremes();r=T(o.zMin,v(e,!1===o.displayNegative?o.zThreshold:-Number.MAX_VALUE,r)),n=T(o.zMax,Math.max(n,i)),this.gl.uniform1i(this.isBubbleUniform,1),this.gl.uniform1i(this.isCircleUniform,1),this.gl.uniform1i(this.bubbleSizeAreaUniform,"width"!==t.options.sizeBy),this.gl.uniform1i(this.bubbleSizeAbsUniform,t.options.sizeByAbsoluteValue),this.setUniform("bubbleMinSize",a.minPxSize*s),this.setUniform("bubbleMaxSize",a.maxPxSize*s),this.setUniform("bubbleZMin",r),this.setUniform("bubbleZMax",n),this.setUniform("bubbleZThreshold",t.options.zThreshold)}}setColor(t){this.gl&&this.shaderProgram&&this.gl.uniform4f(this.fcUniform,t[0]/255,t[1]/255,t[2]/255,t[3])}setDrawAsCircle(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isCircleUniform,+!!t)}setInverted(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isInverted,t)}setPMatrix(t){this.gl&&this.shaderProgram&&this.gl.uniformMatrix4fv(this.pUniform,!1,t)}setPointSize(t){this.gl&&this.shaderProgram&&this.gl.uniform1f(this.psUniform,t)}setSkipTranslation(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.skipTranslationUniform,+(!0===t))}setTexture(t){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.uSamplerUniform,t)}setUniform(t,e){if(this.gl&&this.shaderProgram){let i=this.uLocations[t]=this.uLocations[t]||this.gl.getUniformLocation(this.shaderProgram,t);this.gl.uniform1f(i,e)}}},M=class{constructor(t,e,i){this.buffer=!1,this.iterator=0,this.preAllocated=!1,this.vertAttribute=!1,this.components=i||2,this.dataComponents=i,this.gl=t,this.shader=e}allocate(t){this.iterator=-1,this.preAllocated=new Float32Array(4*t)}bind(){if(!this.buffer)return!1;this.gl.vertexAttribPointer(this.vertAttribute,this.components,this.gl.FLOAT,!1,0,0)}build(t,e,i){let s;return(this.data=t||[],this.data&&0!==this.data.length||this.preAllocated)?(this.components=i||this.components,this.buffer&&this.gl.deleteBuffer(this.buffer),this.preAllocated||(s=new Float32Array(this.data)),this.buffer=this.gl.createBuffer(),this.gl.bindBuffer(this.gl.ARRAY_BUFFER,this.buffer),this.gl.bufferData(this.gl.ARRAY_BUFFER,this.preAllocated||s,this.gl.STATIC_DRAW),this.vertAttribute=this.gl.getAttribLocation(this.shader.getProgram(),e),this.gl.enableVertexAttribArray(this.vertAttribute),s=!1,!0):(this.destroy(),!1)}destroy(){this.buffer&&(this.gl.deleteBuffer(this.buffer),this.buffer=!1,this.vertAttribute=!1),this.iterator=0,this.components=this.dataComponents||2,this.data=[]}push(t,e,i,s){this.preAllocated&&(this.preAllocated[++this.iterator]=t,this.preAllocated[++this.iterator]=e,this.preAllocated[++this.iterator]=i,this.preAllocated[++this.iterator]=s)}render(t,e,i){let s=this.preAllocated?this.preAllocated.length:this.data.length;return!!this.buffer&&!!s&&((!t||t>s||t<0)&&(t=0),(!e||e>s)&&(e=s),!(t>=e)&&(i=i||"POINTS",this.gl.drawArrays(this.gl[i],t/this.components,(e-t)/this.components),!0))}},{getBoostClipRect:S}=b,{parse:E}=A(),{doc:k,win:R}=l(),{isNumber:w,isObject:U,merge:L,objectEach:_,pick:N}=l(),D={column:!0,columnrange:!0,bar:!0,area:!0,areaspline:!0,arearange:!0},z={scatter:!0,bubble:!0},I=["webgl","experimental-webgl","moz-webgl","webkit-3d"];class G{static orthoMatrix(t,e){return[2/t,0,0,0,0,-(2/e),0,0,0,0,-2,0,-1,1,-1,1]}static seriesPointCount(t){let e,i,s;return t.boosted?(e=!!t.options.stacking,i=(t.getColumn("x").length?t.getColumn("x"):void 0)||t.options.xData||t.getColumn("x",!0),s=(e?t.data:i||t.options.data).length,"treemap"===t.type?s*=12:"heatmap"===t.type?s*=6:D[t.type]&&(s*=2),s):0}constructor(t){this.data=[],this.height=0,this.isInited=!1,this.markerData=[],this.series=[],this.textureHandles={},this.width=0,this.postRenderCallback=t,this.settings={pointSize:1,lineWidth:1,fillColor:"#AA00AA",useAlpha:!0,usePreallocated:!1,useGPUTranslations:!1,debug:{timeRendering:!1,timeSeriesProcessing:!1,timeSetup:!1,timeBufferCopy:!1,timeKDTree:!1,showSkipSummary:!1}}}getPixelRatio(){return this.settings.pixelRatio||R.devicePixelRatio||1}setOptions(t){"pixelRatio"in t||(t.pixelRatio=1),L(!0,this.settings,t)}allocateBuffer(t){let e=this.vbuffer,i=0;this.settings.usePreallocated&&(t.series.forEach(t=>{t.boosted&&(i+=G.seriesPointCount(t))}),e&&e.allocate(i))}allocateBufferForSingleSeries(t){let e=this.vbuffer,i=0;this.settings.usePreallocated&&(t.boosted&&(i=G.seriesPointCount(t)),e&&e.allocate(i))}clear(){let t=this.gl;t&&t.clear(t.COLOR_BUFFER_BIT|t.DEPTH_BUFFER_BIT)}pushSeriesData(t,e){let i=this.data,s=this.settings,o=this.vbuffer,r=t.pointArrayMap&&"low,high"===t.pointArrayMap.join(","),{chart:n,options:a,sorted:l,xAxis:h,yAxis:d}=t,u=!!a.stacking,c=a.data,g=t.xAxis.getExtremes(),m=g.min-(t.xAxis.minPointOffset||0),f=g.max+(t.xAxis.minPointOffset||0),p=t.yAxis.getExtremes(),b=p.min-(t.yAxis.minPointOffset||0),x=p.max+(t.yAxis.minPointOffset||0),A=(t.getColumn("x").length?t.getColumn("x"):void 0)||a.xData||t.getColumn("x",!0),y=(t.getColumn("y").length?t.getColumn("y"):void 0)||a.yData||t.getColumn("y",!0),v=(t.getColumn("z").length?t.getColumn("z"):void 0)||a.zData||t.getColumn("z",!0),P=!A||0===A.length,T=t.options.colorByPoint,C=a.connectNulls,M=t.points||!1,S=u?t.data:A||c,k={x:Number.MAX_VALUE,y:0},R={x:-Number.MAX_VALUE,y:0},w=void 0===n.index,L=D[t.type],_=a.zoneAxis||"y",N=a.zones||!1,z=a.threshold,I=this.getPixelRatio(),G=t.chart.plotWidth,B=!1,O=!1,V,X,F=0,H=!1,Y,W,j,K,Z=-1,q=!1,Q=!1,J,$=!1,tt=!1,te,ti=!1,ts=!0,to=!0,tr,tn=!1,ta=!1,tl=0,th=0;if(a.boostData&&a.boostData.length>0)return;a.gapSize&&(ta="value"!==a.gapUnit?a.gapSize*t.closestPointRange:a.gapSize),N&&(tr=[],N.forEach((t,e)=>{if(t.color){let i=E(t.color).rgba;i[0]/=255,i[1]/=255,i[2]/=255,tr[e]=i,tn||void 0!==t.value||(tn=i)}}),tn||(tn=E(t.pointAttribs&&t.pointAttribs().fill||t.color).rgba,tn[0]/=255,tn[1]/=255,tn[2]/=255)),n.inverted&&(G=t.chart.plotHeight),t.closestPointRangePx=Number.MAX_VALUE;let td=t=>{t&&(e.colorData.push(t[0]),e.colorData.push(t[1]),e.colorData.push(t[2]),e.colorData.push(t[3]))},tu=(t,r,n,a=1,l)=>{td(l),1!==I&&(!s.useGPUTranslations||e.skipTranslation)&&(t*=I,r*=I,a*=I),s.usePreallocated&&o?(o.push(t,r,+!!n,a),tl+=4):(i.push(t),i.push(r),i.push(n?I:0),i.push(a))},tc=()=>{e.segments.length&&(e.segments[e.segments.length-1].to=i.length||tl)},tg=()=>{e.segments.length&&e.segments[e.segments.length-1].from===(i.length||tl)||(tc(),e.segments.push({from:i.length||tl}))},tm=(t,e,i,s,o)=>{td(o),tu(t+i,e),td(o),tu(t,e),td(o),tu(t,e+s),td(o),tu(t,e+s),td(o),tu(t+i,e+s),td(o),tu(t+i,e)};if(tg(),M&&M.length>0){e.skipTranslation=!0,e.drawMode="TRIANGLES",M[0].node&&M[0].node.levelDynamic&&M.sort((t,e)=>{if(t.node){if(t.node.levelDynamic>e.node.levelDynamic)return 1;if(t.node.levelDynamic<e.node.levelDynamic)return -1}return 0}),M.forEach(e=>{let i,s,o=e.plotY;if(void 0!==o&&!isNaN(o)&&null!==e.y&&e.shapeArgs){let{x:o=0,y:r=0,width:a=0,height:l=0}=e.shapeArgs;i=(s=n.styledMode?e.series.colorAttribs(e):s=e.series.pointAttribs(e))["stroke-width"]||0,te=E(s.fill).rgba,te[0]/=255,te[1]/=255,te[2]/=255,t.is("treemap")&&(i=i||1,X=E(s.stroke).rgba,X[0]/=255,X[1]/=255,X[2]/=255,tm(o,r,a,l,X),i/=2),t.is("heatmap")&&n.inverted&&(o=h.len-o,r=d.len-r,a=-a,l=-l),tm(o+i,r+i,a-2*i,l-2*i,te)}}),tc();return}for(;Z<S.length-1;){if(void 0===(j=S[++Z]))continue;if(w)break;let i=c&&c[Z];if(!P){U(i,!0)&&i.color&&(te=E(i.color).rgba);let e=t.options.keys?.indexOf("color");Array.isArray(i)&&e&&"string"==typeof i[e]?te=E(i[e]).rgba:T&&n.options.colors&&(th%=n.options.colors.length,te=E(n.options.colors[th]).rgba),te&&(te[0]/=255,te[1]/=255,te[2]/=255),th++}if(P?(Y=j[0],W=j[1],S[Z+1]&&(Q=S[Z+1][0]),S[Z-1]&&(q=S[Z-1][0]),j.length>=3&&(K=j[2],j[2]>e.zMax&&(e.zMax=j[2]),j[2]<e.zMin&&(e.zMin=j[2]))):(Y=j,W=y?.[Z],S[Z+1]&&(Q=S[Z+1]),S[Z-1]&&(q=S[Z-1]),v&&v.length&&(K=v[Z],v[Z]>e.zMax&&(e.zMax=v[Z]),v[Z]<e.zMin&&(e.zMin=v[Z]))),!C&&(null===Y||null===W)){tg();continue}if(Q&&Q>=m&&Q<=f&&($=!0),q&&q>=m&&q<=f&&(tt=!0),r?(P&&(W=j.slice(1,3)),J=t.getColumn("low",!0)?.[Z],W=t.getColumn("high",!0)?.[Z]||0):u&&(Y=j.x,J=(W=j.stackY)-j.y),null!=b&&null!=x&&(ts=W>=b&&W<=x),!l&&!ts||(Y>f&&R.x<f&&(R.x=Y,R.y=W),Y<m&&k.x>m&&(k.x=Y,k.y=W),null===W&&C))continue;if(null===W||!ts&&S.length>1&&!$&&!tt){tg();continue}if((l&&(Q>=m||Y>=m)&&(q<=f||Y<=f)||!l&&Y>=m&&Y<=f)&&(ti=!0),ti||$||tt){if(ta&&Y-q>ta&&tg(),N){let t;N.some((e,i)=>{let s=N[i-1];return"x"===_?void 0!==e.value&&Y<=e.value&&(tr[i]&&(!s||Y>=s.value)&&(t=tr[i]),!0):void 0!==e.value&&W<=e.value&&(tr[i]&&(!s||W>=s.value)&&(t=tr[i]),!0)}),te=t||tn||te}if(s.useGPUTranslations||(e.skipTranslation=!0,Y=h.toPixels(Y,!0),W=d.toPixels(W,!0),!(Y>G)||"POINTS"!==e.drawMode)){if(e.hasMarkers&&ti&&!1!==B&&(t.closestPointRangePx=Math.min(t.closestPointRangePx,Math.abs(Y-B))),!s.useGPUTranslations&&!s.usePreallocated&&B&&1>Math.abs(Y-B)&&O&&1>Math.abs(W-O)){s.debug.showSkipSummary&&++F;continue}L&&(V=J||0,(!1===J||void 0===J)&&(V=W<0?W:0),(r||u)&&!d.logarithmic||(V=Math.max(null===z?b:z,b)),s.useGPUTranslations||(V=d.toPixels(V,!0)),tu(Y,V,!1,0,te)),a.step&&!to&&tu(Y,O,!1,2,te),tu(Y,W,!1,"bubble"===t.type?K||1:2,te),B=Y,O=W,H=!0,to=!1}}}s.debug.showSkipSummary&&console.log("skipped points:",F);let tf=(t,i)=>{if(s.useGPUTranslations||(e.skipTranslation=!0,t.x=h.toPixels(t.x,!0),t.y=d.toPixels(t.y,!0)),i){this.data=[t.x,t.y,0,2].concat(this.data);return}tu(t.x,t.y,0,2)};!H&&!1!==C&&"line_strip"===t.drawMode&&(k.x<Number.MAX_VALUE&&tf(k,!0),R.x>-Number.MAX_VALUE&&tf(R)),tc()}pushSeries(t){let e=this.markerData,i=this.series,s=this.settings;i.length>0&&i[i.length-1].hasMarkers&&(i[i.length-1].markerTo=e.length),s.debug.timeSeriesProcessing&&console.time("building "+t.type+" series");let o={segments:[],markerFrom:e.length,colorData:[],series:t,zMin:Number.MAX_VALUE,zMax:-Number.MAX_VALUE,hasMarkers:!!t.options.marker&&!1!==t.options.marker.enabled,showMarkers:!0,drawMode:y[t.type]||"LINE_STRIP"};t.index>=i.length?i.push(o):i[t.index]=o,this.pushSeriesData(t,o),s.debug.timeSeriesProcessing&&console.timeEnd("building "+t.type+" series")}flush(){let t=this.vbuffer;this.data=[],this.markerData=[],this.series=[],t&&t.destroy()}setXAxis(t){let e=this.shader;if(!e)return;let i=this.getPixelRatio();e.setUniform("xAxisTrans",t.transA*i),e.setUniform("xAxisMin",t.min),e.setUniform("xAxisMax",t.max),e.setUniform("xAxisMinPad",t.minPixelPadding*i),e.setUniform("xAxisPointRange",t.pointRange),e.setUniform("xAxisLen",t.len*i),e.setUniform("xAxisPos",t.pos*i),e.setUniform("xAxisCVSCoord",!t.horiz),e.setUniform("xAxisIsLog",!!t.logarithmic),e.setUniform("xAxisReversed",!!t.reversed)}setYAxis(t){let e=this.shader;if(!e)return;let i=this.getPixelRatio();e.setUniform("yAxisTrans",t.transA*i),e.setUniform("yAxisMin",t.min),e.setUniform("yAxisMax",t.max),e.setUniform("yAxisMinPad",t.minPixelPadding*i),e.setUniform("yAxisPointRange",t.pointRange),e.setUniform("yAxisLen",t.len*i),e.setUniform("yAxisPos",t.pos*i),e.setUniform("yAxisCVSCoord",!t.horiz),e.setUniform("yAxisIsLog",!!t.logarithmic),e.setUniform("yAxisReversed",!!t.reversed)}setThreshold(t,e){let i=this.shader;i&&(i.setUniform("hasThreshold",t),i.setUniform("translatedThreshold",e))}renderChart(t){let e=this.gl,i=this.settings,s=this.shader,o=this.vbuffer,r=this.getPixelRatio();if(!t)return!1;this.width=t.chartWidth*r,this.height=t.chartHeight*r;let n=this.height,a=this.width;if(!e||!s||!a||!n)return!1;i.debug.timeRendering&&console.time("gl rendering"),e.canvas.width=a,e.canvas.height=n,s.bind(),e.viewport(0,0,a,n),s.setPMatrix(G.orthoMatrix(a,n)),i.lineWidth>1&&!l().isMS&&e.lineWidth(i.lineWidth),o&&(o.build(this.data,"aVertexPosition",4),o.bind()),s.setInverted(t.inverted),this.series.forEach((a,l)=>{let h=a.series.options,d=h.marker,u=void 0!==h.lineWidth?h.lineWidth:1,c=h.threshold,g=w(c),m=a.series.yAxis.getThreshold(c),f=N(h.marker?h.marker.enabled:null,!!a.series.xAxis.isRadial||null,a.series.closestPointRangePx>2*((h.marker?h.marker.radius:10)||10)),p=this.textureHandles[d&&d.symbol||a.series.symbol]||this.textureHandles.circle,b,x,y,v=[];if(0!==a.segments.length&&a.segments[0].from!==a.segments[0].to&&(p.isReady&&(e.bindTexture(e.TEXTURE_2D,p.handle),s.setTexture(p.handle)),t.styledMode?a.series.markerGroup===a.series.chart.boost?.markerGroup?(delete a.series.markerGroup,a.series.markerGroup=a.series.plotGroup("markerGroup","markers","visible",1,t.seriesGroup).addClass("highcharts-tracker"),y=a.series.markerGroup.getStyle("fill"),a.series.markerGroup.destroy(),a.series.markerGroup=a.series.chart.boost?.markerGroup):y=a.series.markerGroup?.getStyle("fill"):(y="POINTS"===a.drawMode&&a.series.pointAttribs&&a.series.pointAttribs().fill||a.series.color,h.colorByPoint&&(y=a.series.chart.options.colors[l])),a.series.fillOpacity&&h.fillOpacity&&(y=new(A())(y).setOpacity(N(h.fillOpacity,1)).get()),v=E(y).rgba,i.useAlpha||(v[3]=1),"add"===h.boostBlending?(e.blendFunc(e.SRC_ALPHA,e.ONE),e.blendEquation(e.FUNC_ADD)):"mult"===h.boostBlending||"multiply"===h.boostBlending?e.blendFunc(e.DST_COLOR,e.ZERO):"darken"===h.boostBlending?(e.blendFunc(e.ONE,e.ONE),e.blendEquation(e.FUNC_MIN)):e.blendFuncSeparate(e.SRC_ALPHA,e.ONE_MINUS_SRC_ALPHA,e.ONE,e.ONE_MINUS_SRC_ALPHA),s.reset(),a.colorData.length>0?(s.setUniform("hasColor",1),(x=new M(e,s)).build(Array(a.segments[0].from).concat(a.colorData),"aColor",4),x.bind()):(s.setUniform("hasColor",0),e.disableVertexAttribArray(e.getAttribLocation(s.getProgram(),"aColor"))),s.setColor(v),this.setXAxis(a.series.xAxis),this.setYAxis(a.series.yAxis),this.setThreshold(g,m),"POINTS"===a.drawMode&&s.setPointSize(2*N(h.marker&&h.marker.radius,.5)*r),s.setSkipTranslation(a.skipTranslation),"bubble"===a.series.type&&s.setBubbleUniforms(a.series,a.zMin,a.zMax,r),s.setDrawAsCircle(z[a.series.type]||!1),o)){if(u>0||"LINE_STRIP"!==a.drawMode){let{x:i,y:s,width:r,height:l}=S(t,a.series);for(e.enable(e.SCISSOR_TEST),e.scissor(i,n-s-l,r,l),b=0;b<a.segments.length;b++)o.render(a.segments[b].from,a.segments[b].to,a.drawMode);e.disable(e.SCISSOR_TEST)}if(a.hasMarkers&&f)for(s.setPointSize(2*N(h.marker&&h.marker.radius,5)*r),s.setDrawAsCircle(!0),b=0;b<a.segments.length;b++)o.render(a.segments[b].from,a.segments[b].to,"POINTS")}}),i.debug.timeRendering&&console.timeEnd("gl rendering"),this.postRenderCallback&&this.postRenderCallback(this),this.flush()}render(t){if(this.clear(),t.renderer.forExport)return this.renderChart(t);this.isInited?this.renderChart(t):setTimeout(()=>{this.render(t)},1)}setSize(t,e){let i=this.shader;i&&(this.width!==t||this.height!==e)&&(this.width=t,this.height=e,i.bind(),i.setPMatrix(G.orthoMatrix(t,e)))}init(t,e){let i=this.settings;if(this.isInited=!1,!t)return!1;i.debug.timeSetup&&console.time("gl setup");for(let e=0;e<I.length&&(this.gl=t.getContext(I[e],{}),!this.gl);++e);let s=this.gl;if(!s)return!1;e||this.flush(),s.enable(s.BLEND),s.blendFunc(s.SRC_ALPHA,s.ONE_MINUS_SRC_ALPHA),s.disable(s.DEPTH_TEST),s.depthFunc(s.LESS);let o=this.shader=new C(s);if(!o)return!1;this.vbuffer=new M(s,o);let r=(t,e)=>{let i={isReady:!1,texture:k.createElement("canvas"),handle:s.createTexture()},o=i.texture.getContext("2d");this.textureHandles[t]=i,i.texture.width=512,i.texture.height=512,o.mozImageSmoothingEnabled=!1,o.webkitImageSmoothingEnabled=!1,o.msImageSmoothingEnabled=!1,o.imageSmoothingEnabled=!1,o.strokeStyle="rgba(255, 255, 255, 0)",o.fillStyle="#FFF",e(o);try{s.activeTexture(s.TEXTURE0),s.bindTexture(s.TEXTURE_2D,i.handle),s.texImage2D(s.TEXTURE_2D,0,s.RGBA,s.RGBA,s.UNSIGNED_BYTE,i.texture),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_S,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_WRAP_T,s.CLAMP_TO_EDGE),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MAG_FILTER,s.LINEAR),s.texParameteri(s.TEXTURE_2D,s.TEXTURE_MIN_FILTER,s.LINEAR),s.bindTexture(s.TEXTURE_2D,null),i.isReady=!0}catch{}};return r("circle",t=>{t.beginPath(),t.arc(256,256,256,0,2*Math.PI),t.stroke(),t.fill()}),r("square",t=>{t.fillRect(0,0,512,512)}),r("diamond",t=>{t.beginPath(),t.moveTo(256,0),t.lineTo(512,256),t.lineTo(256,512),t.lineTo(0,256),t.lineTo(256,0),t.fill()}),r("triangle",t=>{t.beginPath(),t.moveTo(0,512),t.lineTo(256,0),t.lineTo(512,512),t.lineTo(0,512),t.fill()}),r("triangle-down",t=>{t.beginPath(),t.moveTo(0,0),t.lineTo(256,512),t.lineTo(512,0),t.lineTo(0,0),t.fill()}),this.isInited=!0,i.debug.timeSetup&&console.timeEnd("gl setup"),!0}destroy(){let t=this.gl,e=this.shader,i=this.vbuffer;this.flush(),i&&i.destroy(),e&&e.destroy(),t&&(_(this.textureHandles,e=>{e.handle&&t.deleteTexture(e.handle)}),t.canvas.width=1,t.canvas.height=1)}}(s=o||(o={})).setLength=function(t,e,i){return Array.isArray(t)?(t.length=e,t):t[i?"subarray":"slice"](0,e)},s.splice=function(t,e,i,s,o=[]){if(Array.isArray(t))return Array.isArray(o)||(o=Array.from(o)),{removed:t.splice(e,i,...o),array:t};let r=Object.getPrototypeOf(t).constructor,n=t[s?"subarray":"slice"](e,e+i),a=new r(t.length-i+o.length);return a.set(t.subarray(0,e),0),a.set(o,e),a.set(t.subarray(e+i),e+o.length),{removed:n,array:a}};let{setLength:B,splice:O}=o,{fireEvent:V,objectEach:X,uniqueKey:F}=l(),H=class{constructor(t={}){this.autoId=!t.id,this.columns={},this.id=t.id||F(),this.modified=this,this.rowCount=0,this.versionTag=F();let e=0;X(t.columns||{},(t,i)=>{this.columns[i]=t.slice(),e=Math.max(e,t.length)}),this.applyRowCount(e)}applyRowCount(t){this.rowCount=t,X(this.columns,(e,i)=>{e.length!==t&&(this.columns[i]=B(e,t))})}deleteRows(t,e=1){if(e>0&&t<this.rowCount){let i=0;X(this.columns,(s,o)=>{this.columns[o]=O(s,t,e).array,i=s.length}),this.rowCount=i}V(this,"afterDeleteRows",{rowIndex:t,rowCount:e}),this.versionTag=F()}getColumn(t,e){return this.columns[t]}getColumns(t,e){return(t||Object.keys(this.columns)).reduce((t,e)=>(t[e]=this.columns[e],t),{})}getRow(t,e){return(e||Object.keys(this.columns)).map(e=>this.columns[e]?.[t])}setColumn(t,e=[],i=0,s){this.setColumns({[t]:e},i,s)}setColumns(t,e,i){let s=this.rowCount;X(t,(t,e)=>{this.columns[e]=t.slice(),s=t.length}),this.applyRowCount(s),i?.silent||(V(this,"afterSetColumns"),this.versionTag=F())}setRow(t,e=this.rowCount,i,s){let{columns:o}=this,r=i?this.rowCount+1:e+1;X(t,(t,n)=>{let a=o[n]||s?.addColumns!==!1&&Array(r);a&&(i?a=O(a,e,0,!0,[t]).array:a[e]=t,o[n]=a)}),r>this.rowCount&&this.applyRowCount(r),s?.silent||(V(this,"afterSetRows"),this.versionTag=F())}},{getBoostClipRect:Y,isChartSeriesBoosting:W}=b,{getOptions:j}=l(),{composed:K,doc:Z,noop:q,win:Q}=l(),{addEvent:J,destroyObjectProperties:$,error:tt,extend:te,fireEvent:ti,isArray:ts,isNumber:to,pick:tr,pushUnique:tn,wrap:ta,defined:tl}=l();function th(t,e){let i=e.boost;t&&i&&i.target&&i.canvas&&!W(e.chart)&&t.allocateBufferForSingleSeries(e)}function td(t){return tr(t&&t.options&&t.options.boost&&t.options.boost.enabled,!0)}function tu(t,i){let s=t.constructor,o=t.seriesGroup||i.group,r=t.chartWidth,n=t.chartHeight,a=t,l="undefined"!=typeof SVGForeignObjectElement,h=!1;W(t)?a=t:(a=i,h=!!(i.options.events?.click||i.options.point?.events?.click));let d=a.boost=a.boost||{};if(l=!1,e||(e=Z.createElement("canvas")),!d.target&&(d.canvas=e,t.renderer.forExport||!l?(a.renderTarget=d.target=t.renderer.image("",0,0,r,n).addClass("highcharts-boost-canvas").add(o),d.clear=function(){d.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="})},d.copy=function(){d.resize(),d.target.attr({href:d.canvas.toDataURL("image/png")})}):(d.targetFo=t.renderer.createElement("foreignObject").add(o),a.renderTarget=d.target=Z.createElement("canvas"),d.targetCtx=d.target.getContext("2d"),d.targetFo.element.appendChild(d.target),d.clear=function(){d.target.width=d.canvas.width,d.target.height=d.canvas.height},d.copy=function(){d.target.width=d.canvas.width,d.target.height=d.canvas.height,d.targetCtx.drawImage(d.canvas,0,0)}),d.resize=function(){r=t.chartWidth,n=t.chartHeight,(d.targetFo||d.target).attr({x:0,y:0,width:r,height:n}).css({pointerEvents:h?void 0:"none",mixedBlendMode:"normal",opacity:1}).addClass(h?"highcharts-tracker":""),a instanceof s&&a.boost?.markerGroup?.translate(t.plotLeft,t.plotTop)},d.clipRect=t.renderer.clipRect(),(d.targetFo||d.target).attr({zIndex:i.options.zIndex}),a instanceof s&&(a.boost.markerGroup=a.renderer.g().add(o).translate(i.xAxis.pos,i.yAxis.pos))),d.canvas.width=r,d.canvas.height=n,d.clipRect){let e=Y(t,a);d.clipRect.attr(e),e.width===t.clipBox.width&&e.height===t.clipBox.height?o?.clip(t.renderer.clipRect(e.x-4,e.y,e.width+4,e.height+4)):(d.targetFo||d.target).clip(d.clipRect)}return d.resize(),d.clear(),!d.wgl&&(d.wgl=new G(t=>{t.settings.debug.timeBufferCopy&&console.time("buffer copy"),d.copy(),t.settings.debug.timeBufferCopy&&console.timeEnd("buffer copy")}),d.wgl.init(d.canvas)||tt("[highcharts boost] - unable to init WebGL renderer"),d.wgl.setOptions(t.options.boost||{}),a instanceof s&&d.wgl.allocateBuffer(t)),d.wgl.setSize(r,n),d.wgl}function tc(t){let e=t.points;if(e){let t,i;for(i=0;i<e.length;i+=1)(t=e[i])&&t.destroyElements&&t.destroyElements()}for(let e of(["graph","area","tracker"].forEach(e=>{let i=t[e];i&&(t[e]=i.destroy())}),t.zones))$(e,void 0,!0)}function tg(t,e,i,s,o,r){let n=(o=o||0)+(s=s||3e3),a=!0;for(;a&&o<n&&o<t.length;)a=e(t[o],o),++o;a&&(o<t.length?r?tg(t,e,i,s,o,r):Q.requestAnimationFrame?Q.requestAnimationFrame(function(){tg(t,e,i,s,o)}):setTimeout(tg,0,t,e,i,s,o):i&&i())}function tm(t,e){let i=t.options,s=t.dataTable.modified.rowCount,o=t.xAxis&&t.xAxis.options,r=t.yAxis&&t.yAxis.options,n=t.colorAxis&&t.colorAxis.options;return s>tr(i.boostThreshold,Number.MAX_VALUE)&&to(r.min)&&to(r.max)&&(!e||to(o.min)&&to(o.max))&&(!n||to(n.min)&&to(n.max))}let tf=(t,e)=>!t.forceCrop&&(W(t.chart)||(e?e.length:0)>=tr(t.options.boostThreshold,Number.MAX_VALUE));function tp(){let t=this,e=t.chart;e.boost&&e.boost.markerGroup===t.markerGroup&&(t.markerGroup=void 0),e.hoverPoints&&(e.hoverPoints=e.hoverPoints.filter(function(e){return e.series===t})),e.hoverPoint&&e.hoverPoint.series===t&&(e.hoverPoint=void 0)}function tb(){let t=this.boost;t&&t.canvas&&t.target&&(t.wgl&&t.wgl.clear(),t.clear&&t.clear())}function tx(t){let e=t.boost;e&&e.canvas&&e.target&&e.wgl&&!W(t.chart)&&e.wgl.render(t.chart)}function tA(t,e){let i=t.options,s=t.xAxis,o=t.pointClass;if(e instanceof o)return e;let r=i.data,n=t.is("scatter"),a=(n&&t.getColumn("x",!0).length?t.getColumn("x",!0):void 0)||(t.getColumn("x").length?t.getColumn("x"):void 0)||i.xData||t.getColumn("x",!0)||!1,l=t.getColumn("y",!0)||i.yData||!1,h=e.i,d=r?.[h]?.color,u=new o(t,n&&a&&l?[a[h],l[h]]:(ts(r)?r:[])[h],a?a[h]:void 0);if(n&&i?.keys?.length){let t=i.keys;for(let e=t.length-1;e>-1;e--)u[t[e]]=r[h][e]}return u.category=tr(s.categories?s.categories[u.x]:u.x,u.x),u.key=u.name??u.category,u.dist=e.dist,u.distX=e.distX,u.plotX=e.plotX,u.plotY=e.plotY,u.index=h,u.percentage=e.percentage,u.isInside=t.isPointInside(u),d&&(u.color=d),u}function ty(t){let{options:e,xAxis:i,yAxis:s}=this;if(!this.isDirty&&!i.isDirty&&!s.isDirty&&!t)return!1;this.yAxis.setTickInterval();let o=e.boostThreshold||0,r=e.cropThreshold,n=this.getColumn("x"),a=i.getExtremes(),l=a.max??Number.MAX_VALUE,h=a.min??-Number.MAX_VALUE,d=this.getColumn("y"),u=s.getExtremes(),c=u.max??Number.MAX_VALUE,g=u.min??-Number.MAX_VALUE;if(!this.boosted&&i.old&&s.old&&h>=(i.old.min??-Number.MAX_VALUE)&&l<=(i.old.max??Number.MAX_VALUE)&&g>=(s.old.min??-Number.MAX_VALUE)&&c<=(s.old.max??Number.MAX_VALUE))return this.dataTable.modified.setColumns({x:n,y:d}),!0;let m=this.dataTable.rowCount;if(!o||m<o||r&&!this.forceCrop&&!this.getExtremesFromAll&&!e.getExtremesFromAll&&m<r)return this.dataTable.modified.setColumns({x:n,y:d}),!0;let f=[],p=[],b=[],x=!(to(a.max)||to(a.min)),A=!(to(u.max)||to(u.min)),y=!1,v,P=n[0],T=n[0],C,M=d?.[0],S=d?.[0];for(let t=0,e=n.length;t<e;++t)v=n[t],C=d?.[t],v>=h&&v<=l&&C>=g&&C<=c?(f.push({x:v,y:C}),p.push(v),b.push(C),x&&(P=Math.max(P,v),T=Math.min(T,v)),A&&(M=Math.max(M,C),S=Math.min(S,C))):y=!0;return x&&(i.dataMax=Math.max(P,i.dataMax||0),i.dataMin=Math.min(T,i.dataMin||0)),A&&(s.dataMax=Math.max(M,s.dataMax||0),s.dataMin=Math.min(S,s.dataMin||0)),this.cropped=y,this.cropStart=0,y&&this.dataTable.modified===this.dataTable&&(this.dataTable.modified=new H),this.dataTable.modified.setColumns({x:p,y:b}),tf(this,p)||(this.processedData=f),!0}function tv(){let e=this.options||{},i=this.chart,s=i.boost,o=this.boost,r=this.xAxis,n=this.yAxis,a=e.xData||this.getColumn("x",!0),l=e.yData||this.getColumn("y",!0),h=this.getColumn("low",!0),d=this.getColumn("high",!0),u=this.processedData||e.data,c=r.getExtremes(),g=c.min-(r.minPointOffset||0),m=c.max+(r.minPointOffset||0),f=n.getExtremes(),p=f.min-(n.minPointOffset||0),b=f.max+(n.minPointOffset||0),x={},A=!!this.sampling,y=e.enableMouseTracking,v=e.threshold,P=this.pointArrayMap&&"low,high"===this.pointArrayMap.join(","),T=!!e.stacking,C=this.cropStart||0,M=this.requireSorting,S=!a,E="x"===e.findNearestPointBy,k=(this.getColumn("x").length?this.getColumn("x"):void 0)||this.options.xData||this.getColumn("x",!0),R=tr(e.lineWidth,1),w=e.nullInteraction&&p,U=i.tooltip,L=!1,_,N=n.getThreshold(v),D,z,I,G;if(!this.boosted||(this.points?.forEach(t=>{t?.destroyElements?.()}),this.points=[],U&&!U.isHidden?(i.hoverPoint?.series===this||i.hoverPoints?.some(t=>t.series===this))&&(i.hoverPoint=i.hoverPoints=void 0,U.hide(0)):i.hoverPoints&&(i.hoverPoints=i.hoverPoints.filter(t=>t.series!==this)),r.isPanning||n.isPanning)||(L=tu(i,this),i.boosted=!0,!this.visible))return;(this.points||this.graph)&&tc(this),W(i)?(this.markerGroup&&this.markerGroup!==s?.markerGroup&&this.markerGroup.destroy(),this.markerGroup=s?.markerGroup,o&&o.target&&(this.renderTarget=o.target=o.target.destroy())):(this.markerGroup===s?.markerGroup&&(this.markerGroup=void 0),this.markerGroup=this.plotGroup("markerGroup","markers","visible",1,i.seriesGroup).addClass("highcharts-tracker"));let B=this.points=[],O=(e,s,o,a)=>{let l=!!k&&k[C+o],h=t=>{i.inverted&&(t=r.len-t,s=n.len-s),B.push({destroy:q,x:l,clientX:t,plotX:t,plotY:s,i:C+o,percentage:a})};e=Math.ceil(e),t=E?e:e+","+s,y&&(x[t]?l===k[k.length-1]&&(B.length--,h(e)):(x[t]=!0,h(e)))};this.buildKDTree=q,ti(this,"renderCanvas"),s&&o?.target&&R>1&&this.is("line")&&(s.lineWidthFilter?.remove(),s.lineWidthFilter=i.renderer.definition({tagName:"filter",children:[{tagName:"feMorphology",attributes:{operator:"dilate",radius:.25*R}}],attributes:{id:"linewidth"}}),o.target.attr({filter:"url(#linewidth)"})),L&&(th(L,this),L.pushSeries(this),tx(this));let V=L.settings;i.renderer.forExport||(V.debug.timeKDTree&&console.time("kd tree building"),tg(T?this.data.slice(C):a||u,function(t,e){let s=void 0===i.index,o,a,u,c,f,x=!1,y=!0;return!tl(t)||(!s&&(S?(o=t[0],a=t[1]):(o=t,a=l[e]??w??null),P?(S&&(a=t.slice(1,3)),x=h[e],a=d[e]):T&&(o=t.x,x=(a=t.stackY)-t.y,f=t.percentage),M||(y=(a||0)>=p&&a<=b),null!==a&&o>=g&&o<=m&&y&&(u=r.toPixels(o,!0),A?((void 0===I||u===_)&&(P||(x=a),(void 0===G||a>z)&&(z=a,G=e),(void 0===I||x<D)&&(D=x,I=e)),E&&u===_||(void 0!==I&&(c=n.toPixels(z,!0),N=n.toPixels(D,!0),O(u,c,G,f),N!==c&&O(u,N,I,f)),I=G=void 0,_=u)):O(u,c=Math.ceil(n.toPixels(a,!0)),e,f))),!s)},()=>{ti(this,"renderedCanvas"),delete this.buildKDTree,this.options&&this.buildKDTree(),V.debug.timeKDTree&&console.timeEnd("kd tree building")}))}function tP(t){let e=!0;if(this.chart.options&&this.chart.options.boost&&(e=void 0===this.chart.options.boost.enabled||this.chart.options.boost.enabled),!e||!this.boosted)return t.call(this);this.chart.boosted=!0;let i=tu(this.chart,this);i&&(th(i,this),i.pushSeries(this)),tx(this)}function tT(t){if(this.boosted){if(tm(this))return{};if(this.xAxis.isPanning||this.yAxis.isPanning)return this}return t.apply(this,[].slice.call(arguments,1))}function tC(t){let e=this.options.data;if(td(this.chart)&&d[this.type]){let s=this.is("scatter")&&!this.is("bubble")&&!this.is("treemap")&&!this.is("heatmap");if(!tf(this,e)||s||this.is("treemap")||this.options.stacking||!tm(this,!0)){if(this.boosted&&(this.xAxis?.isPanning||this.yAxis?.isPanning))return;s&&"treegrid"!==this.yAxis.type?ty.call(this,arguments[1]):t.apply(this,[].slice.call(arguments,1)),e=this.getColumn("x",!0)}if(this.boosted=tf(this,e),this.boosted){let t;this.options.data?.length&&(to(t=this.getFirstValidPoint(this.options.data))||ts(t)||this.is("treemap")||tt(12,!1,this.chart));var i=this;i.boost=i.boost||{getPoint:t=>tA(i,t)};let e=i.boost.altered=[];if(["allowDG","directTouch","stickyTracking"].forEach(t=>{e.push({prop:t,val:i[t],own:Object.hasOwnProperty.call(i,t)})}),i.allowDG=!1,i.directTouch=!1,i.stickyTracking=!0,i.finishedAnimating=!0,i.labelBySeries&&(i.labelBySeries=i.labelBySeries.destroy()),i.is("scatter")&&!i.is("treemap")&&i.data.length){for(let t of i.data)t?.destroy?.();i.data.length=0,i.points.length=0,delete i.processedData}}else!function(t){let e=t.boost,i=t.chart,s=i.boost;if(s?.markerGroup)for(let t of(s.markerGroup.destroy(),s.markerGroup=void 0,i.series))t.markerGroup=void 0,t.markerGroup=t.plotGroup("markerGroup","markers","visible",1,i.seriesGroup).addClass("highcharts-tracker");e&&((e.altered||[]).forEach(e=>{e.own?t[e.prop]=e.val:delete t[e.prop]}),e.clear&&e.clear()),(i.seriesGroup||t.group)?.clip()}(this)}else t.apply(this,[].slice.call(arguments,1))}function tM(t){let e=t.apply(this,[].slice.call(arguments,1));return this.boost&&e?this.boost.getPoint(e):e}let tS={compose:function(t,e,i,s){if(tn(K,"Boost.Series")){let o=j().plotOptions,r=t.prototype;if(J(t,"destroy",tp),J(t,"hide",tb),s&&(r.renderCanvas=tv),ta(r,"getExtremes",tT),ta(r,"processData",tC),ta(r,"searchPoint",tM),["translate","generatePoints","drawTracker","drawPoints","render"].forEach(t=>(function(t,e,i){function s(t){let e=this.options.stacking&&("translate"===i||"generatePoints"===i);this.boosted&&!e&&td(this.chart)&&"heatmap"!==this.type&&"treemap"!==this.type&&d[this.type]&&0!==this.options.boostThreshold?"render"===i&&this.renderCanvas&&this.renderCanvas():t.call(this)}if(ta(t,i,s),"translate"===i)for(let t of["column","arearange","columnrange","heatmap","treemap"])e[t]&&ta(e[t].prototype,i,s)})(r,e,t)),ta(i.prototype,"firePointEvent",function(t,e,i){if("click"===e&&this.series.boosted){let t=i.point;if((t.dist||t.distX)>=(t.series.options.marker?.radius??10))return}return t.apply(this,[].slice.call(arguments,1))}),h.forEach(t=>{let i=o[t];i&&(i.boostThreshold=5e3,i.boostData=[],e[t].prototype.fillOpacity=!0)}),s){let{area:t,areaspline:i,bubble:s,column:o,heatmap:r,scatter:n,treemap:a}=e;if(t&&te(t.prototype,{fill:!0,fillOpacity:!0,sampling:!0}),i&&te(i.prototype,{fill:!0,fillOpacity:!0,sampling:!0}),s){let t=s.prototype;delete t.buildKDTree,ta(t,"markerAttribs",function(t){return!this.boosted&&t.apply(this,[].slice.call(arguments,1))})}o&&te(o.prototype,{fill:!0,sampling:!0}),n&&(n.prototype.fill=!0),[r,a].forEach(t=>{t&&ta(t.prototype,"drawPoints",tP)})}}return t},destroyGraphics:tc,eachAsync:tg,getPoint:tA},{getBoostClipRect:tE,isChartSeriesBoosting:tk}=b,{destroyGraphics:tR}=tS,{parse:tw}=A(),{doc:tU,noop:tL}=l(),{addEvent:t_,fireEvent:tN,isNumber:tD,merge:tz,pick:tI,wrap:tG}=l();!function(t){let e,i="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII=";function s(t,e,i,s,o){o&&e!==o.clientX&&(t.moveTo(o.clientX,o.yBottom),t.lineTo(o.clientX,o.plotY),t.lineTo(e,i),t.lineTo(e,s))}function o(t,e,i,s,o){t.moveTo(e,i),t.arc(e,i,this.radii&&this.radii[o],0,2*Math.PI,!1)}function r(t,e,i,s){t.rect(e-1,i,1,s-i)}function n(){this.boost&&this.boost.copy&&this.boost.copy()}function a(){let t=this.boost||{};t.target&&t.target.attr({href:i}),t.canvas&&t.canvas.getContext("2d").clearRect(0,0,t.canvas.width,t.canvas.height)}function h(){tk(this.chart)?this.boost&&this.boost.clear&&this.boost.clear():this.boost&&this.boost.copy?this.boost.copy():this.chart.boost&&this.chart.boost.copy&&this.chart.boost.copy()}function d(t,e,i){t.lineTo(e,i)}function u(){let t,e=this.chart,s=tk(e)?e:this,o=s===e?e.seriesGroup:e.seriesGroup||this.group,r=e.chartWidth,n=e.chartHeight,a=function(t,e,i,s,o,r,n){t.call(this,i,e,s,o,r,n)},l=s.boost=s.boost||{};return t=l.targetCtx,l.canvas||(l.canvas=tU.createElement("canvas"),l.target=e.renderer.image("",0,0,r,n).addClass("highcharts-boost-canvas").add(o),t=l.targetCtx=l.canvas.getContext("2d"),e.inverted&&["moveTo","lineTo","rect","arc"].forEach(e=>{tG(t,e,a)}),l.copy=function(){l.target.attr({href:l.canvas.toDataURL("image/png")})},l.clear=function(){t.clearRect(0,0,l.canvas.width,l.canvas.height),s===l.target&&l.target.attr({href:i})},l.clipRect=e.renderer.clipRect(),l.target.clip(l.clipRect)),l.canvas.width!==r&&(l.canvas.width=r),l.canvas.height!==n&&(l.canvas.height=n),l.target.attr({x:0,y:0,width:r,height:n,style:"pointer-events: none",href:i}),l.clipRect&&l.clipRect.attr(tE(e,s)),t}function c(){let t=this,s=t.options,o=t.chart,r=t.xAxis,n=t.yAxis,a=o.options.boost||{},h={timeRendering:a.timeRendering||!1,timeSeriesProcessing:a.timeSeriesProcessing||!1,timeSetup:a.timeSetup||!1},d=t.getColumn("x",!0),u=t.getColumn("y",!0),c=s.data,g=r.getExtremes(),m=g.min,f=g.max,p=n.getExtremes(),b=p.min,x=p.max,y={},v=!!t.sampling,P=s.marker&&s.marker.radius,T=t.cvsStrokeBatch||1e3,C=s.enableMouseTracking,M=s.threshold,S=tD(M),E=n.getThreshold(M),k=t.fill,R=t.pointArrayMap&&"low,high"===t.pointArrayMap.join(","),w=!!s.stacking,U=t.cropStart||0,L=o.options.loading,_=t.requireSorting,N=s.connectNulls,D=!d,z=w?t.data:d||c,I=t.fillOpacity?A().parse(t.color).setOpacity(tI(s.fillOpacity,.75)).get():t.color,G="x"===s.findNearestPointBy,B=this.boost||{},O=t.cvsDrawPoint,V=s.lineWidth?t.cvsLineTo:void 0,X=P&&P<=1?t.cvsMarkerSquare:t.cvsMarkerCircle;B.target&&B.target.attr({href:i}),(t.points||t.graph)&&tR(t),t.plotGroup("group","series",t.visible?"visible":"hidden",s.zIndex,o.seriesGroup),t.markerGroup=t.group,t_(t,"destroy",function(){t.markerGroup=null});let F=this.points=[],H=this.getContext();if(t.buildKDTree=tL,B.clear&&B.clear(),!t.visible)return;c.length>99999&&(o.options.loading=tz(L,{labelStyle:{backgroundColor:tw("#ffffff").setOpacity(.75).get(),padding:"1em",borderRadius:"0.5em"},style:{backgroundColor:"none",opacity:1}}),l().clearTimeout(e),o.showLoading("Drawing..."),o.options.loading=L),h.timeRendering&&console.time("canvas rendering");let Y=0,W,j,K=E,Z,q,Q,J,$,tt,te=function(){k?(H.fillStyle=I,H.fill()):(H.strokeStyle=t.color,H.lineWidth=s.lineWidth,H.stroke())},ti=function(e,i,s,r){0===Y&&(H.beginPath(),V&&(H.lineJoin="round")),o.scroller&&"highcharts-navigator-series"===t.options.className?(i+=o.scroller.top,s&&(s+=o.scroller.top)):i+=o.plotTop,e+=o.plotLeft,Z?H.moveTo(e,i):O?O(H,e,i,s,j):V?V(H,e,i):X&&X.call(t,H,e,i,P,r),(Y+=1)===T&&(te(),Y=0),j={clientX:e,plotY:i,yBottom:s}},ts=(this.getColumn("x").length?this.getColumn("x"):void 0)||this.options.xData||!!this.getColumn("x",!0).length&&this.getColumn("x",!0),to=function(t,e,i){tt=G?t:t+","+e,C&&!y[tt]&&(y[tt]=!0,o.inverted&&(t=r.len-t,e=n.len-e),F.push({x:!!ts&&ts[U+i],clientX:t,plotX:t,plotY:e,i:U+i}))};tS.eachAsync(z,(e,i)=>{let s=void 0===o.index,a,l,h,d,c,g,p=!1,A=!1,y=NaN,P=NaN,T=!0;return!s&&(D?(a=e[0],l=e[1],z[i+1]&&(y=z[i+1][0]),z[i-1]&&(P=z[i-1][0])):(a=e,l=u[i],z[i+1]&&(y=z[i+1]),z[i-1]&&(P=z[i-1])),y&&y>=m&&y<=f&&(p=!0),P&&P>=m&&P<=f&&(A=!0),R?(D&&(l=e.slice(1,3)),g=l[0],l=l[1]):w&&(a=e.x,g=(l=e.stackY)-e.y),c=null===l,_||(T=l>=b&&l<=x),!c&&(a>=m&&a<=f&&T||p||A)&&(h=Math.round(r.toPixels(a,!0)),v?((void 0===J||h===W)&&(R||(g=l),(void 0===$||l>Q)&&(Q=l,$=i),(void 0===J||g<q)&&(q=g,J=i)),h!==W&&(void 0!==J&&(d=n.toPixels(Q,!0),K=n.toPixels(q,!0),ti(h,S?Math.min(d,E):d,S?Math.max(K,E):K,i),to(h,d,$),K!==d&&to(h,K,J)),J=$=void 0,W=h)):(ti(h,d=Math.round(n.toPixels(l,!0)),K,i),to(h,d,i))),Z=c&&!N,i%5e4==0&&(t.boost&&t.boost.copy?t.boost.copy():t.chart.boost&&t.chart.boost.copy&&t.chart.boost.copy())),!s},function(){let i=o.loadingDiv,s=o.loadingShown;te(),t.canvasToSVG(),h.timeRendering&&console.timeEnd("canvas rendering"),tN(t,"renderedCanvas"),s&&(i.style.transition="opacity 250ms",i.opacity=0,o.loadingShown=!1,e=setTimeout(function(){i.parentNode&&i.parentNode.removeChild(i),o.loadingDiv=o.loadingSpan=null},250)),delete t.buildKDTree,t.buildKDTree()},o.renderer.forExport?Number.MAX_VALUE:void 0)}function g(t,e,i,s){t.moveTo(e,i),t.arc(e,i,s,0,2*Math.PI,!1)}function m(t,e,i,s){t.rect(e-s,i-s,2*s,2*s)}function f(){let t=this.chart,e=this.getContext(),i=this.chart.inverted,s=this.xAxis,o=this.yAxis;e?(this.points.forEach(r=>{let n,a=r.plotY;if(void 0!==a&&!isNaN(a)&&null!==r.y&&e){let{x:n=0,y:a=0,width:l=0,height:h=0}=r.shapeArgs||{};e.fillStyle=(t.styledMode?r.series.colorAttribs(r):r.series.pointAttribs(r)).fill,i?e.fillRect(o.len-a+s.left,s.len-n+o.top,-h,-l):e.fillRect(n+s.left,a+o.top,l,h)}}),this.canvasToSVG()):this.chart.showLoading("Your browser doesn't support HTML5 canvas, <br>please use a modern browser")}t.compose=function(t,e,i){let l=e.prototype;if(!l.renderCanvas){let{area:e,bubble:p,column:b,heatmap:x,scatter:A}=i;if(t.prototype.callbacks.push(t=>{t_(t,"predraw",a),t_(t,"render",n)}),l.canvasToSVG=h,l.cvsLineTo=d,l.getContext=u,l.renderCanvas=c,e){let t=e.prototype;t.cvsDrawPoint=s,t.fill=!0,t.fillOpacity=!0,t.sampling=!0}if(p){let t=p.prototype;t.cvsMarkerCircle=o,t.cvsStrokeBatch=1}if(b){let t=b.prototype;t.cvsDrawPoint=r,t.fill=!0,t.sampling=!0}if(x&&tG(x.prototype,"drawPoints",f),A){let t=A.prototype;t.cvsMarkerCircle=g,t.cvsMarkerSquare=m,t.fill=!0}}}}(r||(r={}));let tB=r,tO=l();tO.initCanvasBoost=function(){tB.compose(tO.Chart,tO.Series,tO.seriesTypes)};let tV=l();export{tV as default};