dashboardApp.directive('notKeptWidget', ['notKeptWidgetHelper', '$q', function (notKeptWidgetHelper) {
    return {
        templateUrl: MP_SITE_URL + '/dashboard/partials/not_kept_widget',
        restrict: 'A',
        scope: {
            widget: '=',
            currentUser: "=",
            currentDash: "=",
            saveOldName: '&',
            editName: '&',
            deleteWidget: '&',
        },

        link: function (scope, element) {
            scope.refresh = function () {
                return element.attr('refresh');
            }
            scope.$watch(scope.refresh, function () {
                scope.chartList = notKeptWidgetHelper.getChartConfig();
            })
            scope.$watch('refresh', function () {
                notKeptWidgetHelper.getNotKeptStats().then(
                    function (result) {
                        notKeptWidgetHelper.setChartData(result.data);
                        scope.chartList = notKeptWidgetHelper.getChartConfig();
                    }
                );
            });
        }
    };
}]);
