// src/forms/TimeframePicker.tsx
import { useEffect, useState } from "react";
import { Controller, useFormContext } from "react-hook-form";
import { DatePicker } from "@mui/x-date-pickers/DatePicker";
import dayjs from "dayjs";
import { jsx, jsxs } from "react/jsx-runtime";
var ensureStartOfDay = (date) => {
  const momentDate = typeof date === "string" ? dayjs(date.replace("Z", "")) : dayjs(date);
  return `${momentDate.format().split("T")[0]}T00:00:00.000`;
};
var ensureEndOfDay = (date) => {
  const momentDate = typeof date === "string" ? dayjs(date.replace("Z", "")) : dayjs(date);
  return `${momentDate.format().split("T")[0]}T23:59:59.999`;
};
var TimeframePicker = ({
  tonight: propsTonight,
  format = "YYYY-MM-DD",
  fromLabel = "From",
  toLabel = "To",
  slotProps = {},
  fallbackValue = dayjs()
}) => {
  const [tonight] = useState(dayjs(propsTonight));
  const [maxStartDate, setMaxStartDate] = useState(tonight);
  const [minEndDate, setMinEndDate] = useState(tonight);
  const { control, setValue, watch, getValues } = useFormContext();
  const startDate = watch("startDate");
  const endDate = watch("endDate");
  useEffect(() => {
    const currentEndDate = getValues("endDate");
    const now = (/* @__PURE__ */ new Date()).toISOString().replace("Z", "");
    if (startDate > currentEndDate) {
      setValue("endDate", ensureEndOfDay(startDate));
    } else if (currentEndDate > now) {
      setValue("endDate", now);
    }
    setMinEndDate(dayjs(startDate));
  }, [startDate, getValues, setValue]);
  useEffect(() => {
    const currentStartDate = getValues("startDate");
    if (endDate < currentStartDate) {
      setValue("startDate", ensureStartOfDay(endDate));
    }
    setMaxStartDate(dayjs(endDate));
  }, [endDate, getValues, setValue]);
  const handleChangeStartDate = (date) => ensureStartOfDay(date);
  const handleChangeEndDate = (date) => ensureEndOfDay(date);
  return /* @__PURE__ */ jsxs("div", { className: "flexbox", style: { flexWrap: "wrap", gap: 15 }, children: [
    /* @__PURE__ */ jsx(
      Controller,
      {
        name: "startDate",
        control,
        render: ({ field: { onChange, value } }) => /* @__PURE__ */ jsx(
          DatePicker,
          {
            disableFuture: true,
            format,
            slotProps: {
              ...slotProps,
              textField: (props) => ({
                ...slotProps.textField,
                inputProps: {
                  ...props.inputProps,
                  ...slotProps.textField?.inputProps,
                  "aria-label": "From"
                }
              })
            },
            yearsOrder: "desc",
            label: fromLabel,
            maxDate: maxStartDate,
            onChange: (e) => onChange(handleChangeStartDate(e)),
            value: value ? dayjs(value) : fallbackValue
          }
        )
      }
    ),
    /* @__PURE__ */ jsx(
      Controller,
      {
        name: "endDate",
        control,
        render: ({ field: { onChange, value } }) => /* @__PURE__ */ jsx(
          DatePicker,
          {
            disableFuture: true,
            format,
            slotProps: {
              ...slotProps,
              textField: (props) => ({
                ...slotProps.textField,
                inputProps: {
                  ...props.inputProps,
                  ...slotProps.textField?.inputProps,
                  "aria-label": "To"
                }
              })
            },
            yearsOrder: "desc",
            label: toLabel,
            minDate: minEndDate,
            onChange: (e) => onChange(handleChangeEndDate(e)),
            value: value ? dayjs(value) : fallbackValue
          }
        )
      }
    )
  ] });
};
var TimeframePicker_default = TimeframePicker;

export {
  TimeframePicker,
  TimeframePicker_default
};
//# sourceMappingURL=chunk-2IUUMY7K.js.map