import _extends from "@babel/runtime/helpers/esm/extends";
/* v8 ignore start */
import dayjs from 'dayjs';
// dayjs has no exports field defined
// See https://github.com/iamkun/dayjs/issues/2562
/* eslint-disable import/extensions */
import weekOfYearPlugin from 'dayjs/plugin/weekOfYear.js';
import customParseFormatPlugin from 'dayjs/plugin/customParseFormat.js';
import localizedFormatPlugin from 'dayjs/plugin/localizedFormat.js';
import isBetweenPlugin from 'dayjs/plugin/isBetween.js';
import advancedFormatPlugin from 'dayjs/plugin/advancedFormat.js';
/* v8 ignore stop */
/* eslint-enable import/extensions */
import { warnOnce } from '@mui/x-internals/warning';
dayjs.extend(localizedFormatPlugin);
dayjs.extend(weekOfYearPlugin);
dayjs.extend(isBetweenPlugin);
dayjs.extend(advancedFormatPlugin);
const formatTokenMap = {
  // Year
  YY: 'year',
  YYYY: {
    sectionType: 'year',
    contentType: 'digit',
    maxLength: 4
  },
  // Month
  M: {
    sectionType: 'month',
    contentType: 'digit',
    maxLength: 2
  },
  MM: 'month',
  MMM: {
    sectionType: 'month',
    contentType: 'letter'
  },
  MMMM: {
    sectionType: 'month',
    contentType: 'letter'
  },
  // Day of the month
  D: {
    sectionType: 'day',
    contentType: 'digit',
    maxLength: 2
  },
  DD: 'day',
  Do: {
    sectionType: 'day',
    contentType: 'digit-with-letter'
  },
  // Day of the week
  d: {
    sectionType: 'weekDay',
    contentType: 'digit',
    maxLength: 2
  },
  dd: {
    sectionType: 'weekDay',
    contentType: 'letter'
  },
  ddd: {
    sectionType: 'weekDay',
    contentType: 'letter'
  },
  dddd: {
    sectionType: 'weekDay',
    contentType: 'letter'
  },
  // Meridiem
  A: 'meridiem',
  a: 'meridiem',
  // Hours
  H: {
    sectionType: 'hours',
    contentType: 'digit',
    maxLength: 2
  },
  HH: 'hours',
  h: {
    sectionType: 'hours',
    contentType: 'digit',
    maxLength: 2
  },
  hh: 'hours',
  // Minutes
  m: {
    sectionType: 'minutes',
    contentType: 'digit',
    maxLength: 2
  },
  mm: 'minutes',
  // Seconds
  s: {
    sectionType: 'seconds',
    contentType: 'digit',
    maxLength: 2
  },
  ss: 'seconds'
};
const defaultFormats = {
  year: 'YYYY',
  month: 'MMMM',
  monthShort: 'MMM',
  dayOfMonth: 'D',
  dayOfMonthFull: 'Do',
  weekday: 'dddd',
  weekdayShort: 'dd',
  hours24h: 'HH',
  hours12h: 'hh',
  meridiem: 'A',
  minutes: 'mm',
  seconds: 'ss',
  fullDate: 'll',
  keyboardDate: 'L',
  shortDate: 'MMM D',
  normalDate: 'D MMMM',
  normalDateWithWeekday: 'ddd, MMM D',
  fullTime12h: 'hh:mm A',
  fullTime24h: 'HH:mm',
  keyboardDateTime12h: 'L hh:mm A',
  keyboardDateTime24h: 'L HH:mm'
};
const MISSING_UTC_PLUGIN = ['Missing UTC plugin', 'To be able to use UTC or timezones, you have to enable the `utc` plugin', 'Find more information on https://mui.com/x/react-date-pickers/timezone/#day-js-and-utc'].join('\n');
const MISSING_TIMEZONE_PLUGIN = ['Missing timezone plugin', 'To be able to use timezones, you have to enable both the `utc` and the `timezone` plugin', 'Find more information on https://mui.com/x/react-date-pickers/timezone/#day-js-and-timezone'].join('\n');
/**
 * Based on `@date-io/dayjs`
 *
 * MIT License
 *
 * Copyright (c) 2017 Dmitriy Kovalenko
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
export class AdapterDayjs {
  isMUIAdapter = true;
  isTimezoneCompatible = true;
  lib = 'dayjs';
  escapedCharacters = {
    start: '[',
    end: ']'
  };
  formatTokenMap = (() => formatTokenMap)();
  constructor({
    locale,
    formats
  } = {}) {
    this.locale = locale;
    this.formats = _extends({}, defaultFormats, formats);

    // Moved plugins to the constructor to allow for users to use options on the library
    // for reference: https://github.com/mui/mui-x/pull/11151
    dayjs.extend(customParseFormatPlugin);
  }
  setLocaleToValue = value => {
    const expectedLocale = this.getCurrentLocaleCode();
    if (expectedLocale === value.locale()) {
      return value;
    }
    return value.locale(expectedLocale);
  };
  hasUTCPlugin = () => typeof dayjs.utc !== 'undefined';
  hasTimezonePlugin = () => typeof dayjs.tz !== 'undefined';
  isSame = (value, comparing, comparisonTemplate) => {
    const comparingInValueTimezone = this.setTimezone(comparing, this.getTimezone(value));
    return value.format(comparisonTemplate) === comparingInValueTimezone.format(comparisonTemplate);
  };

  /**
   * Replaces "default" by undefined and "system" by the system timezone before passing it to `dayjs`.
   */
  cleanTimezone = timezone => {
    switch (timezone) {
      case 'default':
        {
          return undefined;
        }
      case 'system':
        {
          return dayjs.tz.guess();
        }
      default:
        {
          return timezone;
        }
    }
  };
  createSystemDate = value => {
    let date;
    if (this.hasUTCPlugin() && this.hasTimezonePlugin()) {
      const timezone = dayjs.tz.guess();
      if (timezone === 'UTC') {
        date = dayjs(value);
      } /* v8 ignore next 3 */else {
        // We can't change the system timezone in the tests
        date = dayjs.tz(value, timezone);
      }
    } else {
      date = dayjs(value);
    }
    return this.setLocaleToValue(date);
  };
  createUTCDate = value => {
    /* v8 ignore next 3 */
    if (!this.hasUTCPlugin()) {
      throw new Error(MISSING_UTC_PLUGIN);
    }
    return this.setLocaleToValue(dayjs.utc(value));
  };
  createTZDate = (value, timezone) => {
    /* v8 ignore next 3 */
    if (!this.hasUTCPlugin()) {
      throw new Error(MISSING_UTC_PLUGIN);
    }

    /* v8 ignore next 3 */
    if (!this.hasTimezonePlugin()) {
      throw new Error(MISSING_TIMEZONE_PLUGIN);
    }
    const keepLocalTime = value !== undefined && !value.endsWith('Z');
    return this.setLocaleToValue(dayjs(value).tz(this.cleanTimezone(timezone), keepLocalTime));
  };
  getLocaleFormats = () => {
    const locales = dayjs.Ls;
    const locale = this.locale || 'en';
    let localeObject = locales[locale];
    if (localeObject === undefined) {
      /* v8 ignore start */
      if (process.env.NODE_ENV !== 'production') {
        warnOnce(['MUI X: Your locale has not been found.', 'Either the locale key is not a supported one. Locales supported by dayjs are available here: https://github.com/iamkun/dayjs/tree/dev/src/locale.', "Or you forget to import the locale from 'dayjs/locale/{localeUsed}'", 'fallback on English locale.']);
      }
      /* v8 ignore stop */
      localeObject = locales.en;
    }
    return localeObject.formats;
  };

  /**
   * If the new day does not have the same offset as the old one (when switching to summer day time for example),
   * Then dayjs will not automatically adjust the offset (moment does).
   * We have to parse again the value to make sure the `fixOffset` method is applied.
   * See https://github.com/iamkun/dayjs/blob/b3624de619d6e734cd0ffdbbd3502185041c1b60/src/plugin/timezone/index.js#L72
   */
  adjustOffset = value => {
    if (!this.hasTimezonePlugin()) {
      return value;
    }
    const timezone = this.getTimezone(value);
    if (timezone !== 'UTC') {
      const fixedValue = value.tz(this.cleanTimezone(timezone), true);
      // TODO: Simplify the case when we raise the `dayjs` peer dep to 1.11.12 (https://github.com/iamkun/dayjs/releases/tag/v1.11.12)
      /* v8 ignore next 3 */
      // @ts-ignore
      if (fixedValue.$offset === (value.$offset ?? 0)) {
        return value;
      }
      // Change only what is needed to avoid creating a new object with unwanted data
      // Especially important when used in an environment where utc or timezone dates are used only in some places
      // Reference: https://github.com/mui/mui-x/issues/13290
      // @ts-ignore
      value.$offset = fixedValue.$offset;
    }
    return value;
  };
  date = (value, timezone = 'default') => {
    if (value === null) {
      return null;
    }
    if (timezone === 'UTC') {
      return this.createUTCDate(value);
    }
    if (timezone === 'system' || timezone === 'default' && !this.hasTimezonePlugin()) {
      return this.createSystemDate(value);
    }
    return this.createTZDate(value, timezone);
  };
  getInvalidDate = () => dayjs(new Date('Invalid date'));
  getTimezone = value => {
    if (this.hasTimezonePlugin()) {
      // @ts-ignore
      const zone = value.$x?.$timezone;
      if (zone) {
        return zone;
      }
    }
    if (this.hasUTCPlugin() && value.isUTC()) {
      return 'UTC';
    }
    return 'system';
  };
  setTimezone = (value, timezone) => {
    if (this.getTimezone(value) === timezone) {
      return value;
    }
    if (timezone === 'UTC') {
      /* v8 ignore next 3 */
      if (!this.hasUTCPlugin()) {
        throw new Error(MISSING_UTC_PLUGIN);
      }
      return value.utc();
    }

    // We know that we have the UTC plugin.
    // Otherwise, the value timezone would always equal "system".
    // And it would be caught by the first "if" of this method.
    if (timezone === 'system') {
      return value.local();
    }
    if (!this.hasTimezonePlugin()) {
      if (timezone === 'default') {
        return value;
      }

      /* v8 ignore next */
      throw new Error(MISSING_TIMEZONE_PLUGIN);
    }
    return this.setLocaleToValue(dayjs.tz(value, this.cleanTimezone(timezone)));
  };
  toJsDate = value => {
    return value.toDate();
  };
  parse = (value, format) => {
    if (value === '') {
      return null;
    }
    return dayjs(value, format, this.locale, true);
  };
  getCurrentLocaleCode = () => {
    return this.locale || 'en';
  };
  is12HourCycleInCurrentLocale = () => {
    /* v8 ignore next */
    return /A|a/.test(this.getLocaleFormats().LT || '');
  };
  expandFormat = format => {
    const localeFormats = this.getLocaleFormats();

    // @see https://github.com/iamkun/dayjs/blob/dev/src/plugin/localizedFormat/index.js
    const t = formatBis => formatBis.replace(/(\[[^\]]+])|(MMMM|MM|DD|dddd)/g, (_, a, b) => a || b.slice(1));
    return format.replace(/(\[[^\]]+])|(LTS?|l{1,4}|L{1,4})/g, (_, a, b) => {
      const B = b && b.toUpperCase();
      return a || localeFormats[b] || t(localeFormats[B]);
    });
  };
  isValid = value => {
    if (value == null) {
      return false;
    }
    return value.isValid();
  };
  format = (value, formatKey) => {
    return this.formatByString(value, this.formats[formatKey]);
  };
  formatByString = (value, formatString) => {
    return this.setLocaleToValue(value).format(formatString);
  };
  formatNumber = numberToFormat => {
    return numberToFormat;
  };
  isEqual = (value, comparing) => {
    if (value === null && comparing === null) {
      return true;
    }
    if (value === null || comparing === null) {
      return false;
    }
    return value.toDate().getTime() === comparing.toDate().getTime();
  };
  isSameYear = (value, comparing) => {
    return this.isSame(value, comparing, 'YYYY');
  };
  isSameMonth = (value, comparing) => {
    return this.isSame(value, comparing, 'YYYY-MM');
  };
  isSameDay = (value, comparing) => {
    return this.isSame(value, comparing, 'YYYY-MM-DD');
  };
  isSameHour = (value, comparing) => {
    return value.isSame(comparing, 'hour');
  };
  isAfter = (value, comparing) => {
    return value > comparing;
  };
  isAfterYear = (value, comparing) => {
    if (!this.hasUTCPlugin()) {
      return value.isAfter(comparing, 'year');
    }
    return !this.isSameYear(value, comparing) && value.utc() > comparing.utc();
  };
  isAfterDay = (value, comparing) => {
    if (!this.hasUTCPlugin()) {
      return value.isAfter(comparing, 'day');
    }
    return !this.isSameDay(value, comparing) && value.utc() > comparing.utc();
  };
  isBefore = (value, comparing) => {
    return value < comparing;
  };
  isBeforeYear = (value, comparing) => {
    if (!this.hasUTCPlugin()) {
      return value.isBefore(comparing, 'year');
    }
    return !this.isSameYear(value, comparing) && value.utc() < comparing.utc();
  };
  isBeforeDay = (value, comparing) => {
    if (!this.hasUTCPlugin()) {
      return value.isBefore(comparing, 'day');
    }
    return !this.isSameDay(value, comparing) && value.utc() < comparing.utc();
  };
  isWithinRange = (value, [start, end]) => {
    return value >= start && value <= end;
  };
  startOfYear = value => {
    return this.adjustOffset(value.startOf('year'));
  };
  startOfMonth = value => {
    return this.adjustOffset(value.startOf('month'));
  };
  startOfWeek = value => {
    return this.adjustOffset(this.setLocaleToValue(value).startOf('week'));
  };
  startOfDay = value => {
    return this.adjustOffset(value.startOf('day'));
  };
  endOfYear = value => {
    return this.adjustOffset(value.endOf('year'));
  };
  endOfMonth = value => {
    return this.adjustOffset(value.endOf('month'));
  };
  endOfWeek = value => {
    return this.adjustOffset(this.setLocaleToValue(value).endOf('week'));
  };
  endOfDay = value => {
    return this.adjustOffset(value.endOf('day'));
  };
  addYears = (value, amount) => {
    return this.adjustOffset(value.add(amount, 'year'));
  };
  addMonths = (value, amount) => {
    return this.adjustOffset(value.add(amount, 'month'));
  };
  addWeeks = (value, amount) => {
    return this.adjustOffset(value.add(amount, 'week'));
  };
  addDays = (value, amount) => {
    return this.adjustOffset(value.add(amount, 'day'));
  };
  addHours = (value, amount) => {
    return this.adjustOffset(value.add(amount, 'hour'));
  };
  addMinutes = (value, amount) => {
    return this.adjustOffset(value.add(amount, 'minute'));
  };
  addSeconds = (value, amount) => {
    return this.adjustOffset(value.add(amount, 'second'));
  };
  getYear = value => {
    return value.year();
  };
  getMonth = value => {
    return value.month();
  };
  getDate = value => {
    return value.date();
  };
  getHours = value => {
    return value.hour();
  };
  getMinutes = value => {
    return value.minute();
  };
  getSeconds = value => {
    return value.second();
  };
  getMilliseconds = value => {
    return value.millisecond();
  };
  setYear = (value, year) => {
    return this.adjustOffset(value.set('year', year));
  };
  setMonth = (value, month) => {
    return this.adjustOffset(value.set('month', month));
  };
  setDate = (value, date) => {
    return this.adjustOffset(value.set('date', date));
  };
  setHours = (value, hours) => {
    return this.adjustOffset(value.set('hour', hours));
  };
  setMinutes = (value, minutes) => {
    return this.adjustOffset(value.set('minute', minutes));
  };
  setSeconds = (value, seconds) => {
    return this.adjustOffset(value.set('second', seconds));
  };
  setMilliseconds = (value, milliseconds) => {
    return this.adjustOffset(value.set('millisecond', milliseconds));
  };
  getDaysInMonth = value => {
    return value.daysInMonth();
  };
  getWeekArray = value => {
    const start = this.startOfWeek(this.startOfMonth(value));
    const end = this.endOfWeek(this.endOfMonth(value));
    let count = 0;
    let current = start;
    const nestedWeeks = [];
    while (current < end) {
      const weekNumber = Math.floor(count / 7);
      nestedWeeks[weekNumber] = nestedWeeks[weekNumber] || [];
      nestedWeeks[weekNumber].push(current);
      current = this.addDays(current, 1);
      count += 1;
    }
    return nestedWeeks;
  };
  getWeekNumber = value => {
    return value.week();
  };
  getDayOfWeek(value) {
    return value.day() + 1;
  }
  getYearRange = ([start, end]) => {
    const startDate = this.startOfYear(start);
    const endDate = this.endOfYear(end);
    const years = [];
    let current = startDate;
    while (this.isBefore(current, endDate)) {
      years.push(current);
      current = this.addYears(current, 1);
    }
    return years;
  };
}