import {
  commonErrorFallback,
  commonErrorHandler,
  createAppAsyncThunk
} from "./chunk-V3QEONX7.js";
import {
  general_api_default
} from "./chunk-RS37Y2PQ.js";
import {
  actions_default
} from "./chunk-F26IKSML.js";
import {
  actions,
  sliceName
} from "./chunk-PGFVHKP5.js";
import {
  getSearchEndpoint
} from "./chunk-SCZLNFB5.js";
import {
  getDeviceFilters
} from "./chunk-KJNNEDRV.js";
import {
  convertDeviceListStateToFilters
} from "./chunk-UE5N5VO3.js";
import {
  DEVICE_LIST_DEFAULTS,
  TIMEOUTS,
  alertChannels,
  headerNames,
  monitorApiUrlv1
} from "./chunk-7C4SQBEE.js";

// src/monitorSlice/thunks.ts
var { page: defaultPage, perPage: defaultPerPage } = DEVICE_LIST_DEFAULTS;
var cutoffLength = 75;
var ellipsis = "...";
var longTextTrimmer = (text) => text.length >= cutoffLength + ellipsis.length ? `${text.substring(0, cutoffLength + ellipsis.length)}${ellipsis}` : text;
var sanitizeDeviceAlerts = (alerts) => alerts.map((alert) => ({ ...alert, fullName: alert.name, name: longTextTrimmer(alert.name || "") }));
var getDeviceAlerts = createAppAsyncThunk(`${sliceName}/getDeviceAlerts`, ({ id, config = {} }, { dispatch }) => {
  const { page = defaultPage, perPage = defaultPerPage, issuedBefore, issuedAfter, sortAscending = false } = config;
  const issued_after = issuedAfter ? `&issued_after=${issuedAfter}` : "";
  const issued_before = issuedBefore ? `&issued_before=${issuedBefore}` : "";
  return general_api_default.get(
    `${monitorApiUrlv1}/devices/${id}/alerts?page=${page}&per_page=${perPage}${issued_after}${issued_before}&sort_ascending=${sortAscending}`
  ).catch((err) => commonErrorHandler(err, `Retrieving device alerts for device ${id} failed:`, dispatch)).then(
    (res) => Promise.all([
      dispatch(actions.receiveDeviceAlerts({ deviceId: id, alerts: sanitizeDeviceAlerts(res.data) })),
      dispatch(actions.setAlertListState({ total: Number(res.headers[headerNames.total]) }))
    ])
  );
});
var getLatestDeviceAlerts = createAppAsyncThunk(
  `${sliceName}/getLatestDeviceAlerts`,
  ({ id, config = {} }, { dispatch }) => {
    const { page = defaultPage, perPage = 10 } = config;
    return general_api_default.get(`${monitorApiUrlv1}/devices/${id}/alerts/latest?page=${page}&per_page=${perPage}`).catch((err) => commonErrorHandler(err, `Retrieving device alerts for device ${id} failed:`, dispatch)).then((res) => Promise.resolve(dispatch(actions.receiveLatestDeviceAlerts({ deviceId: id, alerts: sanitizeDeviceAlerts(res.data) }))));
  }
);
var getIssueCountsByType = createAppAsyncThunk(
  `${sliceName}/getIssueCountsByType`,
  ({ type, options = {} }, { dispatch, getState }) => {
    const state = getState();
    const { filters = getDeviceFilters(state), group, status, ...remainder } = options;
    const { applicableFilters: nonMonitorFilters, filterTerms } = convertDeviceListStateToFilters({
      ...remainder,
      filters,
      group,
      offlineThreshold: state.app.offlineThreshold,
      selectedIssues: [type],
      status
    });
    return general_api_default.post(getSearchEndpoint(getState()), {
      page: 1,
      per_page: 1,
      filters: filterTerms,
      attributes: [{ scope: "identity", attribute: "status" }]
    }).catch((err) => commonErrorHandler(err, `Retrieving issue counts failed:`, dispatch, commonErrorFallback)).then((res) => {
      const total = nonMonitorFilters.length ? state.monitor.issueCounts.byType[type].total : Number(res.headers[headerNames.total]);
      const filtered = nonMonitorFilters.length ? Number(res.headers[headerNames.total]) : total;
      if (total === state.monitor.issueCounts.byType[type].total && filtered === state.monitor.issueCounts.byType[type].filtered) {
        return Promise.resolve();
      }
      return Promise.resolve(dispatch(actions.receiveDeviceIssueCounts({ counts: { filtered, total }, issueType: type })));
    });
  }
);
var getDeviceMonitorConfig = createAppAsyncThunk(
  `${sliceName}/getDeviceMonitorConfig`,
  (id, { dispatch }) => general_api_default.get(`${monitorApiUrlv1}/devices/${id}/config`).catch((err) => commonErrorHandler(err, `Retrieving device monitor config for device ${id} failed:`, dispatch)).then(({ data }) => Promise.all([dispatch(actions_default.receivedDevice({ id, monitors: data }), Promise.resolve(data))]))
);
var changeNotificationSetting = createAppAsyncThunk(
  `${sliceName}/changeNotificationSetting`,
  ({ enabled, channel = alertChannels.email }, { dispatch }) => general_api_default.put(`${monitorApiUrlv1}/settings/global/channel/alerts/${channel}/status`, { enabled }).catch((err) => commonErrorHandler(err, `${enabled ? "En" : "Dis"}abling  ${channel} alerts failed:`, dispatch)).then(
    () => Promise.all([
      dispatch(actions.changeAlertChannel({ channel, enabled })),
      dispatch(
        actions_default.setSnackbar({ message: `Successfully ${enabled ? "en" : "dis"}abled ${channel} alerts`, autoHideDuration: TIMEOUTS.fiveSeconds })
      )
    ])
  )
);

export {
  getDeviceAlerts,
  getLatestDeviceAlerts,
  getIssueCountsByType,
  getDeviceMonitorConfig,
  changeNotificationSetting
};
//# sourceMappingURL=chunk-H5FAPMJJ.js.map