import * as _northern_tech_types_RolePermission from '@northern.tech/types/RolePermission';
import * as _northern_tech_types_PermissionSetWithScope from '@northern.tech/types/PermissionSetWithScope';
import * as _northern_tech_types_AuditLog from '@northern.tech/types/AuditLog';
import * as _northern_tech_types_DeviceState from '@northern.tech/types/DeviceState';
import * as _northern_tech_types_MonitorConfiguration from '@northern.tech/types/MonitorConfiguration';
import * as _northern_tech_types_DeviceStateDeviceconnect from '@northern.tech/types/DeviceStateDeviceconnect';
import * as _northern_tech_types_DeviceConfiguration from '@northern.tech/types/DeviceConfiguration';
import * as _northern_tech_types_ExternalIdentity from '@northern.tech/types/ExternalIdentity';
import * as _northern_tech_types_AuthSet from '@northern.tech/types/AuthSet';
import * as _northern_tech_types_DeviceDeviceauth from '@northern.tech/types/DeviceDeviceauth';
import * as _northern_tech_types_IdentityData from '@northern.tech/types/IdentityData';
import * as reselect from 'reselect';
import { RootState } from './store.js';
import * as _northern_tech_utils_constants from '@northern.tech/utils/constants';
import { ReadState } from './usersSlice/constants.js';
import { User, UserSession, CustomColumn, GlobalSettings, UserSettings } from './usersSlice/index.js';
import { ReleaseSliceType, Release } from './releasesSlice/index.js';
import { OrganizationState, Organization, AuditLogSelectionState } from './organizationSlice/types.js';
import { OnboardingApproach } from './onboardingSlice/index.js';
import * as _northern_tech_types_Alert from '@northern.tech/types/Alert';
import { Deployment, DeploymentByStatus, DeploymentConfig, SelectionState, DeviceDeployment } from './deploymentsSlice/index.js';
import { DeviceSliceType, Device, DeviceGroup, InventoryAttributes } from './devicesSlice/index.js';
import { SearchState, SentryConfig, SnackbarContent, Upload } from './appSlice/index.js';
import '@reduxjs/toolkit';
import 'redux-thunk';
import 'redux';
import 'immer';
import '@northern.tech/types/MenderTypes';
import './commonConstants.js';
import 'react/jsx-runtime';
import './appSlice/constants.js';
import '@mui/material/OverridableComponent';
import '@mui/material';
import './organizationSlice/constants.js';
import './devicesSlice/constants.js';

declare const getIsEnterprise: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => boolean) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: Partial<Organization>, resultFuncArgs_1: Record<string, boolean>) => boolean;
    memoizedResultFunc: ((resultFuncArgs_0: Partial<Organization>, resultFuncArgs_1: Record<string, boolean>) => boolean) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => boolean;
    dependencies: [(state: RootState) => Partial<Organization>, (state: RootState) => Record<string, boolean>];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getAttrsEndpoint: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => string) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: Record<string, boolean>) => string;
    memoizedResultFunc: ((resultFuncArgs_0: Record<string, boolean>) => string) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => string;
    dependencies: [(state: RootState) => Record<string, boolean>];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getSearchEndpoint: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => string) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: Record<string, boolean>) => string;
    memoizedResultFunc: ((resultFuncArgs_0: Record<string, boolean>) => string) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => string;
    dependencies: [(state: RootState) => Record<string, boolean>];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getUserRoles: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => {
    isAdmin: boolean;
    uiPermissions: any;
}) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: User, resultFuncArgs_1: Record<string, _northern_tech_utils_constants.Role>, resultFuncArgs_2: boolean) => {
        isAdmin: boolean;
        uiPermissions: any;
    };
    memoizedResultFunc: ((resultFuncArgs_0: User, resultFuncArgs_1: Record<string, _northern_tech_utils_constants.Role>, resultFuncArgs_2: boolean) => {
        isAdmin: boolean;
        uiPermissions: any;
    }) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => {
        isAdmin: boolean;
        uiPermissions: any;
    };
    dependencies: [((state: {
        app: {
            cancelSource: any;
            commit: string;
            demoArtifactLink: string;
            docsVersion: string;
            features: Record<string, boolean>;
            feedbackProbability: number;
            firstLoginAfterSignup: boolean;
            hostAddress: string | null;
            hostedAnnouncement: string;
            newThreshold: string;
            offlineThreshold: string;
            recaptchaSiteKey: string;
            searchState: SearchState;
            sentry: SentryConfig;
            snackbar: SnackbarContent;
            stripeAPIKey: string;
            trackerCode: string;
            uploadsById: Record<string, Upload>;
            versionInformation: {
                [key: string]: string | {
                    releaseDate: string;
                    repos: Record<string, string>;
                } | undefined;
                backend?: string;
                GUI?: string;
                latestRelease?: {
                    releaseDate: string;
                    repos: Record<string, string>;
                };
            };
            yesterday?: string;
        };
        devices: DeviceSliceType;
        deployments: {
            byId: Record<string, Deployment>;
            byStatus: DeploymentByStatus;
            config: DeploymentConfig;
            deploymentDeviceLimit: number;
            selectedDeviceIds: string[];
            selectionState: SelectionState;
        };
        monitor: {
            alerts: {
                alertList: {
                    page: number;
                    perPage: number;
                    total: number;
                };
                byDeviceId: {
                    alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                    latest?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                };
            };
            issueCounts: {
                byType: {
                    issues: {
                        filtered: number;
                        total: number;
                    };
                    offline: {
                        filtered: number;
                        total: number;
                    };
                    failedLastUpdate: {
                        filtered: number;
                        total: number;
                    };
                    monitoring: {
                        filtered: number;
                        total: number;
                    };
                    authRequests: {
                        filtered: number;
                        total: number;
                    };
                    gatewayDevices: {
                        filtered: number;
                        total: number;
                    };
                };
            };
            settings: {
                global: {
                    channels: {
                        email: {
                            enabled: boolean;
                        };
                    };
                };
            };
        };
        onboarding: {
            address?: string;
            approach: OnboardingApproach | null;
            complete: boolean;
            demoArtifactPort: number;
            deviceConnection?: string;
            deviceType: string[] | string | null;
            progress: string | null;
            showTips: boolean | null;
            showTipsDialog: boolean;
        };
        organization: OrganizationState;
        releases: ReleaseSliceType;
        users: {
            activationCode?: string;
            byId: Record<string, User>;
            currentSession?: UserSession | object;
            currentUser: string | null;
            customColumns: CustomColumn[];
            globalSettings: GlobalSettings;
            permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
            qrCode: string | null;
            rolesById: Record<string, _northern_tech_utils_constants.Role>;
            rolesInitialized: boolean;
            settingsInitialized: boolean;
            showConnectDeviceDialog: boolean;
            showFeedbackDialog: boolean;
            showStartupNotification: boolean;
            tooltips: {
                byId: Record<string, {
                    readState: ReadState;
                }>;
            };
            userSettings: UserSettings;
            userSettingsInitialized: boolean;
        };
    }) => User) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    } & {
        resultFunc: (resultFuncArgs_0: Record<string, User>, resultFuncArgs_1: string | null) => User;
        memoizedResultFunc: ((resultFuncArgs_0: Record<string, User>, resultFuncArgs_1: string | null) => User) & {
            clearCache: () => void;
            resultsCount: () => number;
            resetResultsCount: () => void;
        };
        lastResult: () => User;
        dependencies: [(state: RootState) => Record<string, User>, (state: RootState) => string | null];
        recomputations: () => number;
        resetRecomputations: () => void;
        dependencyRecomputations: () => number;
        resetDependencyRecomputations: () => void;
    } & {
        memoize: typeof reselect.weakMapMemoize;
        argsMemoize: typeof reselect.weakMapMemoize;
    }, (state: RootState) => Record<string, _northern_tech_utils_constants.Role>, ((state: {
        app: {
            cancelSource: any;
            commit: string;
            demoArtifactLink: string;
            docsVersion: string;
            features: Record<string, boolean>;
            feedbackProbability: number;
            firstLoginAfterSignup: boolean;
            hostAddress: string | null;
            hostedAnnouncement: string;
            newThreshold: string;
            offlineThreshold: string;
            recaptchaSiteKey: string;
            searchState: SearchState;
            sentry: SentryConfig;
            snackbar: SnackbarContent;
            stripeAPIKey: string;
            trackerCode: string;
            uploadsById: Record<string, Upload>;
            versionInformation: {
                [key: string]: string | {
                    releaseDate: string;
                    repos: Record<string, string>;
                } | undefined;
                backend?: string;
                GUI?: string;
                latestRelease?: {
                    releaseDate: string;
                    repos: Record<string, string>;
                };
            };
            yesterday?: string;
        };
        devices: DeviceSliceType;
        deployments: {
            byId: Record<string, Deployment>;
            byStatus: DeploymentByStatus;
            config: DeploymentConfig;
            deploymentDeviceLimit: number;
            selectedDeviceIds: string[];
            selectionState: SelectionState;
        };
        monitor: {
            alerts: {
                alertList: {
                    page: number;
                    perPage: number;
                    total: number;
                };
                byDeviceId: {
                    alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                    latest?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                };
            };
            issueCounts: {
                byType: {
                    issues: {
                        filtered: number;
                        total: number;
                    };
                    offline: {
                        filtered: number;
                        total: number;
                    };
                    failedLastUpdate: {
                        filtered: number;
                        total: number;
                    };
                    monitoring: {
                        filtered: number;
                        total: number;
                    };
                    authRequests: {
                        filtered: number;
                        total: number;
                    };
                    gatewayDevices: {
                        filtered: number;
                        total: number;
                    };
                };
            };
            settings: {
                global: {
                    channels: {
                        email: {
                            enabled: boolean;
                        };
                    };
                };
            };
        };
        onboarding: {
            address?: string;
            approach: OnboardingApproach | null;
            complete: boolean;
            demoArtifactPort: number;
            deviceConnection?: string;
            deviceType: string[] | string | null;
            progress: string | null;
            showTips: boolean | null;
            showTipsDialog: boolean;
        };
        organization: OrganizationState;
        releases: ReleaseSliceType;
        users: {
            activationCode?: string;
            byId: Record<string, User>;
            currentSession?: UserSession | object;
            currentUser: string | null;
            customColumns: CustomColumn[];
            globalSettings: GlobalSettings;
            permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
            qrCode: string | null;
            rolesById: Record<string, _northern_tech_utils_constants.Role>;
            rolesInitialized: boolean;
            settingsInitialized: boolean;
            showConnectDeviceDialog: boolean;
            showFeedbackDialog: boolean;
            showStartupNotification: boolean;
            tooltips: {
                byId: Record<string, {
                    readState: ReadState;
                }>;
            };
            userSettings: UserSettings;
            userSettingsInitialized: boolean;
        };
    }) => boolean) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    } & {
        resultFunc: (resultFuncArgs_0: Partial<Organization>, resultFuncArgs_1: Record<string, boolean>) => boolean;
        memoizedResultFunc: ((resultFuncArgs_0: Partial<Organization>, resultFuncArgs_1: Record<string, boolean>) => boolean) & {
            clearCache: () => void;
            resultsCount: () => number;
            resetResultsCount: () => void;
        };
        lastResult: () => boolean;
        dependencies: [(state: RootState) => Partial<Organization>, (state: RootState) => Record<string, boolean>];
        recomputations: () => number;
        resetRecomputations: () => void;
        dependencyRecomputations: () => number;
        resetDependencyRecomputations: () => void;
    } & {
        memoize: typeof reselect.weakMapMemoize;
        argsMemoize: typeof reselect.weakMapMemoize;
    }];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getUserCapabilities: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => {
    canAuditlog: any;
    canConfigure: boolean;
    canDeploy: any;
    canManageDevices: boolean;
    canManageReleases: boolean;
    canManageUsers: any;
    canReadDeployments: any;
    canReadDevices: boolean;
    canReadReleases: boolean;
    canReadUsers: any;
    canTroubleshoot: boolean;
    canUploadReleases: boolean;
    canWriteDevices: boolean;
    groupsPermissions: any;
    releasesPermissions: any;
    SPTenant: boolean | undefined;
}) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: {
        isAdmin: boolean;
        uiPermissions: any;
    }, resultFuncArgs_1: boolean | undefined) => {
        canAuditlog: any;
        canConfigure: boolean;
        canDeploy: any;
        canManageDevices: boolean;
        canManageReleases: boolean;
        canManageUsers: any;
        canReadDeployments: any;
        canReadDevices: boolean;
        canReadReleases: boolean;
        canReadUsers: any;
        canTroubleshoot: boolean;
        canUploadReleases: boolean;
        canWriteDevices: boolean;
        groupsPermissions: any;
        releasesPermissions: any;
        SPTenant: boolean | undefined;
    };
    memoizedResultFunc: ((resultFuncArgs_0: {
        isAdmin: boolean;
        uiPermissions: any;
    }, resultFuncArgs_1: boolean | undefined) => {
        canAuditlog: any;
        canConfigure: boolean;
        canDeploy: any;
        canManageDevices: boolean;
        canManageReleases: boolean;
        canManageUsers: any;
        canReadDeployments: any;
        canReadDevices: boolean;
        canReadReleases: boolean;
        canReadUsers: any;
        canTroubleshoot: boolean;
        canUploadReleases: boolean;
        canWriteDevices: boolean;
        groupsPermissions: any;
        releasesPermissions: any;
        SPTenant: boolean | undefined;
    }) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => {
        canAuditlog: any;
        canConfigure: boolean;
        canDeploy: any;
        canManageDevices: boolean;
        canManageReleases: boolean;
        canManageUsers: any;
        canReadDeployments: any;
        canReadDevices: boolean;
        canReadReleases: boolean;
        canReadUsers: any;
        canTroubleshoot: boolean;
        canUploadReleases: boolean;
        canWriteDevices: boolean;
        groupsPermissions: any;
        releasesPermissions: any;
        SPTenant: boolean | undefined;
    };
    dependencies: [((state: {
        app: {
            cancelSource: any;
            commit: string;
            demoArtifactLink: string;
            docsVersion: string;
            features: Record<string, boolean>;
            feedbackProbability: number;
            firstLoginAfterSignup: boolean;
            hostAddress: string | null;
            hostedAnnouncement: string;
            newThreshold: string;
            offlineThreshold: string;
            recaptchaSiteKey: string;
            searchState: SearchState;
            sentry: SentryConfig;
            snackbar: SnackbarContent;
            stripeAPIKey: string;
            trackerCode: string;
            uploadsById: Record<string, Upload>;
            versionInformation: {
                [key: string]: string | {
                    releaseDate: string;
                    repos: Record<string, string>;
                } | undefined;
                backend?: string;
                GUI?: string;
                latestRelease?: {
                    releaseDate: string;
                    repos: Record<string, string>;
                };
            };
            yesterday?: string;
        };
        devices: DeviceSliceType;
        deployments: {
            byId: Record<string, Deployment>;
            byStatus: DeploymentByStatus;
            config: DeploymentConfig;
            deploymentDeviceLimit: number;
            selectedDeviceIds: string[];
            selectionState: SelectionState;
        };
        monitor: {
            alerts: {
                alertList: {
                    page: number;
                    perPage: number;
                    total: number;
                };
                byDeviceId: {
                    alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                    latest?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                };
            };
            issueCounts: {
                byType: {
                    issues: {
                        filtered: number;
                        total: number;
                    };
                    offline: {
                        filtered: number;
                        total: number;
                    };
                    failedLastUpdate: {
                        filtered: number;
                        total: number;
                    };
                    monitoring: {
                        filtered: number;
                        total: number;
                    };
                    authRequests: {
                        filtered: number;
                        total: number;
                    };
                    gatewayDevices: {
                        filtered: number;
                        total: number;
                    };
                };
            };
            settings: {
                global: {
                    channels: {
                        email: {
                            enabled: boolean;
                        };
                    };
                };
            };
        };
        onboarding: {
            address?: string;
            approach: OnboardingApproach | null;
            complete: boolean;
            demoArtifactPort: number;
            deviceConnection?: string;
            deviceType: string[] | string | null;
            progress: string | null;
            showTips: boolean | null;
            showTipsDialog: boolean;
        };
        organization: OrganizationState;
        releases: ReleaseSliceType;
        users: {
            activationCode?: string;
            byId: Record<string, User>;
            currentSession?: UserSession | object;
            currentUser: string | null;
            customColumns: CustomColumn[];
            globalSettings: GlobalSettings;
            permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
            qrCode: string | null;
            rolesById: Record<string, _northern_tech_utils_constants.Role>;
            rolesInitialized: boolean;
            settingsInitialized: boolean;
            showConnectDeviceDialog: boolean;
            showFeedbackDialog: boolean;
            showStartupNotification: boolean;
            tooltips: {
                byId: Record<string, {
                    readState: ReadState;
                }>;
            };
            userSettings: UserSettings;
            userSettingsInitialized: boolean;
        };
    }) => {
        isAdmin: boolean;
        uiPermissions: any;
    }) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    } & {
        resultFunc: (resultFuncArgs_0: User, resultFuncArgs_1: Record<string, _northern_tech_utils_constants.Role>, resultFuncArgs_2: boolean) => {
            isAdmin: boolean;
            uiPermissions: any;
        };
        memoizedResultFunc: ((resultFuncArgs_0: User, resultFuncArgs_1: Record<string, _northern_tech_utils_constants.Role>, resultFuncArgs_2: boolean) => {
            isAdmin: boolean;
            uiPermissions: any;
        }) & {
            clearCache: () => void;
            resultsCount: () => number;
            resetResultsCount: () => void;
        };
        lastResult: () => {
            isAdmin: boolean;
            uiPermissions: any;
        };
        dependencies: [((state: {
            app: {
                cancelSource: any;
                commit: string;
                demoArtifactLink: string;
                docsVersion: string;
                features: Record<string, boolean>;
                feedbackProbability: number;
                firstLoginAfterSignup: boolean;
                hostAddress: string | null;
                hostedAnnouncement: string;
                newThreshold: string;
                offlineThreshold: string;
                recaptchaSiteKey: string;
                searchState: SearchState;
                sentry: SentryConfig;
                snackbar: SnackbarContent;
                stripeAPIKey: string;
                trackerCode: string;
                uploadsById: Record<string, Upload>;
                versionInformation: {
                    [key: string]: string | {
                        releaseDate: string;
                        repos: Record<string, string>;
                    } | undefined;
                    backend?: string;
                    GUI?: string;
                    latestRelease?: {
                        releaseDate: string;
                        repos: Record<string, string>;
                    };
                };
                yesterday?: string;
            };
            devices: DeviceSliceType;
            deployments: {
                byId: Record<string, Deployment>;
                byStatus: DeploymentByStatus;
                config: DeploymentConfig;
                deploymentDeviceLimit: number;
                selectedDeviceIds: string[];
                selectionState: SelectionState;
            };
            monitor: {
                alerts: {
                    alertList: {
                        page: number;
                        perPage: number;
                        total: number;
                    };
                    byDeviceId: {
                        alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                            fullName?: string;
                        }>;
                        latest?: Record<string, _northern_tech_types_Alert.Alert & {
                            fullName?: string;
                        }>;
                    };
                };
                issueCounts: {
                    byType: {
                        issues: {
                            filtered: number;
                            total: number;
                        };
                        offline: {
                            filtered: number;
                            total: number;
                        };
                        failedLastUpdate: {
                            filtered: number;
                            total: number;
                        };
                        monitoring: {
                            filtered: number;
                            total: number;
                        };
                        authRequests: {
                            filtered: number;
                            total: number;
                        };
                        gatewayDevices: {
                            filtered: number;
                            total: number;
                        };
                    };
                };
                settings: {
                    global: {
                        channels: {
                            email: {
                                enabled: boolean;
                            };
                        };
                    };
                };
            };
            onboarding: {
                address?: string;
                approach: OnboardingApproach | null;
                complete: boolean;
                demoArtifactPort: number;
                deviceConnection?: string;
                deviceType: string[] | string | null;
                progress: string | null;
                showTips: boolean | null;
                showTipsDialog: boolean;
            };
            organization: OrganizationState;
            releases: ReleaseSliceType;
            users: {
                activationCode?: string;
                byId: Record<string, User>;
                currentSession?: UserSession | object;
                currentUser: string | null;
                customColumns: CustomColumn[];
                globalSettings: GlobalSettings;
                permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
                qrCode: string | null;
                rolesById: Record<string, _northern_tech_utils_constants.Role>;
                rolesInitialized: boolean;
                settingsInitialized: boolean;
                showConnectDeviceDialog: boolean;
                showFeedbackDialog: boolean;
                showStartupNotification: boolean;
                tooltips: {
                    byId: Record<string, {
                        readState: ReadState;
                    }>;
                };
                userSettings: UserSettings;
                userSettingsInitialized: boolean;
            };
        }) => User) & {
            clearCache: () => void;
            resultsCount: () => number;
            resetResultsCount: () => void;
        } & {
            resultFunc: (resultFuncArgs_0: Record<string, User>, resultFuncArgs_1: string | null) => User;
            memoizedResultFunc: ((resultFuncArgs_0: Record<string, User>, resultFuncArgs_1: string | null) => User) & {
                clearCache: () => void;
                resultsCount: () => number;
                resetResultsCount: () => void;
            };
            lastResult: () => User;
            dependencies: [(state: RootState) => Record<string, User>, (state: RootState) => string | null];
            recomputations: () => number;
            resetRecomputations: () => void;
            dependencyRecomputations: () => number;
            resetDependencyRecomputations: () => void;
        } & {
            memoize: typeof reselect.weakMapMemoize;
            argsMemoize: typeof reselect.weakMapMemoize;
        }, (state: RootState) => Record<string, _northern_tech_utils_constants.Role>, ((state: {
            app: {
                cancelSource: any;
                commit: string;
                demoArtifactLink: string;
                docsVersion: string;
                features: Record<string, boolean>;
                feedbackProbability: number;
                firstLoginAfterSignup: boolean;
                hostAddress: string | null;
                hostedAnnouncement: string;
                newThreshold: string;
                offlineThreshold: string;
                recaptchaSiteKey: string;
                searchState: SearchState;
                sentry: SentryConfig;
                snackbar: SnackbarContent;
                stripeAPIKey: string;
                trackerCode: string;
                uploadsById: Record<string, Upload>;
                versionInformation: {
                    [key: string]: string | {
                        releaseDate: string;
                        repos: Record<string, string>;
                    } | undefined;
                    backend?: string;
                    GUI?: string;
                    latestRelease?: {
                        releaseDate: string;
                        repos: Record<string, string>;
                    };
                };
                yesterday?: string;
            };
            devices: DeviceSliceType;
            deployments: {
                byId: Record<string, Deployment>;
                byStatus: DeploymentByStatus;
                config: DeploymentConfig;
                deploymentDeviceLimit: number;
                selectedDeviceIds: string[];
                selectionState: SelectionState;
            };
            monitor: {
                alerts: {
                    alertList: {
                        page: number;
                        perPage: number;
                        total: number;
                    };
                    byDeviceId: {
                        alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                            fullName?: string;
                        }>;
                        latest?: Record<string, _northern_tech_types_Alert.Alert & {
                            fullName?: string;
                        }>;
                    };
                };
                issueCounts: {
                    byType: {
                        issues: {
                            filtered: number;
                            total: number;
                        };
                        offline: {
                            filtered: number;
                            total: number;
                        };
                        failedLastUpdate: {
                            filtered: number;
                            total: number;
                        };
                        monitoring: {
                            filtered: number;
                            total: number;
                        };
                        authRequests: {
                            filtered: number;
                            total: number;
                        };
                        gatewayDevices: {
                            filtered: number;
                            total: number;
                        };
                    };
                };
                settings: {
                    global: {
                        channels: {
                            email: {
                                enabled: boolean;
                            };
                        };
                    };
                };
            };
            onboarding: {
                address?: string;
                approach: OnboardingApproach | null;
                complete: boolean;
                demoArtifactPort: number;
                deviceConnection?: string;
                deviceType: string[] | string | null;
                progress: string | null;
                showTips: boolean | null;
                showTipsDialog: boolean;
            };
            organization: OrganizationState;
            releases: ReleaseSliceType;
            users: {
                activationCode?: string;
                byId: Record<string, User>;
                currentSession?: UserSession | object;
                currentUser: string | null;
                customColumns: CustomColumn[];
                globalSettings: GlobalSettings;
                permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
                qrCode: string | null;
                rolesById: Record<string, _northern_tech_utils_constants.Role>;
                rolesInitialized: boolean;
                settingsInitialized: boolean;
                showConnectDeviceDialog: boolean;
                showFeedbackDialog: boolean;
                showStartupNotification: boolean;
                tooltips: {
                    byId: Record<string, {
                        readState: ReadState;
                    }>;
                };
                userSettings: UserSettings;
                userSettingsInitialized: boolean;
            };
        }) => boolean) & {
            clearCache: () => void;
            resultsCount: () => number;
            resetResultsCount: () => void;
        } & {
            resultFunc: (resultFuncArgs_0: Partial<Organization>, resultFuncArgs_1: Record<string, boolean>) => boolean;
            memoizedResultFunc: ((resultFuncArgs_0: Partial<Organization>, resultFuncArgs_1: Record<string, boolean>) => boolean) & {
                clearCache: () => void;
                resultsCount: () => number;
                resetResultsCount: () => void;
            };
            lastResult: () => boolean;
            dependencies: [(state: RootState) => Partial<Organization>, (state: RootState) => Record<string, boolean>];
            recomputations: () => number;
            resetRecomputations: () => void;
            dependencyRecomputations: () => number;
            resetDependencyRecomputations: () => void;
        } & {
            memoize: typeof reselect.weakMapMemoize;
            argsMemoize: typeof reselect.weakMapMemoize;
        }];
        recomputations: () => number;
        resetRecomputations: () => void;
        dependencyRecomputations: () => number;
        resetDependencyRecomputations: () => void;
    } & {
        memoize: typeof reselect.weakMapMemoize;
        argsMemoize: typeof reselect.weakMapMemoize;
    }, (state: RootState) => boolean | undefined];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getTenantCapabilities: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => {
    canDelta: boolean;
    canRetry: boolean;
    canSchedule: boolean;
    hasAuditlogs: boolean;
    hasDeviceConfig: boolean;
    hasDeviceConnect: boolean;
    hasFullFiltering: boolean;
    hasMonitor: boolean;
    isEnterprise: boolean;
    plan: "os" | "professional" | "enterprise";
}) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: Record<string, boolean>, resultFuncArgs_1: Partial<Organization>, resultFuncArgs_2: boolean) => {
        canDelta: boolean;
        canRetry: boolean;
        canSchedule: boolean;
        hasAuditlogs: boolean;
        hasDeviceConfig: boolean;
        hasDeviceConnect: boolean;
        hasFullFiltering: boolean;
        hasMonitor: boolean;
        isEnterprise: boolean;
        plan: "os" | "professional" | "enterprise";
    };
    memoizedResultFunc: ((resultFuncArgs_0: Record<string, boolean>, resultFuncArgs_1: Partial<Organization>, resultFuncArgs_2: boolean) => {
        canDelta: boolean;
        canRetry: boolean;
        canSchedule: boolean;
        hasAuditlogs: boolean;
        hasDeviceConfig: boolean;
        hasDeviceConnect: boolean;
        hasFullFiltering: boolean;
        hasMonitor: boolean;
        isEnterprise: boolean;
        plan: "os" | "professional" | "enterprise";
    }) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => {
        canDelta: boolean;
        canRetry: boolean;
        canSchedule: boolean;
        hasAuditlogs: boolean;
        hasDeviceConfig: boolean;
        hasDeviceConnect: boolean;
        hasFullFiltering: boolean;
        hasMonitor: boolean;
        isEnterprise: boolean;
        plan: "os" | "professional" | "enterprise";
    };
    dependencies: [(state: RootState) => Record<string, boolean>, (state: RootState) => Partial<Organization>, ((state: {
        app: {
            cancelSource: any;
            commit: string;
            demoArtifactLink: string;
            docsVersion: string;
            features: Record<string, boolean>;
            feedbackProbability: number;
            firstLoginAfterSignup: boolean;
            hostAddress: string | null;
            hostedAnnouncement: string;
            newThreshold: string;
            offlineThreshold: string;
            recaptchaSiteKey: string;
            searchState: SearchState;
            sentry: SentryConfig;
            snackbar: SnackbarContent;
            stripeAPIKey: string;
            trackerCode: string;
            uploadsById: Record<string, Upload>;
            versionInformation: {
                [key: string]: string | {
                    releaseDate: string;
                    repos: Record<string, string>;
                } | undefined;
                backend?: string;
                GUI?: string;
                latestRelease?: {
                    releaseDate: string;
                    repos: Record<string, string>;
                };
            };
            yesterday?: string;
        };
        devices: DeviceSliceType;
        deployments: {
            byId: Record<string, Deployment>;
            byStatus: DeploymentByStatus;
            config: DeploymentConfig;
            deploymentDeviceLimit: number;
            selectedDeviceIds: string[];
            selectionState: SelectionState;
        };
        monitor: {
            alerts: {
                alertList: {
                    page: number;
                    perPage: number;
                    total: number;
                };
                byDeviceId: {
                    alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                    latest?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                };
            };
            issueCounts: {
                byType: {
                    issues: {
                        filtered: number;
                        total: number;
                    };
                    offline: {
                        filtered: number;
                        total: number;
                    };
                    failedLastUpdate: {
                        filtered: number;
                        total: number;
                    };
                    monitoring: {
                        filtered: number;
                        total: number;
                    };
                    authRequests: {
                        filtered: number;
                        total: number;
                    };
                    gatewayDevices: {
                        filtered: number;
                        total: number;
                    };
                };
            };
            settings: {
                global: {
                    channels: {
                        email: {
                            enabled: boolean;
                        };
                    };
                };
            };
        };
        onboarding: {
            address?: string;
            approach: OnboardingApproach | null;
            complete: boolean;
            demoArtifactPort: number;
            deviceConnection?: string;
            deviceType: string[] | string | null;
            progress: string | null;
            showTips: boolean | null;
            showTipsDialog: boolean;
        };
        organization: OrganizationState;
        releases: ReleaseSliceType;
        users: {
            activationCode?: string;
            byId: Record<string, User>;
            currentSession?: UserSession | object;
            currentUser: string | null;
            customColumns: CustomColumn[];
            globalSettings: GlobalSettings;
            permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
            qrCode: string | null;
            rolesById: Record<string, _northern_tech_utils_constants.Role>;
            rolesInitialized: boolean;
            settingsInitialized: boolean;
            showConnectDeviceDialog: boolean;
            showFeedbackDialog: boolean;
            showStartupNotification: boolean;
            tooltips: {
                byId: Record<string, {
                    readState: ReadState;
                }>;
            };
            userSettings: UserSettings;
            userSettingsInitialized: boolean;
        };
    }) => boolean) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    } & {
        resultFunc: (resultFuncArgs_0: Partial<Organization>, resultFuncArgs_1: Record<string, boolean>) => boolean;
        memoizedResultFunc: ((resultFuncArgs_0: Partial<Organization>, resultFuncArgs_1: Record<string, boolean>) => boolean) & {
            clearCache: () => void;
            resultsCount: () => number;
            resetResultsCount: () => void;
        };
        lastResult: () => boolean;
        dependencies: [(state: RootState) => Partial<Organization>, (state: RootState) => Record<string, boolean>];
        recomputations: () => number;
        resetRecomputations: () => void;
        dependencyRecomputations: () => number;
        resetDependencyRecomputations: () => void;
    } & {
        memoize: typeof reselect.weakMapMemoize;
        argsMemoize: typeof reselect.weakMapMemoize;
    }];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getFilterAttributes: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => any) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: GlobalSettings, resultFuncArgs_1: {
        identityAttributes: string[];
        inventoryAttributes: string[];
        systemAttributes: string[];
        tagAttributes: string[];
    }) => any;
    memoizedResultFunc: ((resultFuncArgs_0: GlobalSettings, resultFuncArgs_1: {
        identityAttributes: string[];
        inventoryAttributes: string[];
        systemAttributes: string[];
        tagAttributes: string[];
    }) => any) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => any;
    dependencies: [(state: RootState) => GlobalSettings, (state: RootState) => {
        identityAttributes: string[];
        inventoryAttributes: string[];
        systemAttributes: string[];
        tagAttributes: string[];
    }];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getOnboardingState: ((state: any) => any) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: any, resultFuncArgs_1: UserSettings) => any;
    memoizedResultFunc: ((resultFuncArgs_0: any, resultFuncArgs_1: UserSettings) => any) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => any;
    dependencies: [(state: any) => any, (state: RootState) => UserSettings];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getDemoDeviceAddress: ((state: any) => string) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: Record<string, Device>, resultFuncArgs_1: any) => string;
    memoizedResultFunc: ((resultFuncArgs_0: Record<string, Device>, resultFuncArgs_1: any) => string) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => string;
    dependencies: [(state: RootState) => Record<string, Device>, (state: any) => any];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getDeviceConfigDeployment: ((state: any, deviceId: any) => {
    device: Device;
    deviceConfigDeployment: any;
}) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: Device, resultFuncArgs_1: Record<string, Deployment>) => {
        device: Device;
        deviceConfigDeployment: any;
    };
    memoizedResultFunc: ((resultFuncArgs_0: Device, resultFuncArgs_1: Record<string, Deployment>) => {
        device: Device;
        deviceConfigDeployment: any;
    }) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => {
        device: Device;
        deviceConfigDeployment: any;
    };
    dependencies: [((state: any, deviceId: any) => Device) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    } & {
        resultFunc: (resultFuncArgs_0: Record<string, Device>, resultFuncArgs_1: any) => Device;
        memoizedResultFunc: ((resultFuncArgs_0: Record<string, Device>, resultFuncArgs_1: any) => Device) & {
            clearCache: () => void;
            resultsCount: () => number;
            resetResultsCount: () => void;
        };
        lastResult: () => Device;
        dependencies: [(state: RootState) => Record<string, Device>, (_: any, deviceId: any) => any];
        recomputations: () => number;
        resetRecomputations: () => void;
        dependencyRecomputations: () => number;
        resetDependencyRecomputations: () => void;
    } & {
        memoize: typeof reselect.weakMapMemoize;
        argsMemoize: typeof reselect.weakMapMemoize;
    }, (state: RootState) => Record<string, Deployment>];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getDeploymentRelease: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => Release | {
    device_types_compatible: never[];
}) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: Record<string, Deployment>, resultFuncArgs_1: SelectionState, resultFuncArgs_2: Record<string, Release>) => Release | {
        device_types_compatible: never[];
    };
    memoizedResultFunc: ((resultFuncArgs_0: Record<string, Deployment>, resultFuncArgs_1: SelectionState, resultFuncArgs_2: Record<string, Release>) => Release | {
        device_types_compatible: never[];
    }) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => Release | {
        device_types_compatible: never[];
    };
    dependencies: [(state: RootState) => Record<string, Deployment>, (state: RootState) => SelectionState, (state: RootState) => Record<string, Release>];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getSelectedDeploymentData: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => {
    deployment: any;
    selectedDevices: any[];
}) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: Record<string, Deployment>, resultFuncArgs_1: SelectionState, resultFuncArgs_2: Record<string, Device>, resultFuncArgs_3: string[]) => {
        deployment: any;
        selectedDevices: any[];
    };
    memoizedResultFunc: ((resultFuncArgs_0: Record<string, Deployment>, resultFuncArgs_1: SelectionState, resultFuncArgs_2: Record<string, Device>, resultFuncArgs_3: string[]) => {
        deployment: any;
        selectedDevices: any[];
    }) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => {
        deployment: any;
        selectedDevices: any[];
    };
    dependencies: [(state: RootState) => Record<string, Deployment>, (state: RootState) => SelectionState, (state: RootState) => Record<string, Device>, (state: RootState) => string[]];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getAvailableIssueOptionsByType: ((state: any) => {}) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: Record<string, boolean>, resultFuncArgs_1: {
        canDelta: boolean;
        canRetry: boolean;
        canSchedule: boolean;
        hasAuditlogs: boolean;
        hasDeviceConfig: boolean;
        hasDeviceConnect: boolean;
        hasFullFiltering: boolean;
        hasMonitor: boolean;
        isEnterprise: boolean;
        plan: "os" | "professional" | "enterprise";
    }, resultFuncArgs_2: any) => {};
    memoizedResultFunc: ((resultFuncArgs_0: Record<string, boolean>, resultFuncArgs_1: {
        canDelta: boolean;
        canRetry: boolean;
        canSchedule: boolean;
        hasAuditlogs: boolean;
        hasDeviceConfig: boolean;
        hasDeviceConnect: boolean;
        hasFullFiltering: boolean;
        hasMonitor: boolean;
        isEnterprise: boolean;
        plan: "os" | "professional" | "enterprise";
    }, resultFuncArgs_2: any) => {}) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => {};
    dependencies: [(state: RootState) => Record<string, boolean>, ((state: {
        app: {
            cancelSource: any;
            commit: string;
            demoArtifactLink: string;
            docsVersion: string;
            features: Record<string, boolean>;
            feedbackProbability: number;
            firstLoginAfterSignup: boolean;
            hostAddress: string | null;
            hostedAnnouncement: string;
            newThreshold: string;
            offlineThreshold: string;
            recaptchaSiteKey: string;
            searchState: SearchState;
            sentry: SentryConfig;
            snackbar: SnackbarContent;
            stripeAPIKey: string;
            trackerCode: string;
            uploadsById: Record<string, Upload>;
            versionInformation: {
                [key: string]: string | {
                    releaseDate: string;
                    repos: Record<string, string>;
                } | undefined;
                backend?: string;
                GUI?: string;
                latestRelease?: {
                    releaseDate: string;
                    repos: Record<string, string>;
                };
            };
            yesterday?: string;
        };
        devices: DeviceSliceType;
        deployments: {
            byId: Record<string, Deployment>;
            byStatus: DeploymentByStatus;
            config: DeploymentConfig;
            deploymentDeviceLimit: number;
            selectedDeviceIds: string[];
            selectionState: SelectionState;
        };
        monitor: {
            alerts: {
                alertList: {
                    page: number;
                    perPage: number;
                    total: number;
                };
                byDeviceId: {
                    alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                    latest?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                };
            };
            issueCounts: {
                byType: {
                    issues: {
                        filtered: number;
                        total: number;
                    };
                    offline: {
                        filtered: number;
                        total: number;
                    };
                    failedLastUpdate: {
                        filtered: number;
                        total: number;
                    };
                    monitoring: {
                        filtered: number;
                        total: number;
                    };
                    authRequests: {
                        filtered: number;
                        total: number;
                    };
                    gatewayDevices: {
                        filtered: number;
                        total: number;
                    };
                };
            };
            settings: {
                global: {
                    channels: {
                        email: {
                            enabled: boolean;
                        };
                    };
                };
            };
        };
        onboarding: {
            address?: string;
            approach: OnboardingApproach | null;
            complete: boolean;
            demoArtifactPort: number;
            deviceConnection?: string;
            deviceType: string[] | string | null;
            progress: string | null;
            showTips: boolean | null;
            showTipsDialog: boolean;
        };
        organization: OrganizationState;
        releases: ReleaseSliceType;
        users: {
            activationCode?: string;
            byId: Record<string, User>;
            currentSession?: UserSession | object;
            currentUser: string | null;
            customColumns: CustomColumn[];
            globalSettings: GlobalSettings;
            permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
            qrCode: string | null;
            rolesById: Record<string, _northern_tech_utils_constants.Role>;
            rolesInitialized: boolean;
            settingsInitialized: boolean;
            showConnectDeviceDialog: boolean;
            showFeedbackDialog: boolean;
            showStartupNotification: boolean;
            tooltips: {
                byId: Record<string, {
                    readState: ReadState;
                }>;
            };
            userSettings: UserSettings;
            userSettingsInitialized: boolean;
        };
    }) => {
        canDelta: boolean;
        canRetry: boolean;
        canSchedule: boolean;
        hasAuditlogs: boolean;
        hasDeviceConfig: boolean;
        hasDeviceConnect: boolean;
        hasFullFiltering: boolean;
        hasMonitor: boolean;
        isEnterprise: boolean;
        plan: "os" | "professional" | "enterprise";
    }) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    } & {
        resultFunc: (resultFuncArgs_0: Record<string, boolean>, resultFuncArgs_1: Partial<Organization>, resultFuncArgs_2: boolean) => {
            canDelta: boolean;
            canRetry: boolean;
            canSchedule: boolean;
            hasAuditlogs: boolean;
            hasDeviceConfig: boolean;
            hasDeviceConnect: boolean;
            hasFullFiltering: boolean;
            hasMonitor: boolean;
            isEnterprise: boolean;
            plan: "os" | "professional" | "enterprise";
        };
        memoizedResultFunc: ((resultFuncArgs_0: Record<string, boolean>, resultFuncArgs_1: Partial<Organization>, resultFuncArgs_2: boolean) => {
            canDelta: boolean;
            canRetry: boolean;
            canSchedule: boolean;
            hasAuditlogs: boolean;
            hasDeviceConfig: boolean;
            hasDeviceConnect: boolean;
            hasFullFiltering: boolean;
            hasMonitor: boolean;
            isEnterprise: boolean;
            plan: "os" | "professional" | "enterprise";
        }) & {
            clearCache: () => void;
            resultsCount: () => number;
            resetResultsCount: () => void;
        };
        lastResult: () => {
            canDelta: boolean;
            canRetry: boolean;
            canSchedule: boolean;
            hasAuditlogs: boolean;
            hasDeviceConfig: boolean;
            hasDeviceConnect: boolean;
            hasFullFiltering: boolean;
            hasMonitor: boolean;
            isEnterprise: boolean;
            plan: "os" | "professional" | "enterprise";
        };
        dependencies: [(state: RootState) => Record<string, boolean>, (state: RootState) => Partial<Organization>, ((state: {
            app: {
                cancelSource: any;
                commit: string;
                demoArtifactLink: string;
                docsVersion: string;
                features: Record<string, boolean>;
                feedbackProbability: number;
                firstLoginAfterSignup: boolean;
                hostAddress: string | null;
                hostedAnnouncement: string;
                newThreshold: string;
                offlineThreshold: string;
                recaptchaSiteKey: string;
                searchState: SearchState;
                sentry: SentryConfig;
                snackbar: SnackbarContent;
                stripeAPIKey: string;
                trackerCode: string;
                uploadsById: Record<string, Upload>;
                versionInformation: {
                    [key: string]: string | {
                        releaseDate: string;
                        repos: Record<string, string>;
                    } | undefined;
                    backend?: string;
                    GUI?: string;
                    latestRelease?: {
                        releaseDate: string;
                        repos: Record<string, string>;
                    };
                };
                yesterday?: string;
            };
            devices: DeviceSliceType;
            deployments: {
                byId: Record<string, Deployment>;
                byStatus: DeploymentByStatus;
                config: DeploymentConfig;
                deploymentDeviceLimit: number;
                selectedDeviceIds: string[];
                selectionState: SelectionState;
            };
            monitor: {
                alerts: {
                    alertList: {
                        page: number;
                        perPage: number;
                        total: number;
                    };
                    byDeviceId: {
                        alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                            fullName?: string;
                        }>;
                        latest?: Record<string, _northern_tech_types_Alert.Alert & {
                            fullName?: string;
                        }>;
                    };
                };
                issueCounts: {
                    byType: {
                        issues: {
                            filtered: number;
                            total: number;
                        };
                        offline: {
                            filtered: number;
                            total: number;
                        };
                        failedLastUpdate: {
                            filtered: number;
                            total: number;
                        };
                        monitoring: {
                            filtered: number;
                            total: number;
                        };
                        authRequests: {
                            filtered: number;
                            total: number;
                        };
                        gatewayDevices: {
                            filtered: number;
                            total: number;
                        };
                    };
                };
                settings: {
                    global: {
                        channels: {
                            email: {
                                enabled: boolean;
                            };
                        };
                    };
                };
            };
            onboarding: {
                address?: string;
                approach: OnboardingApproach | null;
                complete: boolean;
                demoArtifactPort: number;
                deviceConnection?: string;
                deviceType: string[] | string | null;
                progress: string | null;
                showTips: boolean | null;
                showTipsDialog: boolean;
            };
            organization: OrganizationState;
            releases: ReleaseSliceType;
            users: {
                activationCode?: string;
                byId: Record<string, User>;
                currentSession?: UserSession | object;
                currentUser: string | null;
                customColumns: CustomColumn[];
                globalSettings: GlobalSettings;
                permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
                qrCode: string | null;
                rolesById: Record<string, _northern_tech_utils_constants.Role>;
                rolesInitialized: boolean;
                settingsInitialized: boolean;
                showConnectDeviceDialog: boolean;
                showFeedbackDialog: boolean;
                showStartupNotification: boolean;
                tooltips: {
                    byId: Record<string, {
                        readState: ReadState;
                    }>;
                };
                userSettings: UserSettings;
                userSettingsInitialized: boolean;
            };
        }) => boolean) & {
            clearCache: () => void;
            resultsCount: () => number;
            resetResultsCount: () => void;
        } & {
            resultFunc: (resultFuncArgs_0: Partial<Organization>, resultFuncArgs_1: Record<string, boolean>) => boolean;
            memoizedResultFunc: ((resultFuncArgs_0: Partial<Organization>, resultFuncArgs_1: Record<string, boolean>) => boolean) & {
                clearCache: () => void;
                resultsCount: () => number;
                resetResultsCount: () => void;
            };
            lastResult: () => boolean;
            dependencies: [(state: RootState) => Partial<Organization>, (state: RootState) => Record<string, boolean>];
            recomputations: () => number;
            resetRecomputations: () => void;
            dependencyRecomputations: () => number;
            resetDependencyRecomputations: () => void;
        } & {
            memoize: typeof reselect.weakMapMemoize;
            argsMemoize: typeof reselect.weakMapMemoize;
        }];
        recomputations: () => number;
        resetRecomputations: () => void;
        dependencyRecomputations: () => number;
        resetDependencyRecomputations: () => void;
    } & {
        memoize: typeof reselect.weakMapMemoize;
        argsMemoize: typeof reselect.weakMapMemoize;
    }, (state: any) => any];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getGroupNames: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => string[]) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: Record<string, DeviceGroup>, resultFuncArgs_1: {
        isAdmin: boolean;
        uiPermissions: any;
    }) => string[];
    memoizedResultFunc: ((resultFuncArgs_0: Record<string, DeviceGroup>, resultFuncArgs_1: {
        isAdmin: boolean;
        uiPermissions: any;
    }) => string[]) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => string[];
    dependencies: [(state: RootState) => Record<string, DeviceGroup>, ((state: {
        app: {
            cancelSource: any;
            commit: string;
            demoArtifactLink: string;
            docsVersion: string;
            features: Record<string, boolean>;
            feedbackProbability: number;
            firstLoginAfterSignup: boolean;
            hostAddress: string | null;
            hostedAnnouncement: string;
            newThreshold: string;
            offlineThreshold: string;
            recaptchaSiteKey: string;
            searchState: SearchState;
            sentry: SentryConfig;
            snackbar: SnackbarContent;
            stripeAPIKey: string;
            trackerCode: string;
            uploadsById: Record<string, Upload>;
            versionInformation: {
                [key: string]: string | {
                    releaseDate: string;
                    repos: Record<string, string>;
                } | undefined;
                backend?: string;
                GUI?: string;
                latestRelease?: {
                    releaseDate: string;
                    repos: Record<string, string>;
                };
            };
            yesterday?: string;
        };
        devices: DeviceSliceType;
        deployments: {
            byId: Record<string, Deployment>;
            byStatus: DeploymentByStatus;
            config: DeploymentConfig;
            deploymentDeviceLimit: number;
            selectedDeviceIds: string[];
            selectionState: SelectionState;
        };
        monitor: {
            alerts: {
                alertList: {
                    page: number;
                    perPage: number;
                    total: number;
                };
                byDeviceId: {
                    alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                    latest?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                };
            };
            issueCounts: {
                byType: {
                    issues: {
                        filtered: number;
                        total: number;
                    };
                    offline: {
                        filtered: number;
                        total: number;
                    };
                    failedLastUpdate: {
                        filtered: number;
                        total: number;
                    };
                    monitoring: {
                        filtered: number;
                        total: number;
                    };
                    authRequests: {
                        filtered: number;
                        total: number;
                    };
                    gatewayDevices: {
                        filtered: number;
                        total: number;
                    };
                };
            };
            settings: {
                global: {
                    channels: {
                        email: {
                            enabled: boolean;
                        };
                    };
                };
            };
        };
        onboarding: {
            address?: string;
            approach: OnboardingApproach | null;
            complete: boolean;
            demoArtifactPort: number;
            deviceConnection?: string;
            deviceType: string[] | string | null;
            progress: string | null;
            showTips: boolean | null;
            showTipsDialog: boolean;
        };
        organization: OrganizationState;
        releases: ReleaseSliceType;
        users: {
            activationCode?: string;
            byId: Record<string, User>;
            currentSession?: UserSession | object;
            currentUser: string | null;
            customColumns: CustomColumn[];
            globalSettings: GlobalSettings;
            permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
            qrCode: string | null;
            rolesById: Record<string, _northern_tech_utils_constants.Role>;
            rolesInitialized: boolean;
            settingsInitialized: boolean;
            showConnectDeviceDialog: boolean;
            showFeedbackDialog: boolean;
            showStartupNotification: boolean;
            tooltips: {
                byId: Record<string, {
                    readState: ReadState;
                }>;
            };
            userSettings: UserSettings;
            userSettingsInitialized: boolean;
        };
    }) => {
        isAdmin: boolean;
        uiPermissions: any;
    }) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    } & {
        resultFunc: (resultFuncArgs_0: User, resultFuncArgs_1: Record<string, _northern_tech_utils_constants.Role>, resultFuncArgs_2: boolean) => {
            isAdmin: boolean;
            uiPermissions: any;
        };
        memoizedResultFunc: ((resultFuncArgs_0: User, resultFuncArgs_1: Record<string, _northern_tech_utils_constants.Role>, resultFuncArgs_2: boolean) => {
            isAdmin: boolean;
            uiPermissions: any;
        }) & {
            clearCache: () => void;
            resultsCount: () => number;
            resetResultsCount: () => void;
        };
        lastResult: () => {
            isAdmin: boolean;
            uiPermissions: any;
        };
        dependencies: [((state: {
            app: {
                cancelSource: any;
                commit: string;
                demoArtifactLink: string;
                docsVersion: string;
                features: Record<string, boolean>;
                feedbackProbability: number;
                firstLoginAfterSignup: boolean;
                hostAddress: string | null;
                hostedAnnouncement: string;
                newThreshold: string;
                offlineThreshold: string;
                recaptchaSiteKey: string;
                searchState: SearchState;
                sentry: SentryConfig;
                snackbar: SnackbarContent;
                stripeAPIKey: string;
                trackerCode: string;
                uploadsById: Record<string, Upload>;
                versionInformation: {
                    [key: string]: string | {
                        releaseDate: string;
                        repos: Record<string, string>;
                    } | undefined;
                    backend?: string;
                    GUI?: string;
                    latestRelease?: {
                        releaseDate: string;
                        repos: Record<string, string>;
                    };
                };
                yesterday?: string;
            };
            devices: DeviceSliceType;
            deployments: {
                byId: Record<string, Deployment>;
                byStatus: DeploymentByStatus;
                config: DeploymentConfig;
                deploymentDeviceLimit: number;
                selectedDeviceIds: string[];
                selectionState: SelectionState;
            };
            monitor: {
                alerts: {
                    alertList: {
                        page: number;
                        perPage: number;
                        total: number;
                    };
                    byDeviceId: {
                        alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                            fullName?: string;
                        }>;
                        latest?: Record<string, _northern_tech_types_Alert.Alert & {
                            fullName?: string;
                        }>;
                    };
                };
                issueCounts: {
                    byType: {
                        issues: {
                            filtered: number;
                            total: number;
                        };
                        offline: {
                            filtered: number;
                            total: number;
                        };
                        failedLastUpdate: {
                            filtered: number;
                            total: number;
                        };
                        monitoring: {
                            filtered: number;
                            total: number;
                        };
                        authRequests: {
                            filtered: number;
                            total: number;
                        };
                        gatewayDevices: {
                            filtered: number;
                            total: number;
                        };
                    };
                };
                settings: {
                    global: {
                        channels: {
                            email: {
                                enabled: boolean;
                            };
                        };
                    };
                };
            };
            onboarding: {
                address?: string;
                approach: OnboardingApproach | null;
                complete: boolean;
                demoArtifactPort: number;
                deviceConnection?: string;
                deviceType: string[] | string | null;
                progress: string | null;
                showTips: boolean | null;
                showTipsDialog: boolean;
            };
            organization: OrganizationState;
            releases: ReleaseSliceType;
            users: {
                activationCode?: string;
                byId: Record<string, User>;
                currentSession?: UserSession | object;
                currentUser: string | null;
                customColumns: CustomColumn[];
                globalSettings: GlobalSettings;
                permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
                qrCode: string | null;
                rolesById: Record<string, _northern_tech_utils_constants.Role>;
                rolesInitialized: boolean;
                settingsInitialized: boolean;
                showConnectDeviceDialog: boolean;
                showFeedbackDialog: boolean;
                showStartupNotification: boolean;
                tooltips: {
                    byId: Record<string, {
                        readState: ReadState;
                    }>;
                };
                userSettings: UserSettings;
                userSettingsInitialized: boolean;
            };
        }) => User) & {
            clearCache: () => void;
            resultsCount: () => number;
            resetResultsCount: () => void;
        } & {
            resultFunc: (resultFuncArgs_0: Record<string, User>, resultFuncArgs_1: string | null) => User;
            memoizedResultFunc: ((resultFuncArgs_0: Record<string, User>, resultFuncArgs_1: string | null) => User) & {
                clearCache: () => void;
                resultsCount: () => number;
                resetResultsCount: () => void;
            };
            lastResult: () => User;
            dependencies: [(state: RootState) => Record<string, User>, (state: RootState) => string | null];
            recomputations: () => number;
            resetRecomputations: () => void;
            dependencyRecomputations: () => number;
            resetDependencyRecomputations: () => void;
        } & {
            memoize: typeof reselect.weakMapMemoize;
            argsMemoize: typeof reselect.weakMapMemoize;
        }, (state: RootState) => Record<string, _northern_tech_utils_constants.Role>, ((state: {
            app: {
                cancelSource: any;
                commit: string;
                demoArtifactLink: string;
                docsVersion: string;
                features: Record<string, boolean>;
                feedbackProbability: number;
                firstLoginAfterSignup: boolean;
                hostAddress: string | null;
                hostedAnnouncement: string;
                newThreshold: string;
                offlineThreshold: string;
                recaptchaSiteKey: string;
                searchState: SearchState;
                sentry: SentryConfig;
                snackbar: SnackbarContent;
                stripeAPIKey: string;
                trackerCode: string;
                uploadsById: Record<string, Upload>;
                versionInformation: {
                    [key: string]: string | {
                        releaseDate: string;
                        repos: Record<string, string>;
                    } | undefined;
                    backend?: string;
                    GUI?: string;
                    latestRelease?: {
                        releaseDate: string;
                        repos: Record<string, string>;
                    };
                };
                yesterday?: string;
            };
            devices: DeviceSliceType;
            deployments: {
                byId: Record<string, Deployment>;
                byStatus: DeploymentByStatus;
                config: DeploymentConfig;
                deploymentDeviceLimit: number;
                selectedDeviceIds: string[];
                selectionState: SelectionState;
            };
            monitor: {
                alerts: {
                    alertList: {
                        page: number;
                        perPage: number;
                        total: number;
                    };
                    byDeviceId: {
                        alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                            fullName?: string;
                        }>;
                        latest?: Record<string, _northern_tech_types_Alert.Alert & {
                            fullName?: string;
                        }>;
                    };
                };
                issueCounts: {
                    byType: {
                        issues: {
                            filtered: number;
                            total: number;
                        };
                        offline: {
                            filtered: number;
                            total: number;
                        };
                        failedLastUpdate: {
                            filtered: number;
                            total: number;
                        };
                        monitoring: {
                            filtered: number;
                            total: number;
                        };
                        authRequests: {
                            filtered: number;
                            total: number;
                        };
                        gatewayDevices: {
                            filtered: number;
                            total: number;
                        };
                    };
                };
                settings: {
                    global: {
                        channels: {
                            email: {
                                enabled: boolean;
                            };
                        };
                    };
                };
            };
            onboarding: {
                address?: string;
                approach: OnboardingApproach | null;
                complete: boolean;
                demoArtifactPort: number;
                deviceConnection?: string;
                deviceType: string[] | string | null;
                progress: string | null;
                showTips: boolean | null;
                showTipsDialog: boolean;
            };
            organization: OrganizationState;
            releases: ReleaseSliceType;
            users: {
                activationCode?: string;
                byId: Record<string, User>;
                currentSession?: UserSession | object;
                currentUser: string | null;
                customColumns: CustomColumn[];
                globalSettings: GlobalSettings;
                permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
                qrCode: string | null;
                rolesById: Record<string, _northern_tech_utils_constants.Role>;
                rolesInitialized: boolean;
                settingsInitialized: boolean;
                showConnectDeviceDialog: boolean;
                showFeedbackDialog: boolean;
                showStartupNotification: boolean;
                tooltips: {
                    byId: Record<string, {
                        readState: ReadState;
                    }>;
                };
                userSettings: UserSettings;
                userSettingsInitialized: boolean;
            };
        }) => boolean) & {
            clearCache: () => void;
            resultsCount: () => number;
            resetResultsCount: () => void;
        } & {
            resultFunc: (resultFuncArgs_0: Partial<Organization>, resultFuncArgs_1: Record<string, boolean>) => boolean;
            memoizedResultFunc: ((resultFuncArgs_0: Partial<Organization>, resultFuncArgs_1: Record<string, boolean>) => boolean) & {
                clearCache: () => void;
                resultsCount: () => number;
                resetResultsCount: () => void;
            };
            lastResult: () => boolean;
            dependencies: [(state: RootState) => Partial<Organization>, (state: RootState) => Record<string, boolean>];
            recomputations: () => number;
            resetRecomputations: () => void;
            dependencyRecomputations: () => number;
            resetDependencyRecomputations: () => void;
        } & {
            memoize: typeof reselect.weakMapMemoize;
            argsMemoize: typeof reselect.weakMapMemoize;
        }];
        recomputations: () => number;
        resetRecomputations: () => void;
        dependencyRecomputations: () => number;
        resetDependencyRecomputations: () => void;
    } & {
        memoize: typeof reselect.weakMapMemoize;
        argsMemoize: typeof reselect.weakMapMemoize;
    }];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getDeviceReportsForUser: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => any) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: UserSettings, resultFuncArgs_1: User, resultFuncArgs_2: GlobalSettings, resultFuncArgs_3: Record<string, Device>) => any;
    memoizedResultFunc: ((resultFuncArgs_0: UserSettings, resultFuncArgs_1: User, resultFuncArgs_2: GlobalSettings, resultFuncArgs_3: Record<string, Device>) => any) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => any;
    dependencies: [(state: RootState) => UserSettings, ((state: {
        app: {
            cancelSource: any;
            commit: string;
            demoArtifactLink: string;
            docsVersion: string;
            features: Record<string, boolean>;
            feedbackProbability: number;
            firstLoginAfterSignup: boolean;
            hostAddress: string | null;
            hostedAnnouncement: string;
            newThreshold: string;
            offlineThreshold: string;
            recaptchaSiteKey: string;
            searchState: SearchState;
            sentry: SentryConfig;
            snackbar: SnackbarContent;
            stripeAPIKey: string;
            trackerCode: string;
            uploadsById: Record<string, Upload>;
            versionInformation: {
                [key: string]: string | {
                    releaseDate: string;
                    repos: Record<string, string>;
                } | undefined;
                backend?: string;
                GUI?: string;
                latestRelease?: {
                    releaseDate: string;
                    repos: Record<string, string>;
                };
            };
            yesterday?: string;
        };
        devices: DeviceSliceType;
        deployments: {
            byId: Record<string, Deployment>;
            byStatus: DeploymentByStatus;
            config: DeploymentConfig;
            deploymentDeviceLimit: number;
            selectedDeviceIds: string[];
            selectionState: SelectionState;
        };
        monitor: {
            alerts: {
                alertList: {
                    page: number;
                    perPage: number;
                    total: number;
                };
                byDeviceId: {
                    alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                    latest?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                };
            };
            issueCounts: {
                byType: {
                    issues: {
                        filtered: number;
                        total: number;
                    };
                    offline: {
                        filtered: number;
                        total: number;
                    };
                    failedLastUpdate: {
                        filtered: number;
                        total: number;
                    };
                    monitoring: {
                        filtered: number;
                        total: number;
                    };
                    authRequests: {
                        filtered: number;
                        total: number;
                    };
                    gatewayDevices: {
                        filtered: number;
                        total: number;
                    };
                };
            };
            settings: {
                global: {
                    channels: {
                        email: {
                            enabled: boolean;
                        };
                    };
                };
            };
        };
        onboarding: {
            address?: string;
            approach: OnboardingApproach | null;
            complete: boolean;
            demoArtifactPort: number;
            deviceConnection?: string;
            deviceType: string[] | string | null;
            progress: string | null;
            showTips: boolean | null;
            showTipsDialog: boolean;
        };
        organization: OrganizationState;
        releases: ReleaseSliceType;
        users: {
            activationCode?: string;
            byId: Record<string, User>;
            currentSession?: UserSession | object;
            currentUser: string | null;
            customColumns: CustomColumn[];
            globalSettings: GlobalSettings;
            permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
            qrCode: string | null;
            rolesById: Record<string, _northern_tech_utils_constants.Role>;
            rolesInitialized: boolean;
            settingsInitialized: boolean;
            showConnectDeviceDialog: boolean;
            showFeedbackDialog: boolean;
            showStartupNotification: boolean;
            tooltips: {
                byId: Record<string, {
                    readState: ReadState;
                }>;
            };
            userSettings: UserSettings;
            userSettingsInitialized: boolean;
        };
    }) => User) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    } & {
        resultFunc: (resultFuncArgs_0: Record<string, User>, resultFuncArgs_1: string | null) => User;
        memoizedResultFunc: ((resultFuncArgs_0: Record<string, User>, resultFuncArgs_1: string | null) => User) & {
            clearCache: () => void;
            resultsCount: () => number;
            resetResultsCount: () => void;
        };
        lastResult: () => User;
        dependencies: [(state: RootState) => Record<string, User>, (state: RootState) => string | null];
        recomputations: () => number;
        resetRecomputations: () => void;
        dependencyRecomputations: () => number;
        resetDependencyRecomputations: () => void;
    } & {
        memoize: typeof reselect.weakMapMemoize;
        argsMemoize: typeof reselect.weakMapMemoize;
    }, (state: RootState) => GlobalSettings, (state: RootState) => Record<string, Device>];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getMappedDevicesList: ((state: any, listType: any) => unknown[]) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (...resultFuncArgs: any) => unknown[];
    memoizedResultFunc: ((...resultFuncArgs: any) => unknown[]) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => unknown[];
    dependencies: [(state: RootState) => Record<string, Device>, (state: any, listType: any) => any, () => {
        defaultObject: {
            auth_sets: never[];
        };
        cutOffSize: number;
    }];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getAuditlogDevice: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => {
    id: string;
    identity_data?: _northern_tech_types_IdentityData.IdentityData;
    status: _northern_tech_types_DeviceDeviceauth.DeviceDeviceauth.status;
    created_ts?: string;
    updated_ts?: string;
    check_in_time?: string;
    auth_sets?: Array<_northern_tech_types_AuthSet.AuthSet>;
    decommissioning?: boolean;
    external_id?: _northern_tech_types_ExternalIdentity.ExternalIdentity;
    attributes: InventoryAttributes;
    identity?: Record<string, string>;
    monitor?: Record<string, string>;
    system: Record<string, string>;
    tags?: Record<string, string>;
    check_in_time_exact?: string;
    check_in_time_rounded?: string;
    config?: _northern_tech_types_DeviceConfiguration.DeviceConfiguration;
    connect_status?: _northern_tech_types_DeviceStateDeviceconnect.DeviceStateDeviceconnect["status"];
    connect_updated_ts?: string;
    deploymentsCount?: number;
    deviceDeployments?: DeviceDeployment;
    etag?: string;
    gatewayIds?: string[];
    group?: string;
    isNew?: boolean;
    isOffline?: boolean;
    monitors?: _northern_tech_types_MonitorConfiguration.MonitorConfiguration[];
    twinsByIntegration?: Record<string, _northern_tech_types_DeviceState.DeviceState & {
        twinError?: string;
    }>;
}) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: _northern_tech_types_AuditLog.AuditLog | undefined, resultFuncArgs_1: Record<string, Device>) => {
        id: string;
        identity_data?: _northern_tech_types_IdentityData.IdentityData;
        status: _northern_tech_types_DeviceDeviceauth.DeviceDeviceauth.status;
        created_ts?: string;
        updated_ts?: string;
        check_in_time?: string;
        auth_sets?: Array<_northern_tech_types_AuthSet.AuthSet>;
        decommissioning?: boolean;
        external_id?: _northern_tech_types_ExternalIdentity.ExternalIdentity;
        attributes: InventoryAttributes;
        identity?: Record<string, string>;
        monitor?: Record<string, string>;
        system: Record<string, string>;
        tags?: Record<string, string>;
        check_in_time_exact?: string;
        check_in_time_rounded?: string;
        config?: _northern_tech_types_DeviceConfiguration.DeviceConfiguration;
        connect_status?: _northern_tech_types_DeviceStateDeviceconnect.DeviceStateDeviceconnect["status"];
        connect_updated_ts?: string;
        deploymentsCount?: number;
        deviceDeployments?: DeviceDeployment;
        etag?: string;
        gatewayIds?: string[];
        group?: string;
        isNew?: boolean;
        isOffline?: boolean;
        monitors?: _northern_tech_types_MonitorConfiguration.MonitorConfiguration[];
        twinsByIntegration?: Record<string, _northern_tech_types_DeviceState.DeviceState & {
            twinError?: string;
        }>;
    };
    memoizedResultFunc: ((resultFuncArgs_0: _northern_tech_types_AuditLog.AuditLog | undefined, resultFuncArgs_1: Record<string, Device>) => {
        id: string;
        identity_data?: _northern_tech_types_IdentityData.IdentityData;
        status: _northern_tech_types_DeviceDeviceauth.DeviceDeviceauth.status;
        created_ts?: string;
        updated_ts?: string;
        check_in_time?: string;
        auth_sets?: Array<_northern_tech_types_AuthSet.AuthSet>;
        decommissioning?: boolean;
        external_id?: _northern_tech_types_ExternalIdentity.ExternalIdentity;
        attributes: InventoryAttributes;
        identity?: Record<string, string>;
        monitor?: Record<string, string>;
        system: Record<string, string>;
        tags?: Record<string, string>;
        check_in_time_exact?: string;
        check_in_time_rounded?: string;
        config?: _northern_tech_types_DeviceConfiguration.DeviceConfiguration;
        connect_status?: _northern_tech_types_DeviceStateDeviceconnect.DeviceStateDeviceconnect["status"];
        connect_updated_ts?: string;
        deploymentsCount?: number;
        deviceDeployments?: DeviceDeployment;
        etag?: string;
        gatewayIds?: string[];
        group?: string;
        isNew?: boolean;
        isOffline?: boolean;
        monitors?: _northern_tech_types_MonitorConfiguration.MonitorConfiguration[];
        twinsByIntegration?: Record<string, _northern_tech_types_DeviceState.DeviceState & {
            twinError?: string;
        }>;
    }) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => {
        id: string;
        identity_data?: _northern_tech_types_IdentityData.IdentityData;
        status: _northern_tech_types_DeviceDeviceauth.DeviceDeviceauth.status;
        created_ts?: string;
        updated_ts?: string;
        check_in_time?: string;
        auth_sets?: Array<_northern_tech_types_AuthSet.AuthSet>;
        decommissioning?: boolean;
        external_id?: _northern_tech_types_ExternalIdentity.ExternalIdentity;
        attributes: InventoryAttributes;
        identity?: Record<string, string>;
        monitor?: Record<string, string>;
        system: Record<string, string>;
        tags?: Record<string, string>;
        check_in_time_exact?: string;
        check_in_time_rounded?: string;
        config?: _northern_tech_types_DeviceConfiguration.DeviceConfiguration;
        connect_status?: _northern_tech_types_DeviceStateDeviceconnect.DeviceStateDeviceconnect["status"];
        connect_updated_ts?: string;
        deploymentsCount?: number;
        deviceDeployments?: DeviceDeployment;
        etag?: string;
        gatewayIds?: string[];
        group?: string;
        isNew?: boolean;
        isOffline?: boolean;
        monitors?: _northern_tech_types_MonitorConfiguration.MonitorConfiguration[];
        twinsByIntegration?: Record<string, _northern_tech_types_DeviceState.DeviceState & {
            twinError?: string;
        }>;
    };
    dependencies: [((state: {
        app: {
            cancelSource: any;
            commit: string;
            demoArtifactLink: string;
            docsVersion: string;
            features: Record<string, boolean>;
            feedbackProbability: number;
            firstLoginAfterSignup: boolean;
            hostAddress: string | null;
            hostedAnnouncement: string;
            newThreshold: string;
            offlineThreshold: string;
            recaptchaSiteKey: string;
            searchState: SearchState;
            sentry: SentryConfig;
            snackbar: SnackbarContent;
            stripeAPIKey: string;
            trackerCode: string;
            uploadsById: Record<string, Upload>;
            versionInformation: {
                [key: string]: string | {
                    releaseDate: string;
                    repos: Record<string, string>;
                } | undefined;
                backend?: string;
                GUI?: string;
                latestRelease?: {
                    releaseDate: string;
                    repos: Record<string, string>;
                };
            };
            yesterday?: string;
        };
        devices: DeviceSliceType;
        deployments: {
            byId: Record<string, Deployment>;
            byStatus: DeploymentByStatus;
            config: DeploymentConfig;
            deploymentDeviceLimit: number;
            selectedDeviceIds: string[];
            selectionState: SelectionState;
        };
        monitor: {
            alerts: {
                alertList: {
                    page: number;
                    perPage: number;
                    total: number;
                };
                byDeviceId: {
                    alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                    latest?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                };
            };
            issueCounts: {
                byType: {
                    issues: {
                        filtered: number;
                        total: number;
                    };
                    offline: {
                        filtered: number;
                        total: number;
                    };
                    failedLastUpdate: {
                        filtered: number;
                        total: number;
                    };
                    monitoring: {
                        filtered: number;
                        total: number;
                    };
                    authRequests: {
                        filtered: number;
                        total: number;
                    };
                    gatewayDevices: {
                        filtered: number;
                        total: number;
                    };
                };
            };
            settings: {
                global: {
                    channels: {
                        email: {
                            enabled: boolean;
                        };
                    };
                };
            };
        };
        onboarding: {
            address?: string;
            approach: OnboardingApproach | null;
            complete: boolean;
            demoArtifactPort: number;
            deviceConnection?: string;
            deviceType: string[] | string | null;
            progress: string | null;
            showTips: boolean | null;
            showTipsDialog: boolean;
        };
        organization: OrganizationState;
        releases: ReleaseSliceType;
        users: {
            activationCode?: string;
            byId: Record<string, User>;
            currentSession?: UserSession | object;
            currentUser: string | null;
            customColumns: CustomColumn[];
            globalSettings: GlobalSettings;
            permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
            qrCode: string | null;
            rolesById: Record<string, _northern_tech_utils_constants.Role>;
            rolesInitialized: boolean;
            settingsInitialized: boolean;
            showConnectDeviceDialog: boolean;
            showFeedbackDialog: boolean;
            showStartupNotification: boolean;
            tooltips: {
                byId: Record<string, {
                    readState: ReadState;
                }>;
            };
            userSettings: UserSettings;
            userSettingsInitialized: boolean;
        };
    }) => _northern_tech_types_AuditLog.AuditLog | undefined) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    } & {
        resultFunc: (resultFuncArgs_0: _northern_tech_types_AuditLog.AuditLog[], resultFuncArgs_1: AuditLogSelectionState) => _northern_tech_types_AuditLog.AuditLog | undefined;
        memoizedResultFunc: ((resultFuncArgs_0: _northern_tech_types_AuditLog.AuditLog[], resultFuncArgs_1: AuditLogSelectionState) => _northern_tech_types_AuditLog.AuditLog | undefined) & {
            clearCache: () => void;
            resultsCount: () => number;
            resetResultsCount: () => void;
        };
        lastResult: () => _northern_tech_types_AuditLog.AuditLog | undefined;
        dependencies: [(state: RootState) => _northern_tech_types_AuditLog.AuditLog[], (state: RootState) => AuditLogSelectionState];
        recomputations: () => number;
        resetRecomputations: () => void;
        dependencyRecomputations: () => number;
        resetDependencyRecomputations: () => void;
    } & {
        memoize: typeof reselect.weakMapMemoize;
        argsMemoize: typeof reselect.weakMapMemoize;
    }, (state: RootState) => Record<string, Device>];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};
declare const getRelevantRoles: ((state: {
    app: {
        cancelSource: any;
        commit: string;
        demoArtifactLink: string;
        docsVersion: string;
        features: Record<string, boolean>;
        feedbackProbability: number;
        firstLoginAfterSignup: boolean;
        hostAddress: string | null;
        hostedAnnouncement: string;
        newThreshold: string;
        offlineThreshold: string;
        recaptchaSiteKey: string;
        searchState: SearchState;
        sentry: SentryConfig;
        snackbar: SnackbarContent;
        stripeAPIKey: string;
        trackerCode: string;
        uploadsById: Record<string, Upload>;
        versionInformation: {
            [key: string]: string | {
                releaseDate: string;
                repos: Record<string, string>;
            } | undefined;
            backend?: string;
            GUI?: string;
            latestRelease?: {
                releaseDate: string;
                repos: Record<string, string>;
            };
        };
        yesterday?: string;
    };
    devices: DeviceSliceType;
    deployments: {
        byId: Record<string, Deployment>;
        byStatus: DeploymentByStatus;
        config: DeploymentConfig;
        deploymentDeviceLimit: number;
        selectedDeviceIds: string[];
        selectionState: SelectionState;
    };
    monitor: {
        alerts: {
            alertList: {
                page: number;
                perPage: number;
                total: number;
            };
            byDeviceId: {
                alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
                latest?: Record<string, _northern_tech_types_Alert.Alert & {
                    fullName?: string;
                }>;
            };
        };
        issueCounts: {
            byType: {
                issues: {
                    filtered: number;
                    total: number;
                };
                offline: {
                    filtered: number;
                    total: number;
                };
                failedLastUpdate: {
                    filtered: number;
                    total: number;
                };
                monitoring: {
                    filtered: number;
                    total: number;
                };
                authRequests: {
                    filtered: number;
                    total: number;
                };
                gatewayDevices: {
                    filtered: number;
                    total: number;
                };
            };
        };
        settings: {
            global: {
                channels: {
                    email: {
                        enabled: boolean;
                    };
                };
            };
        };
    };
    onboarding: {
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    };
    organization: OrganizationState;
    releases: ReleaseSliceType;
    users: {
        activationCode?: string;
        byId: Record<string, User>;
        currentSession?: UserSession | object;
        currentUser: string | null;
        customColumns: CustomColumn[];
        globalSettings: GlobalSettings;
        permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
        qrCode: string | null;
        rolesById: Record<string, _northern_tech_utils_constants.Role>;
        rolesInitialized: boolean;
        settingsInitialized: boolean;
        showConnectDeviceDialog: boolean;
        showFeedbackDialog: boolean;
        showStartupNotification: boolean;
        tooltips: {
            byId: Record<string, {
                readState: ReadState;
            }>;
        };
        userSettings: UserSettings;
        userSettingsInitialized: boolean;
    };
}) => {
    name: string;
    description?: string;
    permission_sets_with_scope?: Array<_northern_tech_types_PermissionSetWithScope.PermissionSetWithScope>;
    permissions?: Array<_northern_tech_types_RolePermission.RolePermission> | undefined;
    editable?: boolean;
    isCustom?: boolean;
    uiPermissions: Readonly<{
        auditlog: string[];
        deployments?: string[];
        groups: Record<string, string[]>;
        releases: Record<string, string[]>;
        tenantManagement: string[];
        userManagement: string[];
    }>;
    value: string;
}[] | ({
    readonly name: "Admin";
    readonly value: "RBAC_ROLE_PERMIT_ALL";
    readonly description: "Full access";
    readonly permissions: readonly [];
    readonly uiPermissions: {
        readonly auditlog: ("read" | "manage" | "deploy" | "configure" | "connect" | "upload")[];
        readonly userManagement: ("read" | "manage" | "deploy" | "configure" | "connect" | "upload")[];
        readonly tenantManagement: ("read" | "manage" | "deploy" | "configure" | "connect" | "upload")[];
        readonly deployments?: string[] | undefined;
        readonly groups: Record<string, string[]>;
        readonly releases: Record<string, string[]>;
    };
} | {
    readonly name: "Read access";
    readonly value: "RBAC_ROLE_OBSERVER";
    readonly description: "This role can see all linked organizations but cannot make any changes";
    readonly permissions: readonly [];
    readonly uiPermissions: {
        readonly auditlog: readonly ["read"];
        readonly userManagement: readonly ["read"];
        readonly tenantManagement: readonly ["read"];
        readonly deployments?: string[] | undefined;
        readonly groups: Record<string, string[]>;
        readonly releases: Record<string, string[]>;
    };
})[]) & {
    clearCache: () => void;
    resultsCount: () => number;
    resetResultsCount: () => void;
} & {
    resultFunc: (resultFuncArgs_0: Partial<Organization>, resultFuncArgs_1: {
        name: string;
        description?: string;
        permission_sets_with_scope?: Array<_northern_tech_types_PermissionSetWithScope.PermissionSetWithScope>;
        permissions?: Array<_northern_tech_types_RolePermission.RolePermission> | undefined;
        editable?: boolean;
        isCustom?: boolean;
        uiPermissions: Readonly<{
            auditlog: string[];
            deployments?: string[];
            groups: Record<string, string[]>;
            releases: Record<string, string[]>;
            tenantManagement: string[];
            userManagement: string[];
        }>;
        value: string;
    }[]) => {
        name: string;
        description?: string;
        permission_sets_with_scope?: Array<_northern_tech_types_PermissionSetWithScope.PermissionSetWithScope>;
        permissions?: Array<_northern_tech_types_RolePermission.RolePermission> | undefined;
        editable?: boolean;
        isCustom?: boolean;
        uiPermissions: Readonly<{
            auditlog: string[];
            deployments?: string[];
            groups: Record<string, string[]>;
            releases: Record<string, string[]>;
            tenantManagement: string[];
            userManagement: string[];
        }>;
        value: string;
    }[] | ({
        readonly name: "Admin";
        readonly value: "RBAC_ROLE_PERMIT_ALL";
        readonly description: "Full access";
        readonly permissions: readonly [];
        readonly uiPermissions: {
            readonly auditlog: ("read" | "manage" | "deploy" | "configure" | "connect" | "upload")[];
            readonly userManagement: ("read" | "manage" | "deploy" | "configure" | "connect" | "upload")[];
            readonly tenantManagement: ("read" | "manage" | "deploy" | "configure" | "connect" | "upload")[];
            readonly deployments?: string[] | undefined;
            readonly groups: Record<string, string[]>;
            readonly releases: Record<string, string[]>;
        };
    } | {
        readonly name: "Read access";
        readonly value: "RBAC_ROLE_OBSERVER";
        readonly description: "This role can see all linked organizations but cannot make any changes";
        readonly permissions: readonly [];
        readonly uiPermissions: {
            readonly auditlog: readonly ["read"];
            readonly userManagement: readonly ["read"];
            readonly tenantManagement: readonly ["read"];
            readonly deployments?: string[] | undefined;
            readonly groups: Record<string, string[]>;
            readonly releases: Record<string, string[]>;
        };
    })[];
    memoizedResultFunc: ((resultFuncArgs_0: Partial<Organization>, resultFuncArgs_1: {
        name: string;
        description?: string;
        permission_sets_with_scope?: Array<_northern_tech_types_PermissionSetWithScope.PermissionSetWithScope>;
        permissions?: Array<_northern_tech_types_RolePermission.RolePermission> | undefined;
        editable?: boolean;
        isCustom?: boolean;
        uiPermissions: Readonly<{
            auditlog: string[];
            deployments?: string[];
            groups: Record<string, string[]>;
            releases: Record<string, string[]>;
            tenantManagement: string[];
            userManagement: string[];
        }>;
        value: string;
    }[]) => {
        name: string;
        description?: string;
        permission_sets_with_scope?: Array<_northern_tech_types_PermissionSetWithScope.PermissionSetWithScope>;
        permissions?: Array<_northern_tech_types_RolePermission.RolePermission> | undefined;
        editable?: boolean;
        isCustom?: boolean;
        uiPermissions: Readonly<{
            auditlog: string[];
            deployments?: string[];
            groups: Record<string, string[]>;
            releases: Record<string, string[]>;
            tenantManagement: string[];
            userManagement: string[];
        }>;
        value: string;
    }[] | ({
        readonly name: "Admin";
        readonly value: "RBAC_ROLE_PERMIT_ALL";
        readonly description: "Full access";
        readonly permissions: readonly [];
        readonly uiPermissions: {
            readonly auditlog: ("read" | "manage" | "deploy" | "configure" | "connect" | "upload")[];
            readonly userManagement: ("read" | "manage" | "deploy" | "configure" | "connect" | "upload")[];
            readonly tenantManagement: ("read" | "manage" | "deploy" | "configure" | "connect" | "upload")[];
            readonly deployments?: string[] | undefined;
            readonly groups: Record<string, string[]>;
            readonly releases: Record<string, string[]>;
        };
    } | {
        readonly name: "Read access";
        readonly value: "RBAC_ROLE_OBSERVER";
        readonly description: "This role can see all linked organizations but cannot make any changes";
        readonly permissions: readonly [];
        readonly uiPermissions: {
            readonly auditlog: readonly ["read"];
            readonly userManagement: readonly ["read"];
            readonly tenantManagement: readonly ["read"];
            readonly deployments?: string[] | undefined;
            readonly groups: Record<string, string[]>;
            readonly releases: Record<string, string[]>;
        };
    })[]) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    };
    lastResult: () => {
        name: string;
        description?: string;
        permission_sets_with_scope?: Array<_northern_tech_types_PermissionSetWithScope.PermissionSetWithScope>;
        permissions?: Array<_northern_tech_types_RolePermission.RolePermission> | undefined;
        editable?: boolean;
        isCustom?: boolean;
        uiPermissions: Readonly<{
            auditlog: string[];
            deployments?: string[];
            groups: Record<string, string[]>;
            releases: Record<string, string[]>;
            tenantManagement: string[];
            userManagement: string[];
        }>;
        value: string;
    }[] | ({
        readonly name: "Admin";
        readonly value: "RBAC_ROLE_PERMIT_ALL";
        readonly description: "Full access";
        readonly permissions: readonly [];
        readonly uiPermissions: {
            readonly auditlog: ("read" | "manage" | "deploy" | "configure" | "connect" | "upload")[];
            readonly userManagement: ("read" | "manage" | "deploy" | "configure" | "connect" | "upload")[];
            readonly tenantManagement: ("read" | "manage" | "deploy" | "configure" | "connect" | "upload")[];
            readonly deployments?: string[] | undefined;
            readonly groups: Record<string, string[]>;
            readonly releases: Record<string, string[]>;
        };
    } | {
        readonly name: "Read access";
        readonly value: "RBAC_ROLE_OBSERVER";
        readonly description: "This role can see all linked organizations but cannot make any changes";
        readonly permissions: readonly [];
        readonly uiPermissions: {
            readonly auditlog: readonly ["read"];
            readonly userManagement: readonly ["read"];
            readonly tenantManagement: readonly ["read"];
            readonly deployments?: string[] | undefined;
            readonly groups: Record<string, string[]>;
            readonly releases: Record<string, string[]>;
        };
    })[];
    dependencies: [(state: RootState) => Partial<Organization>, ((state: {
        app: {
            cancelSource: any;
            commit: string;
            demoArtifactLink: string;
            docsVersion: string;
            features: Record<string, boolean>;
            feedbackProbability: number;
            firstLoginAfterSignup: boolean;
            hostAddress: string | null;
            hostedAnnouncement: string;
            newThreshold: string;
            offlineThreshold: string;
            recaptchaSiteKey: string;
            searchState: SearchState;
            sentry: SentryConfig;
            snackbar: SnackbarContent;
            stripeAPIKey: string;
            trackerCode: string;
            uploadsById: Record<string, Upload>;
            versionInformation: {
                [key: string]: string | {
                    releaseDate: string;
                    repos: Record<string, string>;
                } | undefined;
                backend?: string;
                GUI?: string;
                latestRelease?: {
                    releaseDate: string;
                    repos: Record<string, string>;
                };
            };
            yesterday?: string;
        };
        devices: DeviceSliceType;
        deployments: {
            byId: Record<string, Deployment>;
            byStatus: DeploymentByStatus;
            config: DeploymentConfig;
            deploymentDeviceLimit: number;
            selectedDeviceIds: string[];
            selectionState: SelectionState;
        };
        monitor: {
            alerts: {
                alertList: {
                    page: number;
                    perPage: number;
                    total: number;
                };
                byDeviceId: {
                    alerts?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                    latest?: Record<string, _northern_tech_types_Alert.Alert & {
                        fullName?: string;
                    }>;
                };
            };
            issueCounts: {
                byType: {
                    issues: {
                        filtered: number;
                        total: number;
                    };
                    offline: {
                        filtered: number;
                        total: number;
                    };
                    failedLastUpdate: {
                        filtered: number;
                        total: number;
                    };
                    monitoring: {
                        filtered: number;
                        total: number;
                    };
                    authRequests: {
                        filtered: number;
                        total: number;
                    };
                    gatewayDevices: {
                        filtered: number;
                        total: number;
                    };
                };
            };
            settings: {
                global: {
                    channels: {
                        email: {
                            enabled: boolean;
                        };
                    };
                };
            };
        };
        onboarding: {
            address?: string;
            approach: OnboardingApproach | null;
            complete: boolean;
            demoArtifactPort: number;
            deviceConnection?: string;
            deviceType: string[] | string | null;
            progress: string | null;
            showTips: boolean | null;
            showTipsDialog: boolean;
        };
        organization: OrganizationState;
        releases: ReleaseSliceType;
        users: {
            activationCode?: string;
            byId: Record<string, User>;
            currentSession?: UserSession | object;
            currentUser: string | null;
            customColumns: CustomColumn[];
            globalSettings: GlobalSettings;
            permissionSetsById: Record<string, _northern_tech_utils_constants.PermissionSet>;
            qrCode: string | null;
            rolesById: Record<string, _northern_tech_utils_constants.Role>;
            rolesInitialized: boolean;
            settingsInitialized: boolean;
            showConnectDeviceDialog: boolean;
            showFeedbackDialog: boolean;
            showStartupNotification: boolean;
            tooltips: {
                byId: Record<string, {
                    readState: ReadState;
                }>;
            };
            userSettings: UserSettings;
            userSettingsInitialized: boolean;
        };
    }) => {
        name: string;
        description?: string;
        permission_sets_with_scope?: Array<_northern_tech_types_PermissionSetWithScope.PermissionSetWithScope>;
        permissions?: Array<_northern_tech_types_RolePermission.RolePermission> | undefined;
        editable?: boolean;
        isCustom?: boolean;
        uiPermissions: Readonly<{
            auditlog: string[];
            deployments?: string[];
            groups: Record<string, string[]>;
            releases: Record<string, string[]>;
            tenantManagement: string[];
            userManagement: string[];
        }>;
        value: string;
    }[]) & {
        clearCache: () => void;
        resultsCount: () => number;
        resetResultsCount: () => void;
    } & {
        resultFunc: (resultFuncArgs_0: Record<string, _northern_tech_utils_constants.Role>) => {
            name: string;
            description?: string;
            permission_sets_with_scope?: Array<_northern_tech_types_PermissionSetWithScope.PermissionSetWithScope>;
            permissions?: Array<_northern_tech_types_RolePermission.RolePermission> | undefined;
            editable?: boolean;
            isCustom?: boolean;
            uiPermissions: Readonly<{
                auditlog: string[];
                deployments?: string[];
                groups: Record<string, string[]>;
                releases: Record<string, string[]>;
                tenantManagement: string[];
                userManagement: string[];
            }>;
            value: string;
        }[];
        memoizedResultFunc: ((resultFuncArgs_0: Record<string, _northern_tech_utils_constants.Role>) => {
            name: string;
            description?: string;
            permission_sets_with_scope?: Array<_northern_tech_types_PermissionSetWithScope.PermissionSetWithScope>;
            permissions?: Array<_northern_tech_types_RolePermission.RolePermission> | undefined;
            editable?: boolean;
            isCustom?: boolean;
            uiPermissions: Readonly<{
                auditlog: string[];
                deployments?: string[];
                groups: Record<string, string[]>;
                releases: Record<string, string[]>;
                tenantManagement: string[];
                userManagement: string[];
            }>;
            value: string;
        }[]) & {
            clearCache: () => void;
            resultsCount: () => number;
            resetResultsCount: () => void;
        };
        lastResult: () => {
            name: string;
            description?: string;
            permission_sets_with_scope?: Array<_northern_tech_types_PermissionSetWithScope.PermissionSetWithScope>;
            permissions?: Array<_northern_tech_types_RolePermission.RolePermission> | undefined;
            editable?: boolean;
            isCustom?: boolean;
            uiPermissions: Readonly<{
                auditlog: string[];
                deployments?: string[];
                groups: Record<string, string[]>;
                releases: Record<string, string[]>;
                tenantManagement: string[];
                userManagement: string[];
            }>;
            value: string;
        }[];
        dependencies: [(state: RootState) => Record<string, _northern_tech_utils_constants.Role>];
        recomputations: () => number;
        resetRecomputations: () => void;
        dependencyRecomputations: () => number;
        resetDependencyRecomputations: () => void;
    } & {
        memoize: typeof reselect.weakMapMemoize;
        argsMemoize: typeof reselect.weakMapMemoize;
    }];
    recomputations: () => number;
    resetRecomputations: () => void;
    dependencyRecomputations: () => number;
    resetDependencyRecomputations: () => void;
} & {
    memoize: typeof reselect.weakMapMemoize;
    argsMemoize: typeof reselect.weakMapMemoize;
};

export { getAttrsEndpoint, getAuditlogDevice, getAvailableIssueOptionsByType, getDemoDeviceAddress, getDeploymentRelease, getDeviceConfigDeployment, getDeviceReportsForUser, getFilterAttributes, getGroupNames, getIsEnterprise, getMappedDevicesList, getOnboardingState, getRelevantRoles, getSearchEndpoint, getSelectedDeploymentData, getTenantCapabilities, getUserCapabilities, getUserRoles };
