import { AppDispatch, RootState } from '../store.js';
import * as _reduxjs_toolkit from '@reduxjs/toolkit';
import { UserSettings } from '../usersSlice/index.js';
import { OnboardingApproach } from './index.js';
import { OnboardingStep } from './constants.js';
import 'redux-thunk';
import 'redux';
import '@northern.tech/utils/constants';
import '../usersSlice/constants.js';
import '../releasesSlice/index.js';
import 'immer';
import '@northern.tech/types/MenderTypes';
import '../organizationSlice/types.js';
import '../appSlice/constants.js';
import '@mui/material/OverridableComponent';
import '@mui/material';
import '../organizationSlice/constants.js';
import '@northern.tech/types/Alert';
import '../deploymentsSlice/index.js';
import '../devicesSlice/index.js';
import '../commonConstants.js';
import 'react/jsx-runtime';
import '../devicesSlice/constants.js';
import '../appSlice/index.js';

declare const getOnboardingState: _reduxjs_toolkit.AsyncThunk<[{
    payload: boolean;
    type: "onboarding/setOnboardingComplete";
}, {
    payload: Partial<{
        address?: string;
        approach: OnboardingApproach | null;
        complete: boolean;
        demoArtifactPort: number;
        deviceConnection?: string;
        deviceType: string[] | string | null;
        progress: string | null;
        showTips: boolean | null;
        showTipsDialog: boolean;
    }>;
    type: "onboarding/setOnboardingState";
}, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: Partial<UserSettings> | undefined;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: Partial<UserSettings> | undefined;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>], void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const setOnboardingDeviceType: _reduxjs_toolkit.AsyncThunk<[{
    payload: string | string[];
    type: "onboarding/setOnboardingDeviceType";
}, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: Partial<UserSettings> | undefined;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: Partial<UserSettings> | undefined;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>], string | string[], {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const setOnboardingApproach: _reduxjs_toolkit.AsyncThunk<[{
    payload: OnboardingApproach;
    type: "onboarding/setOnboardingApproach";
}, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: Partial<UserSettings> | undefined;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: Partial<UserSettings> | undefined;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>], OnboardingApproach, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const setOnboardingComplete: _reduxjs_toolkit.AsyncThunk<any[], boolean, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const setOnboardingCanceled: _reduxjs_toolkit.AsyncThunk<void, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const advanceOnboarding: _reduxjs_toolkit.AsyncThunk<[{
    payload: string;
    type: "onboarding/setOnboardingProgress";
}, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: Partial<UserSettings> | undefined;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: Partial<UserSettings> | undefined;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>] | undefined, OnboardingStep, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;

export { advanceOnboarding, getOnboardingState, setOnboardingApproach, setOnboardingCanceled, setOnboardingComplete, setOnboardingDeviceType };
