"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/organizationSlice/constants.ts
var constants_exports = {};
__export(constants_exports, {
  AUDIT_LOGS_TYPES: () => AUDIT_LOGS_TYPES,
  JSON_METADATA_FORMAT: () => JSON_METADATA_FORMAT,
  SP_AUDIT_LOGS_TYPES: () => SP_AUDIT_LOGS_TYPES,
  SSO_TYPES: () => SSO_TYPES,
  TENANT_LIST_DEFAULT: () => TENANT_LIST_DEFAULT,
  XML_METADATA_FORMAT: () => XML_METADATA_FORMAT,
  auditlogTypes: () => auditlogTypes,
  getOidcStartUrl: () => getOidcStartUrl,
  getSamlStartUrl: () => getSamlStartUrl
});
module.exports = __toCommonJS(constants_exports);

// src/constants.ts
var import_constants = require("@northern.tech/utils/constants");

// src/organizationSlice/constants.ts
var XML_METADATA_FORMAT = "xml";
var JSON_METADATA_FORMAT = "json";
var getSamlStartUrl = (id) => `${window.location.origin}${import_constants.useradmApiUrl}/auth/sso/${id}/login`;
var getOidcStartUrl = (id) => `${window.location.origin}${import_constants.useradmApiUrl}/oidc/${id}/start`;
var SSO_TYPES = {
  saml: {
    id: "saml",
    type: "saml",
    title: "SAML",
    metadataFormat: XML_METADATA_FORMAT,
    editorLanguage: XML_METADATA_FORMAT,
    contentType: "application/samlmetadata+xml",
    getStartUrl: getSamlStartUrl,
    configDetails: [
      { key: "entityID", label: "Entity ID", getValue: (id) => `${window.location.origin}${import_constants.useradmApiUrl}/sso/sp/metadata/${id}` },
      { key: "acs", label: "ACS URL", getValue: (id) => `${window.location.origin}${import_constants.useradmApiUrl}/auth/sso/${id}/acs` },
      { key: "startURL", label: "Start URL", getValue: getSamlStartUrl }
    ]
  },
  oidc: {
    id: "oidc",
    type: "oidc",
    title: "OpenID Connect",
    metadataFormat: JSON_METADATA_FORMAT,
    editorLanguage: JSON_METADATA_FORMAT,
    contentType: "application/json",
    getStartUrl: getOidcStartUrl,
    configDetails: [{ key: "startURL", label: "Start Url", getValue: getOidcStartUrl }]
  }
};
var auditlogTypes = {
  artifact: { title: "Artifact", queryParameter: "object_type", value: "artifact" },
  deployment: { title: "Deployment", queryParameter: "object_deployment_name", value: "deployment" },
  device: { title: "Device", queryParameter: "object_id", value: "device" },
  user_access_token: { title: "Personal Access Token", queryParameter: "user_access_token", value: "user_access_token" },
  user: { title: "User", queryParameter: "object_id", value: "user" },
  tenant: { title: "Tenant", queryParameter: "object_id", value: "tenant" }
};
var AUDIT_LOGS_TYPES = [auditlogTypes.artifact, auditlogTypes.deployment, auditlogTypes.device, auditlogTypes.user_access_token, auditlogTypes.user];
var SP_AUDIT_LOGS_TYPES = [auditlogTypes.user, auditlogTypes.tenant];
var TENANT_LIST_DEFAULT = {
  page: 1,
  perPage: 20
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AUDIT_LOGS_TYPES,
  JSON_METADATA_FORMAT,
  SP_AUDIT_LOGS_TYPES,
  SSO_TYPES,
  TENANT_LIST_DEFAULT,
  XML_METADATA_FORMAT,
  auditlogTypes,
  getOidcStartUrl,
  getSamlStartUrl
});
//# sourceMappingURL=constants.cjs.map