import { DeviceAttributeProjection } from './DeviceAttributeProjection.js';
import { DeviceFilterTerm } from './DeviceFilterTerm.js';
import { DeviceSortTerm } from './DeviceSortTerm.js';
import { GeoBoundingBoxFilter } from './GeoBoundingBoxFilter.js';
import { GeoDistanceFilter } from './GeoDistanceFilter.js';
import './GeoDistance.js';
import './GeoPoint.js';

type DeviceSearchTerms = {
    /**
     * Pagination parameter for iterating search results.
     */
    page?: number;
    /**
     * Number of devices returned per page.
     */
    per_page?: number;
    /**
     * Filtering terms.
     */
    filters?: Array<DeviceFilterTerm>;
    geo_distance_filter?: GeoDistanceFilter;
    geo_bounding_box_filter?: GeoBoundingBoxFilter;
    /**
     * Attribute keys to sort by.
     */
    sort?: Array<DeviceSortTerm>;
    /**
     * Restrict the attribute result to the selected attributes.
     */
    attributes?: Array<DeviceAttributeProjection>;
    /**
     * Restrict the result to the given device IDs.
     */
    device_ids?: Array<string>;
};

export type { DeviceSearchTerms };
