/*
 * CFEngine Click Capture
 * (requires JQuery)
 */



// CONFIGURATION
var debug = false;
var clickSite = siteID;
var clickServer = '';
var clickGroup = '';
var browser = '';
var lastTime = 0;
var customVariables = {};



// Browser Detection by http://jsfiddle.net/9zxvE/
function testCSS(prop) {
    return prop in document.documentElement.style;
}

if (!!(window.opera && window.opera.version))
    browser = "opera";
else if (testCSS('MozBoxSizing'))
    browser = "firefox";
else if (Object.prototype.toString.call(window.HTMLElement).indexOf('Constructor')>0)
    browser = "safari";
else if (testCSS('WebkitTransform'))
    browser = "chrome";
else if (/*@cc_on!@*/false || testCSS('msTransform'))
    browser = "msie";
else
    browser = "unknown";



// Click Recording by CFEngine
$(document).ready(function () {
    $(document).on("mouseup",function(e) {

        var x = e.pageX;
        var y = e.pageY;
        var w = $(window).width();
        var h = $(window).height();
        var scrollx = $(window).scrollTop();
        var scrolly = $(window).scrollLeft();
        var color = e.which || e.button;
        var clickTime = new Date();

        if( lastTime===0 || (clickTime.getTime()-lastTime.getTime())>=1000 ){
            lastTime = new Date();
            params = {
                "s" : clickSite,
                "g" : clickGroup,
                "x" : x,
                "y" : y,
                "w" : w,
                "scrollx" : scrollx,
                "scrolly" : scrolly,
                "b" : browser,
                "c" : color,
                "random" : Date(),
                "_cvar" : JSON.stringify(customVariables)
            };

            if (clickServer!=='' && clickGroup!=='' && color!==0){
                $.ajax({
                    async: false,
                    timeout: 1000,
                    type: "GET",
                    url: clickServer,
                    data: params,
                    contentType: "application/x-www-form-urlencoded",
                    success: function(response){
                        if(debug) console.log(response);
                    }
                });
            }
        }

    });
});
