/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*jslint plusplus: true */
/*global dashboardApp, angular, $*/

'use strict';

angular.
module('complianceWidgetHelper', [])
    .factory('complianceWidgetHelper',
    [function () {
        let helper = {};

        let config = {
            chart: {
                plotBackgroundColor: null,
                plotBorderWidth: 0,
                plotShadow: false,
                backgroundColor: 'transparent'
            },
            title: {
                text: '',
                align: 'left',
                verticalAlign: 'middle',
                y: -5,
                x: 57,
                style: {
                    fontWeight: '500',
                    fontSize: '14px',
                    fontFamily: 'Red Hat Text',
                    display: 'inline-block'
                }
            },
            subtitle: {
                align: 'left',
                verticalAlign: 'bottom',
                floating: true,
                width: 168,
                x: 5,
                text: '',
                style: {
                    fontSize: '12px',
                    fontWeight: "500",
                    color:  widgetColors.complianceColors().subtitle,
                    width: "50px",
                    textTransform: 'none'
                },
            },
            tooltip: {
                headerFormat: '<span style="font-size: 14px"><b>{point.key}</b></span><br/>',
                style: {
                    fontSize: '12px',
                },
                pointFormat: '{point.percentage:.1f}%</b>'
            },
            plotOptions: {
                pie: {
                    dataLabels: {
                        enabled: true,
                        distance: -50,
                        style: {
                            fontWeight: 'bold',
                            color: 'white'
                        }
                    },
                    center: ['52px', '53px'],
                    size: '130px',
                    colors: widgetColors.complianceColors().pie,
                    borderWidth: 0
                }
            },
            series: [{
                type: 'pie',
                innerSize: '50%',
                data: [
                    {
                        name: 'Passing',
                        y: 0,
                        dataLabels: {
                            enabled: false
                        }
                    },
                    {
                        name: 'Failing',
                        y: 0,
                        dataLabels: {
                            enabled: false
                        }
                    }
                ]
            }],
            credits: {
                enabled: false
            },
            exporting: {
                enabled: false
            }
        };

        helper.getChartData = function (totalScore, totalChecks, totalCount) {
            if (totalScore == undefined) {
                return null;
            }
            config.series[0].data[0].y = totalScore;
            config.series[0].data[1].y = 100 - totalScore;
            config.title.text = `${totalScore} %`;

            config.chart.events = {
                render: function () {
                    const attr = {align: 'center'};
                    const styles = {
                        fontSize: '16px',
                        fontWeight: "500",
                        color: widgetColors.complianceColors().subtitle
                    };
                    this.renderer
                        .text(`${totalScore} % compliance over ${totalChecks}`, 110, 225)
                        .attr(attr)
                        .css(styles)
                        .add();
                    this.renderer
                        .text(`check${totalChecks == 1 ? '' : 's'} among ${totalCount} hosts`, 110, 240)
                        .attr(attr).css(styles)
                        .add();
                }
            };
            return angular.copy(config);
        };

        return helper;
    }]);
