// src/ConfigurationObject.tsx
import React, { Fragment, useState } from "react";
import { FileCopyOutlined as CopyToClipboardIcon } from "@mui/icons-material";
import { Tooltip } from "@mui/material";
import { makeStyles } from "tss-react/mui";
import copy from "copy-to-clipboard";
import { jsx, jsxs } from "react/jsx-runtime";
var useStyles = makeStyles()((theme) => ({
  root: {
    [".key > b"]: {
      backgroundColor: theme.palette.grey[400],
      color: theme.palette.getContrastText(theme.palette.grey[400])
    }
  }
}));
var cutoffLength = 100;
var ValueColumn = ({ value = "", setSnackbar }) => {
  const [tooltipVisible, setTooltipVisible] = useState(false);
  const isComponent = React.isValidElement(value);
  const onClick = () => {
    if (setSnackbar) {
      let copyable = value;
      if (isComponent) {
        copyable = value.props.value;
      }
      copy(copyable);
      setSnackbar("Value copied to clipboard");
    }
  };
  let shownValue = value;
  if (!isComponent) {
    shownValue = /* @__PURE__ */ jsx("div", { title: value, children: value.length > cutoffLength ? `${value.substring(0, cutoffLength - 3)}...` : value });
  }
  return /* @__PURE__ */ jsxs(
    "div",
    {
      className: `flexbox ${setSnackbar ? "clickable" : ""}`,
      onClick,
      onMouseEnter: () => setTooltipVisible(true),
      onMouseLeave: () => setTooltipVisible(false),
      children: [
        shownValue,
        setSnackbar && /* @__PURE__ */ jsx(Tooltip, { title: "Copy to clipboard", placement: "top", open: tooltipVisible, children: /* @__PURE__ */ jsx(CopyToClipboardIcon, { color: "primary", className: `margin-left-small ${tooltipVisible ? "fadeIn" : "fadeOut"}`, fontSize: "small" }) })
      ]
    }
  );
};
var KeyColumn = ({ value, chipLikeKey }) => /* @__PURE__ */ jsx("div", { className: `align-right ${chipLikeKey ? "key" : ""} muted`, children: /* @__PURE__ */ jsx("b", { children: value }) });
var TwoColumns = ({
  className = "",
  children = void 0,
  chipLikeKey = true,
  compact = false,
  items = {},
  KeyComponent = KeyColumn,
  KeyProps = {},
  setSnackbar,
  style = {},
  ValueComponent = ValueColumn,
  ValueProps = {}
}) => {
  const { classes } = useStyles();
  return /* @__PURE__ */ jsx("div", { className: `break-all two-columns ${classes.root} ${compact ? "compact" : ""} ${className}`, style, children: children ? children : Object.entries(items).map(([key, value]) => /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(KeyComponent, { chipLikeKey, value: key, ...KeyProps }),
    /* @__PURE__ */ jsx(ValueComponent, { setSnackbar, value, ...ValueProps })
  ] }, key)) });
};
var TwoColumnData = ({ className = "", config, ...props }) => /* @__PURE__ */ jsx(TwoColumns, { className: `column-data ${className}`, items: config, ...props });
var TwoColumnDataMultiple = ({ className = "", config, style, ...props }) => /* @__PURE__ */ jsx("div", { className: `two-columns-multiple ${className}`, style: { ...style }, children: Object.entries(config).map(([key, value]) => /* @__PURE__ */ jsx(TwoColumnData, { className: "multiple", config: { [key]: value }, compact: true, ...props }, key)) });
var ConfigurationObject = ({ config, ...props }) => {
  const content = Object.entries(config).reduce((accu, [key, value]) => {
    accu[key] = `${value}`;
    return accu;
  }, {});
  return /* @__PURE__ */ jsx(TwoColumnData, { ...props, config: content });
};
var ConfigurationObject_default = ConfigurationObject;

export {
  TwoColumns,
  TwoColumnData,
  TwoColumnDataMultiple,
  ConfigurationObject,
  ConfigurationObject_default
};
//# sourceMappingURL=chunk-TYZY4LRW.js.map