"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/api/users-api.ts
var users_api_exports = {};
__export(users_api_exports, {
  default: () => users_api_default
});
module.exports = __toCommonJS(users_api_exports);
var import_axios2 = __toESM(require("axios"), 1);

// src/auth.ts
var import_universal_cookie = __toESM(require("universal-cookie"), 1);

// src/constants.ts
var import_constants2 = require("@northern.tech/utils/constants");

// src/commonConstants.tsx
var import_js = require("@mdi/js");
var import_MenderTypes = require("@northern.tech/types/MenderTypes");
var import_jsx_runtime = require("react/jsx-runtime");
var timeUnits = {
  days: "days",
  minutes: "minutes",
  hours: "hours"
};
var oneSecond = 1e3;
var TIMEOUTS = {
  debounceDefault: 700,
  debounceShort: 300,
  halfASecond: 0.5 * oneSecond,
  oneSecond,
  twoSeconds: 2 * oneSecond,
  threeSeconds: 3 * oneSecond,
  fiveSeconds: 5 * oneSecond,
  refreshDefault: 10 * oneSecond,
  refreshLong: 60 * oneSecond
};
var DEVICE_ONLINE_CUTOFF = { interval: 1, intervalName: timeUnits.days };
var defaultIdAttribute = Object.freeze({ attribute: "id", scope: import_constants2.ATTRIBUTE_SCOPES.identity });
var credentialTypes = {
  aws: import_MenderTypes.Credentials.type.AWS,
  http: import_MenderTypes.Credentials.type.HTTP,
  sas: import_MenderTypes.Credentials.type.SAS,
  x509: "x509"
};
var EXTERNAL_PROVIDER = {
  "iot-core": {
    credentialsType: credentialTypes.aws,
    icon: import_js.mdiAws,
    title: "AWS IoT Core",
    twinTitle: "Device Shadow",
    provider: "iot-core",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_jsx_runtime.Fragment, { children: "For help finding your AWS IoT Core connection string, check the AWS IoT documentation." })
  },
  "iot-hub": {
    credentialsType: credentialTypes.sas,
    icon: import_js.mdiMicrosoftAzure,
    title: "Azure IoT Hub",
    twinTitle: "Device Twin",
    provider: "iot-hub",
    enabled: true,
    deviceTwin: true,
    configHint: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("span", { children: [
      "For help finding your Azure IoT Hub connection string, look under 'Shared access policies' in the Microsoft Azure UI as described",
      " ",
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        "a",
        {
          href: "https://devblogs.microsoft.com/iotdev/understand-different-connection-strings-in-azure-iot-hub/#iothubconn",
          target: "_blank",
          rel: "noopener noreferrer",
          children: "here"
        }
      ),
      "."
    ] })
  },
  webhook: {
    credentialsType: credentialTypes.http,
    deviceTwin: false,
    twinTitle: "",
    // disable the webhook provider here, since it is treated different than other integrations, with a custom configuration & management view, etc.
    enabled: false,
    provider: "webhook"
  }
};
var emptyWebhook = {
  description: "",
  provider: import_MenderTypes.Integration.provider.WEBHOOK,
  credentials: {
    type: EXTERNAL_PROVIDER.webhook.credentialsType,
    [EXTERNAL_PROVIDER.webhook.credentialsType]: {
      secret: "",
      url: ""
    }
  }
};
var regionNames = new Intl.DisplayNames(["en"], { type: "region" });
var countries = [
  "AD",
  "AE",
  "AF",
  "AG",
  "AI",
  "AL",
  "AM",
  "AO",
  "AQ",
  "AR",
  "AS",
  "AT",
  "AU",
  "AW",
  "AX",
  "AZ",
  "BA",
  "BB",
  "BD",
  "BE",
  "BF",
  "BG",
  "BH",
  "BI",
  "BJ",
  "BL",
  "BM",
  "BN",
  "BO",
  "BR",
  "BS",
  "BT",
  "BV",
  "BW",
  "BY",
  "BZ",
  "CA",
  "CC",
  "CD",
  "CF",
  "CG",
  "CH",
  "CI",
  "CK",
  "CL",
  "CM",
  "CN",
  "CO",
  "CR",
  "CU",
  "CV",
  "CW",
  "CX",
  "CY",
  "CZ",
  "DE",
  "DJ",
  "DK",
  "DM",
  "DO",
  "DZ",
  "EC",
  "EE",
  "EG",
  "EH",
  "ER",
  "ES",
  "ET",
  "FI",
  "FJ",
  "FK",
  "FM",
  "FO",
  "FR",
  "GA",
  "GB",
  "GD",
  "GE",
  "GF",
  "GG",
  "GH",
  "GI",
  "GL",
  "GM",
  "GN",
  "GP",
  "GQ",
  "GR",
  "GS",
  "GT",
  "GU",
  "GW",
  "GY",
  "HK",
  "HM",
  "HN",
  "HR",
  "HT",
  "HU",
  "ID",
  "IE",
  "IL",
  "IM",
  "IN",
  "IO",
  "IQ",
  "IR",
  "IS",
  "IT",
  "JE",
  "JM",
  "JO",
  "JP",
  "KE",
  "KG",
  "KH",
  "KI",
  "KM",
  "KN",
  "KP",
  "KR",
  "KW",
  "KY",
  "KZ",
  "LA",
  "LB",
  "LC",
  "LI",
  "LK",
  "LR",
  "LS",
  "LT",
  "LU",
  "LV",
  "LY",
  "MA",
  "MC",
  "MD",
  "ME",
  "MF",
  "MG",
  "MH",
  "MK",
  "ML",
  "MM",
  "MN",
  "MO",
  "MP",
  "MQ",
  "MR",
  "MS",
  "MT",
  "MU",
  "MV",
  "MW",
  "MX",
  "MY",
  "MZ",
  "NA",
  "NC",
  "NE",
  "NF",
  "NG",
  "NI",
  "NL",
  "NO",
  "NP",
  "NR",
  "NU",
  "NZ",
  "OM",
  "PA",
  "PE",
  "PF",
  "PG",
  "PH",
  "PK",
  "PL",
  "PM",
  "PN",
  "PR",
  "PS",
  "PT",
  "PW",
  "PY",
  "QA",
  "RE",
  "RO",
  "RS",
  "RU",
  "RW",
  "SA",
  "SB",
  "SC",
  "SD",
  "SE",
  "SG",
  "SH",
  "SI",
  "SJ",
  "SK",
  "SL",
  "SM",
  "SN",
  "SO",
  "SR",
  "SS",
  "ST",
  "SV",
  "SX",
  "SY",
  "SZ",
  "TC",
  "TD",
  "TF",
  "TG",
  "TH",
  "TJ",
  "TK",
  "TL",
  "TM",
  "TN",
  "TO",
  "TR",
  "TT",
  "TV",
  "TW",
  "TZ",
  "UA",
  "UG",
  "US",
  "UY",
  "UZ",
  "VA",
  "VC",
  "VE",
  "VG",
  "VI",
  "VN",
  "VU",
  "WF",
  "WS",
  "XK",
  "YE",
  "YT",
  "ZA",
  "ZM",
  "ZW"
].map((code) => ({ code, label: regionNames.of(code) })).sort((a, b) => a.label.localeCompare(b.label));

// src/auth.ts
var cookies = new import_universal_cookie.default();
var emptySession = Object.freeze({ token: "", expiresAt: void 0 });
var tokenCache = "";
var getSessionInfo = () => {
  let sessionInfo = { ...emptySession };
  try {
    sessionInfo = JSON.parse(window.localStorage.getItem("JWT") ?? "");
  } catch {
  }
  if (sessionInfo.expiresAt && new Date(sessionInfo.expiresAt) < /* @__PURE__ */ new Date()) {
    cleanUp();
    return { ...emptySession };
  }
  if (!sessionInfo.token) {
    const jwtTokenFromCookie = cookies.get("JWT", { doNotParse: true }) ?? "";
    if (jwtTokenFromCookie) {
      setSessionInfo({ token: jwtTokenFromCookie });
      sessionInfo.token = jwtTokenFromCookie;
      cookies.remove("JWT");
      cookies.remove("JWT", { path: "/" });
    }
  }
  sessionInfo.token = sessionInfo.token || "";
  tokenCache = sessionInfo.token;
  return sessionInfo;
};
var getToken = () => tokenCache ? tokenCache : getSessionInfo().token;
var setSessionInfo = ({ token, expiresAt }) => {
  tokenCache = token;
  window.localStorage.setItem("JWT", JSON.stringify({ token, expiresAt }));
};
var cleanUp = () => {
  tokenCache = "";
  cookies.remove("JWT");
  cookies.remove("JWT", { path: "/" });
  window.localStorage.removeItem("JWT");
  window.localStorage.removeItem("oauth");
};

// src/api/general-api.ts
var import_axios = __toESM(require("axios"), 1);
var unauthorizedRedirect = (error) => {
  if (!(0, import_axios.isCancel)(error) && error.response?.status === 401 && getToken()) {
    cleanUp();
    window.location.replace("/ui/");
  }
  return Promise.reject(error);
};
var commonRequestConfig = { timeout: TIMEOUTS.refreshDefault, headers: { "Content-Type": "application/json" } };
var authenticatedRequest = import_axios.default.create(commonRequestConfig);
authenticatedRequest.interceptors.response.use((res) => res, unauthorizedRedirect);
authenticatedRequest.interceptors.request.use(
  (config) => ({ ...config, headers: { ...config.headers, Authorization: `Bearer ${getToken()}` } }),
  (error) => Promise.reject(error)
);
var Api = {
  get: authenticatedRequest.get,
  delete: (url, data) => authenticatedRequest.request({ method: "delete", url, data }),
  patch: authenticatedRequest.patch,
  post: authenticatedRequest.post,
  postUnauthorized: (url, data, config = {}) => import_axios.default.post(url, data, { ...commonRequestConfig, ...config }),
  put: authenticatedRequest.put,
  upload: (url, formData, progress, cancelSignal) => authenticatedRequest.post(url, formData, {
    headers: { "Content-Type": "multipart/form-data" },
    onUploadProgress: progress,
    timeout: 0,
    signal: cancelSignal
  }),
  uploadPut: (url, formData, progress, cancelSignal) => authenticatedRequest.put(url, formData, {
    headers: { "Content-Type": "multipart/form-data" },
    onUploadProgress: progress,
    timeout: 0,
    signal: cancelSignal
  })
};

// src/api/users-api.ts
var Api2 = {
  postLogin: (url, { email: username, password, ...body }) => import_axios2.default.post(url, body, { ...commonRequestConfig, auth: { username, password } }).then((res) => ({ text: res.data, code: res.status, contentType: res.headers?.["content-type"] })),
  putVerifyTFA: (url, userData) => {
    let body = {};
    if (userData.hasOwnProperty("token2fa")) {
      body = { token2fa: userData.token2fa };
    }
    return import_axios2.default.put(url, body, { ...commonRequestConfig, headers: { ...commonRequestConfig.headers, Authorization: `Bearer ${getToken()}` } });
  }
};
var users_api_default = Api2;
//# sourceMappingURL=users-api.cjs.map