import { SnackbarContent } from '../appSlice/index.js';
import { Device } from '../devicesSlice/index.js';
import * as _reduxjs_toolkit from '@reduxjs/toolkit';
import { AppDispatch, RootState } from '../store.js';
import { NewDeployment, NewDeploymentForGroup, NewDeploymentV2, DeploymentDeployments } from '@northern.tech/types/MenderTypes';
import { Deployment, SelectionListState, DeploymentByStatusKey, SelectionState, DeploymentConfig } from './index.js';
import { SortOptions } from '@northern.tech/utils/constants';
import 'redux';
import 'immer';
import '@mui/material';
import '../commonConstants.js';
import 'react/jsx-runtime';
import '../devicesSlice/constants.js';
import 'redux-thunk';
import '../usersSlice/constants.js';
import '../usersSlice/index.js';
import '../releasesSlice/index.js';
import '../organizationSlice/types.js';
import '../appSlice/constants.js';
import '@mui/material/OverridableComponent';
import '../organizationSlice/constants.js';
import '../onboardingSlice/index.js';
import '@northern.tech/types/Alert';

declare const deriveDeploymentGroup: ({ filter, group, groups, name }: Deployment) => string | undefined;
type GetDeploymentsByStatusPayload = Partial<SelectionListState> & {
    group?: string;
    shouldSelect?: boolean;
    sort?: SortOptions;
    status: DeploymentByStatusKey;
};
declare const getDeploymentsByStatus: _reduxjs_toolkit.AsyncThunk<any[], GetDeploymentsByStatusPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const createDeployment: _reduxjs_toolkit.AsyncThunk<any, {
    hasNewRetryDefault: boolean;
    newDeployment: NewDeployment | (NewDeploymentForGroup & {
        group: string;
    }) | NewDeploymentV2;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getDeploymentDevices: _reduxjs_toolkit.AsyncThunk<any[], {
    id: string;
    page?: number;
    perPage?: number;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
type GetDeviceDeploymentsPayload = {
    deviceId: string;
    filterSelection?: string[];
    page?: number;
    perPage?: number;
};
declare const getDeviceDeployments: _reduxjs_toolkit.AsyncThunk<{
    payload: {
        id: string;
    } & Partial<Device>;
    type: "devices/receivedDevice";
}, GetDeviceDeploymentsPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const resetDeviceDeployments: _reduxjs_toolkit.AsyncThunk<_reduxjs_toolkit.PayloadAction<{
    payload: {
        id: string;
    } & Partial<Device>;
    type: "devices/receivedDevice";
}, string, {
    arg: GetDeviceDeploymentsPayload;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: GetDeviceDeploymentsPayload;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getSingleDeployment: _reduxjs_toolkit.AsyncThunk<{
    payload: Deployment;
    type: "deployments/receivedDeployment";
}, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getDeviceLog: _reduxjs_toolkit.AsyncThunk<[{
    payload: {
        deviceId: string;
        id: string;
        log: boolean;
    };
    type: "deployments/receivedDeploymentDeviceLog";
}, any], {
    deploymentId: string;
    deviceId: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const abortDeployment: _reduxjs_toolkit.AsyncThunk<[{
    payload: Record<string, Deployment>;
    type: "deployments/receivedDeployments";
}, {
    payload: {
        deploymentIds: string[];
        status: DeploymentByStatusKey;
        total: number;
    };
    type: "deployments/receivedDeploymentsForStatus";
}, {
    payload: string;
    type: "deployments/removedDeployment";
}, {
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}], string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const updateDeploymentControlMap: _reduxjs_toolkit.AsyncThunk<_reduxjs_toolkit.PayloadAction<{
    payload: Deployment;
    type: "deployments/receivedDeployment";
}, string, {
    arg: string;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: string;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, {
    deploymentId: string;
    updateControlMap: DeploymentDeployments["update_control_map"];
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
type DeepPartial<T> = {
    [P in keyof T]?: T[P] extends object ? DeepPartial<T[P]> : T[P];
};
type SetDeploymentsStatePayload = DeepPartial<SelectionState> & {
    page?: number;
    perPage?: number;
};
declare const setDeploymentsState: _reduxjs_toolkit.AsyncThunk<any[], SetDeploymentsStatePayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getDeploymentsConfig: _reduxjs_toolkit.AsyncThunk<{
    payload: DeploymentConfig;
    type: "deployments/setDeploymentsConfig";
}, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const saveDeltaDeploymentsConfig: _reduxjs_toolkit.AsyncThunk<unknown, {
    compressionLevel: number;
    disableChecksum: boolean;
    disableDecompression: boolean;
    duplicatesWindow: number;
    inputWindow: number;
    instructionBuffer: number;
    sourceWindow: number;
    timeout: number;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;

export { type GetDeploymentsByStatusPayload, abortDeployment, createDeployment, deriveDeploymentGroup, getDeploymentDevices, getDeploymentsByStatus, getDeploymentsConfig, getDeviceDeployments, getDeviceLog, getSingleDeployment, resetDeviceDeployments, saveDeltaDeploymentsConfig, setDeploymentsState, updateDeploymentControlMap };
