"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/devicesSlice/index.ts
var devicesSlice_exports = {};
__export(devicesSlice_exports, {
  actions: () => actions,
  default: () => devicesSlice_default,
  devicesSlice: () => devicesSlice,
  initialState: () => initialState,
  sliceName: () => sliceName
});
module.exports = __toCommonJS(devicesSlice_exports);
var import_helpers = require("@northern.tech/utils/helpers");
var import_toolkit = require("@reduxjs/toolkit");

// src/constants.ts
var import_constants = require("@northern.tech/utils/constants");

// src/devicesSlice/index.ts
var sliceName = "devices";
var initialState = {
  byId: {
    // [deviceId]: {
    //   ...,
    //   twinsByIntegration: { [external.provider.id]: twinData }
    // }
  },
  byStatus: {
    [import_constants.DEVICE_STATES.accepted]: { deviceIds: [], total: 0 },
    active: { deviceIds: [], total: 0 },
    inactive: { deviceIds: [], total: 0 },
    [import_constants.DEVICE_STATES.pending]: { deviceIds: [], total: 0 },
    [import_constants.DEVICE_STATES.preauth]: { deviceIds: [], total: 0 },
    [import_constants.DEVICE_STATES.rejected]: { deviceIds: [], total: 0 }
  },
  deviceList: {
    deviceIds: [],
    ...import_constants.DEVICE_LIST_DEFAULTS,
    selectedAttributes: [],
    selectedIssues: [],
    selection: [],
    sort: {
      direction: import_constants.SORTING_OPTIONS.desc
      // key: null,
      // scope: null
    },
    state: import_constants.DEVICE_STATES.accepted,
    total: 0,
    refreshTrigger: false,
    isLoading: false,
    detailsTab: "",
    open: false
  },
  filters: [
    // { key: 'device_type', value: 'raspberry', operator: '$eq', scope: 'inventory' }
  ],
  filteringAttributes: { identityAttributes: [], inventoryAttributes: [], systemAttributes: [], tagAttributes: [] },
  filteringAttributesLimit: 10,
  filteringAttributesConfig: {
    attributes: {
      // inventory: ['some_attribute']
    },
    count: 0,
    limit: 100
  },
  reports: [
    // { items: [{ key: "someKey", count: 42  }], otherCount: 123, total: <otherCount + itemsCount> }
  ],
  total: 0,
  limit: 0,
  groups: {
    byId: {
      // groupName: { deviceIds: [], total: 0, filters: [] },
      // dynamo: { deviceIds: [], total: 3, filters: [{ a: 1 }] }
    },
    selectedGroup: void 0
  }
};
var devicesSlice = (0, import_toolkit.createSlice)({
  name: sliceName,
  initialState,
  reducers: {
    receivedGroups: (state, action) => {
      state.groups.byId = action.payload;
    },
    addToGroup: (state, action) => {
      const { group, deviceIds } = action.payload;
      const maybeExistingGroup = {
        filters: [],
        deviceIds: [],
        ...state.groups.byId[group]
      };
      state.groups.byId[group] = {
        ...maybeExistingGroup,
        deviceIds: [...maybeExistingGroup.deviceIds, ...deviceIds].filter(import_helpers.duplicateFilter),
        total: (maybeExistingGroup.total || 0) + 1
      };
    },
    removeFromGroup: (state, action) => {
      const { group, deviceIds: removedIds } = action.payload;
      const { deviceIds = [], total = 0, ...maybeExistingGroup } = state.groups.byId[group] || {};
      const changedGroup = {
        ...maybeExistingGroup,
        deviceIds: deviceIds.filter((id) => !removedIds.includes(id)),
        total: Math.max(total - removedIds.length, 0)
      };
      if (changedGroup.total || changedGroup.deviceIds.length) {
        state.groups.byId[group] = changedGroup;
        return;
      } else if (state.groups.selectedGroup === group) {
        state.groups.selectedGroup = void 0;
      }
      const { [group]: removal, ...remainingById } = state.groups.byId;
      state.groups.byId = remainingById;
    },
    addGroup: (state, action) => {
      const { groupName, group } = action.payload;
      state.groups.byId[groupName] = {
        ...state.groups.byId[groupName],
        ...group
      };
    },
    selectGroup: (state, { payload: group }) => {
      state.deviceList.deviceIds = group && state.groups.byId[group] && state.groups.byId[group].deviceIds && state.groups.byId[group].deviceIds.length > 0 ? state.groups.byId[group].deviceIds : [];
      state.groups.selectedGroup = group;
    },
    removeGroup: (state, action) => {
      const { [action.payload]: removal, ...remainingById } = state.groups.byId;
      state.groups.byId = remainingById;
      state.groups.selectedGroup = state.groups.selectedGroup === action.payload ? void 0 : state.groups.selectedGroup;
    },
    setDeviceListState: (state, action) => {
      state.deviceList = {
        ...state.deviceList,
        ...action.payload,
        sort: {
          ...state.deviceList.sort,
          ...action.payload.sort
        }
      };
    },
    setFilterAttributes: (state, action) => {
      state.filteringAttributes = action.payload;
    },
    setFilterablesConfig: (state, action) => {
      state.filteringAttributesConfig = action.payload;
    },
    receivedDevices: (state, action) => {
      state.byId = {
        ...state.byId,
        ...action.payload
      };
    },
    setDeviceFilters: (state, action) => {
      if ((0, import_helpers.deepCompare)(action.payload, state.filters)) {
        return;
      }
      state.filters = action.payload.filter((filter) => filter.key && filter.operator && filter.scope && typeof filter.value !== "undefined");
    },
    setInactiveDevices: (state, action) => {
      const { activeDeviceTotal, inactiveDeviceTotal } = action.payload;
      state.byStatus.active.total = activeDeviceTotal;
      state.byStatus.inactive.total = inactiveDeviceTotal;
    },
    setDeviceReports: (state, action) => {
      state.reports = action.payload;
    },
    setDevicesByStatus: (state, action) => {
      const { forceUpdate, status, total, deviceIds } = action.payload;
      state.byStatus[status] = total || forceUpdate ? { deviceIds, total } : state.byStatus[status];
    },
    setDevicesCountByStatus: (state, action) => {
      const { count, status } = action.payload;
      state.byStatus[status].total = count;
    },
    setDeviceLimit: (state, action) => {
      state.limit = action.payload;
    },
    receivedDevice: (state, action) => {
      state.byId[action.payload.id] = {
        ...state.byId[action.payload.id],
        ...action.payload
      };
    },
    maybeUpdateDevicesByStatus: (state, action) => {
      const { deviceId, authId } = action.payload;
      const device = state.byId[deviceId];
      const hasMultipleAuthSets = authId && device.auth_sets ? device.auth_sets.filter((authset) => authset.id !== authId).length > 0 : false;
      if (!hasMultipleAuthSets && Object.values(import_constants.DEVICE_STATES).includes(device.status)) {
        const deviceIds = state.byStatus[device.status].deviceIds.filter((id) => id !== deviceId);
        state.byStatus[device.status] = { deviceIds, total: Math.max(0, state.byStatus[device.status].total - 1) };
      }
    }
  }
});
var actions = devicesSlice.actions;
var devicesSlice_default = devicesSlice.reducer;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  actions,
  devicesSlice,
  initialState,
  sliceName
});
//# sourceMappingURL=index.cjs.map