import { SnackbarContent, SearchState } from '../appSlice/index.js';
import * as _reduxjs_toolkit from '@reduxjs/toolkit';
import { SortCriteria, StatusDeviceauth, PreAuthSet, DeviceConfiguration, ManagementAPIConfiguration, NewConfigurationDeployment, Integration } from '@northern.tech/types/MenderTypes';
import { DeviceListState, Device, DeviceGroup, DeviceFilter, DeviceStatus, DeviceSelectedAttribute } from './index.js';
import { DeviceIssueOptionKey } from '@northern.tech/utils/constants';
import { AppDispatch, RootState } from '../store.js';
import 'redux';
import 'immer';
import '@mui/material';
import '../commonConstants.js';
import 'react/jsx-runtime';
import './constants.js';
import '../deploymentsSlice/index.js';
import 'redux-thunk';
import '../usersSlice/constants.js';
import '../usersSlice/index.js';
import '../releasesSlice/index.js';
import '../organizationSlice/types.js';
import '../appSlice/constants.js';
import '@mui/material/OverridableComponent';
import '../organizationSlice/constants.js';
import '../onboardingSlice/index.js';
import '@northern.tech/types/Alert';

declare const getGroups: _reduxjs_toolkit.AsyncThunk<any, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const addDevicesToGroup: _reduxjs_toolkit.AsyncThunk<{
    payload: {
        deviceIds: string[];
        group: string;
    };
    type: "devices/addToGroup";
}, {
    deviceIds: string[];
    group: string;
    isCreation: boolean;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const removeDevicesFromGroup: _reduxjs_toolkit.AsyncThunk<[{
    payload: {
        deviceIds: string[];
        group: string;
    };
    type: "devices/removeFromGroup";
}, {
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}], {
    deviceIds: string[];
    group: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const addStaticGroup: _reduxjs_toolkit.AsyncThunk<[_reduxjs_toolkit.PayloadAction<any[], string, {
    arg: SetDeviceListStatePayload;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: SetDeviceListStatePayload;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, _reduxjs_toolkit.PayloadAction<any, string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, {
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}], {
    devices: Device[];
    group: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const removeStaticGroup: _reduxjs_toolkit.AsyncThunk<[{
    payload: string;
    type: "devices/removeGroup";
}, _reduxjs_toolkit.PayloadAction<any, string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError>, {
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}], string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getDynamicGroups: _reduxjs_toolkit.AsyncThunk<void | {
    payload: Record<string, DeviceGroup>;
    type: "devices/receivedGroups";
}, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const addDynamicGroup: _reduxjs_toolkit.AsyncThunk<[{
    payload: DeviceFilter[];
    type: "devices/setDeviceFilters";
}, {
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: void;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<void | {
    payload: Record<string, DeviceGroup>;
    type: "devices/receivedGroups";
}, string, {
    arg: void;
    requestId: string;
    requestStatus: "fulfilled";
}, never>], {
    filterPredicates: DeviceFilter[];
    groupName: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const updateDynamicGroup: _reduxjs_toolkit.AsyncThunk<any, {
    filterPredicates: DeviceFilter[];
    groupName: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const removeDynamicGroup: _reduxjs_toolkit.AsyncThunk<[{
    payload: string;
    type: "devices/removeGroup";
}, {
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}], string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const selectGroup: _reduxjs_toolkit.AsyncThunk<any, {
    filters: DeviceFilter[];
    group: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
type getGroupDevicesPayload = {
    group: string;
    page?: number;
    perPage?: number;
    shouldIncludeAllStates: boolean;
};
declare const getGroupDevices: _reduxjs_toolkit.AsyncThunk<any, getGroupDevicesPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getAllGroupDevices: _reduxjs_toolkit.AsyncThunk<any, {
    attribute: string;
    group: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getAllDynamicGroupDevices: _reduxjs_toolkit.AsyncThunk<any, {
    attribute: string;
    group: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getDeviceById: _reduxjs_toolkit.AsyncThunk<any, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getDeviceInfo: _reduxjs_toolkit.AsyncThunk<any[], string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getDeviceCount: _reduxjs_toolkit.AsyncThunk<{
    payload: {
        count: number;
        status: DeviceStatus;
    };
    type: "devices/setDevicesCountByStatus";
}, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getAllDeviceCounts: _reduxjs_toolkit.AsyncThunk<(_reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: string;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<{
    payload: {
        count: number;
        status: DeviceStatus;
    };
    type: "devices/setDevicesCountByStatus";
}, string, {
    arg: string;
    requestId: string;
    requestStatus: "fulfilled";
}, never>)[], void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getDeviceLimit: _reduxjs_toolkit.AsyncThunk<{
    payload: number;
    type: "devices/setDeviceLimit";
}, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
type SetDeviceListStatePayload = {
    fetchAuth?: boolean;
    forceRefresh?: boolean;
    shouldSelectDevices?: boolean;
} & Partial<DeviceListState>;
declare const setDeviceListState: _reduxjs_toolkit.AsyncThunk<any[], SetDeviceListStatePayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
type GetDevicesByStatusPayload = {
    fetchAuth: boolean;
    filterSelection: DeviceFilter[];
    group: string;
    page: number;
    perPage: number;
    selectedAttributes: DeviceSelectedAttribute[];
    selectedIssues: DeviceIssueOptionKey[];
    sortOptions: SortCriteria[];
    status: DeviceStatus;
};
declare const getDevicesByStatus: _reduxjs_toolkit.AsyncThunk<any[], Partial<GetDevicesByStatusPayload>, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getAllDevicesByStatus: _reduxjs_toolkit.AsyncThunk<any, {
    attribute: string;
    status: DeviceStatus;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
type SearchDevicesPayload = SearchState & {
    sortOptions: SortCriteria[];
};
declare const searchDevices: _reduxjs_toolkit.AsyncThunk<[{
    payload: Record<string, Device>;
    type: "devices/receivedDevices";
}, {
    deviceIds: string[];
    searchTotal: number;
}], Partial<SearchDevicesPayload>, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getDeviceAttributes: _reduxjs_toolkit.AsyncThunk<{
    payload: {
        identityAttributes: string[];
        inventoryAttributes: string[];
        systemAttributes: string[];
        tagAttributes: string[];
    };
    type: "devices/setFilterAttributes";
}, void, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const updateReportData: _reduxjs_toolkit.AsyncThunk<{
    payload: {
        items: {
            count: number;
            key: string;
        }[];
        otherCount: number;
        total: number;
    }[];
    type: "devices/setDeviceReports";
}, number, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getReportDataWithoutBackendSupport: _reduxjs_toolkit.AsyncThunk<_reduxjs_toolkit.PayloadAction<{
    payload: {
        items: {
            count: number;
            key: string;
        }[];
        otherCount: number;
        total: number;
    }[];
    type: "devices/setDeviceReports";
}, string, {
    arg: number;
    requestId: string;
    requestStatus: "fulfilled";
}, never> | _reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: number;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | undefined, number, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getDeviceConnect: _reduxjs_toolkit.AsyncThunk<[{
    payload: {
        id: string;
    } & Partial<Device>;
    type: "devices/receivedDevice";
}, any], string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const triggerDeviceUpdate: _reduxjs_toolkit.AsyncThunk</*elided*/ any, {
    id: string;
    type: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
type GetSessionDetailsPayload = {
    deviceId: string;
    endDate: string;
    sessionId: string;
    startDate: string;
    userId: string;
};
declare const getSessionDetails: _reduxjs_toolkit.AsyncThunk<{
    start: any;
    end: any;
}, GetSessionDetailsPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getDeviceFileDownloadLink: _reduxjs_toolkit.AsyncThunk<string, {
    deviceId: string;
    path: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const deviceFileUpload: _reduxjs_toolkit.AsyncThunk<{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, {
    deviceId: string;
    file: File;
    path: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getDeviceAuth: _reduxjs_toolkit.AsyncThunk<any, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getDevicesWithAuth: _reduxjs_toolkit.AsyncThunk<any, {
    id: string;
}[], {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const updateDeviceAuth: _reduxjs_toolkit.AsyncThunk<{
    payload: {
        authId?: string;
        deviceId: string;
    };
    type: "devices/maybeUpdateDevicesByStatus";
}, {
    authId: string;
    deviceId: string;
    status: StatusDeviceauth.status;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const updateDevicesAuth: _reduxjs_toolkit.AsyncThunk<{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, {
    deviceIds: string[];
    status: StatusDeviceauth.status;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const deleteAuthset: _reduxjs_toolkit.AsyncThunk<{
    payload: {
        authId?: string;
        deviceId: string;
    };
    type: "devices/maybeUpdateDevicesByStatus";
}, {
    authId: string;
    deviceId: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const preauthDevice: _reduxjs_toolkit.AsyncThunk<{
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}, PreAuthSet, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const decommissionDevice: _reduxjs_toolkit.AsyncThunk<{
    payload: {
        authId?: string;
        deviceId: string;
    };
    type: "devices/maybeUpdateDevicesByStatus";
}, {
    authId?: string;
    deviceId: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getDeviceConfig: _reduxjs_toolkit.AsyncThunk<[{
    payload: {
        id: string;
    } & Partial<Device>;
    type: "devices/receivedDevice";
}, DeviceConfiguration] | undefined, string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const setDeviceConfig: _reduxjs_toolkit.AsyncThunk<_reduxjs_toolkit.PayloadAction<unknown, string, {
    arg: string;
    requestId: string;
    requestStatus: "rejected";
    aborted: boolean;
    condition: boolean;
} & ({
    rejectedWithValue: true;
} | ({
    rejectedWithValue: false;
} & {})), _reduxjs_toolkit.SerializedError> | _reduxjs_toolkit.PayloadAction<[{
    payload: {
        id: string;
    } & Partial<Device>;
    type: "devices/receivedDevice";
}, DeviceConfiguration] | undefined, string, {
    arg: string;
    requestId: string;
    requestStatus: "fulfilled";
}, never>, {
    config: ManagementAPIConfiguration;
    deviceId: string;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
type ApplyDeviceConfigPayload = {
    config: DeviceConfiguration;
    configDeploymentConfiguration: NewConfigurationDeployment;
    deviceId: string;
    isDefault: boolean;
};
declare const applyDeviceConfig: _reduxjs_toolkit.AsyncThunk<any[], ApplyDeviceConfigPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const setDeviceTags: _reduxjs_toolkit.AsyncThunk<[{
    payload: {
        id: string;
    } & Partial<Device>;
    type: "devices/receivedDevice";
}, {
    payload: string | SnackbarContent;
    type: "app/setSnackbar";
}], {
    deviceId: string;
    tags: Record<string, string>;
}, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
type DeviceTwinPayload = {
    deviceId: string;
    integration: Integration;
};
declare const getDeviceTwin: _reduxjs_toolkit.AsyncThunk<void, DeviceTwinPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
type SetDeviceTwinPayload = {
    deviceId: string;
    integration: Integration;
    settings: any;
};
declare const setDeviceTwin: _reduxjs_toolkit.AsyncThunk<{
    payload: {
        id: string;
    } & Partial<Device>;
    type: "devices/receivedDevice";
}, SetDeviceTwinPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
type GetSystemDevicesPayload = {
    id: string;
    page?: number;
    perPage?: number;
    sortOptions: SortCriteria[];
};
declare const getSystemDevices: _reduxjs_toolkit.AsyncThunk<unknown, GetSystemDevicesPayload, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;
declare const getGatewayDevices: _reduxjs_toolkit.AsyncThunk<any[], string, {
    dispatch: AppDispatch;
    state: RootState;
    extra?: unknown;
    rejectValue?: unknown;
    serializedErrorType?: unknown;
    pendingMeta?: unknown;
    fulfilledMeta?: unknown;
    rejectedMeta?: unknown;
}>;

export { addDevicesToGroup, addDynamicGroup, addStaticGroup, applyDeviceConfig, decommissionDevice, deleteAuthset, deviceFileUpload, getAllDeviceCounts, getAllDevicesByStatus, getAllDynamicGroupDevices, getAllGroupDevices, getDeviceAttributes, getDeviceAuth, getDeviceById, getDeviceConfig, getDeviceConnect, getDeviceCount, getDeviceFileDownloadLink, getDeviceInfo, getDeviceLimit, getDeviceTwin, getDevicesByStatus, getDevicesWithAuth, getDynamicGroups, getGatewayDevices, getGroupDevices, getGroups, getReportDataWithoutBackendSupport, getSessionDetails, getSystemDevices, preauthDevice, removeDevicesFromGroup, removeDynamicGroup, removeStaticGroup, searchDevices, selectGroup, setDeviceConfig, setDeviceListState, setDeviceTags, setDeviceTwin, triggerDeviceUpdate, updateDeviceAuth, updateDevicesAuth, updateDynamicGroup, updateReportData };
